/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathDouble$;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a double value, the value zero if no match is found, or NaN if a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002>i\t\t\u0011#\u0001\u0002@\u0019A\u0011DGA\u0001\u0012\u0003\t\t\u0005\u0003\u0004@'\u0011\u0005\u0011q\n\u0005\n\u0003#\u001a\u0012\u0011!C#\u0003'B\u0011\"!\u0016\u0014\u0003\u0003%\t)a\u0016\t\u0013\u0005u3#!A\u0005\u0002\u0006}\u0003\"CA9'\u0005\u0005I\u0011BA:\u0005-A\u0006+\u0019;i\t>,(\r\\3\u000b\u0005ma\u0012a\u0001=nY*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001U9\"\u0004CA\u0016-\u001b\u0005Q\u0012BA\u0017\u001b\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u001d\u0001&o\u001c3vGR\u0004\"aL\u001b\n\u0005Y\u0002$\u0001D*fe&\fG.\u001b>bE2,W#\u0001\u001d\u0011\u0005eRT\"\u0001\u000f\n\u0005mb\"AC#yaJ,7o]5p]\u0006!\u00010\u001c7!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\r\t%i\u0011\t\u0003W\u0001AQaG\u0003A\u0002aBQ!P\u0003A\u0002a\n!\u0002\u001d:fiRLh*Y7f+\u00051\u0005CA$O\u001d\tAE\n\u0005\u0002Ja5\t!J\u0003\u0002LQ\u00051AH]8pizJ!!\u0014\u0019\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bB\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bI\u0001\u0006if\u0004Xm]\u0005\u00031V\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00047z{\u0006CA\u0018]\u0013\ti\u0006GA\u0002B]fDQa\u0007\u0005A\u0002mCQ!\u0010\u0005A\u0002m\u000bAaY8qsR\u0019\u0011IY2\t\u000fmI\u0001\u0013!a\u0001q!9Q(\u0003I\u0001\u0002\u0004A\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002M*\u0012\u0001hZ\u0016\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001c\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002pU\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017BA(v\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005a\bCA\u0018~\u0013\tq\bGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002\\\u0003\u0007A\u0001\"!\u0002\u000f\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0001#BA\u0007\u0003'YVBAA\b\u0015\r\t\t\u0002M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000b\u0003\u001f\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111DA\u0011!\ry\u0013QD\u0005\u0004\u0003?\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u000b\u0001\u0012\u0011!a\u00017\u00061Q-];bYN$B!a\u0007\u0002(!A\u0011QA\t\u0002\u0002\u0003\u00071\fK\u0006\u0001\u0003W\t\t$a\r\u00028\u0005e\u0002cA\u001d\u0002.%\u0019\u0011q\u0006\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QG\u0001\u0002\u0016}3UKT\"`QalG\u000e\f\u0011ya\u0006$\b.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007\u0005Z8vE2,\u0007E^1mk\u0016d\u0003\u0005\u001e5fAY\fG.^3!u\u0016\u0014x\u000eI5gA9|\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\f\u0011pe\u0002r\u0015M\u0014\u0011jM\u0002\n\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\t2vi\u0002\"\b.\u001a\u0011wC2,X\rI5tA9|g.\f8v[\u0016\u0014\u0018n\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u000f\u00025*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt\u0014\u0007P\u0018c}q\u0012gH\r\u001f0Ezbt&\u0019 (Y\u0001:3/^7)C>\u0012\u0017fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!\u0003-A\u0006+\u0019;i\t>,(\r\\3\u0011\u0005-\u001a2\u0003B\n\u0002DQ\u0002r!!\u0012\u0002LaB\u0014)\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u0019\u0002\u000fI,h\u000e^5nK&!\u0011QJA$\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002g\u0006)\u0011\r\u001d9msR)\u0011)!\u0017\u0002\\!)1D\u0006a\u0001q!)QH\u0006a\u0001q\u00059QO\\1qa2LH\u0003BA1\u0003[\u0002RaLA2\u0003OJ1!!\u001a1\u0005\u0019y\u0005\u000f^5p]B)q&!\u001b9q%\u0019\u00111\u000e\u0019\u0003\rQ+\b\u000f\\33\u0011!\tygFA\u0001\u0002\u0004\t\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\bE\u0002u\u0003oJ1!!\u001fv\u0005\u0019y%M[3di\u0002")
public class XPathDouble
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathDouble xPathDouble) {
        return XPathDouble$.MODULE$.unapply(xPathDouble);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathDouble> tupled() {
        return XPathDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathDouble>> curried() {
        return XPathDouble$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_double";
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToDouble((double)ret);
    }

    public XPathDouble copy(Expression xml, Expression path) {
        return new XPathDouble(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathDouble";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathDouble;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathDouble xPathDouble = (XPathDouble)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathDouble.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathDouble.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathDouble.canEqual(this)) return false;
        return true;
    }

    public XPathDouble(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

