/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLocate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(substr, str[, pos]) - Returns the position of the first occurrence of `substr` in `str` after position `pos`.\n      The given `pos` and return value are 1-based.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('bar', 'foobarbar');\n       4\n      > SELECT _FUNC_('bar', 'foobarbar', 5);\n       7\n      > SELECT POSITION('bar' IN 'foobarbar');\n       4\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0011#\u0001>B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011!A\u0005A!f\u0001\n\u0003\t\u0005\u0002C%\u0001\u0005#\u0005\u000b\u0011\u0002\"\t\u000b)\u0003A\u0011A&\t\u000b)\u0003A\u0011\u0001)\t\u000bM\u0003A\u0011\t+\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000bE\u0004A\u0011\t:\t\u000bq\u0004A\u0011K?\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003k\u0001\u0011\u0013!C\u0001\u0003oA\u0011\"!\u0014\u0001#\u0003%\t!a\u000e\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005]\u0002\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000fC\u0011\"a#\u0001\u0003\u0003%\t%!$\b\u0013\u0005-&%!A\t\u0002\u00055f\u0001C\u0011#\u0003\u0003E\t!a,\t\r)[B\u0011AA_\u0011%\tylGA\u0001\n\u000b\n\t\rC\u0005\u0002Dn\t\t\u0011\"!\u0002F\"I\u0011QZ\u000e\u0002\u0002\u0013\u0005\u0015q\u001a\u0005\n\u0003C\\\u0012\u0011!C\u0005\u0003G\u0014Ab\u0015;sS:<Gj\\2bi\u0016T!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0006\u0001A\"t'\u0010\t\u0003cIj\u0011AI\u0005\u0003g\t\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tT'\u0003\u00027E\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005ar\u0014BA :\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019XOY:ueV\t!\t\u0005\u00022\u0007&\u0011AI\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017aB:vEN$(\u000fI\u0001\u0004gR\u0014\u0018\u0001B:ue\u0002\nQa\u001d;beR\faa\u001d;beR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003M\u001b:{\u0005CA\u0019\u0001\u0011\u0015\u0001u\u00011\u0001C\u0011\u00151u\u00011\u0001C\u0011\u0015Au\u00011\u0001C)\ra\u0015K\u0015\u0005\u0006\u0001\"\u0001\rA\u0011\u0005\u0006\r\"\u0001\rAQ\u0001\tG\"LG\u000e\u001a:f]V\tQ\u000bE\u0002W=\ns!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005is\u0013A\u0002\u001fs_>$h(C\u0001;\u0013\ti\u0016(A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011Q,O\u0001\t]VdG.\u00192mKV\t1\r\u0005\u00029I&\u0011Q-\u000f\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-4\u0013!\u0002;za\u0016\u001c\u0018BA7k\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\t\u0001\u000fE\u0002W=\"\fA!\u001a<bYR\u00111O\u001e\t\u0003qQL!!^\u001d\u0003\u0007\u0005s\u0017\u0010C\u0004x\u001bA\u0005\t\u0019\u0001=\u0002\u000b%t\u0007/\u001e;\u0011\u0005eTX\"\u0001\u0013\n\u0005m$#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000by\fI!a\u0005\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0012\u0002\u000f\r|G-Z4f]&!\u0011qAA\u0001\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0006\u001d\u0001\u0007\u0011QB\u0001\u0004GRD\bcA@\u0002\u0010%!\u0011\u0011CA\u0001\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0006\u000f\u0001\u0004q\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00037\u0001B!!\b\u0002&9!\u0011qDA\u0011!\tA\u0016(C\u0002\u0002$e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u0012s\u0005!1m\u001c9z)\u001da\u0015qFA\u0019\u0003gAq\u0001\u0011\t\u0011\u0002\u0003\u0007!\tC\u0004G!A\u0005\t\u0019\u0001\"\t\u000f!\u0003\u0002\u0013!a\u0001\u0005\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001dU\r\u0011\u00151H\u0016\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0005v]\u000eDWmY6fI*\u0019\u0011qI\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0005\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005Y\u0006twM\u0003\u0002\u0002`\u0005!!.\u0019<b\u0013\u0011\t9#!\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0004c\u0001\u001d\u0002j%\u0019\u00111N\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007M\f\t\bC\u0005\u0002tY\t\t\u00111\u0001\u0002h\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001f\u0011\u000b\u0005m\u0014\u0011Q:\u000e\u0005\u0005u$bAA@s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0015Q\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002d\u0003\u0013C\u0001\"a\u001d\u0019\u0003\u0003\u0005\ra]\u0001\u0007KF,\u0018\r\\:\u0015\u0007\r\fy\t\u0003\u0005\u0002te\t\t\u00111\u0001tQ=\u0001\u00111SAM\u00037\u000by*!)\u0002&\u0006\u001d\u0006cA\u0019\u0002\u0016&\u0019\u0011q\u0013\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QT\u0001\u0002b)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tk\n\u001cHO\u001d\u0017!gR\u00148\f\f\u0011q_Nl\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t9pg&$\u0018n\u001c8!_\u001a\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011pG\u000e,(O]3oG\u0016\u0004sN\u001a\u0011agV\u00147\u000f\u001e:aA%t\u0007\u0005Y:ue\u0002\u0004\u0013M\u001a;fe\u0002\u0002xn]5uS>t\u0007\u0005\u00199pg\u0002t#\u0002\t\u0011!A\u0001\u0002C\u000b[3!O&4XM\u001c\u0011aa>\u001c\b\rI1oI\u0002\u0012X\r^;s]\u00022\u0018\r\\;fA\u0005\u0014X\rI\u0019.E\u0006\u001cX\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003G\u000b\u0011\u0011\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\t\f'o\n\u0017!O\u0019|wNY1sE\u0006\u0014x%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsEY1sO1\u0002sEZ8pE\u0006\u0014(-\u0019:(Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00118\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0002vjU%U\u0013>s\u0005f\n2be\u001e\u0002\u0013J\u0014\u0011(M>|'-\u0019:cCJ<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAU\u0003\u0015\td&\u000e\u00181\u00031\u0019FO]5oO2{7-\u0019;f!\t\t4d\u0005\u0003\u001c\u0003ck\u0004\u0003CAZ\u0003s\u0013%I\u0011'\u000e\u0005\u0005U&bAA\\s\u00059!/\u001e8uS6,\u0017\u0002BA^\u0003k\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ti+\u0001\u0005u_N#(/\u001b8h)\t\t)&A\u0003baBd\u0017\u0010F\u0004M\u0003\u000f\fI-a3\t\u000b\u0001s\u0002\u0019\u0001\"\t\u000b\u0019s\u0002\u0019\u0001\"\t\u000b!s\u0002\u0019\u0001\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011[Ao!\u0015A\u00141[Al\u0013\r\t).\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ra\nIN\u0011\"C\u0013\r\tY.\u000f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005}w$!AA\u00021\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0015\b\u0003BA,\u0003OLA!!;\u0002Z\t1qJ\u00196fGR\u0004")
public class StringLocate
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression substr;
    private final Expression str;
    private final Expression start;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLocate stringLocate) {
        return StringLocate$.MODULE$.unapply(stringLocate);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLocate> tupled() {
        return StringLocate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLocate>>> curried() {
        return StringLocate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression substr() {
        return this.substr;
    }

    public Expression str() {
        return this.str;
    }

    public Expression start() {
        return this.start;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.substr();
        Expression expression2 = this.str();
        Expression expression3 = this.start();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return this.substr().nullable() || this.str().nullable();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object eval(InternalRow input) {
        int sVal;
        Object l;
        Object r;
        Object s = this.start().eval(input);
        return s == null ? BoxesRunTime.boxToInteger((int)0) : ((r = this.substr().eval(input)) == null ? null : ((l = this.str().eval(input)) == null ? null : ((sVal = BoxesRunTime.unboxToInt((Object)s)) < 1 ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)(((UTF8String)l).indexOf((UTF8String)r, BoxesRunTime.unboxToInt((Object)s) - 1) + 1)))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode substrGen = this.substr().genCode(ctx);
        ExprCode strGen = this.str().genCode(ctx);
        ExprCode startGen = this.start().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      int ", " = 0;\n      boolean ", " = false;\n      ", "\n      if (!", ") {\n        ", "\n        if (!", ") {\n          ", "\n          if (!", ") {\n            if (", " > 0) {\n              ", " = ", ".indexOf(", ",\n                ", " - 1) + 1;\n            }\n          } else {\n            ", " = true;\n          }\n        } else {\n          ", " = true;\n        }\n      }\n     "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ev.isNull(), startGen.code(), startGen.isNull(), substrGen.code(), substrGen.isNull(), strGen.code(), strGen.isNull(), startGen.value(), ev.value(), strGen.value(), substrGen.value(), startGen.value(), ev.isNull(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "locate";
    }

    public StringLocate copy(Expression substr, Expression str, Expression start) {
        return new StringLocate(substr, str, start);
    }

    public Expression copy$default$1() {
        return this.substr();
    }

    public Expression copy$default$2() {
        return this.str();
    }

    public Expression copy$default$3() {
        return this.start();
    }

    @Override
    public String productPrefix() {
        return "StringLocate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.substr();
                break;
            }
            case 1: {
                expression = this.str();
                break;
            }
            case 2: {
                expression = this.start();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLocate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLocate)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLocate stringLocate = (StringLocate)x$1;
        Expression expression = this.substr();
        Expression expression2 = stringLocate.substr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.str();
        Expression expression4 = stringLocate.str();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.start();
        Expression expression6 = stringLocate.start();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLocate.canEqual(this)) return false;
        return true;
    }

    public StringLocate(Expression substr, Expression str, Expression start) {
        this.substr = substr;
        this.str = str;
        this.start = start;
        ExpectsInputTypes.$init$(this);
    }

    public StringLocate(Expression substr, Expression str) {
        this(substr, str, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

