/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramSerializer$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple8;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CatalogColumnStat$
implements Logging,
scala.Serializable {
    public static CatalogColumnStat$ MODULE$;
    private final String KEY_VERSION;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_DISTINCT_COUNT;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MIN_VALUE;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_VALUE;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_NULL_COUNT;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_AVG_LEN;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_LEN;
    private final String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_HISTOGRAM;
    private final int VERSION;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CatalogColumnStat$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<BigInt> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<BigInt> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<Histogram> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$8() {
        return this.VERSION();
    }

    public String KEY_VERSION() {
        return this.KEY_VERSION;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_DISTINCT_COUNT() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_DISTINCT_COUNT;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MIN_VALUE() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MIN_VALUE;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_VALUE() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_VALUE;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_NULL_COUNT() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_NULL_COUNT;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_AVG_LEN() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_AVG_LEN;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_LEN() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_LEN;
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_HISTOGRAM() {
        return this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_HISTOGRAM;
    }

    public int VERSION() {
        return this.VERSION;
    }

    private TimestampFormatter getTimestampFormatter() {
        return TimestampFormatter$.MODULE$.apply("yyyy-MM-dd HH:mm:ss.SSSSSS", DateTimeUtils$.MODULE$.TimeZoneUTC());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object fromExternalString(String s, String name, DataType dataType, int version) {
        boolean bl = false;
        DataType dataType2 = null;
        boolean bl2 = false;
        DataType dataType3 = null;
        DataType dataType4 = dataType;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).toBoolean());
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType2 = dataType4;
            if (version == 1) {
                return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf(s)));
            }
        }
        if (bl) {
            return BoxesRunTime.boxToInteger((int)DateFormatter$.MODULE$.apply().parse(s));
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl2 = true;
            dataType3 = dataType4;
            if (version == 1) {
                return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(s)));
            }
        }
        if (bl2) {
            return BoxesRunTime.boxToLong((long)this.getTimestampFormatter().parse(s));
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s)).toByte());
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s)).toShort());
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt());
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s)).toLong());
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s)).toFloat());
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s)).toDouble());
        }
        if (dataType4 instanceof DecimalType) {
            return Decimal$.MODULE$.apply(s);
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            return null;
        }
        if (StringType$.MODULE$.equals(dataType4)) {
            return null;
        }
        boolean bl3 = false;
        if (!bl3) throw new AnalysisException(new StringBuilder(55).append("Column statistics deserialization is not supported for ").append(new StringBuilder(23).append("column ").append(name).append(" of data type: ").append(dataType).append(".").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        return null;
    }

    public String toExternalString(Object v, String colName, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        if (DateType$.MODULE$.equals(dataType2)) {
            object = DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)v));
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = DateTimeUtils$.MODULE$.toJavaTimestamp(BoxesRunTime.unboxToLong((Object)v));
        } else {
            boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof IntegralType ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)));
            if (bl) {
                object = v;
            } else if (dataType2 instanceof DecimalType) {
                object = ((Decimal)v).toJavaBigDecimal();
            } else {
                throw new AnalysisException(new StringBuilder(53).append("Column statistics serialization is not supported for ").append(new StringBuilder(23).append("column ").append(colName).append(" of data type: ").append(dataType).append(".").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        Date externalValue = object;
        return ((Object)externalValue).toString();
    }

    public Option<CatalogColumnStat> fromMap(String table, String colName, Map<String, String> map) {
        Some some;
        try {
            some = new Some((Object)new CatalogColumnStat((Option<BigInt>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_DISTINCT_COUNT()).toString()).map((Function1 & Serializable & scala.Serializable)v -> package$.MODULE$.BigInt().apply(new StringOps(Predef$.MODULE$.augmentString(v)).toLong())), (Option<String>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MIN_VALUE()).toString()), (Option<String>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_VALUE()).toString()), (Option<BigInt>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_NULL_COUNT()).toString()).map((Function1 & Serializable & scala.Serializable)v -> package$.MODULE$.BigInt().apply(new StringOps(Predef$.MODULE$.augmentString(v)).toLong())), (Option<Object>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_AVG_LEN()).toString()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)CatalogColumnStat$.$anonfun$fromMap$3(x$14))), (Option<Object>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_LEN()).toString()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)CatalogColumnStat$.$anonfun$fromMap$4(x$15))), (Option<Histogram>)map.get((Object)new StringBuilder(1).append(colName).append(".").append(this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_HISTOGRAM()).toString()).map((Function1 & Serializable & scala.Serializable)str -> HistogramSerializer$.MODULE$.deserialize((String)str)), new StringOps(Predef$.MODULE$.augmentString((String)map.apply((Object)new StringBuilder(1).append(colName).append(".").append(this.KEY_VERSION()).toString()))).toInt()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to parse column statistics for column ").append(colName).append(" in table ").append(table).toString(), e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public CatalogColumnStat apply(Option<BigInt> distinctCount, Option<String> min, Option<String> max, Option<BigInt> nullCount, Option<Object> avgLen, Option<Object> maxLen, Option<Histogram> histogram, int version) {
        return new CatalogColumnStat(distinctCount, min, max, nullCount, avgLen, maxLen, histogram, version);
    }

    public Option<BigInt> apply$default$1() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<BigInt> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Histogram> apply$default$7() {
        return None$.MODULE$;
    }

    public int apply$default$8() {
        return this.VERSION();
    }

    public Option<Tuple8<Option<BigInt>, Option<String>, Option<String>, Option<BigInt>, Option<Object>, Option<Object>, Option<Histogram>, Object>> unapply(CatalogColumnStat x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8(x$0.distinctCount(), x$0.min(), x$0.max(), x$0.nullCount(), x$0.avgLen(), x$0.maxLen(), x$0.histogram(), (Object)BoxesRunTime.boxToInteger((int)x$0.version())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$fromMap$3(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toLong();
    }

    public static final /* synthetic */ long $anonfun$fromMap$4(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toLong();
    }

    private CatalogColumnStat$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.KEY_VERSION = "version";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_DISTINCT_COUNT = "distinctCount";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MIN_VALUE = "min";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_VALUE = "max";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_NULL_COUNT = "nullCount";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_AVG_LEN = "avgLen";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_MAX_LEN = "maxLen";
        this.org$apache$spark$sql$catalyst$catalog$CatalogColumnStat$$KEY_HISTOGRAM = "histogram";
        this.VERSION = 1;
    }
}

