/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.MalformedInputException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u000b\u0017\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011)\u0019!C\u0001q!AQ\b\u0001B\u0001B\u0003%\u0011\bC\u0003?\u0001\u0011\u0005q(\u0002\u0003D\u0001\u0011!\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007M\u0002\u0001\u000b\u0011B+\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000e\u0001Q\u0001\n%DQ!\u001c\u0001\u0005\n9DQ!\u001d\u0001\u0005\nIDQ\u0001\u001f\u0001\u0005\neDaa \u0001\u0005\n\u0005\u0005\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0013\u0001\u0005\u0002\u0005U%!\u0004&bG.\u001cxN\u001c)beN,'O\u0003\u0002\u00181\u0005!!n]8o\u0015\tI\"$\u0001\u0005dCR\fG._:u\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055b\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\u0007g\u000eDW-\\1\u0011\u0005I*T\"A\u001a\u000b\u0005QR\u0012!\u0002;za\u0016\u001c\u0018B\u0001\u001c4\u0005!!\u0015\r^1UsB,\u0017aB8qi&|gn]\u000b\u0002sA\u0011!hO\u0007\u0002-%\u0011AH\u0006\u0002\f\u0015N{ej\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005i\u0002\u0001\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B\u001c\u0005\u0001\u0004I$A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\u0005K\u0015;E%\u0003\u0002GM\tIa)\u001e8di&|g.\r\t\u0003\u0011Fk\u0011!\u0013\u0006\u0003\u0015.\u000bAaY8sK*\u0011A*T\u0001\bU\u0006\u001c7n]8o\u0015\tqu*A\u0005gCN$XM\u001d=nY*\t\u0001+A\u0002d_6L!AU%\u0003\u0015)\u001bxN\u001c)beN,'/A\u0007s_>$8i\u001c8wKJ$XM]\u000b\u0002+B!Q%R$W!\r9vL\u0019\b\u00031vs!!\u0017/\u000e\u0003iS!a\u0017\u0012\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013B\u00010'\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_MA\u00111\rZ\u0007\u00021%\u0011Q\r\u0007\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\bs_>$8i\u001c8wKJ$XM\u001d\u0011\u0002\u000f\u0019\f7\r^8ssV\t\u0011\u000e\u0005\u0002IU&\u00111.\u0013\u0002\f\u0015N|gNR1di>\u0014\u00180\u0001\u0005gC\u000e$xN]=!\u0003Ei\u0017m[3S_>$8i\u001c8wKJ$XM\u001d\u000b\u0003+>DQ\u0001\u001d\u0006A\u0002E\n!\u0001\u001a;\u0002/5\f7.Z*ueV\u001cGOU8pi\u000e{gN^3si\u0016\u0014HCA+t\u0011\u0015!8\u00021\u0001v\u0003\t\u0019H\u000f\u0005\u00023m&\u0011qo\r\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001F7bW\u0016l\u0015\r\u001d*p_R\u001cuN\u001c<feR,'\u000f\u0006\u0002Vu\")1\u0010\u0004a\u0001y\u0006\u0011Q\u000e\u001e\t\u0003euL!A`\u001a\u0003\u000f5\u000b\u0007\u000fV=qK\u00061R.Y6f\u0003J\u0014\u0018-\u001f*p_R\u001cuN\u001c<feR,'\u000fF\u0002V\u0003\u0007Aq!!\u0002\u000e\u0001\u0004\t9!\u0001\u0002biB\u0019!'!\u0003\n\u0007\u0005-1GA\u0005BeJ\f\u0017\u0010V=qK\u0006iQ.Y6f\u0007>tg/\u001a:uKJ$B!!\u0005\u0002\u0016A\u0019\u00111C\u0003\u000e\u0003\u0001Aa!a\u0006\u000f\u0001\u0004\t\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u001dA\f'o]3Kg>tGk\\6f]V!\u0011QDA\u0013)\u0019\ty\"a\u0012\u0002LQ!\u0011\u0011EA\u001c!\u0011\t\u0019#!\n\r\u0001\u00119\u0011qE\bC\u0002\u0005%\"!\u0001*\u0012\t\u0005-\u0012\u0011\u0007\t\u0004K\u00055\u0012bAA\u0018M\t!a*\u001e7m!\r)\u00131G\u0005\u0004\u0003k1#aA!os\"9\u0011\u0011H\bA\u0002\u0005m\u0012!\u00014\u0011\u000f\u0015\ni$!\u0011\u0002\"%\u0019\u0011q\b\u0014\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042\u0001SA\"\u0013\r\t)%\u0013\u0002\n\u0015N|g\u000eV8lK:Da!!\u0013\u0010\u0001\u00049\u0015A\u00029beN,'\u000f\u0003\u0004\u0002\u0018=\u0001\r!M\u0001\u0011M\u0006LG.\u001a3D_:4XM]:j_:,B!!\u0015\u0002XQ1\u00111KA-\u00037\u0002r!JA\u001f\u0003\u0003\n)\u0006\u0005\u0003\u0002$\u0005]CaBA\u0014!\t\u0007\u0011\u0011\u0006\u0005\u0007\u0003\u0013\u0002\u0002\u0019A$\t\r\u0005]\u0001\u00031\u00012\u00035\u0019wN\u001c<feR|%M[3diR9!-!\u0019\u0002d\u0005\u0015\u0004BBA%#\u0001\u0007q\tC\u00031#\u0001\u0007Q\u000fC\u0004\u0002hE\u0001\r!!\u001b\u0002\u001f\u0019LW\r\u001c3D_:4XM\u001d;feN\u0004R!JA6\u0003#I1!!\u001c'\u0005\u0015\t%O]1z\u0003)\u0019wN\u001c<feRl\u0015\r\u001d\u000b\u0007\u0003g\ny(!!\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f\u0019\u0003\u0011)H/\u001b7\n\t\u0005u\u0014q\u000f\u0002\b\u001b\u0006\u0004H)\u0019;b\u0011\u0019\tIE\u0005a\u0001\u000f\"9\u00111\u0011\nA\u0002\u0005E\u0011A\u00044jK2$7i\u001c8wKJ$XM]\u0001\rG>tg/\u001a:u\u0003J\u0014\u0018-\u001f\u000b\u0007\u0003\u0013\u000by)!%\u0011\t\u0005U\u00141R\u0005\u0005\u0003\u001b\u000b9HA\u0005BeJ\f\u0017\u0010R1uC\"1\u0011\u0011J\nA\u0002\u001dCq!a!\u0014\u0001\u0004\t\t\"A\u0003qCJ\u001cX-\u0006\u0003\u0002\u0018\u0006}Ec\u0002,\u0002\u001a\u0006-\u0016Q\u0017\u0005\b\u00037#\u0002\u0019AAO\u0003\u0019\u0011XmY8sIB!\u00111EAP\t\u001d\t\t\u000b\u0006b\u0001\u0003G\u0013\u0011\u0001V\t\u0005\u0003K\u000b\t\u0004E\u0002&\u0003OK1!!+'\u0005\u001dqu\u000e\u001e5j]\u001eDq!!,\u0015\u0001\u0004\ty+\u0001\u0007de\u0016\fG/\u001a)beN,'\u000fE\u0004&\u0003cK\u0017QT$\n\u0007\u0005MfEA\u0005Gk:\u001cG/[8oe!9\u0011q\u0017\u000bA\u0002\u0005e\u0016!\u0004:fG>\u0014H\rT5uKJ\fG\u000e\u0005\u0004&\u000b\u0006u\u00151\u0018\t\u0005\u0003{\u000b)-\u0004\u0002\u0002@*\u0019A'!1\u000b\u0007\u0005\rG$\u0001\u0004v]N\fg-Z\u0005\u0005\u0003\u000f\fyL\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\u0004")
public class JacksonParser
implements Logging {
    public final DataType org$apache$spark$sql$catalyst$json$JacksonParser$$schema;
    private final JSONOptions options;
    private final Function1<JsonParser, Seq<InternalRow>> rootConverter;
    private final JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JSONOptions options() {
        return this.options;
    }

    private Function1<JsonParser, Seq<InternalRow>> rootConverter() {
        return this.rootConverter;
    }

    public JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    }

    private Function1<JsonParser, Seq<InternalRow>> makeRootConverter(DataType dt) {
        Function1<JsonParser, Seq<InternalRow>> function1;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            function1 = this.makeStructRootConverter(structType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            function1 = this.makeMapRootConverter(mapType);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            function1 = this.makeArrayRootConverter(arrayType);
        } else {
            throw new MatchError((Object)dataType);
        }
        return function1;
    }

    private Function1<JsonParser, Seq<InternalRow>> makeStructRootConverter(StructType st) {
        Function1<JsonParser, Object> elementConverter = this.makeConverter(st);
        Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, st, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, st, fieldConverters, (Function1)elementConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$1;
            private final StructType st$1;
            private final Function1[] fieldConverters$1;
            private final Function1 elementConverter$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (JsonToken.START_OBJECT.equals(A1)) {
                    InternalRow internalRow = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$1, this.st$1, this.fieldConverters$1);
                    object = Nil$.MODULE$.$colon$colon((Object)internalRow);
                } else {
                    ArrayData array;
                    object = JsonToken.START_ARRAY.equals(A1) ? ((array = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$1, (Function1<JsonParser, Object>)this.elementConverter$1)).numElements() == 0 ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array.toArray(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$schema, ClassTag$.MODULE$.apply(InternalRow.class)))).toSeq()) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken) ? true : JsonToken.START_ARRAY.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$1 = parser$1;
                this.st$1 = st$1;
                this.fieldConverters$1 = fieldConverters$1;
                this.elementConverter$1 = elementConverter$1;
            }
        });
    }

    private Function1<JsonParser, Seq<InternalRow>> makeMapRootConverter(MapType mt) {
        Function1<JsonParser, Object> fieldConverter = this.makeConverter(mt.valueType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, mt, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)fieldConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$2;
            private final Function1 fieldConverter$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = JsonToken.START_OBJECT.equals(A1) ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$2, (Function1<JsonParser, Object>)this.fieldConverter$1)}))})) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$2 = parser$2;
                this.fieldConverter$1 = fieldConverter$1;
            }
        });
    }

    private Function1<JsonParser, Seq<InternalRow>> makeArrayRootConverter(ArrayType at) {
        Function1<JsonParser, Object> elemConverter = this.makeConverter(at.elementType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, at, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elemConverter, at){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$3;
            private final Function1 elemConverter$1;
            private final ArrayType at$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (JsonToken.START_ARRAY.equals(A1)) {
                    object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$3, (Function1<JsonParser, Object>)this.elemConverter$1)}))}));
                } else if (JsonToken.START_OBJECT.equals(A1) && this.at$1.elementType() instanceof StructType) {
                    StructType st = (StructType)this.at$1.elementType();
                    Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> $this.$outer.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
                    object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$3, st, fieldConverters)}))))}))}));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_ARRAY.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken) && this.at$1.elementType() instanceof StructType;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$3 = parser$3;
                this.elemConverter$1 = elemConverter$1;
                this.at$1 = at$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.types.StructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeArrayRootConverter$1$1 org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        });
    }

    public Function1<JsonParser, Object> makeConverter(DataType dataType2) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType3 = dataType2;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Boolean)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = JsonToken.VALUE_TRUE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(true) : (JsonToken.VALUE_FALSE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(false) : function1.apply(x1));
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x1) {
                    JsonToken jsonToken = x1;
                    boolean bl = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
                    return bl;
                }
            });
        } else if (ByteType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Byte)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$4;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.byte2Byte(this.parser$4.getByteValue()) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x2) {
                    JsonToken jsonToken = x2;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$4 = parser$4;
                }
            });
        } else if (ShortType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Short)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$5;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.short2Short(this.parser$5.getShortValue()) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x3) {
                    JsonToken jsonToken = x3;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$5 = parser$5;
                }
            });
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$6;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.int2Integer(this.parser$6.getIntValue()) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x4) {
                    JsonToken jsonToken = x4;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$6 = parser$6;
                }
            });
        } else if (LongType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$7;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$7.getLongValue()) : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x5) {
                    JsonToken jsonToken = x5;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$7 = parser$7;
                }
            });
        } else if (FloatType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Float)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$8;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.float2Float(this.parser$8.getFloatValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1)) {
                        Float f;
                        String string = this.parser$8.getText();
                        if ("NaN".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NaN);
                        } else if ("Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(FloatType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = f;
                    } else {
                        object = function1.apply(x6);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x6) {
                    JsonToken jsonToken = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl2;
                }
                {
                    this.parser$8 = parser$8;
                }
            });
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Double)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$9;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.double2Double(this.parser$9.getDoubleValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1)) {
                        Double d;
                        String string = this.parser$9.getText();
                        if ("NaN".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NaN);
                        } else if ("Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(DoubleType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = d;
                    } else {
                        object = function1.apply(x7);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x7) {
                    JsonToken jsonToken = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl2;
                }
                {
                    this.parser$9 = parser$9;
                }
            });
        } else if (StringType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (UTF8String)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$10;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    UTF8String uTF8String;
                    A1 A1 = x8;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        uTF8String = UTF8String.fromString((String)this.parser$10.getText());
                    } else {
                        ByteArrayOutputStream writer = new ByteArrayOutputStream();
                        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$factory().createGenerator((OutputStream)writer, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                            $anonfun$$nestedInanonfun$makeConverter$8$1.$anonfun$applyOrElse$4(this, generator);
                            return BoxedUnit.UNIT;
                        });
                        uTF8String = UTF8String.fromBytes((byte[])writer.toByteArray());
                    }
                    return (B1)uTF8String;
                }

                public final boolean isDefinedAt(JsonToken x8) {
                    JsonToken jsonToken = x8;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : true;
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4($anonfun$$nestedInanonfun$makeConverter$8$1 $this, JsonGenerator generator) {
                    generator.copyCurrentStructure($this.parser$10);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$10 = parser$10;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 java.io.ByteArrayOutputStream ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 com.fasterxml.jackson.core.JsonGenerator )}, serializedLambda);
                }
            });
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$11;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x9;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$11.getText();
                        object = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.$outer.options().timestampFormat().parse(stringValue).getTime() * 1000L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.stringToTime(stringValue).getTime() * 1000L)));
                    } else {
                        object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$11.getLongValue() * 1000000L) : function1.apply(x9);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x9) {
                    JsonToken jsonToken = x9;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$11 = parser$11;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$9$1 java.lang.String ), $anonfun$applyOrElse$6(java.lang.String )}, serializedLambda);
                }
            });
        } else if (DateType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$12;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$12.getText();
                        object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.millisToDays($this.$outer.options().dateFormat().parse(stringValue).getTime())).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime(stringValue).getTime()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(stringValue)).toInt())));
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x10) {
                    JsonToken jsonToken = x10;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$12 = parser$12;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.String ), $anonfun$applyOrElse$8(java.lang.String ), $anonfun$applyOrElse$10(java.lang.String ), $anonfun$applyOrElse$9(java.lang.String )}, serializedLambda);
                }
            });
        } else if (BinaryType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (byte[])this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$13;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    A1 A1 = x11;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? this.parser$13.getBinaryValue() : (Object)function1.apply(x11);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x11) {
                    JsonToken jsonToken = x11;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$13 = parser$13;
                }
            });
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Decimal)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser, decimalType){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$14;
                private final DecimalType x13$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    A1 A1 = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    Object object = bl ? Decimal$.MODULE$.apply(this.parser$14.getDecimalValue(), this.x13$1.precision(), this.x13$1.scale()) : function1.apply(x12);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x12) {
                    JsonToken jsonToken = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.parser$14 = parser$14;
                    this.x13$1 = x13$1;
                }
            });
        } else if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (InternalRow)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, structType, fieldConverters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$15;
                private final StructType x14$1;
                private final Function1[] fieldConverters$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    A1 A1 = x13;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$15, this.x14$1, this.fieldConverters$2) : function1.apply(x13);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x13) {
                    JsonToken jsonToken = x13;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$15 = parser$15;
                    this.x14$1 = x14$1;
                    this.fieldConverters$2 = fieldConverters$2;
                }
            });
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            Function1<JsonParser, Object> elementConverter = this.makeConverter(arrayType.elementType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (ArrayData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elementConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$16;
                private final Function1 elementConverter$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    A1 A1 = x14;
                    Object object = JsonToken.START_ARRAY.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$16, (Function1<JsonParser, Object>)this.elementConverter$2) : function1.apply(x14);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x14) {
                    JsonToken jsonToken = x14;
                    boolean bl = JsonToken.START_ARRAY.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$16 = parser$16;
                    this.elementConverter$2 = elementConverter$2;
                }
            });
        } else if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            Function1<JsonParser, Object> valueConverter = this.makeConverter(mapType.valueType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (MapData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)valueConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$17;
                private final Function1 valueConverter$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    A1 A1 = x15;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$17, (Function1<JsonParser, Object>)this.valueConverter$1) : function1.apply(x15);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x15) {
                    JsonToken jsonToken = x15;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$17 = parser$17;
                    this.valueConverter$1 = valueConverter$1;
                }
            });
        } else if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            intersect = this.makeConverter(userDefinedType.sqlType());
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)PartialFunction$.MODULE$.empty());
        }
        return intersect;
    }

    private <R> R parseJsonToken(JsonParser parser, DataType dataType, PartialFunction<JsonToken, R> f) {
        JsonToken jsonToken;
        while (JsonToken.FIELD_NAME.equals(jsonToken = parser.getCurrentToken())) {
            parser.nextToken();
        }
        boolean bl = jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken);
        Object object = bl ? null : f.applyOrElse((Object)jsonToken, this.failedConversion(parser, dataType));
        return (R)object;
    }

    private <R> PartialFunction<JsonToken, R> failedConversion(JsonParser parser, DataType dataType) {
        return new scala.Serializable(null, parser, dataType){
            public static final long serialVersionUID = 0L;
            private final JsonParser parser$18;
            private final DataType dataType$2;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!JsonToken.VALUE_STRING.equals(A1) || this.parser$18.getTextLength() >= 1) {
                    throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                }
                B1 B1 = null;
                return B1;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$18.getTextLength() < 1 ? true : true;
                return bl;
            }
            {
                this.parser$18 = parser$18;
                this.dataType$2 = dataType$2;
            }
        };
    }

    public InternalRow org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(JsonParser parser, StructType schema, Function1<JsonParser, Object>[] fieldConverters) {
        GenericInternalRow row = new GenericInternalRow(schema.length());
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            JsonParser jsonParser;
            Option<Object> option = schema.getFieldIndex(parser.getCurrentName());
            if (option instanceof Some) {
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.value());
                row.update(index, fieldConverters[index].apply((Object)parser));
                jsonParser = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                jsonParser = parser.skipChildren();
                continue;
            }
            throw new MatchError(option);
        }
        return row;
    }

    public MapData org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return ArrayBasedMapData$.MODULE$.apply(keys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)), values.toArray(ClassTag$.MODULE$.Any()));
    }

    public ArrayData org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T> Seq<InternalRow> parse(T record, Function2<JsonFactory, T, JsonParser> createParser, Function1<T, UTF8String> recordLiteral) {
        Seq seq;
        try {
            seq = (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory(), record), (Function1 & Serializable & scala.Serializable)parser -> {
                Nil$ nil$;
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    nil$ = Nil$.MODULE$;
                } else {
                    Seq seq = (Seq)this.rootConverter().apply(parser);
                    if (seq == null) {
                        throw new RuntimeException("Root converter returned null");
                    }
                    Seq seq2 = seq;
                    nil$ = seq2;
                }
                return nil$;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
            if (bl) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, throwable2);
            }
            if (throwable2 instanceof CharConversionException) {
                CharConversionException charConversionException = (CharConversionException)throwable2;
                if (this.options().encoding().isEmpty()) {
                    String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n            |Specifying encoding as an input option explicitly might help to resolve the issue.\n            |")).stripMargin()).append(charConversionException.getMessage()).toString();
                    CharConversionException wrappedCharException = new CharConversionException(msg);
                    wrappedCharException.initCause(charConversionException);
                    throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, wrappedCharException);
                }
            }
            throw throwable;
        }
        return seq;
    }

    public JacksonParser(DataType schema, JSONOptions options) {
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$schema = schema;
        this.options = options;
        Logging.$init$((Logging)this);
        this.rootConverter = this.makeRootConverter(schema);
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory = new JsonFactory();
        options.setJacksonOptions(this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory());
    }
}

