/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathLong$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a long integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u0011\u0011\u0002\u0017)bi\"duN\\4\u000b\u0005\r!\u0011a\u0001=nY*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%Ya\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001d\u0001&o\u001c3vGR\u0004\"aF\u000f\n\u0005yA\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0002\u0001\u0005+\u0007I\u0011\u0001\u0011\u0016\u0003\u0005\u0002\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005'\u0001\tE\t\u0015!\u0003\"\u0003\u0011AX\u000e\u001c\u0011\t\u0011!\u0002!Q3A\u0005\u0002\u0001\nA\u0001]1uQ\"A!\u0006\u0001B\tB\u0003%\u0011%A\u0003qCRD\u0007\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\n\u0001\u0011\u0015\u00191\u00061\u0001\"\u0011\u0015A3\u00061\u0001\"\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002iA\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\r\u000e\u0003aR!!\u000f\t\u0002\rq\u0012xn\u001c;?\u0013\tY\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0019\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0003!!\u0017\r^1UsB,W#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0011!\u0002;za\u0016\u001c\u0018BA$E\u0005!!\u0015\r^1UsB,\u0007\"B%\u0001\t\u0003R\u0015\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA&O\u001fB\u0011q\u0003T\u0005\u0003\u001bb\u00111!\u00118z\u0011\u0015\u0019\u0001\n1\u0001L\u0011\u0015A\u0003\n1\u0001L\u0011\u001d\t\u0006!!A\u0005\u0002I\u000bAaY8qsR\u0019af\u0015+\t\u000f\r\u0001\u0006\u0013!a\u0001C!9\u0001\u0006\u0015I\u0001\u0002\u0004\t\u0003b\u0002,\u0001#\u0003%\taV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005A&FA\u0011ZW\u0005Q\u0006CA.a\u001b\u0005a&BA/_\u0003%)hn\u00195fG.,GM\u0003\u0002`1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0005d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91\rAI\u0001\n\u00039\u0016AD2paf$C-\u001a4bk2$HE\r\u0005\bK\u0002\t\t\u0011\"\u0011g\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!!P5\t\u000f=\u0004\u0011\u0011!C\u0001a\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t\u0011\u000f\u0005\u0002\u0018e&\u00111\u000f\u0007\u0002\u0004\u0013:$\bbB;\u0001\u0003\u0003%\tA^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\tYu\u000fC\u0004yi\u0006\u0005\t\u0019A9\u0002\u0007a$\u0013\u0007C\u0004{\u0001\u0005\u0005I\u0011I>\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012\u0001 \t\u0005{\u0006\u00051*D\u0001\u007f\u0015\ty\b$\u0001\u0006d_2dWm\u0019;j_:L1!a\u0001\u007f\u0005!IE/\u001a:bi>\u0014\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0006\u0003#\u00012aFA\u0007\u0013\r\ty\u0001\u0007\u0002\b\u0005>|G.Z1o\u0011!A\u0018QAA\u0001\u0002\u0004Y\u0005\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0003\u0019)\u0017/^1mgR!\u00111BA\r\u0011!A\u00181CA\u0001\u0002\u0004Y\u0005f\u0003\u0001\u0002\u001e\u0005\r\u0012QEA\u0015\u0003W\u00012AIA\u0010\u0013\r\t\t\u0003\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9#AA\r?\u001a+fjQ0)q6dG\u0006\t=qCRD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004Cn\u001c8hA%tG/Z4fe\u00022\u0018\r\\;fY\u0001z'\u000f\t;iK\u00022\u0018\r\\;fAi,'o\u001c\u0011jM\u0002rw\u000eI7bi\u000eD\u0007%[:!M>,h\u000e\u001a\u0017!_J\u0004\u0013\rI7bi\u000eD\u0007%[:!M>,h\u000e\u001a\u0011ckR\u0004C\u000f[3!m\u0006dW/\u001a\u0011jg\u0002rwN\\\u0017ok6,'/[2/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u0017\u0003aS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001fb}q\u0012g(\r\u001f0Ezb$M\u0010\u001a=_\ttDhL1?O1\u0002se];nQ\u0005|#-K\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\b\u0013\u0005E\"!!A\t\u0002\u0005M\u0012!\u0003-QCRDGj\u001c8h!\r\u0019\u0012Q\u0007\u0004\t\u0003\t\t\t\u0011#\u0001\u00028M)\u0011QGA\u001d9A9\u00111HA!C\u0005rSBAA\u001f\u0015\r\ty\u0004G\u0001\beVtG/[7f\u0013\u0011\t\u0019%!\u0010\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004-\u0003k!\t!a\u0012\u0015\u0005\u0005M\u0002BCA&\u0003k\t\t\u0011\"\u0012\u0002N\u0005AAo\\*ue&tw\rF\u0001h\u0011)\t\t&!\u000e\u0002\u0002\u0013\u0005\u00151K\u0001\u0006CB\u0004H.\u001f\u000b\u0006]\u0005U\u0013q\u000b\u0005\u0007\u0007\u0005=\u0003\u0019A\u0011\t\r!\ny\u00051\u0001\"\u0011)\tY&!\u000e\u0002\u0002\u0013\u0005\u0015QL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty&a\u001b\u0011\u000b]\t\t'!\u001a\n\u0007\u0005\r\u0004D\u0001\u0004PaRLwN\u001c\t\u0006/\u0005\u001d\u0014%I\u0005\u0004\u0003SB\"A\u0002+va2,'\u0007C\u0005\u0002n\u0005e\u0013\u0011!a\u0001]\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005E\u0014QGA\u0001\n\u0013\t\u0019(A\u0006sK\u0006$'+Z:pYZ,GCAA;!\rA\u0017qO\u0005\u0004\u0003sJ'AB(cU\u0016\u001cG\u000f")
public class XPathLong
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathLong xPathLong) {
        return XPathLong$.MODULE$.unapply(xPathLong);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathLong> tupled() {
        return XPathLong$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathLong>> curried() {
        return XPathLong$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_long";
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToLong((long)ret.longValue());
    }

    public XPathLong copy(Expression xml, Expression path) {
        return new XPathLong(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathLong";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathLong)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathLong xPathLong = (XPathLong)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathLong.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathLong.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathLong.canEqual(this)) return false;
        return true;
    }

    public XPathLong(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

