/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within the nodes of xml that match the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n       ['b1','b2','b3']\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u0011\u0011\u0002\u0017)bi\"d\u0015n\u001d;\u000b\u0005\r!\u0011a\u0001=nY*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%Ya\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001d\u0001&o\u001c3vGR\u0004\"aF\u000f\n\u0005yA\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0002\u0001\u0005+\u0007I\u0011\u0001\u0011\u0016\u0003\u0005\u0002\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005'\u0001\tE\t\u0015!\u0003\"\u0003\u0011AX\u000e\u001c\u0011\t\u0011!\u0002!Q3A\u0005\u0002\u0001\nA\u0001]1uQ\"A!\u0006\u0001B\tB\u0003%\u0011%A\u0003qCRD\u0007\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\n\u0001\u0011\u0015\u00191\u00061\u0001\"\u0011\u0015A3\u00061\u0001\"\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002iA\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\r\u000e\u0003aR!!\u000f\t\u0002\rq\u0012xn\u001c;?\u0013\tY\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0019\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0003!!\u0017\r^1UsB,W#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0011!\u0002;za\u0016\u001c\u0018BA$E\u0005!!\u0015\r^1UsB,\u0007\"B%\u0001\t\u0003R\u0015\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA&O\u001fB\u0011q\u0003T\u0005\u0003\u001bb\u00111!\u00118z\u0011\u0015\u0019\u0001\n1\u0001L\u0011\u0015A\u0003\n1\u0001L\u0011\u001d\t\u0006!!A\u0005\u0002I\u000bAaY8qsR\u0019af\u0015+\t\u000f\r\u0001\u0006\u0013!a\u0001C!9\u0001\u0006\u0015I\u0001\u0002\u0004\t\u0003b\u0002,\u0001#\u0003%\taV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005A&FA\u0011ZW\u0005Q\u0006CA.a\u001b\u0005a&BA/_\u0003%)hn\u00195fG.,GM\u0003\u0002`1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0005d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91\rAI\u0001\n\u00039\u0016AD2paf$C-\u001a4bk2$HE\r\u0005\bK\u0002\t\t\u0011\"\u0011g\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!!P5\t\u000f=\u0004\u0011\u0011!C\u0001a\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t\u0011\u000f\u0005\u0002\u0018e&\u00111\u000f\u0007\u0002\u0004\u0013:$\bbB;\u0001\u0003\u0003%\tA^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\tYu\u000fC\u0004yi\u0006\u0005\t\u0019A9\u0002\u0007a$\u0013\u0007C\u0004{\u0001\u0005\u0005I\u0011I>\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012\u0001 \t\u0005{\u0006\u00051*D\u0001\u007f\u0015\ty\b$\u0001\u0006d_2dWm\u0019;j_:L1!a\u0001\u007f\u0005!IE/\u001a:bi>\u0014\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0006\u0003#\u00012aFA\u0007\u0013\r\ty\u0001\u0007\u0002\b\u0005>|G.Z1o\u0011!A\u0018QAA\u0001\u0002\u0004Y\u0005\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0003\u0019)\u0017/^1mgR!\u00111BA\r\u0011!A\u00181CA\u0001\u0002\u0004Y\u0005f\u0003\u0001\u0002\u001e\u0005\r\u0012QEA\u0015\u0003W\u00012AIA\u0010\u0013\r\t\t\u0003\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9#\u00018`\rVs5i\u0018\u0015y[2d\u0003\u0005\u001f9bi\"L\u0003%\f\u0011SKR,(O\\:!C\u0002\u001aHO]5oO\u0002\n'O]1zA=4\u0007E^1mk\u0016\u001c\be^5uQ&t\u0007\u0005\u001e5fA9|G-Z:!_\u001a\u0004\u00030\u001c7!i\"\fG\u000fI7bi\u000eD\u0007\u0005\u001e5fAa\u0003\u0016\r\u001e5!Kb\u0004(/Z:tS>tg&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti#AA\u0006\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C(\u0019 =Ez\u0012\u0017\u0007P\u0018c}q\u0012gH\u0019\u001a=_\ttDH\u0019 cgqz#M\u0010\u001fd}\r\fDhL2?y\rt4M\r\u001f0Gzbt&\u0019 (Y\u001d\nwFY\u0018uKb$\b&K\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001ZvEY\u0019(Y\u001d\u0012'g\n\u0017(EN:SL\u0003\u0011!\u000f%\t\tDAA\u0001\u0012\u0003\t\u0019$A\u0005Y!\u0006$\b\u000eT5tiB\u00191#!\u000e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003o\u0019R!!\u000e\u0002:q\u0001r!a\u000f\u0002B\u0005\nc&\u0004\u0002\u0002>)\u0019\u0011q\b\r\u0002\u000fI,h\u000e^5nK&!\u00111IA\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bY\u0005UB\u0011AA$)\t\t\u0019\u0004\u0003\u0006\u0002L\u0005U\u0012\u0011!C#\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002O\"Q\u0011\u0011KA\u001b\u0003\u0003%\t)a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\n)&a\u0016\t\r\r\ty\u00051\u0001\"\u0011\u0019A\u0013q\na\u0001C!Q\u00111LA\u001b\u0003\u0003%\t)!\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u0011qLA6!\u00159\u0012\u0011MA3\u0013\r\t\u0019\u0007\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\t9'I\u0011\n\u0007\u0005%\u0004D\u0001\u0004UkBdWM\r\u0005\n\u0003[\nI&!AA\u00029\n1\u0001\u001f\u00131\u0011)\t\t(!\u000e\u0002\u0002\u0013%\u00111O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA\u0019\u0001.a\u001e\n\u0007\u0005e\u0014N\u0001\u0004PE*,7\r\u001e")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathList xPathList) {
        return XPathList$.MODULE$.unapply(xPathList);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return new ArrayType(StringType$.MODULE$, false);
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        GenericArrayData genericArrayData;
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            UTF8String[] ret = new UTF8String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            genericArrayData = new GenericArrayData((Object)ret);
        } else {
            genericArrayData = null;
        }
        return genericArrayData;
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

