/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0001>\u0011Qb\u0015;sk\u000e$8\u000fV8Kg>t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001BcF\u000f!MA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0005i\u0011\u0011aB2pI\u0016<WM\\\u0005\u00039e\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003#yI!a\b\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005:\u0013B\u0001\u0015#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003A!f\u0001\n\u0003Y\u0013aB8qi&|gn]\u000b\u0002YA!Q\u0006N\u001c8\u001d\tq#\u0007\u0005\u00020E5\t\u0001G\u0003\u00022\u001d\u00051AH]8pizJ!a\r\u0012\u0002\rA\u0013X\rZ3g\u0013\t)dGA\u0002NCBT!a\r\u0012\u0011\u00055B\u0014BA\u001d7\u0005\u0019\u0019FO]5oO\"A1\b\u0001B\tB\u0003%A&\u0001\u0005paRLwN\\:!\u0011!i\u0004A!f\u0001\n\u0003q\u0014!B2iS2$W#A \u0011\u0005E\u0001\u0015BA!\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u007f\u000511\r[5mI\u0002B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tAR\u0001\u000bi&lWMW8oK&#W#A$\u0011\u0007\u0005Bu'\u0003\u0002JE\t1q\n\u001d;j_:D\u0001b\u0013\u0001\u0003\u0012\u0003\u0006IaR\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003N\u0001\u0011\u0005a*\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fB\u000b&\u000b\u0005\u0002\u0012\u0001!)!\u0006\u0014a\u0001Y!)Q\b\u0014a\u0001\u007f!9Q\t\u0014I\u0001\u0002\u00049\u0005\"\u0002+\u0001\t\u0003*\u0016\u0001\u00038vY2\f'\r\\3\u0016\u0003Y\u0003\"!I,\n\u0005a\u0013#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\u0002!\tA\u0017\u000b\u0004\u001fnc\u0006\"\u0002\u0016Z\u0001\u0004a\u0003\"B\u001fZ\u0001\u0004y\u0004\"B'\u0001\t\u0003qFCA(`\u0011\u0015iT\f1\u0001@\u0011\u0015i\u0005\u0001\"\u0001b)\ry%m\u0019\u0005\u0006{\u0001\u0004\ra\u0010\u0005\u0006U\u0001\u0004\ra\u0010\u0005\tK\u0002A)\u0019!C\u0001M\u00061qO]5uKJ,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f!![8\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0010\u0007\"\f'/\u0011:sCf<&/\u001b;fe\"\u0012A\r\u001d\t\u0003CEL!A\u001d\u0012\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011A;\u0002\u0007\u001d,g.F\u0001w!\t9(0D\u0001y\u0015\tIH!\u0001\u0003kg>t\u0017BA>y\u0005AQ\u0015mY6t_:<UM\\3sCR|'\u000f\u000b\u0002ta\"Aa\u0010\u0001EC\u0002\u0013\u0005q0A\u0006j]B,HoU2iK6\fWCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\r\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005!!\u0015\r^1UsB,\u0007FA?q\u0011)\t\t\u0002\u0001EC\u0002\u0013\u0005\u00111C\u0001\nG>tg/\u001a:uKJ,\"!!\u0006\u0011\u000f\u0005\n9\"a\u0007\u0002\"%\u0019\u0011\u0011\u0004\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0011\u0002\u001e%\u0019\u0011q\u0004\u0012\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002$\u0005-RBAA\u0013\u0015\u0011\t9!a\n\u000b\u0007\u0005%\u0002\"\u0001\u0004v]N\fg-Z\u0005\u0005\u0003[\t)C\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3!a\u0004q\u0011\u0019\t\u0019\u0004\u0001C!\u007f\u0006AA-\u0019;b)f\u0004X\rC\u0004\u00028\u0001!\t%!\u000f\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005C!\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t)%a\u0010\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDq!!\u0013\u0001\t\u0003\nY%\u0001\u0007xSRDG+[7f5>tW\rF\u0002\u0015\u0003\u001bBa!RA$\u0001\u00049\u0004bBA)\u0001\u0011\u0005\u00131K\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u00037\t)\u0006\u0003\u0005\u0002X\u0005=\u0003\u0019AA\u000e\u0003\u00151\u0018\r\\;f\u0011\u001d\tY\u0006\u0001C!\u0003;\n!\"\u001b8qkR$\u0016\u0010]3t+\t\ty\u0006\u0005\u0004\u0002b\u0005-\u0014\u0011\u000f\b\u0005\u0003G\n9GD\u00020\u0003KJ\u0011aI\u0005\u0004\u0003S\u0012\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003[\nyGA\u0002TKFT1!!\u001b#!\u0011\t\u0019!a\u001d\n\t\u0005U\u0014Q\u0001\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016D\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\u0002\t\r|\u0007/\u001f\u000b\b\u001f\u0006u\u0014qPAA\u0011!Q\u0013q\u000fI\u0001\u0002\u0004a\u0003\u0002C\u001f\u0002xA\u0005\t\u0019A \t\u0011\u0015\u000b9\b%AA\u0002\u001dC\u0011\"!\"\u0001#\u0003%\t!a\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0012\u0016\u0004Y\u0005-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]%%\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005}\u0005!%A\u0005\u0002\u0005\u0005\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GS3aPAF\u0011%\t9\u000bAI\u0001\n\u0003\tI+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-&fA$\u0002\f\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e6.\u0001\u0003mC:<\u0017bA\u001d\u00028\"I\u0011q\u0018\u0001\u0002\u0002\u0013\u0005\u0011\u0011Y\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0007\u00042!IAc\u0013\r\t9M\t\u0002\u0004\u0013:$\b\"CAf\u0001\u0005\u0005I\u0011AAg\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0007\u0002P\"Q\u0011\u0011[Ae\u0003\u0003\u0005\r!a1\u0002\u0007a$\u0013\u0007C\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002ZB1\u00111\\Aq\u00037i!!!8\u000b\u0007\u0005}'%\u0001\u0006d_2dWm\u0019;j_:LA!a9\u0002^\nA\u0011\n^3sCR|'\u000fC\u0005\u0002h\u0002\t\t\u0011\"\u0001\u0002j\u0006A1-\u00198FcV\fG\u000eF\u0002W\u0003WD!\"!5\u0002f\u0006\u0005\t\u0019AA\u000e\u0011%\ty\u000fAA\u0001\n\u0003\n\t0\u0001\u0004fcV\fGn\u001d\u000b\u0004-\u0006M\bBCAi\u0003[\f\t\u00111\u0001\u0002\u001c!z\u0001!a>\u0002~\u0006}(1\u0001B\u0003\u0005\u0013\u0011Y\u0001E\u0002\u0012\u0003sL1!a?\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0001\u0002\u0013~3UKT\"`Q\u0015D\bO].-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002R5k\u0014(!gR\u0014\u0018N\\4!o&$\b\u000eI1!O&4XM\u001c\u0011tiJ,8\r\u001e\u0011wC2,X-\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u00119!\u0001Cd\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi\u0012TP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014uS6,w\u0005\f\u0011u_~#\u0018.\\3ti\u0006l\u0007\u000fK\u00143aE*T\u0006\r\u001d.eY:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013&\u000b\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u00123m=\u0002\u0004h\f\u001a1cU\u0012SP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEb#E\u0019\u0012;eul&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\":\u0013m\n\u0017!]\u0006lW\rZ0tiJ,8\r\u001e\u0015(E\u001eb\u0003%M\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#um\u0014#M\t\u001e2{vT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019*Y9\fW.\u001a3`gR\u0014Xo\u0019;)O\t<C\u0006\t\u001a*S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012\\cu\u0013#h\u001f\u0012cEi\u0012T0 \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\bfJ1(Y\u0001\n\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO\u0019~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ!j\u0017\r\u001d\u0015(C\u001eb\u0003%M\u0015*S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#C\nR\u0014'`/\u000bA\u0001\nQa]5oG\u0016\f#A!\u0004\u0002\u000bIr#G\f\u0019\b\u0013\tE!!!A\t\u0002\tM\u0011!D*ueV\u001cGo\u001d+p\u0015N|g\u000eE\u0002\u0012\u0005+1\u0001\"\u0001\u0002\u0002\u0002#\u0005!qC\n\u0006\u0005+\u0011IB\n\t\t\u00057\u0011\t\u0003L H\u001f6\u0011!Q\u0004\u0006\u0004\u0005?\u0011\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005G\u0011iBA\tBEN$(/Y2u\rVt7\r^5p]NBq!\u0014B\u000b\t\u0003\u00119\u0003\u0006\u0002\u0003\u0014!Q!1\u0006B\u000b\u0003\u0003%)E!\f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a-\t\u0015\tE\"QCA\u0001\n\u0003\u0013\u0019$A\u0003baBd\u0017\u0010F\u0004P\u0005k\u00119D!\u000f\t\r)\u0012y\u00031\u0001-\u0011\u0019i$q\u0006a\u0001\u007f!AQIa\f\u0011\u0002\u0003\u0007q\t\u0003\u0006\u0003>\tU\u0011\u0011!CA\u0005\u007f\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003B\t%\u0003\u0003B\u0011I\u0005\u0007\u0002b!\tB#Y}:\u0015b\u0001B$E\t1A+\u001e9mKNB\u0011Ba\u0013\u0003<\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003P\tU\u0011\u0013!C\u0001\u0003S\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003B*\u0005+\t\n\u0011\"\u0001\u0002*\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003X\tU\u0011\u0011!C\u0005\u00053\n1B]3bIJ+7o\u001c7wKR\u0011!1\f\t\u0005\u0003k\u0013i&\u0003\u0003\u0003`\u0005]&AB(cU\u0016\u001cG\u000f")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson structsToJson) {
        return StructsToJson$.MODULE$.unapply(structsToJson);
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                StructField structField = new StructField("a", mapType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType st = StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField));
                JacksonUtils$.MODULE$.verifySchema(st);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$18 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$19 = this.copy$default$1();
        Expression x$20 = this.copy$default$2();
        return this.copy(x$19, x$20, (Option<String>)x$18);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

