/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001>\u0011Ab\u0015;sS:<'+\u001a9fCRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\n1a\u001d;s+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0005gR\u0014\b\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003\u0015!\u0018.\\3t\u0011!Y\u0003A!E!\u0002\u0013\u0019\u0013A\u0002;j[\u0016\u001c\b\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\t\u0001\u0011\u0015\tC\u00061\u0001$\u0011\u0015IC\u00061\u0001$\u0011\u0015\u0019\u0004\u0001\"\u0011#\u0003\u0011aWM\u001a;\t\u000bU\u0002A\u0011\t\u0012\u0002\u000bILw\r\u001b;\t\u000b]\u0002A\u0011\t\u001d\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0019\tQ\u0001^=qKNL!AP\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u0011\u0001\u0005B\u0005\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0005cA\"Ls9\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005)K\u0012a\u00029bG.\fw-Z\u0005\u0003\u00196\u00131aU3r\u0015\tQ\u0015\u0004C\u0003P\u0001\u0011\u0005\u0003+\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002R)Z\u0003\"\u0001\u0007*\n\u0005MK\"aA!os\")QK\u0014a\u0001#\u000611\u000f\u001e:j]\u001eDQa\u0016(A\u0002E\u000b\u0011A\u001c\u0005\u00063\u0002!\tEW\u0001\u000baJ,G\u000f^=OC6,W#A.\u0011\u0005q\u0003gBA/_!\t)\u0015$\u0003\u0002`3\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\ty\u0016\u0004C\u0003e\u0001\u0011\u0005S-A\u0005e_\u001e+gnQ8eKR\u0019a\r\\9\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003W\"\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006[\u000e\u0004\rA\\\u0001\u0004GRD\bCA4p\u0013\t\u0001\bN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bI\u001c\u0007\u0019\u00014\u0002\u0005\u00154\bb\u0002;\u0001\u0003\u0003%\t!^\u0001\u0005G>\u0004\u0018\u0010F\u00020m^Dq!I:\u0011\u0002\u0003\u00071\u0005C\u0004*gB\u0005\t\u0019A\u0012\t\u000fe\u0004\u0011\u0013!C\u0001u\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A>+\u0005\rb8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00033\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"!\u0004\u0001#\u0003%\tA_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t\t\u0002AA\u0001\n\u0003\n\u0019\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003mC:<'BAA\u0010\u0003\u0011Q\u0017M^1\n\u0007\u0005\fI\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0006\t\u00041\u0005-\u0012bAA\u00173\t\u0019\u0011J\u001c;\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004#\u0006U\u0002BCA\u001c\u0003_\t\t\u00111\u0001\u0002*\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f\nVBAA\"\u0015\r\t)%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\n9\u0006E\u0002\u0019\u0003'J1!!\u0016\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000e\u0002L\u0005\u0005\t\u0019A)\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002R\u0005}\u0003\"CA\u001c\u00033\n\t\u00111\u0001RQ-\u0001\u00111MA5\u0003W\ny'!\u001d\u0011\u0007E\t)'C\u0002\u0002h\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002n\u0005\tvLR+O\u0007~C3\u000f\u001e:-A9L\u0003%\f\u0011SKR,(O\\:!i\",\u0007e\u001d;sS:<\u0007e\u001e5jG\"\u0004#/\u001a9fCR\u001c\b\u0005\u001e5fA\u001dLg/\u001a8!gR\u0014\u0018N\\4!m\u0006dW/\u001a\u0011oAQLW.Z:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA:\u0003\u0001S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00193g\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u00124'\r\u001a4\u0015\u0001\u0002s!CA<\u0005\u0005\u0005\t\u0012AA=\u00031\u0019FO]5oOJ+\u0007/Z1u!\r\t\u00121\u0010\u0004\t\u0003\t\t\t\u0011#\u0001\u0002~M)\u00111PA@;A9\u0011\u0011QADG\rzSBAAB\u0015\r\t))G\u0001\beVtG/[7f\u0013\u0011\tI)a!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003w\"\t!!$\u0015\u0005\u0005e\u0004BCAI\u0003w\n\t\u0011\"\u0012\u0002\u0014\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0016!Q\u0011qSA>\u0003\u0003%\t)!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\nY*!(\t\r\u0005\n)\n1\u0001$\u0011\u0019I\u0013Q\u0013a\u0001G!Q\u0011\u0011UA>\u0003\u0003%\t)a)\u0002\u000fUt\u0017\r\u001d9msR!\u0011QUAY!\u0015A\u0012qUAV\u0013\r\tI+\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\tikI\u0012\n\u0007\u0005=\u0016D\u0001\u0004UkBdWM\r\u0005\n\u0003g\u000by*!AA\u0002=\n1\u0001\u001f\u00131\u0011)\t9,a\u001f\u0002\u0002\u0013%\u0011\u0011X\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002<B!\u0011qCA_\u0013\u0011\ty,!\u0007\u0003\r=\u0013'.Z2u\u0001")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat stringRepeat) {
        return StringRepeat$.MODULE$.unapply(stringRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(l, r) -> new StringBuilder(11).append("(").append((String)l).append(").repeat(").append((String)r).append(")").toString());
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.times();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

