/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Stack$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(n, expr1, ..., exprk) - Separates `expr1`, ..., `exprk` into `n` rows.", examples="\n    Examples:\n      > SELECT _FUNC_(2, 1, 2, 3);\n       1  2\n       3  NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001>\u0011Qa\u0015;bG.T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011!\"\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\tIq)\u001a8fe\u0006$xN\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%\u0001\u0005dQ&dGM]3o+\u0005\u0019\u0003c\u0001\u0013-!9\u0011QE\u000b\b\u0003M%j\u0011a\n\u0006\u0003Q9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005-J\u0012a\u00029bG.\fw-Z\u0005\u0003[9\u00121aU3r\u0015\tY\u0013\u0004\u0003\u00051\u0001\tE\t\u0015!\u0003$\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007\u0005C\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0003iU\u0002\"!\u0005\u0001\t\u000b\u0005\n\u0004\u0019A\u0012\t\u0011]\u0002\u0001R1A\u0005\na\nqA\\;n%><8/F\u0001:!\tA\"(\u0003\u0002<3\t\u0019\u0011J\u001c;\t\u0011u\u0002\u0001R1A\u0005\na\n\u0011B\\;n\r&,G\u000eZ:\t\u000b}\u0002A\u0011\u0001!\u0002%!\f7OR8mI\u0006\u0014G.\u001a(v[J{wo]\u000b\u0002\u0003B\u0011\u0001DQ\u0005\u0003\u0007f\u0011qAQ8pY\u0016\fg\u000eC\u0003F\u0001\u0011\u0005c)A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001H!\tA5*D\u0001J\u0015\tQE!\u0001\u0005b]\u0006d\u0017p]5t\u0013\ta\u0015JA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u0015q\u0005\u0001\"\u0001P\u000311\u0017N\u001c3ECR\fG+\u001f9f)\t\u0001f\u000b\u0005\u0002R)6\t!K\u0003\u0002T\r\u0005)A/\u001f9fg&\u0011QK\u0015\u0002\t\t\u0006$\u0018\rV=qK\")q+\u0014a\u0001s\u0005)\u0011N\u001c3fq\")\u0011\f\u0001C!5\u0006iQ\r\\3nK:$8k\u00195f[\u0006,\u0012a\u0017\t\u0003#rK!!\u0018*\u0003\u0015M#(/^2u)f\u0004X\rC\u0003`\u0001\u0011\u0005\u0003-\u0001\u0003fm\u0006dGCA1i!\r!#\rZ\u0005\u0003G:\u0012q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\t\u0003K\u001al\u0011\u0001B\u0005\u0003O\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011N\u0018I\u0001\u0002\u0004!\u0017!B5oaV$\b\"B6\u0001\t\u0003\u0002\u0015AD:vaB|'\u000f^\"pI\u0016<WM\u001c\u0005\u0006[\u0002!\tF\\\u0001\nI><UM\\\"pI\u0016$2a\\;{!\t\u00018/D\u0001r\u0015\t\u0011(!A\u0004d_\u0012,w-\u001a8\n\u0005Q\f(\u0001C#yaJ\u001cu\u000eZ3\t\u000bYd\u0007\u0019A<\u0002\u0007\r$\b\u0010\u0005\u0002qq&\u0011\u00110\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015YH\u000e1\u0001p\u0003\t)g\u000fC\u0004~\u0001\u0005\u0005I\u0011\u0001@\u0002\t\r|\u0007/\u001f\u000b\u0003i}Dq!\t?\u0011\u0002\u0003\u00071\u0005C\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0004U\r\u0019\u0013\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QC\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0013qD\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005Y\u0006twM\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\u0011\ty#!\n\u0003\rM#(/\u001b8h\u0011!\t\u0019\u0004AA\u0001\n\u0003A\u0014\u0001\u00049s_\u0012,8\r^!sSRL\b\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000f\u0002BA\u0019\u0001$!\u0010\n\u0007\u0005}\u0012DA\u0002B]fD\u0011\"a\u0011\u00026\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013\u0007C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002LA1\u0011QJA*\u0003wi!!a\u0014\u000b\u0007\u0005E\u0013$\u0001\u0006d_2dWm\u0019;j_:LA!!\u0016\u0002P\tA\u0011\n^3sCR|'\u000fC\u0005\u0002Z\u0001\t\t\u0011\"\u0001\u0002\\\u0005A1-\u00198FcV\fG\u000eF\u0002B\u0003;B!\"a\u0011\u0002X\u0005\u0005\t\u0019AA\u001e\u0011%\t\t\u0007AA\u0001\n\u0003\n\u0019'\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0003\u0006\u0015\u0004BCA\"\u0003?\n\t\u00111\u0001\u0002<!Z\u0001!!\u001b\u0002p\u0005E\u0014QOA<!\r\t\u00121N\u0005\u0004\u0003[\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003g\nQj\u0018$V\u001d\u000e{\u0006F\u001c\u0017!Kb\u0004(/\r\u0017!]9rC\u0006I3yaJ\\\u0017\u0006I\u0017!'\u0016\u0004\u0018M]1uKN\u0004\u0003-\u001a=qeF\u0002G\u0006\t\u0018/]1\u0002\u0003-\u001a=qe.\u0004\u0007%\u001b8u_\u0002\u0002g\u000e\u0019\u0011s_^\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI(A(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QIb\u0003%\r\u0017!e1\u00023'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c\u0001\u0002#G\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a!A9+F\n\u0014\u0006!A\u001dI\u0011Q\u0010\u0002\u0002\u0002#\u0005\u0011qP\u0001\u0006'R\f7m\u001b\t\u0004#\u0005\u0005e\u0001C\u0001\u0003\u0003\u0003E\t!a!\u0014\u000b\u0005\u0005\u0015QQ\u000f\u0011\r\u0005\u001d\u0015QR\u00125\u001b\t\tIIC\u0002\u0002\ff\tqA];oi&lW-\u0003\u0003\u0002\u0010\u0006%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9!'!!\u0005\u0002\u0005MECAA@\u0011)\t9*!!\u0002\u0002\u0013\u0015\u0013\u0011T\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0005\u0005\u000b\u0003;\u000b\t)!A\u0005\u0002\u0006}\u0015!B1qa2LHc\u0001\u001b\u0002\"\"1\u0011%a'A\u0002\rB!\"!*\u0002\u0002\u0006\u0005I\u0011QAT\u0003\u001d)h.\u00199qYf$B!!+\u00020B!\u0001$a+$\u0013\r\ti+\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005E\u00161UA\u0001\u0002\u0004!\u0014a\u0001=%a!Q\u0011QWAA\u0003\u0003%I!a.\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u0003B!a\t\u0002<&!\u0011QXA\u0013\u0005\u0019y%M[3di\u0002")
public class Stack
extends Expression
implements Generator,
scala.Serializable {
    private int numRows;
    private int numFields;
    private final Seq<Expression> children;
    private volatile byte bitmap$0;

    public static Option<Seq<Expression>> unapply(Stack stack) {
        return Stack$.MODULE$.unapply(stack);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Stack, A> function1) {
        return Stack$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Stack> compose(Function1<A, Seq<Expression>> function1) {
        return Stack$.MODULE$.compose(function1);
    }

    @Override
    public DataType dataType() {
        return Generator.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return Generator.foldable$(this);
    }

    @Override
    public boolean nullable() {
        return Generator.nullable$(this);
    }

    @Override
    public TraversableOnce<InternalRow> terminate() {
        return Generator.terminate$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    private int numRows$lzycompute() {
        Stack stack = this;
        synchronized (stack) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Expression qual$1 = (Expression)this.children().head();
                InternalRow x$5 = qual$1.eval$default$1();
                this.numRows = BoxesRunTime.unboxToInt((Object)qual$1.eval(x$5));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numRows;
    }

    private int numRows() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numRows$lzycompute() : this.numRows;
    }

    private int numFields$lzycompute() {
        Stack stack = this;
        synchronized (stack) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numFields = (int)Math.ceil(((double)this.children().length() - 1.0) / (double)this.numRows());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numFields;
    }

    private int numFields() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.numFields$lzycompute() : this.numFields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasFoldableNumRows() {
        if (!this.children().nonEmpty()) return false;
        DataType dataType = ((Expression)this.children().head()).dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null) {
            if (integerType$ != null) {
                return false;
            }
        } else if (!dataType.equals(integerType$)) return false;
        if (!((Expression)this.children().head()).foldable()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        Object object = new Object();
        try {
            if (this.children().length() <= 1) {
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append(" requires at least 2 arguments.").toString());
                return typeCheckResult;
            }
            DataType dataType = ((Expression)this.children().head()).dataType();
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(integerType$) : integerType$ != null)) {
                if (((Expression)this.children().head()).foldable() && this.numRows() >= 1) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.children().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        int j = (i - 1) % this.numFields();
                        DataType dataType = ((Expression)this.children().apply(i)).dataType();
                        DataType dataType2 = this.elementSchema().fields()[j].dataType();
                        if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                            throw new NonLocalReturnControl(object, (Object)new TypeCheckResult.TypeCheckFailure(new StringBuilder(16).append("Argument ").append(j + 1).append(" (").append(this.elementSchema().fields()[j].dataType().catalogString()).append(") != ").append(new StringBuilder(12).append("Argument ").append(i).append(" (").append(((Expression)this.children().apply(i)).dataType().catalogString()).append(")").toString()).toString()));
                        }
                    });
                    typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    return typeCheckResult;
                }
            }
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("The number of rows must be a positive constant integer.");
            return typeCheckResult;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            typeCheckResult = (TypeCheckResult)ex.value();
            return typeCheckResult;
        }
    }

    public DataType findDataType(int index) {
        DataType dataType;
        Object object = new Object();
        try {
            int firstDataIndex = (index - 1) % this.numFields() + 1;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(firstDataIndex), this.children().length()).by(this.numFields()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                DataType dataType = ((Expression)this.children().apply(i)).dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
                    throw new NonLocalReturnControl(object, (Object)((Expression)this.children().apply(i)).dataType());
                }
            });
            dataType = NullType$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                dataType = (DataType)ex.value();
            }
            throw ex;
        }
        return dataType;
    }

    @Override
    public StructType elementSchema() {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)((IterableLike)((IterableLike)this.children().tail()).take(this.numFields())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression e = (Expression)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(3).append("col").append(index).toString(), e.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public TraversableOnce<InternalRow> eval(InternalRow input) {
        Object[] values = (Object[])((TraversableOnce)((TraversableLike)this.children().tail()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.eval(input), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return (TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRows()).map((Function1 & Serializable & scala.Serializable)row -> Stack.$anonfun$eval$2(this, values, BoxesRunTime.unboxToInt((Object)row)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean supportCodegen() {
        return this.numRows() <= 50;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String rowData = ctx.addMutableState("InternalRow[]", "rows", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(21).append((String)v).append(" = new InternalRow[").append(this.numRows()).append("];").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        Seq values = (Seq)this.children().tail();
        Seq dataTypes = (Seq)((TraversableLike)values.take(this.numFields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom());
        String code = ctx.splitExpressionsWithCurrentInputs((Seq<String>)((Seq)Seq$.MODULE$.tabulate(this.numRows(), (Function1 & Serializable & scala.Serializable)row -> Stack.$anonfun$doGenCode$3(this, ctx, rowData, values, dataTypes, BoxesRunTime.unboxToInt((Object)row)))), ctx.splitExpressionsWithCurrentInputs$default$2(), ctx.splitExpressionsWithCurrentInputs$default$3(), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String wrapperClass = WrappedArray.class.getName();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "<InternalRow> ", " = ", "$.MODULE$.make(", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, wrapperClass, ev.value(), wrapperClass, rowData})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Stack copy(Seq<Expression> children2) {
        return new Stack(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Stack";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Stack)) return false;
        boolean bl = true;
        if (!bl) return false;
        Stack stack = (Stack)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = stack.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!stack.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ InternalRow $anonfun$eval$2(Stack $this, Object[] values$1, int row) {
        Object[] fields = new Object[$this.numFields()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.numFields()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)col -> {
            int index = row * $this.numFields() + col;
            fields$1[col] = index < values$1.length ? values$1[index] : null;
        });
        return InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)fields));
    }

    public static final /* synthetic */ Expression $anonfun$doGenCode$4(Stack $this, Seq values$2, Seq dataTypes$1, int row$2, int col) {
        int index = row$2 * $this.numFields() + col;
        return index < values$2.length() ? (Expression)values$2.apply(index) : new Literal(null, (DataType)dataTypes$1.apply(col));
    }

    public static final /* synthetic */ String $anonfun$doGenCode$3(Stack $this, CodegenContext ctx$1, String rowData$1, Seq values$2, Seq dataTypes$1, int row) {
        Seq fields = (Seq)Seq$.MODULE$.tabulate($this.numFields(), (Function1 & Serializable & scala.Serializable)col -> Stack.$anonfun$doGenCode$4($this, values$2, dataTypes$1, row, BoxesRunTime.unboxToInt((Object)col)));
        ExprCode eval = CreateStruct$.MODULE$.apply((Seq<Expression>)fields).genCode(ctx$1);
        return new StringBuilder(7).append(eval.code()).append("\n").append(rowData$1).append("[").append(row).append("] = ").append(eval.value()).append(";").toString();
    }

    public Stack(Seq<Expression> children2) {
        this.children = children2;
        Generator.$init$(this);
    }
}

