/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Slice$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x, start, length) - Subsets array x starting from index start (or starting from the end if start is negative) with the specified length.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 2, 2);\n       [2,3]\n      > SELECT _FUNC_(array(1, 2, 3, 4), -2, 2);\n       [3,4]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001>\u0011Qa\u00157jG\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013!\u0001=\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0002yA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0003ti\u0006\u0014H\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0019H/\u0019:uA!AQ\u0006\u0001BK\u0002\u0013\u0005!%\u0001\u0004mK:<G\u000f\u001b\u0005\t_\u0001\u0011\t\u0012)A\u0005G\u00059A.\u001a8hi\"\u0004\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\t\u0001\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001$\u0011\u0015i\u0003\u00071\u0001$\u0011\u0015A\u0004\u0001\"\u0011:\u0003!!\u0017\r^1UsB,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011!\u0002;za\u0016\u001c\u0018BA =\u0005!!\u0015\r^1UsB,\u0007\"B!\u0001\t\u0003\u0012\u0015AC5oaV$H+\u001f9fgV\t1\tE\u0002E\u0019>s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111*\u0007\t\u0003wAK!!\u0015\u001f\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\u0002C*\u0001\u0011\u000b\u0007I\u0011\t+\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u0016\t\u0004\t2\u001b\u0003F\u0001*X!\tA\u0002,\u0003\u0002Z3\tIAO]1og&,g\u000e\u001e\u0005\t7\u0002A)\u0019!C\u0005s\u0005YQ\r\\3nK:$H+\u001f9fQ\tQv\u000bC\u0003_\u0001\u0011\u0005s,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003aG\u0016<\u0007C\u0001\rb\u0013\t\u0011\u0017DA\u0002B]fDQ\u0001Z/A\u0002\u0001\fA\u0001\u001f,bY\")a-\u0018a\u0001A\u0006A1\u000f^1siZ\u000bG\u000eC\u0003i;\u0002\u0007\u0001-A\u0005mK:<G\u000f\u001b,bY\")!\u000e\u0001C!W\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004YJ<\bCA7q\u001b\u0005q'BA8\u0003\u0003\u001d\u0019w\u000eZ3hK:L!!\u001d8\u0003\u0011\u0015C\bO]\"pI\u0016DQa]5A\u0002Q\f1a\u0019;y!\tiW/\u0003\u0002w]\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u0002=j\u0001\u0004a\u0017AA3w\u0011\u0015Q\b\u0001\"\u0001|\u0003A9WM\\\"pI\u00164uN\u001d*fgVdG\u000fF\u0006}\u0003\u0013\tY!!\u0004\u0002\u0012\u0005U\u0001cA?\u0002\u00049\u0011ap \t\u0003\rfI1!!\u0001\u001a\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A\r\t\u000bML\b\u0019\u0001;\t\u000baL\b\u0019\u00017\t\r\u0005=\u0011\u00101\u0001}\u0003)Ig\u000e];u\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003'I\b\u0019\u0001?\u0002\u0011M$\u0018M\u001d;JIbDa!a\u0006z\u0001\u0004a\u0018!\u0003:fg2+gn\u001a;i\u0011%\tY\u0002AA\u0001\n\u0003\ti\"\u0001\u0003d_BLHcB\u001a\u0002 \u0005\u0005\u00121\u0005\u0005\tC\u0005e\u0001\u0013!a\u0001G!A\u0011&!\u0007\u0011\u0002\u0003\u00071\u0005\u0003\u0005.\u00033\u0001\n\u00111\u0001$\u0011%\t9\u0003AI\u0001\n\u0003\tI#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-\"fA\u0012\u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:e\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA#\u0001E\u0005I\u0011AA\u0015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t1\fgn\u001a\u0006\u0003\u0003/\nAA[1wC&!\u0011QAA)\u0011%\ti\u0006AA\u0001\n\u0003\ty&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002bA\u0019\u0001$a\u0019\n\u0007\u0005\u0015\u0014DA\u0002J]RD\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001-!\u001c\t\u0015\u0005=\u0014qMA\u0001\u0002\u0004\t\t'A\u0002yIEB\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b\u0005e\u0014q\u00101\u000e\u0005\u0005m$bAA?3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0011qQ\u0001\tG\u0006tW)];bYR!\u0011\u0011RAH!\rA\u00121R\u0005\u0004\u0003\u001bK\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003_\n\u0019)!AA\u0002\u0001D\u0011\"a%\u0001\u0003\u0003%\t%!&\u0002\r\u0015\fX/\u00197t)\u0011\tI)a&\t\u0013\u0005=\u0014\u0011SA\u0001\u0002\u0004\u0001\u0007f\u0004\u0001\u0002\u001c\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u0011\u0007E\ti*C\u0002\u0002 \n\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002&\u0006\tyb\u0018$V\u001d\u000e{\u0006\u0006\u001f\u0017!gR\f'\u000f\u001e\u0017!Y\u0016tw\r\u001e5*A5\u00023+\u001e2tKR\u001c\b%\u0019:sCf\u0004\u0003\u0010I:uCJ$\u0018N\\4!MJ|W\u000eI5oI\u0016D\be\u001d;beR\u0004\u0003f\u001c:!gR\f'\u000f^5oO\u00022'o\\7!i\",\u0007%\u001a8eA%4\u0007e\u001d;beR\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fS\u0001:\u0018\u000e\u001e5!i\",\u0007e\u001d9fG&4\u0017.\u001a3!Y\u0016tw\r\u001e5/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAV\u0003\u0005e!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023\u0007\f\u00115S1\u0002#\u0007\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u00023L\r\u00174;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMb\u0003\u0005N\u0015-A5\u0012D\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007\f\u001b^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAY\u0003\u0015\u0011d\u0006\u000e\u00181\u000f%\t)LAA\u0001\u0012\u0003\t9,A\u0003TY&\u001cW\rE\u0002\u0012\u0003s3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u00111X\n\u0006\u0003s\u000bi,\b\t\t\u0003\u007f\u000b)mI\u0012$g5\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007L\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u000f\f\tMA\tBEN$(/Y2u\rVt7\r^5p]NBq!MA]\t\u0003\tY\r\u0006\u0002\u00028\"Q\u0011qZA]\u0003\u0003%)%!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\t\u0015\u0005U\u0017\u0011XA\u0001\n\u0003\u000b9.A\u0003baBd\u0017\u0010F\u00044\u00033\fY.!8\t\r\u0005\n\u0019\u000e1\u0001$\u0011\u0019I\u00131\u001ba\u0001G!1Q&a5A\u0002\rB!\"!9\u0002:\u0006\u0005I\u0011QAr\u0003\u001d)h.\u00199qYf$B!!:\u0002rB)\u0001$a:\u0002l&\u0019\u0011\u0011^\r\u0003\r=\u0003H/[8o!\u0019A\u0012Q^\u0012$G%\u0019\u0011q^\r\u0003\rQ+\b\u000f\\34\u0011%\t\u00190a8\u0002\u0002\u0003\u00071'A\u0002yIAB!\"a>\u0002:\u0006\u0005I\u0011BA}\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\b\u0003BA(\u0003{LA!a@\u0002R\t1qJ\u00196fGR\u0004")
public class Slice
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Seq<Expression> children;
    private transient DataType elementType;
    private final Expression x;
    private final Expression start;
    private final Expression length;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Slice slice) {
        return Slice$.MODULE$.unapply(slice);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Slice> tupled() {
        return Slice$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Slice>>> curried() {
        return Slice$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression start() {
        return this.start;
    }

    public Expression length() {
        return this.length;
    }

    @Override
    public DataType dataType() {
        return this.x().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    private Seq<Expression> children$lzycompute() {
        Slice slice = this;
        synchronized (slice) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.children = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.x(), this.start(), this.length()}));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.children;
    }

    @Override
    public Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.children$lzycompute() : this.children;
    }

    private DataType elementType$lzycompute() {
        Slice slice = this;
        synchronized (slice) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.x().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Object nullSafeEval(Object xVal, Object startVal, Object lengthVal) {
        int startIndex;
        int startInt = BoxesRunTime.unboxToInt((Object)startVal);
        int lengthInt = BoxesRunTime.unboxToInt((Object)lengthVal);
        ArrayData arr = (ArrayData)xVal;
        if (startInt == 0) {
            throw new RuntimeException(new StringBuilder(70).append("Unexpected value for start in function ").append(this.prettyName()).append(": SQL array indices start at 1.").toString());
        }
        int n = startIndex = startInt < 0 ? startInt + arr.numElements() : startInt - 1;
        if (lengthInt < 0) {
            throw new RuntimeException(new StringBuilder(84).append("Unexpected value for length in function ").append(this.prettyName()).append(": ").append("length must be greater than or equal to 0.").toString());
        }
        if (startIndex < 0 || startIndex >= arr.numElements()) {
            return new GenericArrayData(Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()));
        }
        IndexedSeq data = arr.toSeq(this.elementType());
        return new GenericArrayData((Seq<Object>)((Seq)data.slice(startIndex, startIndex + lengthInt)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(x, start, length) -> {
            String startIdx = ctx.freshName("startIdx");
            String resLength = ctx.freshName("resLength");
            String defaultIntValue = CodeGenerator$.MODULE$.defaultValue("int", false);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(684).append("\n         |").append("int").append(" ").append(startIdx).append(" = ").append(defaultIntValue).append(";\n         |").append("int").append(" ").append(resLength).append(" = ").append(defaultIntValue).append(";\n         |if (").append((String)start).append(" == 0) {\n         |  throw new RuntimeException(\"Unexpected value for start in function ").append(this.prettyName()).append(": \"\n         |    + \"SQL array indices start at 1.\");\n         |} else if (").append((String)start).append(" < 0) {\n         |  ").append(startIdx).append(" = ").append((String)start).append(" + ").append((String)x).append(".numElements();\n         |} else {\n         |  // arrays in SQL are 1-based instead of 0-based\n         |  ").append(startIdx).append(" = ").append((String)start).append(" - 1;\n         |}\n         |if (").append((String)length).append(" < 0) {\n         |  throw new RuntimeException(\"Unexpected value for length in function ").append(this.prettyName()).append(": \"\n         |    + \"length must be greater than or equal to 0.\");\n         |} else if (").append((String)length).append(" > ").append((String)x).append(".numElements() - ").append(startIdx).append(") {\n         |  ").append(resLength).append(" = ").append((String)x).append(".numElements() - ").append(startIdx).append(";\n         |} else {\n         |  ").append(resLength).append(" = ").append((String)length).append(";\n         |}\n         |").append(this.genCodeForResult(ctx, ev, (String)x, startIdx, resLength)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String startIdx, String resLength) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String genericArrayData = GenericArrayData.class.getName();
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, i, new StringBuilder(3).append(i).append(" + ").append(startIdx).toString(), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("\n       |if (").append(startIdx).append(" < 0 || ").append(startIdx).append(" >= ").append(inputArray).append(".numElements()) {\n       |  ").append(ev.value()).append(" = new ").append(genericArrayData).append("(new Object[0]);\n       |} else {\n       |  ").append(allocation).append("\n       |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(resLength).append("; ").append(i).append(" ++) {\n       |    ").append(assignment).append("\n       |  }\n       |  ").append(ev.value()).append(" = ").append(values).append(";\n       |}\n     ").toString())).stripMargin();
    }

    public Slice copy(Expression x, Expression start, Expression length) {
        return new Slice(x, start, length);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.start();
    }

    public Expression copy$default$3() {
        return this.length();
    }

    @Override
    public String productPrefix() {
        return "Slice";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.x();
                break;
            }
            case 1: {
                expression = this.start();
                break;
            }
            case 2: {
                expression = this.length();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Slice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Slice)) return false;
        boolean bl = true;
        if (!bl) return false;
        Slice slice = (Slice)x$1;
        Expression expression = this.x();
        Expression expression2 = slice.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.start();
        Expression expression4 = slice.start();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.length();
        Expression expression6 = slice.length();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!slice.canEqual(this)) return false;
        return true;
    }

    public Slice(Expression x, Expression start, Expression length) {
        this.x = x;
        this.start = start;
        this.length = length;
        ExpectsInputTypes.$init$(this);
    }
}

