/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start, stop, step) - Generates an array of elements from start to stop (inclusive),\n      incrementing by step. The type of the returned elements is the same as the type of argument\n      expressions.\n\n      Supported types are: byte, short, integer, long, date, timestamp.\n\n      The start and stop expressions must resolve to the same type.\n      If start and stop expressions resolve to the 'date' or 'timestamp' type\n      then the step expression must resolve to the 'interval' type, otherwise to the same type\n      as the start and stop expressions.\n  ", arguments="\n    Arguments:\n      * start - an expression. The start of the range.\n      * stop - an expression. The end the range (inclusive).\n      * step - an optional expression. The step of the range.\n          By default step is 1 if start is less than or equal to stop, otherwise -1.\n          For the temporal sequences it's 1 day and -1 day respectively.\n          If start is greater than stop then the step must be negative, and vice versa.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(5, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(to_date('2018-01-01'), to_date('2018-03-01'), interval 1 month);\n       [2018-01-01,2018-02-01,2018-03-01]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B\u0001\u0003\u0001>\u0011\u0001bU3rk\u0016t7-\u001a\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u0018;A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u0015\u0019H/\u0019:u+\u0005\u0001\u0002\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\rM$\u0018M\u001d;!\u0011!1\u0003A!f\u0001\n\u0003\u0011\u0013\u0001B:u_BD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u0006gR|\u0007\u000f\t\u0005\tU\u0001\u0011)\u001a!C\u0001W\u000591\u000f^3q\u001fB$X#\u0001\u0017\u0011\u0007ai\u0003#\u0003\u0002/3\t1q\n\u001d;j_:D\u0001\u0002\r\u0001\u0003\u0012\u0003\u0006I\u0001L\u0001\tgR,\u0007o\u00149uA!A!\u0007\u0001BK\u0002\u0013\u00051'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u000e\t\u000415*\u0004C\u0001\u001c>\u001d\t94\b\u0005\u0002935\t\u0011H\u0003\u0002;\u001d\u00051AH]8pizJ!\u0001P\r\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yeA\u0001\"\u0011\u0001\u0003\u0012\u0003\u0006I\u0001N\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003D\u0001\u0011\u0005A)\u0001\u0004=S:LGO\u0010\u000b\u0006\u000b\u001a;\u0005*\u0013\t\u0003#\u0001AQ!\t\"A\u0002AAQA\n\"A\u0002AAQA\u000b\"A\u00021BqA\r\"\u0011\u0002\u0003\u0007A\u0007C\u0003D\u0001\u0011\u00051\nF\u0002F\u00196CQ!\t&A\u0002AAQA\n&A\u0002AAQa\u0011\u0001\u0005\u0002=#B!\u0012)R%\")\u0011E\u0014a\u0001!!)aE\u0014a\u0001!!)1K\u0014a\u0001!\u0005!1\u000f^3q\u0011\u0015)\u0006\u0001\"\u0011W\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t!r\u000bC\u00033)\u0002\u0007Q\u0007C\u0003Z\u0001\u0011\u0005#,\u0001\u0005dQ&dGM]3o+\u0005Y\u0006c\u0001/b!9\u0011Ql\u0018\b\u0003qyK\u0011AG\u0005\u0003Af\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n\u00191+Z9\u000b\u0005\u0001L\u0002\"B3\u0001\t\u00032\u0017\u0001\u00034pY\u0012\f'\r\\3\u0016\u0003\u001d\u0004\"\u0001\u00075\n\u0005%L\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006W\u0002!\tEZ\u0001\t]VdG.\u00192mK\")Q\u000e\u0001C!]\u0006AA-\u0019;b)f\u0004X-F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011h!A\u0003usB,7/\u0003\u0002uc\nI\u0011I\u001d:bsRK\b/\u001a\u0005\u0006m\u0002!\te^\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010B\u0001\tC:\fG._:jg&\u0011QP\u001f\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\")q\u0010\u0001C\u00015\u0006\t2m\\3sG&\u0014G.Z\"iS2$'/\u001a8\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005q1-Y:u\u0007\"LG\u000e\u001a:f]R{Gc\u0001\t\u0002\b!A\u0011\u0011BA\u0001\u0001\u0004\tY!A\u0005xS\u0012,'\u000fV=qKB\u0019\u0001/!\u0004\n\u0007\u0005=\u0011O\u0001\u0005ECR\fG+\u001f9f\u0011)\t\u0019\u0002\u0001EC\u0002\u0013%\u0011QC\u0001\u0005S6\u0004H.\u0006\u0002\u0002\u0018A!\u0011\u0011DAM\u001d\r\t\u00121D\u0004\b\u0003;\u0011\u0001\u0012AA\u0010\u0003!\u0019V-];f]\u000e,\u0007cA\t\u0002\"\u00191\u0011A\u0001E\u0001\u0003G\u0019R!!\t\u0002&u\u00012\u0001GA\u0014\u0013\r\tI#\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\r\u000b\t\u0003\"\u0001\u0002.Q\u0011\u0011qD\u0003\b\u0003c\t\t\u0003BA\u001a\u0005EaUm]:UQ\u0006twJ]#rk\u0006dgI\u001c\t\t1\u0005U\u0012\u0011HA\u001dO&\u0019\u0011qG\r\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\r\u0002<%\u0019\u0011QH\r\u0003\u0007\u0005s\u0017PB\u0004\u0002B\u0005\u0005B!a\u0011\u0003\u0017\u0011+g-Y;miN#X\r]\n\u0005\u0003\u007f\t)\u0003C\u0006\u0002H\u0005}\"\u0011!Q\u0001\n\u0005%\u0013\u0001\u00027uKF\u0004B!a\u0013\u000205\u0011\u0011\u0011\u0005\u0005\f\u0003\u001f\nyD!A!\u0002\u0013\tY!\u0001\u0005ti\u0016\u0004H+\u001f9f\u0011-\t\u0019&a\u0010\u0003\u0002\u0003\u0006I!!\u000f\u0002\u0007=tW\rC\u0004D\u0003\u007f!\t!a\u0016\u0015\u0011\u0005e\u00131LA/\u0003?\u0002B!a\u0013\u0002@!A\u0011qIA+\u0001\u0004\tI\u0005\u0003\u0005\u0002P\u0005U\u0003\u0019AA\u0006\u0011!\t\u0019&!\u0016A\u0002\u0005e\u0002BCA2\u0003\u007f\u0011\r\u0011\"\u0003\u0002f\u0005Ya.Z4bi&4Xm\u00148f+\t\tI\u0004C\u0005\u0002j\u0005}\u0002\u0015!\u0003\u0002:\u0005aa.Z4bi&4Xm\u00148fA!A\u0011QNA \t\u0003\ty'A\u0003baBd\u0017\u0010\u0006\u0004\u0002:\u0005E\u00141\u000f\u0005\bC\u0005-\u0004\u0019AA\u001d\u0011\u001d1\u00131\u000ea\u0001\u0003sA\u0001\"a\u001e\u0002@\u0011\u0005\u0011\u0011P\u0001\bO\u0016t7i\u001c3f)!\tY(a\"\u0002\u0012\u0006U\u0005\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005%!A\u0004d_\u0012,w-\u001a8\n\t\u0005\u0015\u0015q\u0010\u0002\t\u000bb\u0004(oQ8eK\"A\u0011\u0011RA;\u0001\u0004\tY)A\u0002dib\u0004B!! \u0002\u000e&!\u0011qRA@\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRD\u0001\"a%\u0002v\u0001\u0007\u00111P\u0001\tgR\f'\u000f^$f]\"A\u0011qSA;\u0001\u0004\tY(A\u0004ti>\u0004x)\u001a8\u0007\u0015\u0005m\u0015\u0011\u0005I\u0001$\u0013\tiJ\u0001\u0007TKF,XM\\2f\u00136\u0004Hn\u0005\u0003\u0002\u001a\u0006\u0015\u0002\u0002CAQ\u000333\t!a)\u0002\t\u00154\u0018\r\u001c\u000b\t\u0003s\t)+a*\u0002*\"9\u0011%a(A\u0002\u0005e\u0002b\u0002\u0014\u0002 \u0002\u0007\u0011\u0011\b\u0005\b'\u0006}\u0005\u0019AA\u001d\u0011!\t9(!'\u0007\u0002\u00055F#D\u001b\u00020\u0006E\u00161WA[\u0003o\u000bY\f\u0003\u0005\u0002\n\u0006-\u0006\u0019AAF\u0011\u0019\t\u00131\u0016a\u0001k!1a%a+A\u0002UBaaUAV\u0001\u0004)\u0004bBA]\u0003W\u0003\r!N\u0001\u0004CJ\u0014\bbBA_\u0003W\u0003\r!N\u0001\tK2,W\u000eV=qK\"Q\u0011\u0011YAM\u0005\u00045\t!a1\u0002\u0017\u0011,g-Y;miN#X\r]\u000b\u0003\u000332q!a2\u0002\"\u0011\tIM\u0001\u000bJ]R,wM]1m'\u0016\fX/\u001a8dK&k\u0007\u000f\\\u000b\u0005\u0003\u0017\fYo\u0005\u0004\u0002F\u0006\u0015\u0012Q\u001a\t\u0005\u0003\u0017\nI\nC\u0006\u0002>\u0006\u0015'\u0011!Q\u0001\n\u0005E\u0007c\u00019\u0002T&\u0019\u0011Q[9\u0003\u0019%sG/Z4sC2$\u0016\u0010]3\t\u0017\u0005e\u0017Q\u0019B\u0002B\u0003-\u00111\\\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBAo\u0003G\f9/\u0004\u0002\u0002`*\u0019\u0011\u0011]\r\u0002\u000fI,g\r\\3di&!\u0011Q]Ap\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BAu\u0003Wd\u0001\u0001\u0002\u0005\u0002n\u0006\u0015'\u0019AAx\u0005\u0005!\u0016\u0003BAy\u0003s\u00012\u0001GAz\u0013\r\t)0\u0007\u0002\b\u001d>$\b.\u001b8h\u0011-\tI0!2\u0003\u0002\u0003\u0006Y!a?\u0002\u00079,X\u000eE\u0003]\u0003{\f9/C\u0002\u0002\u0000\u000e\u0014\u0001\"\u00138uK\u001e\u0014\u0018\r\u001c\u0005\b\u0007\u0006\u0015G\u0011\u0001B\u0002)\u0011\u0011)A!\u0004\u0015\r\t\u001d!\u0011\u0002B\u0006!\u0019\tY%!2\u0002h\"A\u0011\u0011\u001cB\u0001\u0001\b\tY\u000e\u0003\u0005\u0002z\n\u0005\u00019AA~\u0011!\tiL!\u0001A\u0002\u0005E\u0007BCAa\u0003\u000b\u0014\r\u0011\"\u0011\u0002D\"I!1CAcA\u0003%\u0011\u0011L\u0001\rI\u00164\u0017-\u001e7u'R,\u0007\u000f\t\u0005\t\u0003C\u000b)\r\"\u0011\u0003\u0018QA!\u0011\u0004B\u0010\u0005G\u00119\u0003E\u0003\u0019\u00057\t9/C\u0002\u0003\u001ee\u0011Q!\u0011:sCfD\u0001B!\t\u0003\u0016\u0001\u0007\u0011\u0011H\u0001\u0007S:\u0004X\u000f^\u0019\t\u0011\t\u0015\"Q\u0003a\u0001\u0003s\ta!\u001b8qkR\u0014\u0004\u0002\u0003B\u0015\u0005+\u0001\r!!\u000f\u0002\r%t\u0007/\u001e;4\u0011!\t9(!2\u0005B\t5B#D\u001b\u00030\tE\"1\u0007B\u001b\u0005o\u0011I\u0004\u0003\u0005\u0002\n\n-\u0002\u0019AAF\u0011\u0019\t#1\u0006a\u0001k!1aEa\u000bA\u0002UBaa\u0015B\u0016\u0001\u0004)\u0004bBA]\u0005W\u0001\r!\u000e\u0005\b\u0003{\u0013Y\u00031\u00016\r\u001d\u0011i$!\t\u0005\u0005\u007f\u0011A\u0003V3na>\u0014\u0018\r\\*fcV,gnY3J[BdW\u0003\u0002B!\u0005;\u001abAa\u000f\u0002&\u00055\u0007b\u0003B#\u0005w\u0011\t\u0011)A\u0005\u0003#\f!\u0001\u001a;\t\u0017\t%#1\bB\u0001B\u0003%!1J\u0001\u0006g\u000e\fG.\u001a\t\u00041\t5\u0013b\u0001B(3\t!Aj\u001c8h\u0011-\u0011\u0019Fa\u000f\u0003\u0002\u0003\u0006IA!\u0016\u0002\u0011\u0019\u0014x.\u001c'p]\u001e\u0004r\u0001\u0007B,\u0005\u0017\u0012Y&C\u0002\u0003Ze\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005%(Q\f\u0003\t\u0003[\u0014YD1\u0001\u0002p\"Y!\u0011\rB\u001e\u0005\u0003\u0005\u000b\u0011\u0002B2\u0003!!\u0018.\\3[_:,\u0007\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\u0005kRLGN\u0003\u0002\u0003n\u0005!!.\u0019<b\u0013\u0011\u0011\tHa\u001a\u0003\u0011QKW.\u001a.p]\u0016D1B!\u001e\u0003<\t\r\t\u0015a\u0003\u0003x\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005u\u00171\u001dB.\u0011-\tIPa\u000f\u0003\u0002\u0003\u0006YAa\u001f\u0011\u000bq\u000biPa\u0017\t\u000f\r\u0013Y\u0004\"\u0001\u0003\u0000QQ!\u0011\u0011BE\u0005\u0017\u0013iIa$\u0015\r\t\r%Q\u0011BD!\u0019\tYEa\u000f\u0003\\!A!Q\u000fB?\u0001\b\u00119\b\u0003\u0005\u0002z\nu\u00049\u0001B>\u0011!\u0011)E! A\u0002\u0005E\u0007\u0002\u0003B%\u0005{\u0002\rAa\u0013\t\u0011\tM#Q\u0010a\u0001\u0005+B\u0001B!\u0019\u0003~\u0001\u0007!1\r\u0005\u000b\u0003\u0003\u0014YD1A\u0005B\u0005\r\u0007\"\u0003B\n\u0005w\u0001\u000b\u0011BA-\u0011)\u00119Ja\u000fC\u0002\u0013%!\u0011T\u0001\u0013E\u0006\u001c7.\u001a3TKF,XM\\2f\u00136\u0004H.\u0006\u0002\u0003\u001cB1\u00111JAc\u00057B\u0011Ba(\u0003<\u0001\u0006IAa'\u0002'\t\f7m[3e'\u0016\fX/\u001a8dK&k\u0007\u000f\u001c\u0011\t\u0015\t\r&1\bb\u0001\n\u0013\u0011)+\u0001\bnS\u000e\u0014xn\u001d)fe6{g\u000e\u001e5\u0016\u0005\t-\u0003\"\u0003BU\u0005w\u0001\u000b\u0011\u0002B&\u0003=i\u0017n\u0019:pgB+'/T8oi\"\u0004\u0003\u0002CAQ\u0005w!\tE!,\u0015\u0011\t=&\u0011\u0017BZ\u0005k\u0003R\u0001\u0007B\u000e\u00057B\u0001B!\t\u0003,\u0002\u0007\u0011\u0011\b\u0005\t\u0005K\u0011Y\u000b1\u0001\u0002:!A!\u0011\u0006BV\u0001\u0004\tI\u0004\u0003\u0005\u0002x\tmB\u0011\tB])5)$1\u0018B_\u0005\u007f\u0013\tMa1\u0003F\"A\u0011\u0011\u0012B\\\u0001\u0004\tY\t\u0003\u0004\"\u0005o\u0003\r!\u000e\u0005\u0007M\t]\u0006\u0019A\u001b\t\rM\u00139\f1\u00016\u0011\u001d\tILa.A\u0002UBq!!0\u00038\u0002\u0007Q\u0007\u0003\u0005\u0003J\u0006\u0005B\u0011\u0002Bf\u0003E9W\r^*fcV,gnY3MK:<G\u000f[\u000b\u0005\u0005\u001b\u0014i\u000e\u0006\u0005\u0003P\n\u0005(1\u001dBs)\u0011\u0011\tNa6\u0011\u0007a\u0011\u0019.C\u0002\u0003Vf\u00111!\u00138u\u0011!\tIPa2A\u0004\te\u0007#\u0002/\u0002~\nm\u0007\u0003BAu\u0005;$\u0001Ba8\u0003H\n\u0007\u0011q\u001e\u0002\u0002+\"9\u0011Ea2A\u0002\tm\u0007b\u0002\u0014\u0003H\u0002\u0007!1\u001c\u0005\b'\n\u001d\u0007\u0019\u0001Bn\u0011!\u0011I/!\t\u0005\n\t-\u0018!F4f]N+\u0017/^3oG\u0016dUM\\4uQ\u000e{G-\u001a\u000b\fk\t5(q\u001eBy\u0005g\u0014)\u0010\u0003\u0005\u0002\n\n\u001d\b\u0019AAF\u0011\u0019\t#q\u001da\u0001k!1aEa:A\u0002UBaa\u0015Bt\u0001\u0004)\u0004b\u0002B|\u0005O\u0004\r!N\u0001\u0004Y\u0016t\u0007BCA7\u0003C\t\t\u0011\"!\u0003|RIQI!@\u0003\u0000\u000e\u000511\u0001\u0005\u0007C\te\b\u0019\u0001\t\t\r\u0019\u0012I\u00101\u0001\u0011\u0011\u0019Q#\u0011 a\u0001Y!A!G!?\u0011\u0002\u0003\u0007A\u0007\u0003\u0006\u0004\b\u0005\u0005\u0012\u0011!CA\u0007\u0013\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\f\rM\u0001\u0003\u0002\r.\u0007\u001b\u0001r\u0001GB\b!AaC'C\u0002\u0004\u0012e\u0011a\u0001V;qY\u0016$\u0004\"CB\u000b\u0007\u000b\t\t\u00111\u0001F\u0003\rAH\u0005\r\u0005\u000b\u00073\t\t#%A\u0005\u0002\rm\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u001e)\u001aAga\b,\u0005\r\u0005\u0002\u0003BB\u0012\u0007[i!a!\n\u000b\t\r\u001d2\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u000b\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007_\u0019)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!ba\r\u0002\"E\u0005I\u0011AB\u000e\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004BCB\u001c\u0003C\t\t\u0011\"\u0003\u0004:\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0004\u0005\u0003\u0004>\r\rSBAB \u0015\u0011\u0019\tEa\u001b\u0002\t1\fgnZ\u0005\u0005\u0007\u000b\u001ayD\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003#\u0019I\u0005E\u0002\u0019\u0007\u0017J1a!\u0014\u001a\u0005%!(/\u00198tS\u0016tG\u000fC\u0004\u0002\"\u0002!\te!\u0015\u0015\t\u0005e21\u000b\u0005\u000b\u0007+\u001ay\u0005%AA\u0002\r]\u0013!B5oaV$\b\u0003BB-\u00077j\u0011\u0001B\u0005\u0004\u0007;\"!aC%oi\u0016\u0014h.\u00197S_^Dqa!\u0019\u0001\t#\u001a\u0019'A\u0005e_\u001e+gnQ8eKR1\u00111PB3\u0007OB\u0001\"!#\u0004`\u0001\u0007\u00111\u0012\u0005\t\u0007S\u001ay\u00061\u0001\u0002|\u0005\u0011QM\u001e\u0005\n\u0007[\u0002\u0011\u0011!C\u0001\u0007_\nAaY8qsRIQi!\u001d\u0004t\rU4q\u000f\u0005\tC\r-\u0004\u0013!a\u0001!!Aaea\u001b\u0011\u0002\u0003\u0007\u0001\u0003\u0003\u0005+\u0007W\u0002\n\u00111\u0001-\u0011!\u001141\u000eI\u0001\u0002\u0004!\u0004\"CB>\u0001E\u0005I\u0011AB?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"aa +\u0007A\u0019y\u0002C\u0005\u0004\u0004\u0002\t\n\u0011\"\u0001\u0004~\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CBD\u0001E\u0005I\u0011ABE\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"aa#+\u00071\u001ay\u0002C\u0005\u0004\u0010\u0002\t\n\u0011\"\u0001\u0004\u001c\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004\"CBJ\u0001\u0005\u0005I\u0011IBK\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111q\u0013\t\u0005\u0007{\u0019I*C\u0002?\u0007\u007fA\u0011b!(\u0001\u0003\u0003%\taa(\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tE\u0007\"CBR\u0001\u0005\u0005I\u0011ABS\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000f\u0004(\"Q1\u0011VBQ\u0003\u0003\u0005\rA!5\u0002\u0007a$\u0013\u0007C\u0005\u0004.\u0002\t\t\u0011\"\u0011\u00040\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00042B111WB]\u0003si!a!.\u000b\u0007\r]\u0016$\u0001\u0006d_2dWm\u0019;j_:LAaa/\u00046\nA\u0011\n^3sCR|'\u000fC\u0005\u0004@\u0002\t\t\u0011\"\u0001\u0004B\u0006A1-\u00198FcV\fG\u000eF\u0002h\u0007\u0007D!b!+\u0004>\u0006\u0005\t\u0019AA\u001d\u0011%\u00199\rAA\u0001\n\u0003\u001aI-\u0001\u0004fcV\fGn\u001d\u000b\u0004O\u000e-\u0007BCBU\u0007\u000b\f\t\u00111\u0001\u0002:!\u001a\u0002aa4\u0004V\u000e]71\\Bo\u0007C\u001c\u0019oa:\u0004jB\u0019\u0011c!5\n\u0007\rM'AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\re\u0017\u0001b\u001e\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;beRd\u0003e\u001d;pa2\u00023\u000f^3qS\u0001j\u0003eR3oKJ\fG/Z:!C:\u0004\u0013M\u001d:bs\u0002zg\rI3mK6,g\u000e^:!MJ|W\u000eI:uCJ$\b\u0005^8!gR|\u0007\u000f\t\u0015j]\u000edWo]5wK&b#\u0002\t\u0011!A\u0001\u0002\u0013N\\2sK6,g\u000e^5oO\u0002\u0012\u0017\u0010I:uKBt\u0003\u0005\u00165fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011sKR,(O\\3eA\u0015dW-\\3oiN\u0004\u0013n\u001d\u0011uQ\u0016\u00043/Y7fA\u0005\u001c\b\u0005\u001e5fAQL\b/\u001a\u0011pM\u0002\n'oZ;nK:$(\u0002\t\u0011!A\u0001\u0002S\r\u001f9sKN\u001c\u0018n\u001c8t])Q\u0001\u0005\t\u0011!A\u0001\u001aV\u000f\u001d9peR,G\r\t;za\u0016\u001c\b%\u0019:fu\u0001\u0012\u0017\u0010^3-AMDwN\u001d;-A%tG/Z4fe2\u0002Cn\u001c8hY\u0001\"\u0017\r^3-AQLW.Z:uC6\u0004hF\u0003\u0006!A\u0001\u0002\u0003\u0005\t+iK\u0002\u001aH/\u0019:uA\u0005tG\rI:u_B\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011sKN|GN^3!i>\u0004C\u000f[3!g\u0006lW\r\t;za\u0016t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ti\u0006\u0014H\u000fI1oI\u0002\u001aHo\u001c9!Kb\u0004(/Z:tS>t7\u000f\t:fg>dg/\u001a\u0011u_\u0002\"\b.\u001a\u0011(I\u0006$Xm\n\u0011pe\u0002:C/[7fgR\fW\u000e]\u0014!if\u0004XM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5f]\u0002\"\b.\u001a\u0011ti\u0016\u0004\b%\u001a=qe\u0016\u001c8/[8oA5,8\u000f\u001e\u0011sKN|GN^3!i>\u0004C\u000f[3!O%tG/\u001a:wC2<\u0003\u0005^=qK2\u0002s\u000e\u001e5fe^L7/\u001a\u0011u_\u0002\"\b.\u001a\u0011tC6,\u0007\u0005^=qK*\u0001\u0003\u0005\t\u0011!A\u0005\u001c\b\u0005\u001e5fAM$\u0018M\u001d;!C:$\u0007e\u001d;pa\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0019y.AB;\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f^1si\u0002j\u0003%\u00198!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u001aH/\u0019:uA=4\u0007\u0005\u001e5fAI\fgnZ3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHo\u001c9![\u0001\ng\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!K:$\u0007\u0005\u001e5fAI\fgnZ3!Q%t7\r\\;tSZ,\u0017F\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR,\u0007\u000fI\u0017!C:\u0004s\u000e\u001d;j_:\fG\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!gR,\u0007\u000fI8gAQDW\r\t:b]\u001e,gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\tK\b\u0005Z3gCVdG\u000fI:uKB\u0004\u0013n\u001d\u00112A%4\u0007e\u001d;beR\u0004\u0013n\u001d\u0011mKN\u001c\b\u0005\u001e5b]\u0002z'\u000fI3rk\u0006d\u0007\u0005^8!gR|\u0007\u000f\f\u0011pi\",'o^5tK\u0002j\u0013G\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012uN\u001d\u0011uQ\u0016\u0004C/Z7q_J\fG\u000eI:fcV,gnY3tA%$xe\u001d\u00112A\u0011\f\u0017\u0010I1oI\u0002j\u0013\u0007\t3bs\u0002\u0012Xm\u001d9fGRLg/\u001a7z])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I%gAM$\u0018M\u001d;!SN\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\u001aHo\u001c9!i\",g\u000e\t;iK\u0002\u001aH/\u001a9![V\u001cH\u000f\t2fA9,w-\u0019;jm\u0016d\u0003%\u00198eAYL7-\u001a\u0011wKJ\u001c\u0018M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0004f\u0006\t)O\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175YUj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u001b-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.6YQb3\u0007\f\u001a-cuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006^8`I\u0006$X\rK\u00143aEBT\u0006M\u0019.aE:\u0013\u0006\f\u0011u_~#\u0017\r^3)OI\u0002\u0014\u0007O\u00171g5\u0002\u0014gJ\u0015-A%tG/\u001a:wC2\u0004\u0013\u0007I7p]RD\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\eA\n\u0004(\f\u00192[A\nDF\r\u00192q5\u0002$'\f\u00192YI\u0002\u0014\u0007O\u00171g5\u0002\u0014'\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u001211^\u0001\u0006e9\"d\u0006\r")
public class Sequence
extends Expression
implements TimeZoneAwareExpression,
scala.Serializable {
    private transient SequenceImpl impl;
    private final Expression start;
    private final Expression stop;
    private final Option<Expression> stepOpt;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> apply$default$4() {
        return Sequence$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return Sequence$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence sequence) {
        return Sequence$.MODULE$.unapply(sequence);
    }

    private boolean resolved$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression start() {
        return this.start;
    }

    public Expression stop() {
        return this.stop;
    }

    public Option<Expression> stepOpt() {
        return this.stepOpt;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$89 = new Some((Object)timeZoneId);
        Expression x$90 = this.copy$default$1();
        Expression x$91 = this.copy$default$2();
        Option<Expression> x$92 = this.copy$default$3();
        return this.copy(x$90, x$91, x$92, (Option<String>)x$89);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.start(), this.stop()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.stepOpt()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)x$61.foldable()));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)x$62.nullable()));
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.start().dataType(), false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        boolean bl;
        boolean bl2;
        DataType startType = this.start().dataType();
        boolean typesCorrect = startType.sameType(this.stop().dataType()) && (bl2 = (bl = TimestampType$.MODULE$.equals(dataType = startType) ? true : DateType$.MODULE$.equals(dataType)) ? this.stepOpt().isEmpty() || CalendarIntervalType$.MODULE$.acceptsType(this.stepType$1()) : (dataType instanceof IntegralType ? this.stepOpt().isEmpty() || this.stepType$1().sameType(startType) : false));
        return typesCorrect ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append(this.prettyName()).append(" only supports integral, timestamp or date types").toString());
    }

    public Seq<Expression> coercibleChildren() {
        return (Seq)this.children().filter((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)Sequence.$anonfun$coercibleChildren$1(x$63)));
    }

    public Expression castChildrenTo(DataType widerType) {
        return new Sequence(new Cast(this.start(), widerType, Cast$.MODULE$.apply$default$3()), new Cast(this.stop(), widerType, Cast$.MODULE$.apply$default$3()), (Option<Expression>)this.stepOpt().map((Function1 & Serializable & scala.Serializable)step -> {
            DataType dataType = step.dataType();
            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
            return (dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$)) ? new Cast((Expression)step, widerType, Cast$.MODULE$.apply$default$3()) : step;
        }), this.timeZoneId());
    }

    private SequenceImpl impl$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                SequenceImpl sequenceImpl;
                DataType dataType = this.dataType().elementType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    ClassTag ct = ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)integralType.tag().mirror()).runtimeClass(integralType.tag().tpe()));
                    sequenceImpl = new IntegralSequenceImpl<Object>(integralType, ct, integralType.integral());
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(LongType$.MODULE$, 1L, (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))), this.timeZone(), ClassTag$.MODULE$.Long(), Numeric.LongIsIntegral$.MODULE$);
                } else if (DateType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(IntegerType$.MODULE$, 86400000000L, (JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$64 -> (int)x$64, this.timeZone(), ClassTag$.MODULE$.Int(), Numeric.IntIsIntegral$.MODULE$);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.impl = sequenceImpl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.impl;
    }

    private SequenceImpl impl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.impl$lzycompute() : this.impl;
    }

    @Override
    public Object eval(InternalRow input) {
        Object startVal = this.start().eval(input);
        if (startVal == null) {
            return null;
        }
        Object stopVal = this.stop().eval(input);
        if (stopVal == null) {
            return null;
        }
        Object stepVal = this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$65 -> x$65.eval(input)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().apply(startVal, stopVal));
        if (stepVal == null) {
            return null;
        }
        return ArrayData$.MODULE$.toArrayData(this.impl().eval(startVal, stopVal, stepVal));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        ExprCode startGen = this.start().genCode(ctx);
        ExprCode stopGen = this.stop().genCode(ctx);
        ExprCode stepGen = (ExprCode)this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$66 -> x$66.genCode(ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().genCode(ctx, startGen, stopGen));
        String resultType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String arr = ctx.freshName("arr");
        String arrElemType = CodeGenerator$.MODULE$.javaType(this.dataType().elementType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         |final ").append(arrElemType).append("[] ").append(arr).append(" = null;\n         |").append(this.impl().genCode(ctx, ExprValue$.MODULE$.exprValueToString(startGen.value()), ExprValue$.MODULE$.exprValueToString(stopGen.value()), ExprValue$.MODULE$.exprValueToString(stepGen.value()), arr, arrElemType)).append("\n         |").append(ev.value()).append(" = UnsafeArrayData.fromPrimitiveArray(").append(arr).append(");\n       ").toString())).stripMargin();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)startGen.code()), ctx.nullSafeExec(this.start().nullable(), ExprValue$.MODULE$.exprValueToString(startGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stopGen.code()), ctx.nullSafeExec(this.stop().nullable(), ExprValue$.MODULE$.exprValueToString(stopGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stepGen.code()), ctx.nullSafeExec(this.stepOpt().exists((Function1 & Serializable & scala.Serializable)x$67 -> BoxesRunTime.boxToBoolean((boolean)x$67.nullable())), ExprValue$.MODULE$.exprValueToString(stepGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n                 |").append(ev.isNull()).append(" = false;\n                 |").append(resultCode).append("\n               ").toString())).stripMargin()))))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultType, ev.value(), nullSafeEval})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n           |", "\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.code(), stopGen.code(), stepGen.code(), resultType, ev.value(), resultCode})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    public Sequence copy(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.stop();
    }

    public Option<Expression> copy$default$3() {
        return this.stepOpt();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Sequence";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.stop();
                break;
            }
            case 2: {
                object = this.stepOpt();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sequence sequence = (Sequence)x$1;
        Expression expression = this.start();
        Expression expression2 = sequence.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.stop();
        Expression expression4 = sequence.stop();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.stepOpt();
        Option<Expression> option2 = sequence.stepOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = sequence.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!sequence.canEqual(this)) return false;
        return true;
    }

    private final DataType stepType$1() {
        return ((Expression)this.stepOpt().get()).dataType();
    }

    public static final /* synthetic */ boolean $anonfun$coercibleChildren$1(Expression x$63) {
        DataType dataType = x$63.dataType();
        CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
        return dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$);
    }

    public Sequence(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        this.start = start;
        this.stop = stop;
        this.stepOpt = stepOpt;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
    }

    public Sequence(Expression start, Expression stop) {
        this(start, stop, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Sequence(Expression start, Expression stop, Expression step) {
        this(start, stop, (Option<Expression>)new Some((Object)step), (Option<String>)None$.MODULE$);
    }

    public static class DefaultStep {
        private final Function2<Object, Object, Object> lteq;
        private final DataType stepType;
        private final Object one;
        private final Object negativeOne;

        private Object negativeOne() {
            return this.negativeOne;
        }

        public Object apply(Object start, Object stop) {
            return BoxesRunTime.unboxToBoolean((Object)this.lteq.apply(start, stop)) ? this.one : this.negativeOne();
        }

        public ExprCode genCode(CodegenContext ctx, ExprCode startGen, ExprCode stopGen) {
            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.one, this.negativeOne()}))).map((Function1 & Serializable & scala.Serializable)x$68 -> Literal$.MODULE$.apply(x$68).genCode(ctx).value(), Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            ExprValue oneVal = (ExprValue)((SeqLike)some.get()).apply(0);
            ExprValue negativeOneVal = (ExprValue)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)oneVal, (Object)negativeOneVal);
            Tuple2 tuple22 = tuple2;
            ExprValue oneVal2 = (ExprValue)tuple22._1();
            ExprValue negativeOneVal2 = (ExprValue)tuple22._2();
            return ExprCode$.MODULE$.forNonNullValue(JavaCode$.MODULE$.expression(new StringBuilder(10).append(startGen.value()).append(" <= ").append(stopGen.value()).append(" ? ").append(oneVal2).append(" : ").append(negativeOneVal2).toString(), this.stepType));
        }

        public DefaultStep(Function2<Object, Object, Object> lteq, DataType stepType, Object one) {
            this.lteq = lteq;
            this.stepType = stepType;
            this.one = one;
            UnaryMinus qual$1 = new UnaryMinus(Literal$.MODULE$.apply(one));
            InternalRow x$93 = qual$1.eval$default$1();
            this.negativeOne = qual$1.eval(x$93);
        }
    }

    public static class IntegralSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType elemType;
        private final ClassTag<T> evidence$1;
        private final Integral<T> num;
        private final DefaultStep defaultStep;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object start = input1;
            Object stop = input2;
            Object step = input3;
            int i = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(start, stop, step, this.num);
            Object arr = this.evidence$1.newArray(i);
            while (i > 0) {
                ScalaRunTime$.MODULE$.array_update(arr, --i, this.num.mkNumericOps(start).$plus(this.num.mkNumericOps(step).$times(this.num.fromInt(i))));
            }
            return arr;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String i = ctx.freshName("i");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n         |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, start, stop, step, i)).append("\n         |").append(arr).append(" = new ").append(elemType).append("[").append(i).append("];\n         |while (").append(i).append(" > 0) {\n         |  ").append(i).append("--;\n         |  ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(start).append(" + ").append(step).append(" * ").append(i).append(");\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$1(IntegralSequenceImpl $this, Object x, Object y) {
            return $this.elemType.ordering().lteq(x, y);
        }

        public IntegralSequenceImpl(IntegralType elemType, ClassTag<T> evidence$1, Integral<T> num) {
            this.elemType = elemType;
            this.evidence$1 = evidence$1;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)IntegralSequenceImpl.$anonfun$defaultStep$1(this, x, y)), elemType, num.one());
        }
    }

    public static interface SequenceImpl {
        public Object eval(Object var1, Object var2, Object var3);

        public String genCode(CodegenContext var1, String var2, String var3, String var4, String var5, String var6);

        public DefaultStep defaultStep();
    }

    public static class TemporalSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType dt;
        private final long scale;
        private final Function1<Object, T> fromLong;
        private final TimeZone timeZone;
        private final ClassTag<T> evidence$2;
        private final Integral<T> num;
        private final DefaultStep defaultStep;
        private final IntegralSequenceImpl<T> backedSequenceImpl;
        private final long microsPerMonth;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        private IntegralSequenceImpl<T> backedSequenceImpl() {
            return this.backedSequenceImpl;
        }

        private long microsPerMonth() {
            return this.microsPerMonth;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object object;
            Object start = input1;
            Object stop = input2;
            CalendarInterval step = (CalendarInterval)input3;
            int stepMonths = step.months;
            long stepMicros = step.microseconds;
            if (stepMonths == 0) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(stepMicros / this.scale))));
            } else {
                long intervalStepInMicros = stepMicros + (long)stepMonths * this.microsPerMonth();
                long startMicros = this.num.toLong(start) * this.scale;
                long stopMicros = this.num.toLong(stop) * this.scale;
                int maxEstimatedArrayLength = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(BoxesRunTime.boxToLong((long)startMicros), BoxesRunTime.boxToLong((long)stopMicros), BoxesRunTime.boxToLong((long)intervalStepInMicros), Numeric.LongIsIntegral$.MODULE$);
                int stepSign = stopMicros > startMicros ? 1 : -1;
                long exclusiveItem = stopMicros + (long)stepSign;
                Object arr = this.evidence$2.newArray(maxEstimatedArrayLength);
                long t = startMicros;
                int i = 0;
                while (t < exclusiveItem ^ stepSign < 0) {
                    ScalaRunTime$.MODULE$.array_update(arr, i, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(t / this.scale))));
                    t = DateTimeUtils$.MODULE$.timestampAddInterval(t, stepMonths, stepMicros, this.timeZone);
                    ++i;
                }
                object = ScalaRunTime$.MODULE$.array_length(arr) == i ? arr : Predef$.MODULE$.genericArrayOps(arr).slice(0, i);
            }
            return object;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String stepMonths = ctx.freshName("stepMonths");
            String stepMicros = ctx.freshName("stepMicros");
            String stepScaled = ctx.freshName("stepScaled");
            String intervalInMicros = ctx.freshName("intervalInMicros");
            String startMicros = ctx.freshName("startMicros");
            String stopMicros = ctx.freshName("stopMicros");
            String arrLength = ctx.freshName("arrLength");
            String stepSign = ctx.freshName("stepSign");
            String exclusiveItem = ctx.freshName("exclusiveItem");
            String t = ctx.freshName("t");
            String i = ctx.freshName("i");
            String genTimeZone = ctx.addReferenceObj("timeZone", this.timeZone, TimeZone.class.getName());
            String sequenceLengthCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |final long ").append(intervalInMicros).append(" = ").append(stepMicros).append(" + ").append(stepMonths).append(" * ").append(this.microsPerMonth()).append("L;\n           |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, startMicros, stopMicros, intervalInMicros, arrLength)).append("\n          ").toString())).stripMargin();
            String timestampAddIntervalCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(120).append("\n           |").append(t).append(" = org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampAddInterval(\n           |  ").append(t).append(", ").append(stepMonths).append(", ").append(stepMicros).append(", ").append(genTimeZone).append(");\n          ").toString())).stripMargin();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(677).append("\n         |final int ").append(stepMonths).append(" = ").append(step).append(".months;\n         |final long ").append(stepMicros).append(" = ").append(step).append(".microseconds;\n         |\n         |if (").append(stepMonths).append(" == 0) {\n         |  final ").append(elemType).append(" ").append(stepScaled).append(" = (").append(elemType).append(") (").append(stepMicros).append(" / ").append(this.scale).append("L);\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepScaled, arr, elemType)).append(";\n         |\n         |} else {\n         |  final long ").append(startMicros).append(" = ").append(start).append(" * ").append(this.scale).append("L;\n         |  final long ").append(stopMicros).append(" = ").append(stop).append(" * ").append(this.scale).append("L;\n         |\n         |  ").append(sequenceLengthCode).append("\n         |\n         |  final int ").append(stepSign).append(" = ").append(stopMicros).append(" > ").append(startMicros).append(" ? +1 : -1;\n         |  final long ").append(exclusiveItem).append(" = ").append(stopMicros).append(" + ").append(stepSign).append(";\n         |\n         |  ").append(arr).append(" = new ").append(elemType).append("[").append(arrLength).append("];\n         |  long ").append(t).append(" = ").append(startMicros).append(";\n         |  int ").append(i).append(" = 0;\n         |\n         |  while (").append(t).append(" < ").append(exclusiveItem).append(" ^ ").append(stepSign).append(" < 0) {\n         |    ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(t).append(" / ").append(this.scale).append("L);\n         |    ").append(timestampAddIntervalCode).append("\n         |    ").append(i).append(" += 1;\n         |  }\n         |\n         |  if (").append(arr).append(".length > ").append(i).append(") {\n         |    ").append(arr).append(" = java.util.Arrays.copyOf(").append(arr).append(", ").append(i).append(");\n         |  }\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$2(TemporalSequenceImpl $this, Object x, Object y) {
            return $this.dt.ordering().lteq(x, y);
        }

        public TemporalSequenceImpl(IntegralType dt, long scale, Function1<Object, T> fromLong, TimeZone timeZone, ClassTag<T> evidence$2, Integral<T> num) {
            this.dt = dt;
            this.scale = scale;
            this.fromLong = fromLong;
            this.timeZone = timeZone;
            this.evidence$2 = evidence$2;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)TemporalSequenceImpl.$anonfun$defaultStep$2(this, x, y)), CalendarIntervalType$.MODULE$, new CalendarInterval(0, 86400000000L));
            this.backedSequenceImpl = new IntegralSequenceImpl<T>(dt, evidence$2, num);
            this.microsPerMonth = 2419200000000L;
        }
    }
}

