/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001>\u0011\u0011bU3oi\u0016t7-Z:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\t\u0015/u\u0019\u0003CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0002\u0002\u000f\r|G-Z4f]&\u0011A$\u0007\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t9\u0001K]8ek\u000e$\bC\u0001\u0010%\u0013\t)sD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005(\u0001\tU\r\u0011\"\u0001)\u0003\r\u0019HO]\u000b\u0002!!A!\u0006\u0001B\tB\u0003%\u0001#\u0001\u0003tiJ\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011\u0001\u0015\u0002\u00111\fgnZ;bO\u0016D\u0001B\f\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\nY\u0006tw-^1hK\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\bG>,h\u000e\u001e:z\u0011!\u0011\u0004A!E!\u0002\u0013\u0001\u0012\u0001C2pk:$(/\u001f\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u00144\u0001\u0004\u0001\u0002b\u0002\u00174!\u0003\u0005\r\u0001\u0005\u0005\baM\u0002\n\u00111\u0001\u0011\u0011\u0015!\u0004\u0001\"\u0001<)\t1D\bC\u0003(u\u0001\u0007\u0001\u0003C\u00035\u0001\u0011\u0005a\bF\u00027\u007f\u0001CQaJ\u001fA\u0002AAQ\u0001L\u001fA\u0002AAQA\u0011\u0001\u0005B\r\u000b\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002\tB\u0011a$R\u0005\u0003\r~\u0011qAQ8pY\u0016\fg\u000eC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0005CA&O\u001b\u0005a%BA'\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tyEJ\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\t\u0006\u0001\"\u0011S\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002'B\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u000f\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\\?\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037~\u0001\"a\u00131\n\u0005\u0005d%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003!\u0019\u0007.\u001b7ee\u0016tW#A3\u0011\u0007Qc\u0006\u0003C\u0003h\u0001\u0011\u0005\u0003.\u0001\u0003fm\u0006dGCA5m!\tq\".\u0003\u0002l?\t\u0019\u0011I\\=\t\u000f54\u0007\u0013!a\u0001]\u0006)\u0011N\u001c9viB\u0011q\u000e]\u0007\u0002\t%\u0011\u0011\u000f\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003t\u0001\u0011%A/\u0001\u0007hKR\u001cVM\u001c;f]\u000e,7\u000f\u0006\u0003vw\u0006-\u0001C\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u0011)H/\u001b7\n\u0005i<(\u0001E$f]\u0016\u0014\u0018nY!se\u0006LH)\u0019;b\u0011\u0015a(\u000f1\u0001~\u0003%\u0019XM\u001c;f]\u000e,7\u000fE\u0002\u007f\u0003\u000bq1a`A\u0001!\t1v$C\u0002\u0002\u0004}\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002?!9\u0011Q\u0002:A\u0002\u0005=\u0011A\u00027pG\u0006dW\r\u0005\u0003\u0002\u0012\u0005eQBAA\n\u0015\rA\u0018Q\u0003\u0006\u0003\u0003/\tAA[1wC&!\u00111DA\n\u0005\u0019aunY1mK\"I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011E\u0001\u0005G>\u0004\u0018\u0010F\u00047\u0003G\t)#a\n\t\u0011\u001d\ni\u0002%AA\u0002AA\u0001\u0002LA\u000f!\u0003\u0005\r\u0001\u0005\u0005\ta\u0005u\u0001\u0013!a\u0001!!I\u00111\u0006\u0001\u0012\u0002\u0013\u0005\u0011QF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyCK\u0002\u0011\u0003cY#!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{y\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011IA\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u000b\u0002\u0011\u0013!C\u0001\u0003[\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u0002.\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA'\u0001\u0005\u0005I\u0011IA(\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)!\u0011qKA\u000b\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0011Q\u000b\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0019\u0011\u0007y\t\u0019'C\u0002\u0002f}\u00111!\u00138u\u0011%\tI\u0007AA\u0001\n\u0003\tY'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007%\fi\u0007\u0003\u0006\u0002p\u0005\u001d\u0014\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0011%\t\u0019\bAA\u0001\n\u0003\n)(A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\bE\u0003\u0002z\u0005}\u0014.\u0004\u0002\u0002|)\u0019\u0011QP\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0002\u0006m$\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0015\u0005!!A\u0005\u0002\u0005\u001d\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0011\u000bI\tC\u0005\u0002p\u0005\r\u0015\u0011!a\u0001S\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0013qR\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\u000b\t\nC\u0005\u0002p\u0005-\u0015\u0011!a\u0001S\"Z\u0001!!&\u0002\u001c\u0006u\u0015\u0011UAR!\r\t\u0012qS\u0005\u0004\u00033\u0013!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\u000bAj\u0018$V\u001d\u000e{\u0006f\u001d;s72\u0002C.\u00198hY\u0001\u001aw.\u001e8uefl\u0016\u0006I\u0017!'Bd\u0017\u000e^:!AN$(\u000f\u0019\u0011j]R|\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pM\u0002\n'O]1zA=4\u0007e^8sINt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0016A\u001c\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!K\u0007\u0005\u001e5fe\u0016\f\u0003eR8pI\u0002jwN\u001d8j]\u001ets%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0013\u0003*\u001b\u0012-EQDWM]3#;2Z&eR8pI\nb#%\\8s]&twMI/^\u0015\u0001\u0002s!CAU\u0005\u0005\u0005\t\u0012AAV\u0003%\u0019VM\u001c;f]\u000e,7\u000fE\u0002\u0012\u0003[3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qV\n\u0006\u0003[\u000b\tl\t\t\t\u0003g\u000bI\f\u0005\t\u0011m5\u0011\u0011Q\u0017\u0006\u0004\u0003o{\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003w\u000b)LA\tBEN$(/Y2u\rVt7\r^5p]NBq\u0001NAW\t\u0003\ty\f\u0006\u0002\u0002,\"Q\u00111YAW\u0003\u0003%)%!2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0015\t\u0015\u0005%\u0017QVA\u0001\n\u0003\u000bY-A\u0003baBd\u0017\u0010F\u00047\u0003\u001b\fy-!5\t\r\u001d\n9\r1\u0001\u0011\u0011!a\u0013q\u0019I\u0001\u0002\u0004\u0001\u0002\u0002\u0003\u0019\u0002HB\u0005\t\u0019\u0001\t\t\u0015\u0005U\u0017QVA\u0001\n\u0003\u000b9.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0017Q\u001d\t\u0006=\u0005m\u0017q\\\u0005\u0004\u0003;|\"AB(qi&|g\u000e\u0005\u0004\u001f\u0003C\u0004\u0002\u0003E\u0005\u0004\u0003G|\"A\u0002+va2,7\u0007C\u0005\u0002h\u0006M\u0017\u0011!a\u0001m\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005-\u0018QVI\u0001\n\u0003\ti#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\u000b\u0003_\fi+%A\u0005\u0002\u00055\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002t\u00065\u0016\u0013!C\u0001\u0003[\tq\"\u00199qYf$C-\u001a4bk2$HE\r\u0005\u000b\u0003o\fi+%A\u0005\u0002\u00055\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005m\u0018QVA\u0001\n\u0013\ti0A\u0006sK\u0006$'+Z:pYZ,GCAA\u0000!\u0011\t\u0019F!\u0001\n\t\t\r\u0011Q\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class Sentences
extends Expression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences sentences) {
        return Sentences$.MODULE$.unapply(sentences);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new ArrayType(StringType$.MODULE$, false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.language();
        Expression expression3 = this.country();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object string = this.str().eval(input);
        if (string == null) {
            genericArrayData = null;
        } else {
            UTF8String languageStr = (UTF8String)this.language().eval(input);
            UTF8String countryStr = (UTF8String)this.country().eval(input);
            Locale locale = languageStr != null && countryStr != null ? new Locale(languageStr.toString(), countryStr.toString()) : Locale.US;
            genericArrayData = this.getSentences(((UTF8String)string).toString(), locale);
        }
        return genericArrayData;
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.language();
                break;
            }
            case 2: {
                expression = this.country();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

