/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep) - Replaces all substrings of `str` that match `regexp` with `rep`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0001>\u0011QBU3h\u000bb\u0004(+\u001a9mC\u000e,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004tk\nTWm\u0019;\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005tk\nTWm\u0019;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u0002:fO\u0016D\b\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d\u0011XmZ3ya\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\u0004e\u0016\u0004\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\tI,\u0007\u000f\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003#\u0001AQ!\t\u0019A\u0002\rBQ!\u000b\u0019A\u0002\rBQ!\f\u0019A\u0002\rB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\u0002\u00131\f7\u000f\u001e*fO\u0016DX#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!\u0002;za\u0016\u001c(BA \t\u0003\u0019)hn]1gK&\u0011\u0011\t\u0010\u0002\u000b+R3\u0005h\u0015;sS:<\u0007\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003E\u00035a\u0017m\u001d;SK\u001e,\u0007p\u0018\u0013fcR\u0011Q\t\u0013\t\u00031\u0019K!aR\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013\n\u000b\t\u00111\u0001;\u0003\rAH%\r\u0005\n\u0017\u0002\u0001\r\u0011!Q!\ni\n!\u0002\\1tiJ+w-\u001a=!Q\tQU\n\u0005\u0002\u0019\u001d&\u0011q*\u0007\u0002\niJ\fgn]5f]RD\u0011\"\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002*\u0002\u000fA\fG\u000f^3s]V\t1\u000b\u0005\u0002U76\tQK\u0003\u0002W/\u0006)!/Z4fq*\u0011\u0001,W\u0001\u0005kRLGNC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q+&a\u0002)biR,'O\u001c\u0005\n=\u0002\u0001\r\u00111A\u0005\n}\u000b1\u0002]1ui\u0016\u0014hn\u0018\u0013fcR\u0011Q\t\u0019\u0005\b\u0013v\u000b\t\u00111\u0001T\u0011%\u0011\u0007\u00011A\u0001B\u0003&1+\u0001\u0005qCR$XM\u001d8!Q\t\tW\nC\u0005f\u0001\u0001\u0007\t\u0019!C\u0005M\u0006yA.Y:u%\u0016\u0004H.Y2f[\u0016tG/F\u0001h!\tAwN\u0004\u0002j[B\u0011!.G\u0007\u0002W*\u0011AND\u0001\u0007yI|w\u000e\u001e \n\u00059L\u0012A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\r\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0013!\u0018a\u00057bgR\u0014V\r\u001d7bG\u0016lWM\u001c;`I\u0015\fHCA#v\u0011\u001dI%/!AA\u0002\u001dD\u0011b\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B4\u0002!1\f7\u000f\u001e*fa2\f7-Z7f]R\u0004\u0003F\u0001<N\u0011%Q\b\u00011AA\u0002\u0013%\u0011(A\u000bmCN$(+\u001a9mC\u000e,W.\u001a8u\u0013:,FK\u0012\u001d\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\u0018!\u00077bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\tO0%KF$\"!\u0012@\t\u000f%[\u0018\u0011!a\u0001u!Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001e\u0002-1\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq\u0001B#a`'\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI!\u0001\u0004sKN,H\u000e^\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#I\u0016\u0001\u00027b]\u001eLA!!\u0006\u0002\u0010\ta1\u000b\u001e:j]\u001e\u0014UO\u001a4fe\"\u001a\u0011QA'\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u0005aa.\u001e7m'\u00064W-\u0012<bYRA\u0011qDA\u0013\u0003S\ti\u0003E\u0002\u0019\u0003CI1!a\t\u001a\u0005\r\te.\u001f\u0005\t\u0003O\tI\u00021\u0001\u0002 \u0005\t1\u000f\u0003\u0005\u0002,\u0005e\u0001\u0019AA\u0010\u0003\u0005\u0001\b\u0002CA\u0018\u00033\u0001\r!a\b\u0002\u0003IDq!a\r\u0001\t\u0003\n)$\u0001\u0005eCR\fG+\u001f9f+\t\t9\u0004\u0005\u0003\u0002:\u0005uRBAA\u001e\u0015\tid!\u0003\u0003\u0002@\u0005m\"\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u001d\u0003CBA%\u0003'\nIF\u0004\u0003\u0002L\u0005=cb\u00016\u0002N%\t!$C\u0002\u0002Re\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002V\u0005]#aA*fc*\u0019\u0011\u0011K\r\u0011\t\u0005e\u00121L\u0005\u0005\u0003;\nYD\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"9\u0011\u0011\r\u0001\u0005B\u0005\r\u0014\u0001C2iS2$'/\u001a8\u0016\u0005\u0005\u0015\u0004#BA%\u0003'\u001a\u0003BBA5\u0001\u0011\u0005c-\u0001\u0006qe\u0016$H/\u001f(b[\u0016Dq!!\u001c\u0001\t#\ny'A\u0005e_\u001e+gnQ8eKR1\u0011\u0011OA?\u0003\u000f\u0003B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0012\u0011aB2pI\u0016<WM\\\u0005\u0005\u0003w\n)H\u0001\u0005FqB\u00148i\u001c3f\u0011!\ty(a\u001bA\u0002\u0005\u0005\u0015aA2uqB!\u00111OAB\u0013\u0011\t))!\u001e\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"A\u0011\u0011RA6\u0001\u0004\t\t(\u0001\u0002fm\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011qR\u0001\u0005G>\u0004\u0018\u0010F\u00044\u0003#\u000b\u0019*!&\t\u0011\u0005\nY\t%AA\u0002\rB\u0001\"KAF!\u0003\u0005\ra\t\u0005\t[\u0005-\u0005\u0013!a\u0001G!I\u0011\u0011\u0014\u0001\u0012\u0002\u0013\u0005\u00111T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiJK\u0002$\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WK\u0012AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003g\u0003\u0011\u0013!C\u0001\u00037\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002\u001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA^\u0001\u0005\u0005I\u0011IA_\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0018\t\u0005\u0003\u001b\t\t-C\u0002q\u0003\u001fA\u0011\"!2\u0001\u0003\u0003%\t!a2\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0007c\u0001\r\u0002L&\u0019\u0011QZ\r\u0003\u0007%sG\u000fC\u0005\u0002R\u0002\t\t\u0011\"\u0001\u0002T\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0010\u0003+D\u0011\"SAh\u0003\u0003\u0005\r!!3\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0007CBAp\u0003K\fy\"\u0004\u0002\u0002b*\u0019\u00111]\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0006\u0005(\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-\b!!A\u0005\u0002\u00055\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0018Q\u001f\t\u00041\u0005E\u0018bAAz3\t9!i\\8mK\u0006t\u0007\"C%\u0002j\u0006\u0005\t\u0019AA\u0010\u0011%\tI\u0010AA\u0001\n\u0003\nY0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\fi\u0010C\u0005J\u0003o\f\t\u00111\u0001\u0002 !Z\u0001A!\u0001\u0003\b\t%!Q\u0002B\b!\r\t\"1A\u0005\u0004\u0005\u000b\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005\u0017\t1l\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3ya2\u0002#/\u001a9*A5\u0002#+\u001a9mC\u000e,7\u000fI1mY\u0002\u001aXOY:ue&twm\u001d\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t1sK\u001e,\u0007\u0010\u001d1!o&$\b\u000e\t1sKB\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t\"A*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aA:C\u0006I\u0014)9r#7&K\u0014-A\u001drW/\\\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001rW/\\\u0017ok6T\u0001\u0005I\u0004\n\u0005+\u0011\u0011\u0011!E\u0001\u0005/\tQBU3h\u000bb\u0004(+\u001a9mC\u000e,\u0007cA\t\u0003\u001a\u0019A\u0011AAA\u0001\u0012\u0003\u0011YbE\u0003\u0003\u001a\tuQ\u0004\u0005\u0005\u0003 \t\u00152eI\u00124\u001b\t\u0011\tCC\u0002\u0003$e\tqA];oi&lW-\u0003\u0003\u0003(\t\u0005\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9\u0011G!\u0007\u0005\u0002\t-BC\u0001B\f\u0011)\u0011yC!\u0007\u0002\u0002\u0013\u0015#\u0011G\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0018\u0005\u000b\u0005k\u0011I\"!A\u0005\u0002\n]\u0012!B1qa2LHcB\u001a\u0003:\tm\"Q\b\u0005\u0007C\tM\u0002\u0019A\u0012\t\r%\u0012\u0019\u00041\u0001$\u0011\u0019i#1\u0007a\u0001G!Q!\u0011\tB\r\u0003\u0003%\tIa\u0011\u0002\u000fUt\u0017\r\u001d9msR!!Q\tB)!\u0015A\"q\tB&\u0013\r\u0011I%\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ra\u0011ieI\u0012$\u0013\r\u0011y%\u0007\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tM#qHA\u0001\u0002\u0004\u0019\u0014a\u0001=%a!Q!q\u000bB\r\u0003\u0003%IA!\u0017\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00057\u0002B!!\u0004\u0003^%!!qLA\b\u0005\u0019y%M[3di\u0002")
public class RegExpReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpReplace> tupled() {
        return RegExpReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpReplace>>> curried() {
        return RegExpReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        Matcher m = this.pattern().matcher(s.toString());
        this.result().delete(0, this.result().length());
        while (m.find()) {
            m.appendReplacement(this.result(), this.lastReplacement());
        }
        m.appendTail(this.result());
        return UTF8String.fromString((String)this.result().toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.rep();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, rep) -> new StringBuilder(465).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n      java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n\n      while (").append(matcher).append(".find()) {\n        ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n      }\n      ").append(matcher).append(".appendTail(").append(termResult).append(");\n      ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n      ").append(termResult).append(" = null;\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep) {
        return new RegExpReplace(subject, regexp, rep);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.rep();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        ExpectsInputTypes.$init$(this);
    }
}

