/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST')\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY')\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query')\n       1\n  ")
@ScalaSignature(bytes="\u0006\u0001\tet!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0003)beN,WK\u001d7\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011\u0001\u0002U1sg\u0016,&\u000f\\\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=Aq!I\tC\u0002\u0013%!%\u0001\u0003I\u001fN#V#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!\u0002;za\u0016\u001c(B\u0001\u0015\t\u0003\u0019)hn]1gK&\u0011!&\n\u0002\u000b+R3\u0005h\u0015;sS:<\u0007B\u0002\u0017\u0012A\u0003%1%A\u0003I\u001fN#\u0006\u0005C\u0004/#\t\u0007I\u0011\u0002\u0012\u0002\tA\u000bE\u000b\u0013\u0005\u0007aE\u0001\u000b\u0011B\u0012\u0002\u000bA\u000bE\u000b\u0013\u0011\t\u000fI\n\"\u0019!C\u0005E\u0005)\u0011+V#S3\"1A'\u0005Q\u0001\n\r\na!U+F%f\u0003\u0003b\u0002\u001c\u0012\u0005\u0004%IAI\u0001\u0004%\u00163\u0005B\u0002\u001d\u0012A\u0003%1%\u0001\u0003S\u000b\u001a\u0003\u0003b\u0002\u001e\u0012\u0005\u0004%IAI\u0001\t!J{EkT\"P\u0019\"1A(\u0005Q\u0001\n\r\n\u0011\u0002\u0015*P)>\u001bu\n\u0014\u0011\t\u000fy\n\"\u0019!C\u0005E\u0005!a)\u0013'F\u0011\u0019\u0001\u0015\u0003)A\u0005G\u0005)a)\u0013'FA!9!)\u0005b\u0001\n\u0013\u0011\u0013!C!V)\"{%+\u0013+Z\u0011\u0019!\u0015\u0003)A\u0005G\u0005Q\u0011)\u0016+I\u001fJKE+\u0017\u0011\t\u000f\u0019\u000b\"\u0019!C\u0005E\u0005AQkU#S\u0013:3u\n\u0003\u0004I#\u0001\u0006IaI\u0001\n+N+%+\u0013(G\u001f\u0002BqAS\tC\u0002\u0013%1*A\u0006S\u000b\u001e+\u0005\f\u0015*F\r&CV#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u00027b]\u001eT\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n11\u000b\u001e:j]\u001eDa!V\t!\u0002\u0013a\u0015\u0001\u0004*F\u000f\u0016C\u0006KU#G\u0013b\u0003\u0003bB,\u0012\u0005\u0004%IaS\u0001\f%\u0016;U\tW*V\u0005\u001aK\u0005\f\u0003\u0004Z#\u0001\u0006I\u0001T\u0001\r%\u0016;U\tW*V\u0005\u001aK\u0005\f\t\u0005\b7F\t\t\u0011\"!]\u0003\u0015\t\u0007\u000f\u001d7z)\ri&1\f\t\u0003!y3AA\u0005\u0002A?N1a\fY2gYj\u0001\"\u0001E1\n\u0005\t\u0014!AC#yaJ,7o]5p]B\u0011\u0001\u0003Z\u0005\u0003K\n\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t9'.D\u0001i\u0015\tI'!A\u0004d_\u0012,w-\u001a8\n\u0005-D'aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005Ui\u0017B\u00018\u0017\u0005\u001d\u0001&o\u001c3vGRD\u0001\u0002\u001d0\u0003\u0016\u0004%\t!]\u0001\tG\"LG\u000e\u001a:f]V\t!\u000fE\u0002tw\u0002t!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]t\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\tQh#A\u0004qC\u000e\\\u0017mZ3\n\u0005ql(aA*fc*\u0011!P\u0006\u0005\t\u007fz\u0013\t\u0012)A\u0005e\u0006I1\r[5mIJ,g\u000e\t\u0005\u0007=y#\t!a\u0001\u0015\u0007u\u000b)\u0001\u0003\u0004q\u0003\u0003\u0001\rA\u001d\u0005\b\u0003\u0013qF\u0011IA\u0006\u0003!qW\u000f\u001c7bE2,WCAA\u0007!\r)\u0012qB\u0005\u0004\u0003#1\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+qF\u0011IA\f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u00033\u0001Ba]>\u0002\u001cA!\u0011QDA\u0011\u001b\t\tyB\u0003\u0002'\r%!\u00111EA\u0010\u0005!!\u0015\r^1UsB,\u0007bBA\u0014=\u0012\u0005\u0013\u0011F\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0004\u0005\b\u0003[qF\u0011IA\u0018\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003c\u0001B!a\r\u0002<9!\u0011QGA\u001c!\t)h#C\u0002\u0002:Y\ta\u0001\u0015:fI\u00164\u0017bA*\u0002>)\u0019\u0011\u0011\b\f\t\u0015\u0005\u0005c\f#b\u0001\n\u0013\t\u0019%A\u0005dC\u000eDW\rZ+sYV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n)\u0002\u00079,G/\u0003\u0003\u0002P\u0005%#aA+S\u0013\"\"\u0011qHA*!\r)\u0012QK\u0005\u0004\u0003/2\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011)\tYF\u0018EC\u0002\u0013%\u0011QL\u0001\u000eG\u0006\u001c\u0007.\u001a3QCR$XM\u001d8\u0016\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0006e\u0016<W\r\u001f\u0006\u0004\u0003S\u0002\u0016\u0001B;uS2LA!!\u001c\u0002d\t9\u0001+\u0019;uKJt\u0007\u0006BA-\u0003'B!\"a\u001d_\u0011\u000b\u0007I\u0011BA;\u0003U\u0019\u0017m\u00195fI\u0016CHO]1diB\u000b'\u000f\u001e$v]\u000e,\"!a\u001e\u0011\u000fU\tI(!\u0012\u00022%\u0019\u00111\u0010\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0006BA9\u0003'Bq!!!_\t\u0003\n\u0019)A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f\u0012\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u001f\u000bIIA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u001d\t\u0019J\u0018C\u0005\u0003+\u000b!bZ3u!\u0006$H/\u001a:o)\u0011\ty&a&\t\u000f\u0005e\u0015\u0011\u0013a\u0001G\u0005\u00191.Z=\t\u000f\u0005ue\f\"\u0003\u0002 \u00061q-\u001a;Ve2$B!!\u0012\u0002\"\"9\u00111UAN\u0001\u0004\u0019\u0013aA;sY\"9\u0011q\u00150\u0005\n\u0005%\u0016AE4fi\u0016CHO]1diB\u000b'\u000f\u001e$v]\u000e$B!a\u001e\u0002,\"9\u0011QVAS\u0001\u0004\u0019\u0013!\u00049beR$v.\u0012=ue\u0006\u001cG\u000fC\u0004\u00022z#I!a-\u0002+\u0015DHO]1diZ\u000bG.^3Ge>l\u0017+^3ssR)1%!.\u0002:\"9\u0011qWAX\u0001\u0004\u0019\u0013!B9vKJL\b\u0002CA^\u0003_\u0003\r!a\u0018\u0002\u000fA\fG\u000f^3s]\"9\u0011q\u00180\u0005\n\u0005\u0005\u0017AD3yiJ\f7\r\u001e$s_6,&\u000f\u001c\u000b\u0006G\u0005\r\u0017Q\u0019\u0005\t\u0003G\u000bi\f1\u0001\u0002F!9\u0011QVA_\u0001\u0004\u0019\u0003bBAe=\u0012%\u00111Z\u0001\u0013a\u0006\u00148/Z+sY^KG\u000f[8vi.+\u0017\u0010F\u0003$\u0003\u001b\fy\rC\u0004\u0002$\u0006\u001d\u0007\u0019A\u0012\t\u000f\u00055\u0016q\u0019a\u0001G!9\u00111\u001b0\u0005B\u0005U\u0017\u0001B3wC2$B!a6\u0002^B\u0019Q#!7\n\u0007\u0005mgCA\u0002B]fD!\"a8\u0002RB\u0005\t\u0019AAq\u0003\u0015Ig\u000e];u!\u0011\t\u0019/!:\u000e\u0003\u0011I1!a:\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u0013\u0005-h,!A\u0005\u0002\u00055\u0018\u0001B2paf$2!XAx\u0011!\u0001\u0018\u0011\u001eI\u0001\u0002\u0004\u0011\b\"CAz=F\u0005I\u0011AA{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a>+\u0007I\fIp\u000b\u0002\u0002|B!\u0011Q B\u0004\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011!C;oG\",7m[3e\u0015\r\u0011)AF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0005\u0003\u007f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011!\u0011iAXA\u0001\n\u0003Z\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0003\u0012y\u000b\t\u0011\"\u0001\u0003\u0014\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0003\t\u0004+\t]\u0011b\u0001B\r-\t\u0019\u0011J\u001c;\t\u0013\tua,!A\u0005\u0002\t}\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\u0014\t\u0003\u0003\u0006\u0003$\tm\u0011\u0011!a\u0001\u0005+\t1\u0001\u001f\u00132\u0011%\u00119CXA\u0001\n\u0003\u0012I#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0003\u0005\u0004\u0003.\tM\u0012q[\u0007\u0003\u0005_Q1A!\r\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0011yC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011IDXA\u0001\n\u0003\u0011Y$\u0001\u0005dC:,\u0015/^1m)\u0011\tiA!\u0010\t\u0015\t\r\"qGA\u0001\u0002\u0004\t9\u000eC\u0005\u0003By\u000b\t\u0011\"\u0011\u0003D\u00051Q-];bYN$B!!\u0004\u0003F!Q!1\u0005B \u0003\u0003\u0005\r!a6)\u0017y\u0013IEa\u0014\u0003R\tU#q\u000b\t\u0004!\t-\u0013b\u0001B'\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B*\u0003}zf)\u0016(D?\"*(\u000f\u001c\u0017!a\u0006\u0014H\u000fV8FqR\u0014\u0018m\u0019;\\Y\u0001ZW-_/*A5\u0002S\t\u001f;sC\u000e$8\u000fI1!a\u0006\u0014H\u000f\t4s_6\u0004\u0013\rI+S\u0019:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00053\n!Q\b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!$H\u000f\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006]1uQ~\nX/\u001a:z{E:C\u0006I\u0014I\u001fN#v%\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL1qC\u000eDWML8sO*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u001b;uajzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40a\u0006$\bnP9vKJLX(M\u0014-A\u001d\nV+\u0012*ZO%R\u0001\u0005\t\u0011!A\u0001\u0002\u0013/^3ssv\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iiR\u0004(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\u0002\u0018\r\u001e5@cV,'/_\u001f2O1\u0002s%U+F%f;C\u0006I\u0014rk\u0016\u0014\u0018pJ\u0015\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003\u0005C\u0003q5\u0002\u0007!\u000fC\u0005\u0003`E\t\t\u0011\"!\u0003b\u00059QO\\1qa2LH\u0003\u0002B2\u0005S\u0002B!\u0006B3e&\u0019!q\r\f\u0003\r=\u0003H/[8o\u0011%\u0011YG!\u0018\u0002\u0002\u0003\u0007Q,A\u0002yIAB\u0011Ba\u001c\u0012\u0003\u0003%IA!\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005g\u00022!\u0014B;\u0013\r\u00119H\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(ParseUrl parseUrl) {
        return ParseUrl$.MODULE$.unapply(parseUrl);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().size(), (Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                URI uRI = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.cachedUrl = uRI;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cachedUrl$lzycompute() : this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                Pattern pattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.cachedPattern = pattern;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cachedPattern$lzycompute() : this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedExtractPartFunc$lzycompute() : this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() > 3 || this.children().size() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(41).append(this.prettyName()).append(" function requires two or three arguments").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder(0).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append(key.toString()).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            uRI = null;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        Function1 & Serializable & scala.Serializable intersect;
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$56 -> x$56.getHost();
        } else {
            UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
            UTF8String uTF8String5 = uTF8String;
            if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)x$57 -> x$57.getRawPath();
            } else {
                UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                UTF8String uTF8String7 = uTF8String;
                if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$58 -> x$58.getRawQuery();
                } else {
                    UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
                    UTF8String uTF8String9 = uTF8String;
                    if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)x$59 -> x$59.getRawFragment();
                    } else {
                        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
                        UTF8String uTF8String11 = uTF8String;
                        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)x$60 -> x$60.getScheme();
                        } else {
                            UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
                            UTF8String uTF8String13 = uTF8String;
                            if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)url -> url.getRawQuery() != null ? new StringBuilder(1).append(url.getRawPath()).append("?").append(url.getRawQuery()).toString() : url.getRawPath();
                            } else {
                                UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
                                UTF8String uTF8String15 = uTF8String;
                                if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
                                    intersect = (Function1 & Serializable & scala.Serializable)x$61 -> x$61.getRawAuthority();
                                } else {
                                    UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
                                    UTF8String uTF8String17 = uTF8String;
                                    intersect = !(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null) ? (Function1 & Serializable & scala.Serializable)x$62 -> x$62.getRawUserInfo() : (Function1 & Serializable & scala.Serializable)url -> null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return intersect;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        return m.find() ? UTF8String.fromString((String)m.group(2)) : null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        return this.cachedExtractPartFunc() != null ? UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url))) : UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        URI currentUrl;
        return this.cachedUrl() != null ? this.extractFromUrl(this.cachedUrl(), partToExtract) : ((currentUrl = this.getUrl(url)) != null ? this.extractFromUrl(currentUrl, partToExtract) : null);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)e -> (UTF8String)e.eval(input), Seq$.MODULE$.canBuildFrom());
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            uTF8String = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        } else {
            Predef$.MODULE$.assert(evaluated.size() == 3);
            Object object = evaluated.apply(1);
            UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
            if (object == null ? uTF8String2 != null : !object.equals(uTF8String2)) {
                return null;
            }
            UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
            if (query == null) {
                return null;
            }
            uTF8String = this.cachedPattern() != null ? this.extractValueFromQuery(query, this.cachedPattern()) : this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
        }
        return uTF8String;
    }

    public ParseUrl copy(Seq<Expression> children2) {
        return new ParseUrl(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2) {
        this.children = children2;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

