/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001>\u00111\u0002U1sg\u0016$v\u000eR1uK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00027fMR,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015aWM\u001a;!\u0011!I\u0003A!f\u0001\n\u0003Q\u0013A\u00024pe6\fG/F\u0001,!\rABfI\u0005\u0003[e\u0011aa\u00149uS>t\u0007\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0016\u0002\u000f\u0019|'/\\1uA!A\u0011\u0007\u0001BK\u0002\u0013\u0005!%A\u0003dQ&dG\r\u0003\u00054\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0019\u0007.\u001b7eA!)Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"Ba\u000e\u001d:uA\u0011\u0011\u0003\u0001\u0005\u0006CQ\u0002\ra\t\u0005\u0006SQ\u0002\ra\u000b\u0005\u0006cQ\u0002\ra\t\u0005\u0006k\u0001!\t\u0001\u0010\u000b\u0004our\u0004\"B\u0011<\u0001\u0004\u0019\u0003\"B\u0015<\u0001\u0004\u0019\u0003\"B\u001b\u0001\t\u0003\u0001ECA\u001cB\u0011\u0015\ts\b1\u0001$\u0011\u0015\u0019\u0005\u0001\"\u0011E\u000351G.\u0019;Be\u001e,X.\u001a8ugV\tQ\tE\u0002G\u001dFs!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\ti\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&\u0001C%uKJ\fGo\u001c:\u000b\u00055K\u0002C\u0001\rS\u0013\t\u0019\u0016DA\u0002B]fDQa\u0002\u0001\u0005BU+\u0012A\u0016\t\u0003/ns!\u0001W-\u0011\u0005!K\u0012B\u0001.\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iK\u0002\"B0\u0001\t\u0003*\u0016A\u00039sKR$\u0018PT1nK\"9\u0011\rAA\u0001\n\u0003\u0011\u0017\u0001B2paf$BaN2eK\"9\u0011\u0005\u0019I\u0001\u0002\u0004\u0019\u0003bB\u0015a!\u0003\u0005\ra\u000b\u0005\bc\u0001\u0004\n\u00111\u0001$\u0011\u001d9\u0007!%A\u0005\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\u0019#nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001/G\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bi\u0002\t\n\u0011\"\u0001v\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012A\u001e\u0016\u0003W)Dq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0001.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u000fi\u0004\u0011\u0011!C!w\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0003mC:<'BAA\u0002\u0003\u0011Q\u0017M^1\n\u0005qs\b\"CA\u0005\u0001\u0005\u0005I\u0011AA\u0006\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0001E\u0002\u0019\u0003\u001fI1!!\u0005\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002R\u00033A!\"a\u0007\u0002\u0014\u0005\u0005\t\u0019AA\u0007\u0003\rAH%\r\u0005\n\u0003?\u0001\u0011\u0011!C!\u0003C\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0001R!!\n\u0002,Ek!!a\n\u000b\u0007\u0005%\u0012$\u0001\u0006d_2dWm\u0019;j_:L1aTA\u0014\u0011%\ty\u0003AA\u0001\n\u0003\t\t$\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019$!\u000f\u0011\u0007a\t)$C\u0002\u00028e\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001c\u00055\u0012\u0011!a\u0001#\"I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013qH\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0012\u0011\t\u0005\n\u00037\tY$!AA\u0002ECs\u0002AA#\u0003\u0017\ni%!\u0015\u0002T\u0005]\u0013\u0011\f\t\u0004#\u0005\u001d\u0013bAA%\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA(\u0003\u0005e&\u0002\t\u0011!A}3UKT\"`Q\u0011\fG/Z0tiJ\\F\u0006\t4nivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003\rZ1uK~\u001bHO\u001d1!Kb\u0004(/Z:tS>t\u0007e^5uQ\u0002\"\b.\u001a\u0011aM6$\b\rI3yaJ,7o]5p]\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003%\u0019\u0011eCR,g\u0006\t*fiV\u0014hn\u001d\u0011ok2d\u0007e^5uQ\u0002JgN^1mS\u0012\u0004\u0013N\u001c9vi:\u0002#)\u001f\u0011eK\u001a\fW\u000f\u001c;-A%$\bEZ8mY><8\u000fI2bgRLgn\u001a\u0011sk2,7\u000f\t;pA\u0005\u0004C-\u0019;fA%4'\u0002\t\u0011!A\u0001\u0002C\u000f[3!A\u001alG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0016\u0002\u0003[Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\u0002\u0014(\f\u00198[M\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T&\r\u001a.gE:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u00037\nQ!\r\u00186]A:\u0011\"a\u0018\u0003\u0003\u0003E\t!!\u0019\u0002\u0017A\u000b'o]3U_\u0012\u000bG/\u001a\t\u0004#\u0005\rd\u0001C\u0001\u0003\u0003\u0003E\t!!\u001a\u0014\u000b\u0005\r\u0014qM\u000f\u0011\u0011\u0005%\u0014qN\u0012,G]j!!a\u001b\u000b\u0007\u00055\u0014$A\u0004sk:$\u0018.\\3\n\t\u0005E\u00141\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB\u001b\u0002d\u0011\u0005\u0011Q\u000f\u000b\u0003\u0003CB!\"!\u001f\u0002d\u0005\u0005IQIA>\u0003!!xn\u0015;sS:<G#\u0001?\t\u0015\u0005}\u00141MA\u0001\n\u0003\u000b\t)A\u0003baBd\u0017\u0010F\u00048\u0003\u0007\u000b))a\"\t\r\u0005\ni\b1\u0001$\u0011\u0019I\u0013Q\u0010a\u0001W!1\u0011'! A\u0002\rB!\"a#\u0002d\u0005\u0005I\u0011QAG\u0003\u001d)h.\u00199qYf$B!a$\u0002\u0018B!\u0001\u0004LAI!\u0019A\u00121S\u0012,G%\u0019\u0011QS\r\u0003\rQ+\b\u000f\\34\u0011%\tI*!#\u0002\u0002\u0003\u0007q'A\u0002yIAB!\"!(\u0002d\u0005\u0005I\u0011BAP\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0006cA?\u0002$&\u0019\u0011Q\u0015@\u0003\r=\u0013'.Z2u\u0001")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

