/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001>\u0011QA\u0014+jY\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011QBU8x\u001dVl'-\u001a:MS.,\u0007CA\t\u0016\u0013\t1\"AA\fTSj,')Y:fI^Kg\u000eZ8x\rVt7\r^5p]B\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u001d\u0011WoY6fiN,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003!\u0011WoY6fiN\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u0011\u0011\u0003\u0001\u0005\u0006C!\u0002\ra\t\u0005\u0006S\u0001!\tA\f\u000b\u0002W!)\u0001\u0007\u0001C!c\u0005A1\r[5mIJ,g.F\u00013!\r\u00194h\t\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001\u001e\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0007M+\u0017O\u0003\u0002;3!)q\b\u0001C!\u0001\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005A\u0011M\\1msNL7/\u0003\u0002G\u0007\nyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0004I\u0001\t\u0007I\u0011B%\u0002\r\t,8m[3u+\u0005Q\u0005CA\tL\u0013\ta%A\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0007B\u0002(\u0001A\u0003%!*A\u0004ck\u000e\\W\r\u001e\u0011\t\u000fA\u0003!\u0019!C\u0005\u0013\u0006y!-^2lKR$\u0006N]3tQ>dG\r\u0003\u0004S\u0001\u0001\u0006IAS\u0001\u0011EV\u001c7.\u001a;UQJ,7\u000f[8mI\u0002Bq\u0001\u0016\u0001C\u0002\u0013%\u0011*\u0001\u0006ck\u000e\\W\r^*ju\u0016DaA\u0016\u0001!\u0002\u0013Q\u0015a\u00032vG.,GoU5{K\u0002Bq\u0001\u0017\u0001C\u0002\u0013%\u0011*\u0001\nck\u000e\\W\r^:XSRD\u0007+\u00193eS:<\u0007B\u0002.\u0001A\u0003%!*A\nck\u000e\\W\r^:XSRD\u0007+\u00193eS:<\u0007\u0005C\u0003]\u0001\u0011%Q,\u0001\bck\u000e\\W\r^(wKJ4Gn\\<\u0015\u0005y\u000b\u0007CA\t`\u0013\t\u0001'A\u0001\u0002JM\")!m\u0017a\u0001G\u0005\tQ\rC\u0004e\u0001\t\u0007I\u0011I3\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0003\u0019\u00042a\u001a6K\u001b\u0005A'BA5\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y!Da\u0001\u001c\u0001!\u0002\u00131\u0017\u0001F1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b\u0005C\u0004o\u0001\t\u0007I\u0011I8\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\u0005\u0001\bcA4kG!1!\u000f\u0001Q\u0001\nA\fa\"\u001b8ji&\fGNV1mk\u0016\u001c\b\u0005C\u0004u\u0001\t\u0007I\u0011I8\u0002#U\u0004H-\u0019;f\u000bb\u0004(/Z:tS>t7\u000f\u0003\u0004w\u0001\u0001\u0006I\u0001]\u0001\u0013kB$\u0017\r^3FqB\u0014Xm]:j_:\u001c\b\u0005C\u0004y\u0001\t\u0007I\u0011I%\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007u\u0002\u0001\u000b\u0011\u0002&\u0002'\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\t\u000fq\u0004\u0011\u0011!C\u0001{\u0006!1m\u001c9z)\tYc\u0010C\u0004\"wB\u0005\t\u0019A\u0012\t\u0013\u0005\u0005\u0001!%A\u0005\u0002\u0005\r\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bQ3aIA\u0004W\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\n3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u000e\u0001\u0005\u0005I\u0011IA\u000f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006LA!!\f\u0002$\t11\u000b\u001e:j]\u001eD\u0011\"!\r\u0001\u0003\u0003%\t!a\r\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0002c\u0001\r\u00028%\u0019\u0011\u0011H\r\u0003\u0007%sG\u000fC\u0005\u0002>\u0001\t\t\u0011\"\u0001\u0002@\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA!\u0003\u000f\u00022\u0001GA\"\u0013\r\t)%\u0007\u0002\u0004\u0003:L\bBCA%\u0003w\t\t\u00111\u0001\u00026\u0005\u0019\u0001\u0010J\u0019\t\u0013\u00055\u0003!!A\u0005B\u0005=\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0003#B4\u0002T\u0005\u0005\u0013bAA+Q\nA\u0011\n^3sCR|'\u000fC\u0005\u0002Z\u0001\t\t\u0011\"\u0001\u0002\\\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002^\u0005\r\u0004c\u0001\r\u0002`%\u0019\u0011\u0011M\r\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011JA,\u0003\u0003\u0005\r!!\u0011\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002^\u0005-\u0004BCA%\u0003K\n\t\u00111\u0001\u0002B!:\u0001!a\u001c\u0002v\u0005]\u0004cA\t\u0002r%\u0019\u00111\u000f\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011P\u0001u\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b8*A5\u0002C)\u001b<jI\u0016\u001c\b\u0005\u001e5fAI|wo\u001d\u0011g_J\u0004S-Y2iA]Lg\u000eZ8xAA\f'\u000f^5uS>t\u0007%\u001b8u_\u0002\u0002g\u000e\u0019\u0011ck\u000e\\W\r^:!e\u0006tw-\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!MJ|W\u000eI\u0019!i>\u0004\u0013\r\u001e\u0011n_N$\b\u0005\u00198a])\u0001\u0003eB\u0005\u0002~\t\t\t\u0011#\u0001\u0002\u0000\u0005)a\nV5mKB\u0019\u0011#!!\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u0007\u001bR!!!\u0002\u0006v\u0001b!a\"\u0002\u000e\u000eZSBAAE\u0015\r\tY)G\u0001\beVtG/[7f\u0013\u0011\ty)!#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004*\u0003\u0003#\t!a%\u0015\u0005\u0005}\u0004BCAL\u0003\u0003\u000b\t\u0011\"\u0012\u0002\u001a\u0006AAo\\*ue&tw\r\u0006\u0002\u0002 !Q\u0011QTAA\u0003\u0003%\t)a(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-\n\t\u000b\u0003\u0004\"\u00037\u0003\ra\t\u0005\u000b\u0003K\u000b\t)!A\u0005\u0002\u0006\u001d\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003S\u000by\u000b\u0005\u0003\u0019\u0003W\u001b\u0013bAAW3\t1q\n\u001d;j_:D\u0011\"!-\u0002$\u0006\u0005\t\u0019A\u0016\u0002\u0007a$\u0003\u0007\u0003\u0006\u00026\u0006\u0005\u0015\u0011!C\u0005\u0003o\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0018\t\u0005\u0003C\tY,\u0003\u0003\u0002>\u0006\r\"AB(cU\u0016\u001cG\u000f")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private final AttributeReference n;

    public static Option<Expression> unapply(NTile nTile) {
        return NTile$.MODULE$.unapply(nTile);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, NTile> compose(Function1<A, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.buckets()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.buckets().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("Buckets expression must be foldable, but got ").append(this.buckets()).toString());
        }
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append("Buckets expression must be integer type, but got ").append(this.buckets()).toString());
        }
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Buckets expression must be positive, but got: ").append(i).toString());
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.buckets();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        String x$34 = "bucket";
        IntegerType$ x$35 = IntegerType$.MODULE$;
        boolean x$36 = false;
        Metadata x$37 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$38 = AttributeReference$.MODULE$.apply$default$5(x$34, x$35, x$36, x$37);
        Seq<String> x$39 = AttributeReference$.MODULE$.apply$default$6(x$34, x$35, x$36, x$37);
        this.bucket = new AttributeReference(x$34, x$35, x$36, x$37, x$38, x$39);
        String x$40 = "bucketThreshold";
        IntegerType$ x$41 = IntegerType$.MODULE$;
        boolean x$42 = false;
        Metadata x$43 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$44 = AttributeReference$.MODULE$.apply$default$5(x$40, x$41, x$42, x$43);
        Seq<String> x$45 = AttributeReference$.MODULE$.apply$default$6(x$40, x$41, x$42, x$43);
        this.bucketThreshold = new AttributeReference(x$40, x$41, x$42, x$43, x$44, x$45);
        String x$46 = "bucketSize";
        IntegerType$ x$47 = IntegerType$.MODULE$;
        boolean x$48 = false;
        Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$50 = AttributeReference$.MODULE$.apply$default$5(x$46, x$47, x$48, x$49);
        Seq<String> x$51 = AttributeReference$.MODULE$.apply$default$6(x$46, x$47, x$48, x$49);
        this.bucketSize = new AttributeReference(x$46, x$47, x$48, x$49, x$50, x$51);
        String x$52 = "bucketsWithPadding";
        IntegerType$ x$53 = IntegerType$.MODULE$;
        boolean x$54 = false;
        Metadata x$55 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$56 = AttributeReference$.MODULE$.apply$default$5(x$52, x$53, x$54, x$55);
        Seq<String> x$57 = AttributeReference$.MODULE$.apply$default$6(x$52, x$53, x$54, x$55);
        this.bucketsWithPadding = new AttributeReference(x$52, x$53, x$54, x$55, x$56, x$57);
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.rowNumber(), this.bucket(), this.bucketThreshold(), this.bucketSize(), this.bucketsWithPadding()}));
        this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.zero(), this.zero(), this.zero(), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$div(buckets)).cast(IntegerType$.MODULE$), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast(IntegerType$.MODULE$)}));
        this.updateExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), NoOp$.MODULE$, NoOp$.MODULE$}));
        this.evaluateExpression = this.bucket();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

