/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011Q\"T1q\rJ|W.\u0011:sCf\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\u0005Y\u00164G/F\u0001$!\t\tB%\u0003\u0002&\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\r\nQ\u0001\\3gi\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0006e&<\u0007\u000e\u001e\u0005\tW\u0001\u0011\t\u0012)A\u0005G\u00051!/[4ii\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00181cA\u0011\u0011\u0003\u0001\u0005\u0006C1\u0002\ra\t\u0005\u0006S1\u0002\ra\t\u0005\u0006g\u0001!\t\u0005N\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A\u001b\u0011\u0007Yr\u0014I\u0004\u00028y9\u0011\u0001hO\u0007\u0002s)\u0011!HD\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!P\r\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\u0004'\u0016\f(BA\u001f\u001a!\t\u0011U)D\u0001D\u0015\t!e!A\u0003usB,7/\u0003\u0002G\u0007\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0006\u0011\u0002!\t%S\u0001\tI\u0006$\u0018\rV=qKV\t!\n\u0005\u0002C\u0017&\u0011Aj\u0011\u0002\t\t\u0006$\u0018\rV=qK\")a\n\u0001C!\u001f\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001kU+\u0011\u0005a\t\u0016B\u0001*\u001a\u0005\r\te.\u001f\u0005\u0006)6\u0003\r\u0001U\u0001\tW\u0016L\u0018I\u001d:bs\")a+\u0014a\u0001!\u0006Qa/\u00197vK\u0006\u0013(/Y=\t\u000ba\u0003A\u0011I-\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u0001.aKB\u00111LX\u0007\u00029*\u0011QLA\u0001\bG>$WmZ3o\u0013\tyFL\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\tw\u000b1\u0001c\u0003\r\u0019G\u000f\u001f\t\u00037\u000eL!\u0001\u001a/\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")am\u0016a\u00015\u0006\u0011QM\u001e\u0005\u0006Q\u0002!\t%[\u0001\u000baJ,G\u000f^=OC6,W#\u00016\u0011\u0005-|gB\u00017n!\tA\u0014$\u0003\u0002o3\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tq\u0017\u0004C\u0004t\u0001\u0005\u0005I\u0011\u0001;\u0002\t\r|\u0007/\u001f\u000b\u0004_U4\bbB\u0011s!\u0003\u0005\ra\t\u0005\bSI\u0004\n\u00111\u0001$\u0011\u001dA\b!%A\u0005\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001{U\t\u00193pK\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00023\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u001daPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"a\u0003\u0001#\u0003%\t!_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ty\u0001AA\u0001\n\u0003\n\t\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\u0007A\f9\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0005\t\u00041\u0005%\u0012bAA\u00163\t\u0019\u0011J\u001c;\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004!\u0006M\u0002BCA\u001b\u0003[\t\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005e\u0002!!A\u0005B\u0005m\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0002#BA \u0003\u000b\u0002VBAA!\u0015\r\t\u0019%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA$\u0003\u0003\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001b\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\n)\u0006E\u0002\u0019\u0003#J1!a\u0015\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u000e\u0002J\u0005\u0005\t\u0019\u0001)\t\u0013\u0005e\u0003!!A\u0005B\u0005m\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002P\u0005u\u0003\"CA\u001b\u0003/\n\t\u00111\u0001QQ=\u0001\u0011\u0011MA4\u0003S\ni'a\u001c\u0002t\u0005U\u0004cA\t\u0002d%\u0019\u0011Q\r\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111N\u0001\u0002\u0006)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015lKf\u001cH\u0006\t<bYV,7/\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA]LG\u000f\u001b\u0011bAA\f\u0017N\u001d\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI6fs>2\u0018\r\\;fA\u0005\u0014(/Y=t]\u0001\nE\u000e\u001c\u0011fY\u0016lWM\u001c;t\u0015\u0001\u0002\u0003\u0005\t\u0011!S:\u00043.Z=tAMDw.\u001e7eA9|G\u000f\t2fA9,H\u000e\\\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011O\u0001d\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEr\u0003\u0007\f\u00114]AJC\u0006I1se\u0006L\bf\n\u001a(Y\u0001:CgJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0018G\f\u0019;EI\u0012Cf\r\u00181u\t\"$% \u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006e9\"d\u0006M\u0004\n\u0003w\u0012\u0011\u0011!E\u0001\u0003{\nQ\"T1q\rJ|W.\u0011:sCf\u001c\bcA\t\u0002\u0000\u0019A\u0011AAA\u0001\u0012\u0003\t\tiE\u0003\u0002\u0000\u0005\rU\u0004E\u0004\u0002\u0006\u0006-5eI\u0018\u000e\u0005\u0005\u001d%bAAE3\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u0013q\u0010C\u0001\u0003##\"!! \t\u0015\u0005U\u0015qPA\u0001\n\u000b\n9*\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0002\u0003\u0006\u0002\u001c\u0006}\u0014\u0011!CA\u0003;\u000bQ!\u00199qYf$RaLAP\u0003CCa!IAM\u0001\u0004\u0019\u0003BB\u0015\u0002\u001a\u0002\u00071\u0005\u0003\u0006\u0002&\u0006}\u0014\u0011!CA\u0003O\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002*\u0006U\u0006#\u0002\r\u0002,\u0006=\u0016bAAW3\t1q\n\u001d;j_:\u0004R\u0001GAYG\rJ1!a-\u001a\u0005\u0019!V\u000f\u001d7fe!I\u0011qWAR\u0003\u0003\u0005\raL\u0001\u0004q\u0012\u0002\u0004BCA^\u0003\u007f\n\t\u0011\"\u0003\u0002>\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\f\u0005\u0003\u0002\u0016\u0005\u0005\u0017\u0002BAb\u0003/\u0011aa\u00142kK\u000e$\b")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays mapFromArrays) {
        return MapFromArrays$.MODULE$.unapply(mapFromArrays);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        if (keyArrayData.numElements() != valueArrayData.numElements()) {
            throw new RuntimeException("The given two arrays should have the same length");
        }
        ArrayType leftArrayType = (ArrayType)this.left().dataType();
        if (leftArrayType.containsNull()) {
            for (int i = 0; i < keyArrayData.numElements(); ++i) {
                if (!keyArrayData.isNullAt(i)) continue;
                throw new RuntimeException("Cannot use null as map key!");
            }
        }
        return new ArrayBasedMapData(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(keyArrayData, valueArrayData) -> {
            String string;
            String arrayBasedMapData = ArrayBasedMapData.class.getName();
            ArrayType leftArrayType = (ArrayType)this.left().dataType();
            if (!leftArrayType.containsNull()) {
                string = "";
            } else {
                String i = ctx.freshName("i");
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)keyArrayData).append(".numElements(); ").append(i).append("++) {\n           |  if (").append((String)keyArrayData).append(".isNullAt(").append(i).append(")) {\n           |    throw new RuntimeException(\"Cannot use null as map key!\");\n           |  }\n           |}\n         ").toString())).stripMargin();
            }
            String keyArrayElemNullCheck = string;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(210).append("\n         |if (").append((String)keyArrayData).append(".numElements() != ").append((String)valueArrayData).append(".numElements()) {\n         |  throw new RuntimeException(\"The given two arrays should have the same length\");\n         |}\n         |").append(keyArrayElemNullCheck).append("\n         |").append(ev.value()).append(" = new ").append(arrayBasedMapData).append("(").append((String)keyArrayData).append(".copy(), ").append((String)valueArrayData).append(".copy());\n       ").toString())).stripMargin();
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

