/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3Q!\u0001\u0002\u0002\u0002=\u0011q#\u00138uKJ\u0004(/\u001a;fI\"\u000b7\u000f\u001b$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0019EQ$A\u0004iCND\u0017J\u001c;\u0015\u0007y\tc\u0005\u0005\u0002\u0012?%\u0011\u0001E\u0005\u0002\u0005\u0019>tw\rC\u0003#7\u0001\u00071%A\u0001j!\t\tB%\u0003\u0002&%\t\u0019\u0011J\u001c;\t\u000b\u001dZ\u0002\u0019\u0001\u0010\u0002\tM,W\r\u001a\u0005\u0006S\u00011\tBK\u0001\tQ\u0006\u001c\b\u000eT8oOR\u0019adK\u0017\t\u000b1B\u0003\u0019\u0001\u0010\u0002\u00031DQa\n\u0015A\u0002yAQa\f\u0001\u0007\u0012A\nq\u0002[1tQVs7/\u00194f\u0005f$Xm\u001d\u000b\u0006=E\u001aTg\u000e\u0005\u0006e9\u0002\r\u0001E\u0001\u0005E\u0006\u001cX\rC\u00035]\u0001\u0007a$\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006m9\u0002\raI\u0001\u0007Y\u0016tw\r\u001e5\t\u000b\u001dr\u0003\u0019\u0001\u0010\t\u000be\u0002A\u0011\u0001\u001e\u0002\t!\f7\u000f\u001b\u000b\u0005=m\u0002\u0005\nC\u0003=q\u0001\u0007Q(A\u0003wC2,X\r\u0005\u0002\u0012}%\u0011qH\u0005\u0002\u0004\u0003:L\b\"B!9\u0001\u0004\u0011\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005\r3U\"\u0001#\u000b\u0005\u00153\u0011!\u0002;za\u0016\u001c\u0018BA$E\u0005!!\u0015\r^1UsB,\u0007\"B\u00149\u0001\u0004q\u0002")
public abstract class InterpretedHashFunction {
    public abstract long hashInt(int var1, long var2);

    public abstract long hashLong(long var1, long var3);

    public abstract long hashUnsafeBytes(Object var1, long var2, int var4, long var5);

    public long hash(Object value, DataType dataType, long seed) {
        long l;
        Object object = value;
        if (object == null) {
            l = seed;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            l = this.hashInt(bl ? 1 : 0, seed);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            l = this.hashInt(by, seed);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            l = this.hashInt(s, seed);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            l = this.hashInt(n, seed);
        } else if (object instanceof Long) {
            long l2 = BoxesRunTime.unboxToLong((Object)object);
            l = this.hashLong(l2, seed);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            l = this.hashInt(Float.floatToIntBits(f), seed);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            l = this.hashLong(Double.doubleToLongBits(d), seed);
        } else if (object instanceof Decimal) {
            long l3;
            Decimal decimal = (Decimal)object;
            int precision = ((DecimalType)dataType).precision();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                l3 = this.hashLong(decimal.toUnscaledLong(), seed);
            } else {
                byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
                l3 = this.hashUnsafeBytes(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length, seed);
            }
            l = l3;
        } else if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            l = this.hashInt(calendarInterval.months, this.hashLong(calendarInterval.microseconds, seed));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            l = this.hashUnsafeBytes(byArray, Platform.BYTE_ARRAY_OFFSET, byArray.length, seed);
        } else if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            l = this.hashUnsafeBytes(uTF8String.getBaseObject(), uTF8String.getBaseOffset(), uTF8String.numBytes(), seed);
        } else if (object instanceof ArrayData) {
            DataType dataType2;
            ArrayData arrayData = (ArrayData)object;
            DataType dataType3 = dataType;
            if (dataType3 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = ((ArrayType)userDefinedType.sqlType()).elementType();
            } else if (dataType3 instanceof ArrayType) {
                DataType et;
                ArrayType arrayType = (ArrayType)dataType3;
                dataType2 = et = arrayType.elementType();
            } else {
                throw new MatchError((Object)dataType3);
            }
            DataType elementType = dataType2;
            long result = seed;
            for (int i = 0; i < arrayData.numElements(); ++i) {
                result = this.hash(arrayData.get(i, elementType), elementType, result);
            }
            l = result;
        } else if (object instanceof MapData) {
            Tuple2 tuple2;
            MapData mapData = (MapData)object;
            DataType dataType4 = dataType;
            if (dataType4 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType4;
                MapType mapType = (MapType)userDefinedType.sqlType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.keyType()), (Object)mapType.valueType());
            } else if (dataType4 instanceof MapType) {
                MapType mapType = (MapType)dataType4;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)kt), (Object)vt);
            } else {
                throw new MatchError((Object)dataType4);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            DataType kt = (DataType)tuple22._1();
            DataType vt = (DataType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)kt, (Object)vt);
            Tuple2 tuple24 = tuple23;
            DataType kt2 = (DataType)tuple24._1();
            DataType vt2 = (DataType)tuple24._2();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            long result = seed;
            for (int i = 0; i < mapData.numElements(); ++i) {
                result = this.hash(keys.get(i, kt2), kt2, result);
                result = this.hash(values.get(i, vt2), vt2, result);
            }
            l = result;
        } else if (object instanceof InternalRow) {
            DataType[] dataTypeArray;
            InternalRow internalRow = (InternalRow)object;
            DataType dataType5 = dataType;
            if (dataType5 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType5;
                dataTypeArray = (DataType[])((TraversableOnce)((StructType)userDefinedType.sqlType()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
            } else if (dataType5 instanceof StructType) {
                StructType structType = (StructType)dataType5;
                StructField[] fields = structType.fields();
                dataTypeArray = (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
            } else {
                throw new MatchError((Object)dataType5);
            }
            DataType[] types = dataTypeArray;
            long result = seed;
            int len = internalRow.numFields();
            for (int i = 0; i < len; ++i) {
                result = this.hash(internalRow.get(i, types[i]), types[i], result);
            }
            l = result;
        } else {
            throw new MatchError(object);
        }
        return l;
    }
}

