/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2 _FUNC_ '1.1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u00111b\u0012:fCR,'\u000f\u00165b]*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!QY\u0012\u0005\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\t\u0003+aq!!\u0005\f\n\u0005]\u0011\u0011a\u00029bG.\fw-Z\u0005\u00033i\u0011aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002\u0018\u0005A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t9\u0001K]8ek\u000e$\bC\u0001\u000f#\u0013\t\u0019SD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005&\u0001\tU\r\u0011\"\u0001'\u0003\u0011aWM\u001a;\u0016\u0003\u001d\u0002\"!\u0005\u0015\n\u0005%\u0012!AC#yaJ,7o]5p]\"A1\u0006\u0001B\tB\u0003%q%A\u0003mK\u001a$\b\u0005\u0003\u0005.\u0001\tU\r\u0011\"\u0001'\u0003\u0015\u0011\u0018n\u001a5u\u0011!y\u0003A!E!\u0002\u00139\u0013A\u0002:jO\"$\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004gQ*\u0004CA\t\u0001\u0011\u0015)\u0003\u00071\u0001(\u0011\u0015i\u0003\u00071\u0001(\u0011\u00159\u0004\u0001\"\u00119\u0003\u0019\u0019\u00180\u001c2pYV\t\u0011\b\u0005\u0002;\u0003:\u00111h\u0010\t\u0003yui\u0011!\u0010\u0006\u0003}9\ta\u0001\u0010:p_Rt\u0014B\u0001!\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001k\u0002\"B#\u0001\t#2\u0015\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA$K\u0019B\u0011A\u0004S\u0005\u0003\u0013v\u00111!\u00118z\u0011\u0015YE\t1\u0001H\u0003\u0019Ig\u000e];uc!)Q\n\u0012a\u0001\u000f\u00061\u0011N\u001c9viJBqa\u0014\u0001\u0002\u0002\u0013\u0005\u0001+\u0001\u0003d_BLHcA\u001aR%\"9QE\u0014I\u0001\u0002\u00049\u0003bB\u0017O!\u0003\u0005\ra\n\u0005\b)\u0002\t\n\u0011\"\u0001V\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u0016\u0016\u0003O][\u0013\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005uk\u0012AC1o]>$\u0018\r^5p]&\u0011qL\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB1\u0001#\u0003%\t!V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d\u0019\u0007!!A\u0005B\u0011\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002CO\"9Q\u000eAA\u0001\n\u0003q\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A8\u0011\u0005q\u0001\u0018BA9\u001e\u0005\rIe\u000e\u001e\u0005\bg\u0002\t\t\u0011\"\u0001u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"aR;\t\u000fY\u0014\u0018\u0011!a\u0001_\u0006\u0019\u0001\u0010J\u0019\t\u000fa\u0004\u0011\u0011!C!s\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001{!\rYhpR\u0007\u0002y*\u0011Q0H\u0001\u000bG>dG.Z2uS>t\u0017BA@}\u0005!IE/\u001a:bi>\u0014\b\"CA\u0002\u0001\u0005\u0005I\u0011AA\u0003\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0004\u0003\u001b\u00012\u0001HA\u0005\u0013\r\tY!\b\u0002\b\u0005>|G.Z1o\u0011!1\u0018\u0011AA\u0001\u0002\u00049\u0005\"CA\t\u0001\u0005\u0005I\u0011IA\n\u0003\u0019)\u0017/^1mgR!\u0011qAA\u000b\u0011!1\u0018qBA\u0001\u0002\u00049\u0005f\u0004\u0001\u0002\u001a\u0005}\u0011\u0011EA\u0013\u0003O\tY#!\f\u0011\u0007E\tY\"C\u0002\u0002\u001e\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002$\u0005)U\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1fqB\u0014\u0018\u0007\u0019\u0011jg\u0002:'/Z1uKJ\u0004C\u000f[1oA\u0001,\u0007\u0010\u001d:3A:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005%\u0012Aa%\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3A5\u0002C\u000f[3!i^|\u0007%\u001a=qe\u0016\u001c8/[8og\u0002jWo\u001d;!E\u0016\u00043/Y7fAQL\b/\u001a\u0011pe\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001a\u0017m\u001d;fI\u0002\"x\u000eI1!G>lWn\u001c8!if\u0004X\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ng\u000e\u001a\u0011nkN$\bEY3!C\u0002\"\u0018\u0010]3!i\"\fG\u000fI2b]\u0002\u0012W\rI8sI\u0016\u0014X\r\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011nCB\u0004C/\u001f9fA%\u001c\bE\\8uA=\u0014H-\u001a:bE2,G\u0006I:pA%$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t\u0003ER8sA\r|W\u000e\u001d7fq\u0002\"\u0018\u0010]3tAM,8\r\u001b\u0011beJ\f\u0017pL:ueV\u001cG\u000f\f\u0011uQ\u0016\u0004C-\u0019;bAQL\b/Z:!_\u001a\u0004c-[3mIN\u0004S.^:u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\f\u0002\u0005GS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00112w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAI\u0002sLR+O\u0007~\u0003s%\r\u00182OmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013\u0006I0G+:\u001bu\f\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013\u0006I0G+:\u001bu\f\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00199[A\n\u0004\u0005\r\u001b;c]RTGM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\n\u0004e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002s!CA\u001a\u0005\u0005\u0005\t\u0012AA\u001b\u0003-9%/Z1uKJ$\u0006.\u00198\u0011\u0007E\t9D\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u001d'\u0015\t9$a\u000f\"!\u001d\ti$a\u0011(OMj!!a\u0010\u000b\u0007\u0005\u0005S$A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0013q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0019\u00028\u0011\u0005\u0011\u0011\n\u000b\u0003\u0003kA!\"!\u0014\u00028\u0005\u0005IQIA(\u0003!!xn\u0015;sS:<G#A3\t\u0015\u0005M\u0013qGA\u0001\n\u0003\u000b)&A\u0003baBd\u0017\u0010F\u00034\u0003/\nI\u0006\u0003\u0004&\u0003#\u0002\ra\n\u0005\u0007[\u0005E\u0003\u0019A\u0014\t\u0015\u0005u\u0013qGA\u0001\n\u0003\u000by&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0014Q\u000e\t\u00069\u0005\r\u0014qM\u0005\u0004\u0003Kj\"AB(qi&|g\u000eE\u0003\u001d\u0003S:s%C\u0002\u0002lu\u0011a\u0001V;qY\u0016\u0014\u0004\"CA8\u00037\n\t\u00111\u00014\u0003\rAH\u0005\r\u0005\u000b\u0003g\n9$!A\u0005\n\u0005U\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001e\u0011\u0007\u0019\fI(C\u0002\u0002|\u001d\u0014aa\u00142kK\u000e$\b")
public class GreaterThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThan greaterThan) {
        return GreaterThan$.MODULE$.unapply(greaterThan);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThan> tupled() {
        return GreaterThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThan>> curried() {
        return GreaterThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return ">";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gt(input1, input2));
    }

    public GreaterThan copy(Expression left, Expression right) {
        return new GreaterThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThan greaterThan = (GreaterThan)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThan.canEqual(this)) return false;
        return true;
    }

    public GreaterThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

