/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.JsonPathParser$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Key$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Subscript$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Wildcard$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$FlattenStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$QuotedStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$RawStyle$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ")
@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0001\u0003\u0001>\u0011QbR3u\u0015N|gn\u00142kK\u000e$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001BcF\u000f$!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\tQ\"!A\u0004d_\u0012,w-\u001a8\n\u0005qI\"aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0004J\u0005\u0003K}\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\n\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u0005UN|g.F\u0001*!\t\t\"&\u0003\u0002,\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u00115\u0002!\u0011#Q\u0001\n%\nQA[:p]\u0002B\u0001b\f\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u0005a\u0006$\b\u000e\u0003\u00052\u0001\tE\t\u0015!\u0003*\u0003\u0015\u0001\u0018\r\u001e5!\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0019QGN\u001c\u0011\u0005E\u0001\u0001\"B\u00143\u0001\u0004I\u0003\"B\u00183\u0001\u0004I\u0003\"B\u001d\u0001\t\u0003B\u0013\u0001\u00027fMRDQa\u000f\u0001\u0005B!\nQA]5hQRDQ!\u0010\u0001\u0005By\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005y\u0004c\u0001!I\u0017:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005\u001d{\u0012a\u00029bG.\fw-Z\u0005\u0003\u0013*\u00131aU3r\u0015\t9u\u0004\u0005\u0002M\u001f6\tQJ\u0003\u0002O\r\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\t\t\u0006$\u0018\rV=qK\")!\u000b\u0001C!'\u0006AA-\u0019;b)f\u0004X-F\u0001L\u0011\u0015)\u0006\u0001\"\u0011W\u0003!qW\u000f\u001c7bE2,W#A,\u0011\u0005yA\u0016BA- \u0005\u001d\u0011un\u001c7fC:DQa\u0017\u0001\u0005Bq\u000b!\u0002\u001d:fiRLh*Y7f+\u0005i\u0006C\u00010c\u001d\ty\u0006\r\u0005\u0002C?%\u0011\u0011mH\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b?!Aa\r\u0001EC\u0002\u0013%q-\u0001\u0006qCJ\u001cX\r\u001a)bi\",\u0012\u0001\u001b\t\u0004=%\\\u0017B\u00016 \u0005\u0019y\u0005\u000f^5p]B\u0019\u0001\t\u001c8\n\u00055T%\u0001\u0002'jgR\u0004\"!E8\n\u0005A\u0014!a\u0004)bi\"Len\u001d;sk\u000e$\u0018n\u001c8)\u0005\u0015\u0014\bC\u0001\u0010t\u0013\t!xDA\u0005ue\u0006t7/[3oi\")a\u000f\u0001C!o\u0006!QM^1m)\tA8\u0010\u0005\u0002\u001fs&\u0011!p\b\u0002\u0004\u0003:L\bb\u0002?v!\u0003\u0005\r!`\u0001\u0006S:\u0004X\u000f\u001e\t\u0003}~l\u0011\u0001B\u0005\u0004\u0003\u0003!!aC%oi\u0016\u0014h.\u00197S_^Dq!!\u0002\u0001\t\u0013\t9!A\u0005qCJ\u001cX\rU1uQR\u0019\u0001.!\u0003\t\u000f=\n\u0019\u00011\u0001\u0002\fA!\u0011QBA\u000b\u001b\t\tyAC\u0002O\u0003#Q1!a\u0005\t\u0003\u0019)hn]1gK&!\u0011qCA\b\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\b\u00037\u0001A\u0011BA\u000f\u0003)\t'O]1z\u0013:$W\r\u001f\u000b\u0007\u0003?\tY#a\u0012\u0011\ry\t\t#!\nX\u0013\r\t\u0019c\b\u0002\n\rVt7\r^5p]F\u00022AHA\u0014\u0013\r\tIc\b\u0002\u0005\u0019>tw\r\u0003\u0005\u0002.\u0005e\u0001\u0019AA\u0018\u0003\u0005\u0001\b\u0003BA\u0019\u0003\u0007j!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005G>\u0014XM\u0003\u0003\u0002:\u0005m\u0012a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003{\ty$A\u0005gCN$XM\u001d=nY*\u0011\u0011\u0011I\u0001\u0004G>l\u0017\u0002BA#\u0003g\u0011!BS:p]B\u000b'o]3s\u0011!\tI%!\u0007A\u0002\u0005-\u0013!\u00014\u0011\ty\tieV\u0005\u0004\u0003\u001fz\"!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+\nA\"\u001a<bYV\fG/\u001a)bi\"$\u0012bVA,\u00033\n\u0019'!\u001c\t\u0011\u00055\u0012\u0011\u000ba\u0001\u0003_A\u0001\"a\u0017\u0002R\u0001\u0007\u0011QL\u0001\u0002OB!\u0011\u0011GA0\u0013\u0011\t\t'a\r\u0003\u001b)\u001bxN\\$f]\u0016\u0014\u0018\r^8s\u0011!\t)'!\u0015A\u0002\u0005\u001d\u0014!B:us2,\u0007cA\t\u0002j%\u0019\u00111\u000e\u0002\u0003\u0015]\u0013\u0018\u000e^3TifdW\r\u0003\u00040\u0003#\u0002\ra\u001b\u0005\n\u0003c\u0002\u0011\u0011!C\u0001\u0003g\nAaY8qsR)Q'!\u001e\u0002x!Aq%a\u001c\u0011\u0002\u0003\u0007\u0011\u0006\u0003\u00050\u0003_\u0002\n\u00111\u0001*\u0011%\tY\bAI\u0001\n\u0003\ti(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}$fA\u0015\u0002\u0002.\u0012\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000e~\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t*a\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002~\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAM\u0001\u0005\u0005I\u0011IAN\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006L1aYAQ\u0011%\ti\u000bAA\u0001\n\u0003\ty+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00022B\u0019a$a-\n\u0007\u0005UvDA\u0002J]RD\u0011\"!/\u0001\u0003\u0003%\t!a/\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u00010!0\t\u0015\u0005}\u0016qWA\u0001\u0002\u0004\t\t,A\u0002yIEB\u0011\"a1\u0001\u0003\u0003%\t%!2\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a2\u0011\u000b\u0005%\u0017q\u001a=\u000e\u0005\u0005-'bAAg?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00171\u001a\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\u001b\u0001\u0002\u0002\u0013\u0005\u0011q[\u0001\tG\u0006tW)];bYR\u0019q+!7\t\u0013\u0005}\u00161[A\u0001\u0002\u0004A\b\"CAo\u0001\u0005\u0005I\u0011IAp\u0003\u0019)\u0017/^1mgR\u0019q+!9\t\u0013\u0005}\u00161\\A\u0001\u0002\u0004A\bf\u0003\u0001\u0002f\u0006-\u0018Q^Ay\u0003g\u00042!EAt\u0013\r\tIO\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty/\u0001\u001f`\rVs5i\u0018\u0015kg>tw\f\u001e=uY\u0001\u0002\u0018\r\u001e5*A5\u0002S\t\u001f;sC\u000e$8\u000fI1!UN|g\u000eI8cU\u0016\u001cG\u000f\t4s_6\u0004\u0003\r]1uQ\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005U\u0018!\u0012\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014\u0013M\t\u001e#E\njx\u0005\f\u0011(I9\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!E*\u0001\u0003eB\u0005\u0002z\n\t\t\u0011#\u0001\u0002|\u0006iq)\u001a;Kg>twJ\u00196fGR\u00042!EA\u007f\r!\t!!!A\t\u0002\u0005}8#BA\u007f\u0005\u0003\u0019\u0003c\u0002B\u0002\u0005\u0013I\u0013&N\u0007\u0003\u0005\u000bQ1Aa\u0002 \u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0003\u0003\u0006\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fM\ni\u0010\"\u0001\u0003\u0010Q\u0011\u00111 \u0005\u000b\u0005'\ti0!A\u0005F\tU\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0005B\u0003B\r\u0003{\f\t\u0011\"!\u0003\u001c\u0005)\u0011\r\u001d9msR)QG!\b\u0003 !1qEa\u0006A\u0002%Baa\fB\f\u0001\u0004I\u0003B\u0003B\u0012\u0003{\f\t\u0011\"!\u0003&\u00059QO\\1qa2LH\u0003\u0002B\u0014\u0005_\u0001BAH5\u0003*A)aDa\u000b*S%\u0019!QF\u0010\u0003\rQ+\b\u000f\\33\u0011%\u0011\tD!\t\u0002\u0002\u0003\u0007Q'A\u0002yIAB!B!\u000e\u0002~\u0006\u0005I\u0011\u0002B\u001c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\te\u0002\u0003BAP\u0005wIAA!\u0010\u0002\"\n1qJ\u00196fGR\u0004")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient Option<List<PathInstruction>> parsedPath;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject getJsonObject) {
        return GetJsonObject$.MODULE$.unapply(getJsonObject);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private Option<List<PathInstruction>> parsedPath$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.parsedPath = this.parsePath((UTF8String)this.path().eval(this.path().eval$default$1()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.parsedPath;
    }

    private Option<List<PathInstruction>> parsedPath() {
        return !this.bitmap$trans$0 ? this.parsedPath$lzycompute() : this.parsedPath;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Option<List<PathInstruction>> parsed;
        UTF8String jsonStr = (UTF8String)this.json().eval(input);
        if (jsonStr == null) {
            return null;
        }
        Option<List<PathInstruction>> option = parsed = this.path().foldable() ? this.parsedPath() : this.parsePath((UTF8String)this.path().eval(input));
        if (parsed.isDefined()) {
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), jsonStr), (Function1 & Serializable & scala.Serializable)parser -> {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    boolean matched = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> BoxesRunTime.boxToBoolean((boolean)GetJsonObject.$anonfun$eval$4(this, parsed, parser, generator))));
                    return matched ? UTF8String.fromBytes((byte[])output.toByteArray()) : null;
                });
            }
            catch (JsonProcessingException jsonProcessingException) {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private Option<List<PathInstruction>> parsePath(UTF8String path) {
        return path != null ? JsonPathParser$.MODULE$.parse(path.toString()) : None$.MODULE$;
    }

    private Function1<Object, Object> arrayIndex(JsonParser p, Function0<Object> f) {
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x0$1 -> {
            boolean bl;
            long l = x0$1;
            JsonToken jsonToken = p.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                bl = false;
            } else if (0L == l) {
                boolean dirty = f.apply$mcZ$sp();
                while (true) {
                    JsonToken jsonToken3 = p.nextToken();
                    JsonToken jsonToken4 = JsonToken.END_ARRAY;
                    if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
                    p.skipChildren();
                }
                bl = dirty;
            } else if (l > 0L) {
                p.skipChildren();
                p.nextToken();
                bl = this.arrayIndex(p, f).apply$mcZJ$sp(l - 1L);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            return bl;
        };
    }

    private boolean evaluatePath(JsonParser p, JsonGenerator g, WriteStyle style, List<PathInstruction> path) {
        boolean bl;
        block56: {
            while (true) {
                List list;
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)p.getCurrentToken(), path)) != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list2 = (List)tuple2._2();
                    if (JsonToken.VALUE_STRING.equals(jsonToken) && Nil$.MODULE$.equals(list2)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$RawStyle$ writeStyle$RawStyle$ = WriteStyle$RawStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$RawStyle$) : writeStyle$RawStyle$ != null)) {
                            if (p.hasTextCharacters()) {
                                g.writeRaw(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                            } else {
                                g.writeRaw(p.getText());
                            }
                            bl = true;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list3 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && Nil$.MODULE$.equals(list3)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$FlattenStyle$ writeStyle$FlattenStyle$ = WriteStyle$FlattenStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$FlattenStyle$) : writeStyle$FlattenStyle$ != null)) {
                            boolean dirty = false;
                            while (true) {
                                JsonToken jsonToken2 = p.nextToken();
                                JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                if (!(jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3))) break;
                                dirty |= this.evaluatePath(p, g, style, (List<PathInstruction>)Nil$.MODULE$);
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null && Nil$.MODULE$.equals(list = (List)tuple2._2())) {
                    g.copyCurrentStructure(p);
                    bl = true;
                    break block56;
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list4 = (List)tuple2._2();
                    if (JsonToken.START_OBJECT.equals(jsonToken) && list4 instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list4;
                        PathInstruction pathInstruction = (PathInstruction)colon2.head();
                        List xs = colon2.tl$access$1();
                        if (PathInstruction$Key$.MODULE$.equals(pathInstruction)) {
                            boolean dirty = false;
                            while (true) {
                                JsonParser jsonParser;
                                JsonToken jsonToken4 = p.nextToken();
                                JsonToken jsonToken5 = JsonToken.END_OBJECT;
                                if (!(jsonToken4 == null ? jsonToken5 != null : !jsonToken4.equals(jsonToken5))) break;
                                if (dirty) {
                                    jsonParser = p.skipChildren();
                                    continue;
                                }
                                dirty = this.evaluatePath(p, g, style, (List<PathInstruction>)xs);
                                jsonParser = BoxedUnit.UNIT;
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list5 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list5 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list5;
                        PathInstruction pathInstruction = (PathInstruction)colon3.head();
                        List list6 = colon3.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list6 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list6;
                            PathInstruction pathInstruction2 = (PathInstruction)colon4.head();
                            List list7 = colon4.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction2) && list7 instanceof .colon.colon) {
                                .colon.colon colon5 = (.colon.colon)list7;
                                PathInstruction pathInstruction3 = (PathInstruction)colon5.head();
                                List list8 = colon5.tl$access$1();
                                if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction3) && list8 instanceof .colon.colon) {
                                    .colon.colon colon6 = (.colon.colon)list8;
                                    PathInstruction pathInstruction4 = (PathInstruction)colon6.head();
                                    List xs = colon6.tl$access$1();
                                    if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction4)) {
                                        boolean dirty = false;
                                        g.writeStartArray();
                                        while (true) {
                                            JsonToken jsonToken6 = p.nextToken();
                                            JsonToken jsonToken7 = JsonToken.END_ARRAY;
                                            if (!(jsonToken6 == null ? jsonToken7 != null : !jsonToken6.equals(jsonToken7))) break;
                                            dirty |= this.evaluatePath(p, g, WriteStyle$FlattenStyle$.MODULE$, (List<PathInstruction>)xs);
                                        }
                                        g.writeEndArray();
                                        bl = dirty;
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list9 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list9 instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list9;
                        PathInstruction pathInstruction = (PathInstruction)colon7.head();
                        List list10 = colon7.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list10 instanceof .colon.colon) {
                            .colon.colon colon8 = (.colon.colon)list10;
                            PathInstruction pathInstruction5 = (PathInstruction)colon8.head();
                            List xs = colon8.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction5)) {
                                WriteStyle writeStyle = style;
                                WriteStyle$QuotedStyle$ writeStyle$QuotedStyle$ = WriteStyle$QuotedStyle$.MODULE$;
                                if (writeStyle == null ? writeStyle$QuotedStyle$ != null : !writeStyle.equals(writeStyle$QuotedStyle$)) {
                                    WriteStyle writeStyle2;
                                    WriteStyle writeStyle3 = style;
                                    if (WriteStyle$RawStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$QuotedStyle$.MODULE$;
                                    } else if (WriteStyle$FlattenStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$FlattenStyle$.MODULE$;
                                    } else {
                                        if (WriteStyle$QuotedStyle$.MODULE$.equals(writeStyle3)) {
                                            throw new IllegalStateException();
                                        }
                                        throw new MatchError((Object)writeStyle3);
                                    }
                                    WriteStyle$QuotedStyle$ nextStyle = writeStyle2;
                                    StringWriter buffer = new StringWriter();
                                    IntRef dirty = IntRef.create((int)0);
                                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((Writer)buffer), (Function1 & Serializable & scala.Serializable)flattenGenerator -> {
                                        GetJsonObject.$anonfun$evaluatePath$2(this, p, xs, nextStyle, dirty, flattenGenerator);
                                        return BoxedUnit.UNIT;
                                    });
                                    StringBuffer buf = buffer.getBuffer();
                                    if (dirty.elem > 1) {
                                        g.writeRawValue(buf.toString());
                                    } else if (dirty.elem == 1) {
                                        g.writeRawValue(buf.substring(1, buf.length() - 1));
                                    }
                                    bl = dirty.elem > 0;
                                    break block56;
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list11 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list11 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list11;
                        PathInstruction pathInstruction = (PathInstruction)colon9.head();
                        List list12 = colon9.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list12 instanceof .colon.colon) {
                            .colon.colon colon10 = (.colon.colon)list12;
                            PathInstruction pathInstruction6 = (PathInstruction)colon10.head();
                            List xs = colon10.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction6)) {
                                boolean dirty = false;
                                g.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken8 = p.nextToken();
                                    JsonToken jsonToken9 = JsonToken.END_ARRAY;
                                    if (!(jsonToken8 == null ? jsonToken9 != null : !jsonToken8.equals(jsonToken9))) break;
                                    dirty |= this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)xs);
                                }
                                g.writeEndArray();
                                bl = dirty;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list13 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list13 instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list13;
                        PathInstruction pathInstruction = (PathInstruction)colon11.head();
                        List list14 = colon11.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list14 instanceof .colon.colon) {
                            .colon.colon colon12 = (.colon.colon)list14;
                            PathInstruction pathInstruction7 = (PathInstruction)colon12.head();
                            List xs = colon12.tl$access$1();
                            if (pathInstruction7 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction7;
                                long idx = index.index();
                                if (xs instanceof .colon.colon) {
                                    .colon.colon colon13;
                                    PathInstruction pathInstruction8;
                                    .colon.colon colon14 = (.colon.colon)xs;
                                    PathInstruction pathInstruction9 = (PathInstruction)colon14.head();
                                    List list15 = colon14.tl$access$1();
                                    if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction9) && list15 instanceof .colon.colon && PathInstruction$Wildcard$.MODULE$.equals(pathInstruction8 = (PathInstruction)(colon13 = (.colon.colon)list15).head())) {
                                        p.nextToken();
                                        bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)colon14)).apply$mcZJ$sp(idx);
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list16 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list16 instanceof .colon.colon) {
                        .colon.colon colon15 = (.colon.colon)list16;
                        PathInstruction pathInstruction = (PathInstruction)colon15.head();
                        List list17 = colon15.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list17 instanceof .colon.colon) {
                            .colon.colon colon16 = (.colon.colon)list17;
                            PathInstruction pathInstruction10 = (PathInstruction)colon16.head();
                            List xs = colon16.tl$access$1();
                            if (pathInstruction10 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction10;
                                long idx = index.index();
                                p.nextToken();
                                bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, style, (List<PathInstruction>)xs)).apply$mcZJ$sp(idx);
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list18 = (List)tuple2._2();
                    if (JsonToken.FIELD_NAME.equals(jsonToken) && list18 instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list18;
                        PathInstruction pathInstruction = (PathInstruction)colon17.head();
                        List xs = colon17.tl$access$1();
                        if (pathInstruction instanceof PathInstruction.Named) {
                            PathInstruction.Named named = (PathInstruction.Named)pathInstruction;
                            String name = named.name();
                            String string = p.getCurrentName();
                            String string2 = name;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JsonToken jsonToken10 = p.nextToken();
                                JsonToken jsonToken11 = JsonToken.VALUE_NULL;
                                if (jsonToken10 == null ? jsonToken11 != null : !jsonToken10.equals(jsonToken11)) {
                                    path = xs;
                                    continue;
                                }
                                bl = false;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 == null) break;
                JsonToken jsonToken = (JsonToken)tuple2._1();
                List list19 = (List)tuple2._2();
                if (!JsonToken.FIELD_NAME.equals(jsonToken) || !(list19 instanceof .colon.colon)) break;
                .colon.colon colon18 = (.colon.colon)list19;
                PathInstruction pathInstruction = (PathInstruction)colon18.head();
                List xs = colon18.tl$access$1();
                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction)) break;
                p.nextToken();
                path = xs;
            }
            p.skipChildren();
            bl = false;
        }
        return bl;
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.json();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(GetJsonObject $this, Option parsed$1, JsonParser parser$2, JsonGenerator generator) {
        parser$2.nextToken();
        return $this.evaluatePath(parser$2, generator, WriteStyle$RawStyle$.MODULE$, (List<PathInstruction>)((List)parsed$1.get()));
    }

    public static final /* synthetic */ void $anonfun$evaluatePath$2(GetJsonObject $this, JsonParser p$1, List xs$1, Product nextStyle$1, IntRef dirty$1, JsonGenerator flattenGenerator) {
        flattenGenerator.writeStartArray();
        while (true) {
            JsonToken jsonToken = p$1.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            dirty$1.elem = dirty$1.elem + ($this.evaluatePath(p$1, flattenGenerator, (WriteStyle)nextStyle$1, (List<PathInstruction>)xs$1) ? 1 : 0);
        }
        flattenGenerator.writeEndArray();
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

