/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(unix_time, format) - Returns `unix_time` in the specified `format`.", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1970-01-01 00:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u0001>\u0011AB\u0012:p[Vs\u0017\u000e\u001f+j[\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0007\u0001A!rC\u0007\u0011\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#aI!!\u0007\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005\u00191/Z2\u0016\u0003\u0019\u0002\"!E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]\"A!\u0006\u0001B\tB\u0003%a%\u0001\u0003tK\u000e\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011A\u0013\u0002\r\u0019|'/\\1u\u0011!q\u0003A!E!\u0002\u00131\u0013a\u00024pe6\fG\u000f\t\u0005\ta\u0001\u0011)\u001a!C\u0001c\u0005QA/[7f5>tW-\u00133\u0016\u0003I\u00022aG\u001a6\u0013\t!DD\u0001\u0004PaRLwN\u001c\t\u0003mur!aN\u001e\u0011\u0005abR\"A\u001d\u000b\u0005ir\u0011A\u0002\u001fs_>$h(\u0003\u0002=9\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\taD\u0004\u0003\u0005B\u0001\tE\t\u0015!\u00033\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\rqJg.\u001b;?)\u0011)ei\u0012%\u0011\u0005E\u0001\u0001\"\u0002\u0013C\u0001\u00041\u0003\"\u0002\u0017C\u0001\u00041\u0003b\u0002\u0019C!\u0003\u0005\rA\r\u0005\u0006\u0007\u0002!\tA\u0013\u000b\u0004\u000b.c\u0005\"\u0002\u0013J\u0001\u00041\u0003\"\u0002\u0017J\u0001\u00041\u0003\"\u0002(\u0001\t\u0003*\u0013\u0001\u00027fMRDQ\u0001\u0015\u0001\u0005B\u0015\nQA]5hQRDQA\u0015\u0001\u0005BM\u000b!\u0002\u001d:fiRLh*Y7f+\u0005)\u0004\"B\"\u0001\t\u0003)FCA#W\u0011\u00159F\u000b1\u0001'\u0003\u0011)h.\u001b=\t\u000be\u0003A\u0011\t.\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u001a\tQ\u0001^=qKNL!\u0001Y/\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQA\u0019\u0001\u0005B\r\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002IB\u00111$Z\u0005\u0003Mr\u0011qAQ8pY\u0016\fg\u000eC\u0003i\u0001\u0011\u0005\u0013.\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001b\t\u0004WB\u001chB\u00017o\u001d\tAT.C\u0001\u001e\u0013\tyG$A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0014(aA*fc*\u0011q\u000e\b\t\u00039RL!!^/\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B<\u0001\t\u0003B\u0018\u0001D<ji\"$\u0016.\\3[_:,GC\u0001\u000bz\u0011\u0015\u0001d\u000f1\u00016\u0011!Y\b\u0001#b\u0001\n\u0013a\u0018aC2p]N$hi\u001c:nCR,\u0012! \t\u0004}\u0006\u0015Q\"A@\u000b\u0007y\u000b\tAC\u0002\u0002\u0004!\ta!\u001e8tC\u001a,\u0017bAA\u0004\u007f\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\t\u0015\u0005-\u0001\u0001#b\u0001\n\u0013\ti!A\u0005g_Jl\u0017\r\u001e;feV\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011!X\r\u001f;\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\tQA)\u0019;f\r>\u0014X.\u0019;\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u0005!QM^1m)\u0011\t)#a\u000b\u0011\u0007m\t9#C\u0002\u0002*q\u00111!\u00118z\u0011)\ti#a\b\u0011\u0002\u0003\u0007\u0011qF\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003c\t\u0019$D\u0001\u0005\u0013\r\t)\u0004\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002:\u0001!\t%a\u000f\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001f\u0003\u0013\n\u0019\u0006\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019EA\u0001\bG>$WmZ3o\u0013\u0011\t9%!\u0011\u0003\u0011\u0015C\bO]\"pI\u0016D\u0001\"a\u0013\u00028\u0001\u0007\u0011QJ\u0001\u0004GRD\b\u0003BA \u0003\u001fJA!!\u0015\u0002B\tq1i\u001c3fO\u0016t7i\u001c8uKb$\b\u0002CA+\u0003o\u0001\r!!\u0010\u0002\u0005\u00154\b\"CA-\u0001\u0005\u0005I\u0011AA.\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0015\u000bi&a\u0018\u0002b!AA%a\u0016\u0011\u0002\u0003\u0007a\u0005\u0003\u0005-\u0003/\u0002\n\u00111\u0001'\u0011!\u0001\u0014q\u000bI\u0001\u0002\u0004\u0011\u0004\"CA3\u0001E\u0005I\u0011AA4\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001b+\u0007\u0019\nYg\u000b\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\r\t9\bH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\bAI\u0001\n\u0003\t9'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fS3AMA6\u0011%\tY\tAA\u0001\n\u0003\ni)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9\"\u0001\u0003mC:<\u0017b\u0001 \u0002\u0014\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011QT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003?\u00032aGAQ\u0013\r\t\u0019\u000b\b\u0002\u0004\u0013:$\b\"CAT\u0001\u0005\u0005I\u0011AAU\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\n\u0002,\"Q\u0011QVAS\u0003\u0003\u0005\r!a(\u0002\u0007a$\u0013\u0007C\u0005\u00022\u0002\t\t\u0011\"\u0011\u00024\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026B1\u0011qWA_\u0003Ki!!!/\u000b\u0007\u0005mF$\u0001\u0006d_2dWm\u0019;j_:LA!a0\u0002:\nA\u0011\n^3sCR|'\u000fC\u0005\u0002D\u0002\t\t\u0011\"\u0001\u0002F\u0006A1-\u00198FcV\fG\u000eF\u0002e\u0003\u000fD!\"!,\u0002B\u0006\u0005\t\u0019AA\u0013\u0011%\tY\rAA\u0001\n\u0003\ni-\u0001\u0004fcV\fGn\u001d\u000b\u0004I\u0006=\u0007BCAW\u0003\u0013\f\t\u00111\u0001\u0002&!z\u0001!a5\u0002Z\u0006m\u0017q\\Aq\u0003K\f9\u000fE\u0002\u0012\u0003+L1!a6\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!8\u0002\u0015~3UKT\"`QUt\u0017\u000e_0uS6,G\u0006\t4pe6\fG/\u000b\u0011.AI+G/\u001e:og\u0002\u0002WO\\5y?RLW.\u001a1!S:\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004\u0003MZ8s[\u0006$\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111]\u0001^\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002D\u0006I\u0014zsfLX&T'.I\u0012\u0004\u0003\n\u0013\u001en[j\u001a8oJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEJt\u0007M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!;\u0002\u000bErSG\f\u0019\b\u0013\u00055(!!A\t\u0002\u0005=\u0018\u0001\u0004$s_6,f.\u001b=US6,\u0007cA\t\u0002r\u001aA\u0011AAA\u0001\u0012\u0003\t\u0019pE\u0003\u0002r\u0006U\b\u0005\u0005\u0005\u0002x\u0006uhE\n\u001aF\u001b\t\tIPC\u0002\u0002|r\tqA];oi&lW-\u0003\u0003\u0002\u0000\u0006e(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!91)!=\u0005\u0002\t\rACAAx\u0011)\u00119!!=\u0002\u0002\u0013\u0015#\u0011B\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0012\u0005\u000b\u0005\u001b\t\t0!A\u0005\u0002\n=\u0011!B1qa2LHcB#\u0003\u0012\tM!Q\u0003\u0005\u0007I\t-\u0001\u0019\u0001\u0014\t\r1\u0012Y\u00011\u0001'\u0011!\u0001$1\u0002I\u0001\u0002\u0004\u0011\u0004B\u0003B\r\u0003c\f\t\u0011\"!\u0003\u001c\u00059QO\\1qa2LH\u0003\u0002B\u000f\u0005K\u0001BaG\u001a\u0003 A11D!\t'MIJ1Aa\t\u001d\u0005\u0019!V\u000f\u001d7fg!I!q\u0005B\f\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\u0002\u0004B\u0003B\u0016\u0003c\f\n\u0011\"\u0001\u0002\u0006\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!Ba\f\u0002rF\u0005I\u0011AAC\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003B\u001a\u0003c\f\t\u0011\"\u0003\u00036\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0004\u0005\u0003\u0002\u0012\ne\u0012\u0002\u0002B\u001e\u0003'\u0013aa\u00142kK\u000e$\b")
public class FromUnixTime
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private UTF8String constFormat;
    private DateFormat formatter;
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$21 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$22 = this.copy$default$1();
        Expression x$23 = this.copy$default$2();
        return this.copy(x$22, x$23, (Option<String>)x$21);
    }

    private UTF8String constFormat$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Expression qual$2 = this.right();
                InternalRow x$24 = qual$2.eval$default$1();
                this.constFormat = (UTF8String)qual$2.eval(x$24);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.constFormat;
    }

    private UTF8String constFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.constFormat$lzycompute() : this.constFormat;
    }

    private DateFormat formatter$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.formatter = this.liftedTree2$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.formatter;
    }

    private DateFormat formatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object time = this.left().eval(input);
        if (time == null) {
            uTF8String = null;
        } else if (this.format().foldable()) {
            if (this.constFormat() == null || this.formatter() == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)this.formatter().format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var3_6 = null;
                    uTF8String = var3_6;
                }
            }
        } else {
            Object f = this.format().eval(input);
            if (f == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)DateTimeUtils$.MODULE$.newDateFormat(f.toString(), this.timeZone()).format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var2_11 = null;
                    uTF8String = var2_11;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String df = DateFormat.class.getName();
        if (this.format().foldable()) {
            if (this.formatter() == null) {
                exprCode = ExprCode$.MODULE$.forNullValue(StringType$.MODULE$);
            } else {
                String formatterName = ctx.addReferenceObj("formatter", this.formatter(), df);
                ExprCode t = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            try {\n              ", " = UTF8String.fromString(", ".format(\n                new java.util.Date(", " * 1000L)));\n            } catch (java.lang.IllegalArgumentException e) {\n              ", " = true;\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.code(), ev.isNull(), t.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), formatterName, t.value(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
            String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, f) -> new StringBuilder(217).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(dtu).append(".newDateFormat(").append((String)f).append(".toString(), ").append(tz).append(").format(\n            new java.util.Date(").append((String)seconds).append(" * 1000L)));\n        } catch (java.lang.IllegalArgumentException e) {\n          ").append(ev.isNull()).append(" = true;\n        }").toString());
        }
        return exprCode;
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.sec();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    private final DateFormat liftedTree2$1() {
        DateFormat dateFormat;
        try {
            dateFormat = DateTimeUtils$.MODULE$.newDateFormat(this.constFormat().toString(), this.timeZone());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var1_4 = null;
            dateFormat = var1_4;
        }
        return dateFormat;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }
}

