/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, timezone) - Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a time in UTC, and renders that time as a timestamp in the given time zone. For example, 'GMT+1' would yield '2017-07-14 03:40:00.0'.", examples="\n    Examples:\n      > SELECT from_utc_timestamp('2016-08-31', 'Asia/Seoul');\n       2016-08-31 09:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011\u0001C\u0012:p[V#6\tV5nKN$\u0018-\u001c9\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\t1,g\r^\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013!\u00027fMR\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000bILw\r\u001b;\t\u0011-\u0002!\u0011#Q\u0001\n\r\naA]5hQR\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"!\u0005\u0001\t\u000b\u0005b\u0003\u0019A\u0012\t\u000b%b\u0003\u0019A\u0012\t\u000bM\u0002A\u0011\t\u001b\u0002\u0015%t\u0007/\u001e;UsB,7/F\u00016!\r1d(\u0011\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA\u001f\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0010!\u0003\u0007M+\u0017O\u0003\u0002>3A\u0011!)R\u0007\u0002\u0007*\u0011AIB\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b!\u0003A\u0011I%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0013\t\u0003\u0005.K!\u0001T\"\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQA\u0014\u0001\u0005B=\u000b!\u0002\u001d:fiRLh*Y7f+\u0005\u0001\u0006CA)V\u001d\t\u00116\u000b\u0005\u000293%\u0011A+G\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U3!)\u0011\f\u0001C!5\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191L\u00181\u0011\u0005aa\u0016BA/\u001a\u0005\r\te.\u001f\u0005\u0006?b\u0003\raW\u0001\u0005i&lW\rC\u0003b1\u0002\u00071,\u0001\u0005uS6,'p\u001c8f\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003%!wnR3o\u0007>$W\rF\u0002fWB\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0002\u0002\u000f\r|G-Z4f]&\u0011!n\u001a\u0002\t\u000bb\u0004(oQ8eK\")AN\u0019a\u0001[\u0006\u00191\r\u001e=\u0011\u0005\u0019t\u0017BA8h\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!\u001d2A\u0002\u0015\f!!\u001a<\t\u000fM\u0004\u0011\u0011!C\u0001i\u0006!1m\u001c9z)\rySO\u001e\u0005\bCI\u0004\n\u00111\u0001$\u0011\u001dI#\u000f%AA\u0002\rBq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u00110\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#aI>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\f\u0001\t\n\u0011\"\u0001z\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a\u0004\u0001\u0003\u0003%\t%!\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&\u0019a+a\u0006\t\u0013\u0005\r\u0002!!A\u0005\u0002\u0005\u0015\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0014!\rA\u0012\u0011F\u0005\u0004\u0003WI\"aA%oi\"I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011G\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rY\u00161\u0007\u0005\u000b\u0003k\ti#!AA\u0002\u0005\u001d\u0012a\u0001=%c!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\b\t\u0006\u0003\u007f\t)eW\u0007\u0003\u0003\u0003R1!a\u0011\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0005AA\u0001\n\u0003\ti%\u0001\u0005dC:,\u0015/^1m)\u0011\ty%!\u0016\u0011\u0007a\t\t&C\u0002\u0002Te\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00026\u0005%\u0013\u0011!a\u00017\"I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131L\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0013Q\f\u0005\n\u0003k\t9&!AA\u0002mCs\u0002AA1\u0003O\nI'!\u001c\u0002p\u0005M\u0014Q\u000f\t\u0004#\u0005\r\u0014bAA3\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA6\u0003\u0005%wLR+O\u0007~CC/[7fgR\fW\u000e\u001d\u0017!i&lWM_8oK&\u0002S\u0006I$jm\u0016t\u0007%\u0019\u0011uS6,7\u000f^1na\u0002b\u0017n[3!OI\u0002\u0014gN\u00171o5\nD\u0007\t\u00193uQ\u0002$\b\r\u0019/a\u001db\u0003%\u001b8uKJ\u0004(/\u001a;tA%$\b%Y:!C\u0002\"\u0018.\\3!S:\u0004S\u000bV\"-A\u0005tG\r\t:f]\u0012,'o\u001d\u0011uQ\u0006$\b\u0005^5nK\u0002\n7\u000fI1!i&lWm\u001d;b[B\u0004\u0013N\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3!u>tWM\f\u0011G_J\u0004S\r_1na2,G\u0006I\u0014H\u001bR[\u0013g\n\u0011x_VdG\rI=jK2$\u0007e\n\u001a1c]j\u0003gN\u00172i\u0001\u00024G\u000f\u001b1uA\u0002d\u0006M\u0014/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA9\u0003-T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\u001a:p[~+HoY0uS6,7\u000f^1na\":#\u0007M\u00197[ABTfM\u0019(Y\u0001:\u0013i]5b_M+w.\u001e7(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[ABTfM\u0019!aeR\u0004\u0007\r\u001e1a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002x\u0005)\u0011GL\u001b/a\u001dI\u00111\u0010\u0002\u0002\u0002#\u0005\u0011QP\u0001\u0011\rJ|W.\u0016+D)&lWm\u001d;b[B\u00042!EA@\r!\t!!!A\t\u0002\u0005\u00055#BA@\u0003\u0007k\u0002cBAC\u0003\u0017\u001b3eL\u0007\u0003\u0003\u000fS1!!#\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!!$\u0002\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f5\ny\b\"\u0001\u0002\u0012R\u0011\u0011Q\u0010\u0005\u000b\u0003+\u000by(!A\u0005F\u0005]\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0001BCAN\u0003\u007f\n\t\u0011\"!\u0002\u001e\u0006)\u0011\r\u001d9msR)q&a(\u0002\"\"1\u0011%!'A\u0002\rBa!KAM\u0001\u0004\u0019\u0003BCAS\u0003\u007f\n\t\u0011\"!\u0002(\u00069QO\\1qa2LH\u0003BAU\u0003k\u0003R\u0001GAV\u0003_K1!!,\u001a\u0005\u0019y\u0005\u000f^5p]B)\u0001$!-$G%\u0019\u00111W\r\u0003\rQ+\b\u000f\\33\u0011%\t9,a)\u0002\u0002\u0003\u0007q&A\u0002yIAB!\"a/\u0002\u0000\u0005\u0005I\u0011BA_\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0006\u0003BA\u000b\u0003\u0003LA!a1\u0002\u0018\t1qJ\u00196fGR\u0004")
public class FromUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FromUTCTimestamp fromUTCTimestamp) {
        return FromUTCTimestamp$.MODULE$.unapply(fromUTCTimestamp);
    }

    public static Function1<Tuple2<Expression, Expression>, FromUTCTimestamp> tupled() {
        return FromUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FromUTCTimestamp>> curried() {
        return FromUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "from_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            UTF8String tz = (UTF8String)this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzClass = TimeZone.class.getName();
                String dtu2 = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String escapedTz = StringEscapeUtils.escapeJava((String)tz.toString());
                String tzTerm = ctx.addMutableState(tzClass, "tz", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(20).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"").append(escapedTz).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String utcTerm = "tzUTC";
                ctx.addImmutableStateIfNotExists(tzClass, utcTerm, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(23).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"UTC\");").toString());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), ev.value(), ev.isNull(), ev.value(), dtu2, eval.value(), utcTerm, tzTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(27).append(dtu).append(".fromUTCTime(").append((String)timestamp).append(", ").append((String)format).append(".toString())").toString());
        }
        return exprCode;
    }

    public FromUTCTimestamp copy(Expression left, Expression right) {
        return new FromUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FromUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUTCTimestamp fromUTCTimestamp = (FromUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = fromUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = fromUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!fromUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public FromUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

