/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$NullOrder$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array) - Sorts the input array in ascending order. The elements of the input array must\n      be orderable. Null elements will be placed at the end of the returned array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u0011:sCf\u001cvN\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!!D!se\u0006L8k\u001c:u\u0019&\\W\r\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013!B2iS2$W#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u000511\r[5mI\u0002BQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDCA\u0016-!\t\t\u0002\u0001C\u0003\"Q\u0001\u00071\u0005C\u0003/\u0001\u0011\u0005s&\u0001\u0005eCR\fG+\u001f9f+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t)$G\u0001\u0005ECR\fG+\u001f9f\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"!\r$\n\u0005\u001d\u0013$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015I\u0005\u0001\"\u0011#\u0003=\t'O]1z\u000bb\u0004(/Z:tS>t\u0007\"B&\u0001\t\u0003b\u0015!\u00038vY2|%\u000fZ3s+\u0005i\u0005C\u0001(^\u001d\ty5L\u0004\u0002Q5:\u0011\u0011+\u0017\b\u0003%bs!aU,\u000f\u0005Q3fB\u0001\u001fV\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u0018\u0002\u0002\u001b\u0005\u0013(/Y=T_J$H*[6f\u0013\tqvLA\u0005Ok2dwJ\u001d3fe*\u0011AL\u0001\u0005\u0006C\u0002!\tEY\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a\rB\u0001\tC:\fG._:jg&\u0011\u0001.\u001a\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\")!\u000e\u0001C!W\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011An\u001c\t\u000315L!A\\\r\u0003\u0007\u0005s\u0017\u0010C\u0003qS\u0002\u0007A.A\u0003beJ\f\u0017\u0010C\u0003s\u0001\u0011\u00053/A\u0005e_\u001e+gnQ8eKR\u0019AO_@\u0011\u0005UDX\"\u0001<\u000b\u0005]\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003sZ\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006wF\u0004\r\u0001`\u0001\u0004GRD\bCA;~\u0013\tqhO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u0005\u0011\u000f1\u0001u\u0003\t)g\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\nA!\u00111BA\n\u001d\u0011\ti!a\u0004\u0011\u0005qJ\u0012bAA\t3\u00051\u0001K]3eK\u001aLA!!\u0006\u0002\u0018\t11\u000b\u001e:j]\u001eT1!!\u0005\u001a\u0011%\tY\u0002AA\u0001\n\u0003\ti\"\u0001\u0003d_BLHcA\u0016\u0002 !A\u0011%!\u0007\u0011\u0002\u0003\u00071\u0005C\u0005\u0002$\u0001\t\n\u0011\"\u0001\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0014U\r\u0019\u0013\u0011F\u0016\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u0011QG\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0005=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013qH\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005Y\u0006twM\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\u0011\t)\"!\u0012\t\u0013\u0005E\u0003!!A\u0005\u0002\u0005M\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\rA\u0012qK\u0005\u0004\u00033J\"aA%oi\"I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011qL\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ra\u0017\u0011\r\u0005\u000b\u0003G\nY&!AA\u0002\u0005U\u0013a\u0001=%c!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011N\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000e\t\u0006\u0003[\n\u0019\b\\\u0007\u0003\u0003_R1!!\u001d\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\nyG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI\bAA\u0001\n\u0003\tY(\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007a\ty(C\u0002\u0002\u0002f\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002d\u0005]\u0014\u0011!a\u0001Y\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011R\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u00141\u0012\u0005\n\u0003G\n))!AA\u00021Ds\u0002AAH\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161\u0015\t\u0004#\u0005E\u0015bAAJ\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAM\u0003\u0005M$\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=*A5\u00023k\u001c:ug\u0002\"\b.\u001a\u0011j]B,H\u000fI1se\u0006L\b%\u001b8!CN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe:\u0002C\u000b[3!K2,W.\u001a8ug\u0002zg\r\t;iK\u0002Jg\u000e];uA\u0005\u0014(/Y=![V\u001cHO\u0003\u0011!A\u0001\u0002\u0003EY3!_J$WM]1cY\u0016t\u0003ET;mY\u0002*G.Z7f]R\u001c\be^5mY\u0002\u0012W\r\t9mC\u000e,G\rI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\u0012X\r^;s]\u0016$\u0007%\u0019:sCft#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a(\u0002O*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006\t8vY2d\u0003eJ2(Y\u0001:\u0013mJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&%\u0019\u0012-E\t\u0014CFI2#Y\t\"'\u0005\f8vY2l&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0016!\u0002\u001a/i9\u0002t!CAU\u0005\u0005\u0005\t\u0012AAV\u0003%\t%O]1z'>\u0014H\u000fE\u0002\u0012\u0003[3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qV\n\u0006\u0003[\u000b\t,\b\t\u0007\u0003g\u000bIlI\u0016\u000e\u0005\u0005U&bAA\\3\u00059!/\u001e8uS6,\u0017\u0002BA^\u0003k\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u001dI\u0013Q\u0016C\u0001\u0003\u007f#\"!a+\t\u0015\u0005\r\u0017QVA\u0001\n\u000b\n)-\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0005\u0003\u0006\u0002J\u00065\u0016\u0011!CA\u0003\u0017\fQ!\u00199qYf$2aKAg\u0011\u0019\t\u0013q\u0019a\u0001G!Q\u0011\u0011[AW\u0003\u0003%\t)a5\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q[An!\u0011A\u0012q[\u0012\n\u0007\u0005e\u0017D\u0001\u0004PaRLwN\u001c\u0005\n\u0003;\fy-!AA\u0002-\n1\u0001\u001f\u00131\u0011)\t\t/!,\u0002\u0002\u0013%\u00111]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002fB!\u00111IAt\u0013\u0011\tI/!\u0012\u0003\r=\u0013'.Z2u\u0001")
public class ArraySort
extends UnaryExpression
implements ArraySortLike,
scala.Serializable {
    private final Expression child;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArraySort, A> function1) {
        return ArraySort$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArraySort> compose(Function1<A, Expression> function1) {
        return ArraySort$.MODULE$.compose(function1);
    }

    @Override
    public boolean containsNull() {
        return ArraySortLike.containsNull$(this);
    }

    @Override
    public Object sortEval(Object array, boolean ascending) {
        return ArraySortLike.sortEval$(this, array, ascending);
    }

    @Override
    public String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        return ArraySortLike.sortCodegen$(this, ctx, ev, base, order);
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ArraySortLike.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public Expression arrayExpression() {
        return this.child();
    }

    @Override
    public int nullOrder() {
        return ArraySortLike$NullOrder$.MODULE$.Greatest();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_8;
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.child().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var1_8;
            }
        }
        if (bl) {
            DataType dt = arrayType.elementType();
            String dtSimple = dt.catalogString();
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(63).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not orderable").toString());
            return var1_8;
        }
        TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
        return var1_8;
    }

    @Override
    public Object nullSafeEval(Object array) {
        return this.sortEval(array, true);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.sortCodegen(ctx, ev, (String)c, "true"));
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    public ArraySort copy(Expression child) {
        return new ArraySort(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.child();
        Expression expression2 = arraySort.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        ArraySortLike.$init$(this);
    }
}

