/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayRepeat$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(element, count) - Returns the array containing element count times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       [\"123\",\"123\"]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001>\u00111\"\u0011:sCf\u0014V\r]3bi*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00027fMR,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015aWM\u001a;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013!\u0002:jO\"$\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\rILw\r\u001b;!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\"\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0004\u0002\u000bQL\b/Z:\n\u0005i:$!C!se\u0006LH+\u001f9f\u0011\u0015a\u0004\u0001\"\u0011>\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002}A\u0019qh\u0012&\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002G3\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rf\u0001\"AN&\n\u00051;$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015q\u0005\u0001\"\u0011P\u0003!qW\u000f\u001c7bE2,W#\u0001)\u0011\u0005a\t\u0016B\u0001*\u001a\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0016\u0001\u0005BU\u000bA!\u001a<bYR\u0011a+\u0017\t\u00031]K!\u0001W\r\u0003\u0007\u0005s\u0017\u0010C\u0004['B\u0005\t\u0019A.\u0002\u000b%t\u0007/\u001e;\u0011\u0005qkV\"\u0001\u0003\n\u0005y#!aC%oi\u0016\u0014h.\u00197S_^DQ\u0001\u0019\u0001\u0005B\u0005\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0011\u0007CA2h\u001d\t!W\r\u0005\u0002B3%\u0011a-G\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g3!)1\u000e\u0001C!Y\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004[ND\bC\u00018r\u001b\u0005y'B\u00019\u0003\u0003\u001d\u0019w\u000eZ3hK:L!A]8\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001\u001e6A\u0002U\f1a\u0019;y!\tqg/\u0003\u0002x_\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B=k\u0001\u0004i\u0017AA3w\u0011\u0015Y\b\u0001\"\u0003}\u0003YqW\u000f\u001c7FY\u0016lWM\u001c;t!J|G/Z2uS>tG#\u00022~}\u0006\u0005\u0001\"B={\u0001\u0004i\u0007\"B@{\u0001\u0004\u0011\u0017a\u0003:jO\"$\u0018j\u001d(vY2Da!a\u0001{\u0001\u0004\u0011\u0017!C2pe\u0016dunZ5d\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\t!dZ3o\u0007>$WMR8s\u001dVl'-\u001a:PM\u0016cW-\\3oiN$b!a\u0003\u0002\u0012\u0005M\u0001#\u0002\r\u0002\u000e\t\u0014\u0017bAA\b3\t1A+\u001e9mKJBa\u0001^A\u0003\u0001\u0004)\bbBA\u000b\u0003\u000b\u0001\rAY\u0001\u0006G>,h\u000e\u001e\u0005\b\u00033\u0001A\u0011BA\u000e\u0003E9WM\\\"pI\u00164uN]#mK6,g\u000e\u001e\u000b\u000eE\u0006u\u0011qDA\u0015\u0003[\ty#a\r\t\rQ\f9\u00021\u0001v\u0011!\t\t#a\u0006A\u0002\u0005\r\u0012aC3mK6,g\u000e\u001e+za\u0016\u00042ANA\u0013\u0013\r\t9c\u000e\u0002\t\t\u0006$\u0018\rV=qK\"9\u00111FA\f\u0001\u0004\u0011\u0017aB3mK6,g\u000e\u001e\u0005\b\u0003+\t9\u00021\u0001c\u0011\u001d\t\t$a\u0006A\u0002\t\f!\u0002\\3gi&\u001bh*\u001e7m\u0011\u001d\t)$a\u0006A\u0002\t\fQ\"\u0019:sCf$\u0015\r^1OC6,\u0007\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0003\u0011\u0019w\u000e]=\u0015\u000b=\ni$a\u0010\t\u0011\u0005\n9\u0004%AA\u0002\rB\u0001\"KA\u001c!\u0003\u0005\ra\t\u0005\n\u0003\u0007\u0002\u0011\u0013!C\u0001\u0003\u000b\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002H)\u001a1%!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u0018\u0001#\u0003%\t!!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0005Y\u0006twM\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\rA\u0017\u0011\u000e\u0005\n\u0003k\u0002\u0011\u0011!C\u0001\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001f\u0011\u0007a\tY(C\u0002\u0002~e\u00111!\u00138u\u0011%\t\t\tAA\u0001\n\u0003\t\u0019)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Y\u000b)\t\u0003\u0006\u0002\b\u0006}\u0014\u0011!a\u0001\u0003s\n1\u0001\u001f\u00132\u0011%\tY\tAA\u0001\n\u0003\ni)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\tE\u0003\u0002\u0012\u0006]e+\u0004\u0002\u0002\u0014*\u0019\u0011QS\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0006M%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005u\u0005!!A\u0005\u0002\u0005}\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007A\u000b\t\u000bC\u0005\u0002\b\u0006m\u0015\u0011!a\u0001-\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013qU\u0001\u0007KF,\u0018\r\\:\u0015\u0007A\u000bI\u000bC\u0005\u0002\b\u0006\r\u0016\u0011!a\u0001-\"z\u0001!!,\u00024\u0006U\u0016\u0011XA^\u0003\u007f\u000b\t\rE\u0002\u0012\u0003_K1!!-\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a.\u0002\u0015~3UKT\"`Q\u0015dW-\\3oi2\u00023m\\;oi&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u001awN\u001c;bS:Lgn\u001a\u0011fY\u0016lWM\u001c;!G>,h\u000e\u001e\u0011uS6,7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QX\u0001H\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013GM\u001a(Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\EE\u00124G\t\u0017#cI\u001a$%\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111Y\u0001\u0006e9\"d\u0006M\u0004\n\u0003\u000f\u0014\u0011\u0011!E\u0001\u0003\u0013\f1\"\u0011:sCf\u0014V\r]3biB\u0019\u0011#a3\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u001b\u001cR!a3\u0002Pv\u0001r!!5\u0002X\u000e\u001as&\u0004\u0002\u0002T*\u0019\u0011Q[\r\u0002\u000fI,h\u000e^5nK&!\u0011\u0011\\Aj\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u0005-G\u0011AAo)\t\tI\r\u0003\u0006\u0002b\u0006-\u0017\u0011!C#\u0003G\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003KB!\"a:\u0002L\u0006\u0005I\u0011QAu\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u00131^Aw\u0011\u0019\t\u0013Q\u001da\u0001G!1\u0011&!:A\u0002\rB!\"!=\u0002L\u0006\u0005I\u0011QAz\u0003\u001d)h.\u00199qYf$B!!>\u0002~B)\u0001$a>\u0002|&\u0019\u0011\u0011`\r\u0003\r=\u0003H/[8o!\u0015A\u0012QB\u0012$\u0011%\ty0a<\u0002\u0002\u0003\u0007q&A\u0002yIAB!Ba\u0001\u0002L\u0006\u0005I\u0011\u0002B\u0003\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0001\u0003BA4\u0005\u0013IAAa\u0003\u0002j\t1qJ\u00196fGR\u0004")
public class ArrayRepeat
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRepeat arrayRepeat) {
        return ArrayRepeat$.MODULE$.unapply(arrayRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRepeat> tupled() {
        return ArrayRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRepeat>> curried() {
        return ArrayRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.left().dataType(), this.left().nullable());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return this.right().nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object count = this.right().eval(input);
        if (count == null) {
            genericArrayData = null;
        } else {
            if (BoxesRunTime.unboxToInt((Object)count) > ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder(48).append("Unsuccessful try to create array with ").append(count).append(" elements ").append(new StringBuilder(39).append("due to exceeding the array size limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString()).toString());
            }
            Object element = this.left().eval(input);
            genericArrayData = new GenericArrayData((Object[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)count), (Function0 & Serializable & scala.Serializable)() -> element, ClassTag$.MODULE$.Any()));
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "array_repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        ExprValue element = leftGen.value();
        ExprValue count = rightGen.value();
        DataType et = this.dataType().elementType();
        String coreLogic = this.genCodeForElement(ctx, et, ExprValue$.MODULE$.exprValueToString(element), ExprValue$.MODULE$.exprValueToString(count), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), ExprValue$.MODULE$.exprValueToString(ev.value()));
        String resultCode = this.nullElementsProtection(ev, ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), coreLogic);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " =\n         |  ", ";\n         |", "\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private String nullElementsProtection(ExprCode ev, String rightIsNull, String coreLogic) {
        return this.nullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n         |if (").append(rightIsNull).append(") {\n         |  ").append(ev.isNull()).append(" = true;\n         |} else {\n         |  ").append(coreLogic).append("\n         |}\n       ").toString())).stripMargin() : coreLogic;
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String count) {
        String numElements = ctx.freshName("numElements");
        String numElementsCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |int ").append(numElements).append(" = 0;\n         |if (").append(count).append(" > 0) {\n         |  ").append(numElements).append(" = ").append(count).append(";\n         |}\n       ").toString())).stripMargin();
        return new Tuple2((Object)numElements, (Object)numElementsCode);
    }

    private String genCodeForElement(CodegenContext ctx, DataType elementType, String element, String count, String leftIsNull, String arrayDataName) {
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, count);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemName = (String)tuple2._1();
        String numElemCode = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemName, (Object)numElemCode);
        Tuple2 tuple23 = tuple22;
        String numElemName2 = (String)tuple23._1();
        String numElemCode2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, elementType, numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.setArrayElement(tempArrayDataName, elementType, k, element, CodeGenerator$.MODULE$.setArrayElement$default$5());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("\n       |").append(numElemCode2).append("\n       |").append(allocation).append("\n       |if (!").append(leftIsNull).append(") {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(assignment).append("\n       |  }\n       |} else {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(tempArrayDataName).append(".setNullAt(").append(k).append(");\n       |  }\n       |}\n       |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n     ").toString())).stripMargin();
    }

    public ArrayRepeat copy(Expression left, Expression right) {
        return new ArrayRepeat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRepeat arrayRepeat = (ArrayRepeat)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRepeat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRepeat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRepeat.canEqual(this)) return false;
        return true;
    }

    public ArrayRepeat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

