/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first element of the array as long.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3, 2, 1), 1);\n       3\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001>\u0011Q\"\u0011:sCf\u0004vn]5uS>t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00027fMR,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015aWM\u001a;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013!\u0002:jO\"$\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\rILw\r\u001b;!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\u0002C\u001a\u0001\u0011\u000b\u0007I\u0011\u0002\u001b\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012!\u000e\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\u0005Pe\u0012,'/\u001b8h\u0015\ti\u0014\u0004\u0005\u0002\u0019\u0005&\u00111)\u0007\u0002\u0004\u0003:L\bF\u0001\u001aF!\tAb)\u0003\u0002H3\tIAO]1og&,g\u000e\u001e\u0005\u0006\u0013\u0002!\tES\u0001\tI\u0006$\u0018\rV=qKV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\r\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\t\t\u0006$\u0018\rV=qK\")!\u000b\u0001C!'\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Q\u00032AN+X\u0013\t1\u0006IA\u0002TKF\u0004\"\u0001\u0014-\n\u0005ek%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015Y\u0006\u0001\"\u0011]\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011\u0005\u0003!\tg.\u00197zg&\u001c\u0018B\u00012`\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\b\"\u00023\u0001\t\u0003*\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA!gQ\")qm\u0019a\u0001\u0003\u0006\u0019\u0011M\u001d:\t\u000b%\u001c\u0007\u0019A!\u0002\u000bY\fG.^3\t\u000b-\u0004A\u0011\t7\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001n!\tq'O\u0004\u0002paB\u0011\u0001(G\u0005\u0003cf\ta\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011/\u0007\u0005\u0006m\u0002!\te^\u0001\nI><UM\\\"pI\u0016$B\u0001\u001f@\u0002\bA\u0011\u0011\u0010`\u0007\u0002u*\u00111PA\u0001\bG>$WmZ3o\u0013\ti(P\u0001\u0005FqB\u00148i\u001c3f\u0011\u0019yX\u000f1\u0001\u0002\u0002\u0005\u00191\r\u001e=\u0011\u0007e\f\u0019!C\u0002\u0002\u0006i\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\nU\u0004\r\u0001_\u0001\u0003KZD\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\u0002\t\r|\u0007/\u001f\u000b\u0006_\u0005E\u00111\u0003\u0005\tC\u0005-\u0001\u0013!a\u0001G!A\u0011&a\u0003\u0011\u0002\u0003\u00071\u0005C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000eU\r\u0019\u0013QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)\u0004AA\u0001\n\u0003\n9$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0003mC:<'BAA\"\u0003\u0011Q\u0017M^1\n\u0007M\fi\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\n\t\u00041\u0005=\u0013bAA)3\t\u0019\u0011J\u001c;\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u0003\u0006e\u0003BCA.\u0003'\n\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0004#BA3\u0003W\nUBAA4\u0015\r\tI'G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003c\u0002\u0011\u0011!C\u0001\u0003g\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\nY\bE\u0002\u0019\u0003oJ1!!\u001f\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0017\u0002p\u0005\u0005\t\u0019A!\t\u0013\u0005}\u0004!!A\u0005B\u0005\u0005\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002v\u0005\r\u0005\"CA.\u0003{\n\t\u00111\u0001BQ=\u0001\u0011qQAG\u0003\u001f\u000b\u0019*!&\u0002\u001a\u0006m\u0005cA\t\u0002\n&\u0019\u00111\u0012\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001h\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK1se\u0006LH\u0006I3mK6,g\u000e^\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!QEj#-Y:fI&\u0002\u0013N\u001c3fq\u0002zg\r\t;iK\u00022\u0017N]:uA\u0015dW-\\3oi\u0002zg\r\t;iK\u0002\n'O]1zA\u0005\u001c\b\u0005\\8oO:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qS\u0001E\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQMb\u0003E\r\u0017!c%b\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003;\u000bQA\r\u00185]A:\u0011\"!)\u0003\u0003\u0003E\t!a)\u0002\u001b\u0005\u0013(/Y=Q_NLG/[8o!\r\t\u0012Q\u0015\u0004\t\u0003\t\t\t\u0011#\u0001\u0002(N)\u0011QUAU;A9\u00111VAYG\rzSBAAW\u0015\r\ty+G\u0001\beVtG/[7f\u0013\u0011\t\u0019,!,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003K#\t!a.\u0015\u0005\u0005\r\u0006BCA^\u0003K\u000b\t\u0011\"\u0012\u0002>\u0006AAo\\*ue&tw\r\u0006\u0002\u0002:!Q\u0011\u0011YAS\u0003\u0003%\t)a1\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\n)-a2\t\r\u0005\ny\f1\u0001$\u0011\u0019I\u0013q\u0018a\u0001G!Q\u00111ZAS\u0003\u0003%\t)!4\u0002\u000fUt\u0017\r\u001d9msR!\u0011qZAn!\u0015A\u0012\u0011[Ak\u0013\r\t\u0019.\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\t9nI\u0012\n\u0007\u0005e\u0017D\u0001\u0004UkBdWM\r\u0005\n\u0003;\fI-!AA\u0002=\n1\u0001\u001f\u00131\u0011)\t\t/!*\u0002\u0002\u0013%\u00111]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002fB!\u00111HAt\u0013\u0011\tI/!\u0010\u0003\r=\u0013'.Z2u\u0001")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition arrayPosition) {
        return ArrayPosition$.MODULE$.unapply(arrayPosition);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$4(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |int ").append(pos).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(ctx.genEqual(this.right().dataType(), (String)value, getValue)).append(") {\n         |    ").append(pos).append(" = ").append(i).append(" + 1;\n         |    break;\n         |  }\n         |}\n         |").append(ev.value()).append(" = (long) ").append(pos).append(";\n       ").toString())).stripMargin();
        });
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$4(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

