/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001>\u0011\u0011bU;cgR\u0014\u0018N\\4\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\t\u0015/y!\u0003CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000f\u0005EI\u0012B\u0001\u000e\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001H\u000f\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011!D\u0001\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&A\u0002tiJ,\u0012A\u000b\t\u0003#-J!\u0001\f\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005/\u0001\tE\t\u0015!\u0003+\u0003\u0011\u0019HO\u001d\u0011\t\u0011A\u0002!Q3A\u0005\u0002%\n1\u0001]8t\u0011!\u0011\u0004A!E!\u0002\u0013Q\u0013\u0001\u00029pg\u0002B\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!K\u0001\u0004Y\u0016t\u0007\u0002\u0003\u001c\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\t1,g\u000e\t\u0005\u0006q\u0001!\t!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u0003#\u0001AQ\u0001K\u001cA\u0002)BQ\u0001M\u001cA\u0002)BQ\u0001N\u001cA\u0002)BQ\u0001\u000f\u0001\u0005\u0002}\"2A\u000f!B\u0011\u0015Ac\b1\u0001+\u0011\u0015\u0001d\b1\u0001+\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003!!\u0017\r^1UsB,W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!3\u0011!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005!!\u0015\r^1UsB,\u0007\"\u0002'\u0001\t\u0003j\u0015AC5oaV$H+\u001f9fgV\ta\nE\u0002P-fs!\u0001U+\u000f\u0005E#V\"\u0001*\u000b\u0005Ms\u0011A\u0002\u001fs_>$h(C\u0001\"\u0013\tQ\u0002%\u0003\u0002X1\n\u00191+Z9\u000b\u0005i\u0001\u0003C\u0001$[\u0013\tYvI\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\")Q\f\u0001C!=\u0006A1\r[5mIJ,g.F\u0001`!\ryeK\u000b\u0005\u0006C\u0002!\tEY\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005G\u001aD\u0017\u000e\u0005\u0002 I&\u0011Q\r\t\u0002\u0004\u0003:L\b\"B4a\u0001\u0004\u0019\u0017AB:ue&tw\rC\u00031A\u0002\u00071\rC\u00035A\u0002\u00071\rC\u0003l\u0001\u0011\u0005C.A\u0005e_\u001e+gnQ8eKR\u0019Qn\u001d=\u0011\u00059\fX\"A8\u000b\u0005A\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003e>\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006i*\u0004\r!^\u0001\u0004GRD\bC\u00018w\u0013\t9xN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000beT\u0007\u0019A7\u0002\u0005\u00154\bbB>\u0001\u0003\u0003%\t\u0001`\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003;{z|\bb\u0002\u0015{!\u0003\u0005\rA\u000b\u0005\bai\u0004\n\u00111\u0001+\u0011\u001d!$\u0010%AA\u0002)B\u0011\"a\u0001\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0001\u0016\u0004U\u0005%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0001%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005\u0015\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003C\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A.\u00198h\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017\u0002BA\u001c\u0003[\u0011aa\u0015;sS:<\u0007\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0004E\u0002 \u0003\u0003J1!a\u0011!\u0005\rIe\u000e\u001e\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002d\u0003\u0017B!\"!\u0014\u0002F\u0005\u0005\t\u0019AA \u0003\rAH%\r\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0002R!a\u0016\u0002^\rl!!!\u0017\u000b\u0007\u0005m\u0003%\u0001\u0006d_2dWm\u0019;j_:LA!a\u0018\u0002Z\tA\u0011\n^3sCR|'\u000fC\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\u00055\u0004cA\u0010\u0002j%\u0019\u00111\u000e\u0011\u0003\u000f\t{w\u000e\\3b]\"I\u0011QJA1\u0003\u0003\u0005\ra\u0019\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003g\na!Z9vC2\u001cH\u0003BA4\u0003kB\u0011\"!\u0014\u0002p\u0005\u0005\t\u0019A2)\u001f\u0001\tI(a \u0002\u0002\u0006\u0015\u0015qQAF\u0003\u001b\u00032!EA>\u0013\r\tiH\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019)AA.?\u001a+fjQ0)gR\u0014H\u0006\t9pgnc\u0003\u0005\\3o;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001e2tiJLgn\u001a\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011ti\u0006\u0014Ho\u001d\u0011bi\u0002\u0002\u0007o\\:aA\u0005tG\rI5tA=4\u0007\u0005\\3oORD\u0007\u0005\u00197f]\u0002d\u0003e\u001c:!i\",\u0007e\u001d7jG\u0016\u0004sN\u001a\u0011csR,\u0007%\u0019:sCf\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011R\u0001\u0002X)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011lAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;C\u0006I\u00174SmR\u0001\u0005\t\u0011!A\u0001\u00023+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFj\n\u0017!k1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!W*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0010\u0006)\u0011GL\u001b/a\u001dI\u00111\u0013\u0002\u0002\u0002#\u0005\u0011QS\u0001\n'V\u00147\u000f\u001e:j]\u001e\u00042!EAL\r!\t!!!A\t\u0002\u0005e5#BAL\u00037#\u0003\u0003CAO\u0003GS#F\u000b\u001e\u000e\u0005\u0005}%bAAQA\u00059!/\u001e8uS6,\u0017\u0002BAS\u0003?\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001dA\u0014q\u0013C\u0001\u0003S#\"!!&\t\u0015\u00055\u0016qSA\u0001\n\u000b\ny+\u0001\u0005u_N#(/\u001b8h)\t\tI\u0003\u0003\u0006\u00024\u0006]\u0015\u0011!CA\u0003k\u000bQ!\u00199qYf$rAOA\\\u0003s\u000bY\f\u0003\u0004)\u0003c\u0003\rA\u000b\u0005\u0007a\u0005E\u0006\u0019\u0001\u0016\t\rQ\n\t\f1\u0001+\u0011)\ty,a&\u0002\u0002\u0013\u0005\u0015\u0011Y\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019-a4\u0011\u000b}\t)-!3\n\u0007\u0005\u001d\u0007E\u0001\u0004PaRLwN\u001c\t\u0007?\u0005-'F\u000b\u0016\n\u0007\u00055\u0007E\u0001\u0004UkBdWm\r\u0005\n\u0003#\fi,!AA\u0002i\n1\u0001\u001f\u00131\u0011)\t).a&\u0002\u0002\u0013%\u0011q[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002ZB!\u00111FAn\u0013\u0011\ti.!\f\u0003\r=\u0013'.Z2u\u0001")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring substring) {
        return Substring$.MODULE$.unapply(substring);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.pos();
        Expression expression3 = this.len();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        DataType dataType2;
        block4: {
            Object object;
            block3: {
                block2: {
                    dataType2 = this.str().dataType();
                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                    object = ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
                    break block3;
                }
                if (!BinaryType$.MODULE$.equals(dataType2)) break block4;
                object = ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Substring $outer;

            public final String apply(String string, String pos, String len) {
                DataType dataType2;
                block4: {
                    String string2;
                    block3: {
                        block2: {
                            dataType2 = this.$outer.str().dataType();
                            if (!StringType$.MODULE$.equals(dataType2)) break block2;
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".substringSQL(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, pos, len}));
                            break block3;
                        }
                        if (!BinaryType$.MODULE$.equals(dataType2)) break block4;
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".subStringSQL(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteArray.class.getName(), string, pos, len}));
                    }
                    return string2;
                }
                throw new MatchError((Object)dataType2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.len();
                break;
            }
            case 1: {
                expression = this.pos();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes$class.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

