/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the trailing string which contains the characters from the trim string from the `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('LQSa', 'SSparkSQLS');\n       SSpark\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mv!B\u0001\u0003\u0011\u0003y\u0011aD*ue&tw\r\u0016:j[JKw\r\u001b;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011qb\u0015;sS:<GK]5n%&<\u0007\u000e^\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQ!I\t\u0005\u0002\t\nQ!\u00199qYf$RaIA=\u0003{\u0002\"\u0001\u0005\u0013\u0007\tI\u0011\u0001)J\n\u0006I\u0019JCF\u0007\t\u0003!\u001dJ!\u0001\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\u0011U%\u00111F\u0001\u0002\u0016'R\u0014\u0018N\\43)JLW.\u0012=qe\u0016\u001c8/[8o!\t)R&\u0003\u0002/-\t9\u0001K]8ek\u000e$\b\u0002\u0003\u0019%\u0005+\u0007I\u0011A\u0019\u0002\rM\u00148m\u0015;s+\u00051\u0003\u0002C\u001a%\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u000fM\u00148m\u0015;sA!AQ\u0007\nBK\u0002\u0013\u0005a'A\u0004ue&l7\u000b\u001e:\u0016\u0003]\u00022!\u0006\u001d'\u0013\tIdC\u0001\u0004PaRLwN\u001c\u0005\tw\u0011\u0012\t\u0012)A\u0005o\u0005AAO]5n'R\u0014\b\u0005C\u0003\u001fI\u0011\u0005Q\bF\u0002$}}BQ\u0001\r\u001fA\u0002\u0019Bq!\u000e\u001f\u0011\u0002\u0003\u0007q\u0007C\u0003\u001fI\u0011\u0005\u0011\tF\u0002$\u0005\u000eCQ!\u000e!A\u0002\u0019BQ\u0001\r!A\u0002\u0019BQA\b\u0013\u0005\u0002\u0015#\"a\t$\t\u000bA\"\u0005\u0019\u0001\u0014\t\u000b!#C\u0011I%\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001K!\tYeJ\u0004\u0002\u0016\u0019&\u0011QJF\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N-!)!\u000b\nC!'\u0006!QM^1m)\t!v\u000b\u0005\u0002\u0016+&\u0011aK\u0006\u0002\u0004\u0003:L\bb\u0002-R!\u0003\u0005\r!W\u0001\u0006S:\u0004X\u000f\u001e\t\u00035nk\u0011\u0001B\u0005\u00039\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\")a\f\nC)?\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004A\u001a\\\u0007CA1e\u001b\u0005\u0011'BA2\u0003\u0003\u001d\u0019w\u000eZ3hK:L!!\u001a2\u0003\u0011\u0015C\bO]\"pI\u0016DQaZ/A\u0002!\f1a\u0019;y!\t\t\u0017.\u0003\u0002kE\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u00027^\u0001\u0004\u0001\u0017AA3w\u0011\u001dqG%!A\u0005\u0002=\fAaY8qsR\u00191\u0005]9\t\u000fAj\u0007\u0013!a\u0001M!9Q'\u001cI\u0001\u0002\u00049\u0004bB:%#\u0003%\t\u0001^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005)(F\u0001\u0014wW\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003%)hn\u00195fG.,GM\u0003\u0002}-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yL(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0001\u0013\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)A\u000b\u00028m\"I\u0011\u0011\u0002\u0013\u0002\u0002\u0013\u0005\u00131B\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0018\u0005!!.\u0019<b\u0013\ry\u0015\u0011\u0003\u0005\n\u0003;!\u0013\u0011!C\u0001\u0003?\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\t\u0011\u0007U\t\u0019#C\u0002\u0002&Y\u00111!\u00138u\u0011%\tI\u0003JA\u0001\n\u0003\tY#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Q\u000bi\u0003\u0003\u0006\u00020\u0005\u001d\u0012\u0011!a\u0001\u0003C\t1\u0001\u001f\u00132\u0011%\t\u0019\u0004JA\u0001\n\u0003\n)$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0004E\u0003\u0002:\u0005}B+\u0004\u0002\u0002<)\u0019\u0011Q\b\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0005m\"\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0015C%!A\u0005\u0002\u0005\u001d\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0013q\n\t\u0004+\u0005-\u0013bAA'-\t9!i\\8mK\u0006t\u0007\"CA\u0018\u0003\u0007\n\t\u00111\u0001U\u0011%\t\u0019\u0006JA\u0001\n\u0003\n)&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0013\n9\u0006C\u0005\u00020\u0005E\u0013\u0011!a\u0001)\"\u001aB%a\u0017\u0002b\u0005\r\u0014qMA5\u0003[\ny'a\u001d\u0002vA\u0019\u0001#!\u0018\n\u0007\u0005}#AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0014!a!\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002\"(/Y5mS:<\u0007e\u001d9bG\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~CCO]5n'R\u0014H\u0006I:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004CO]1jY&tw\rI:ue&tw\rI<iS\u000eD\u0007eY8oi\u0006Lgn\u001d\u0011uQ\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!MJ|W\u000e\t;iK\u0002\u00027\u000f\u001e:a\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tY'AA\u000f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"(/[7TiJ\u0004S\u0006\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\b\u0005^8!iJLW\u000e\f\u0011uQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011bAMLgn\u001a7fAM\u0004\u0018mY3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003c\n\u0011Q\u0002\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C*U*bO1\u0002seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU*qCJ\\'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005]\u0014!B\u0019/k9\u0002\u0004BBA>A\u0001\u0007a%A\u0002tiJDQ!\u000e\u0011A\u0002\u0019Ba!I\t\u0005\u0002\u0005\u0005EcA\u0012\u0002\u0004\"9\u00111PA@\u0001\u00041\u0003\u0002C\u0011\u0012\u0003\u0003%\t)a\"\u0015\u000b\r\nI)a#\t\rA\n)\t1\u0001'\u0011!)\u0014Q\u0011I\u0001\u0002\u00049\u0004\"CAH#\u0005\u0005I\u0011QAI\u0003\u001d)h.\u00199qYf$B!a%\u0002\u001cB!Q\u0003OAK!\u0015)\u0012q\u0013\u00148\u0013\r\tIJ\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005u\u0015QRA\u0001\u0002\u0004\u0019\u0013a\u0001=%a!I\u0011\u0011U\t\u0012\u0002\u0013\u0005\u00111A\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u0015\u0016#%A\u0005\u0002\u0005\r\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005%\u0016#!A\u0005\n\u0005-\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!,\u0011\t\u0005=\u0011qV\u0005\u0005\u0003c\u000b\tB\u0001\u0004PE*,7\r\u001e")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression$class.children(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression$class.sql(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimRight((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimRight());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$5;

            public final ExprCode apply(Expression x$36) {
                return x$36.genCode(this.ctx$5);
            }
            {
                this.ctx$5 = ctx$5;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$37) {
                    return x$37.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimRightFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$38) {
                    return x$38.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimRightFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

