/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.8446490682263027\n      > SELECT _FUNC_(null);\n       0.8446490682263027\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001>\u0011AAU1oI*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!QQ\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005\r\u0011Fi\u0012\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b!J|G-^2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0004\u0001BK\u0002\u0013\u0005q$A\u0003dQ&dG-F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\naa\u00195jY\u0012\u0004\u0003\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\b\u0006\u0002)SA\u0011\u0011\u0003\u0001\u0005\u0006=\u0015\u0002\r\u0001\t\u0005\u0006M\u0001!\ta\u000b\u000b\u0002Q!)Q\u0006\u0001C)]\u0005aQM^1m\u0013:$XM\u001d8bYR\u0011qF\r\t\u0003+AJ!!\r\f\u0003\r\u0011{WO\u00197f\u0011\u0015\u0019D\u00061\u00015\u0003\u0015Ig\u000e];u!\t)d'D\u0001\u0005\u0013\t9DAA\u0006J]R,'O\\1m%><\b\"B\u001d\u0001\t\u0003R\u0014!\u00033p\u000f\u0016t7i\u001c3f)\rY\u0014I\u0012\t\u0003y}j\u0011!\u0010\u0006\u0003}\t\tqaY8eK\u001e,g.\u0003\u0002A{\tAQ\t\u001f9s\u0007>$W\rC\u0003Cq\u0001\u00071)A\u0002dib\u0004\"\u0001\u0010#\n\u0005\u0015k$AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006\u000fb\u0002\raO\u0001\u0003KZDq!\u0013\u0001\u0002\u0002\u0013\u0005!*\u0001\u0003d_BLHC\u0001\u0015L\u0011\u001dq\u0002\n%AA\u0002\u0001Bq!\u0014\u0001\u0012\u0002\u0013\u0005a*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003=S#\u0001\t),\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u0013Ut7\r[3dW\u0016$'B\u0001,\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u00031N\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dQ\u0006!!A\u0005Bm\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDq!\u001a\u0001\u0002\u0002\u0013\u0005a-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001h!\t)\u0002.\u0003\u0002j-\t\u0019\u0011J\u001c;\t\u000f-\u0004\u0011\u0011!C\u0001Y\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HCA7q!\t)b.\u0003\u0002p-\t\u0019\u0011I\\=\t\u000fET\u0017\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\t\u000fM\u0004\u0011\u0011!C!i\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001v!\r1\u00180\\\u0007\u0002o*\u0011\u0001PF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001>x\u0005!IE/\u001a:bi>\u0014\bb\u0002?\u0001\u0003\u0003%\t!`\u0001\tG\u0006tW)];bYR\u0019a0a\u0001\u0011\u0005Uy\u0018bAA\u0001-\t9!i\\8mK\u0006t\u0007bB9|\u0003\u0003\u0005\r!\u001c\u0005\n\u0003\u000f\u0001\u0011\u0011!C!\u0003\u0013\ta!Z9vC2\u001cHc\u0001@\u0002\f!A\u0011/!\u0002\u0002\u0002\u0003\u0007Q\u000eK\b\u0001\u0003\u001f\t)\"a\u0006\u0002\u001c\u0005u\u0011\u0011EA\u0012!\r\t\u0012\u0011C\u0005\u0004\u0003'\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00033\t\u00111B0G+:\u001bu\fK.tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]1oI>l\u0007E^1mk\u0016\u0004s/\u001b;iA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011b]\u0012\u0004\u0013\u000eZ3oi&\u001c\u0017\r\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AUt\u0017NZ8s[2L\b\u0005Z5tiJL'-\u001e;fI\u00022\u0018\r\\;fg\u0002Jg\u000eI.1Y\u0001\n\u0014FL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qD\u0001\u0002`)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111]e2$'O\u001c5ee*\u0014\u0007N\u001a5kQ\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002d\u0006\u000f\u001b5mQJ\u0004G\u000e\u001d3eY\u001a\u0004GM\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9,H\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0003\b\u000e\u001b7ie\u0002d\u0007\u000f\u001a3mM\u0002$g\u000e\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QE\u0001\u0006c9*d\u0006M\u0004\b\u0003S\u0011\u0001\u0012AA\u0016\u0003\u0011\u0011\u0016M\u001c3\u0011\u0007E\tiC\u0002\u0004\u0002\u0005!\u0005\u0011qF\n\u0006\u0003[\t\tD\u0007\t\u0004+\u0005M\u0012bAA\u001b-\t1\u0011I\\=SK\u001aDqAJA\u0017\t\u0003\tI\u0004\u0006\u0002\u0002,!A\u0011QHA\u0017\t\u0003\ty$A\u0003baBd\u0017\u0010F\u0002)\u0003\u0003B\u0001\"a\u0011\u0002<\u0001\u0007\u0011QI\u0001\u0005g\u0016,G\rE\u0002\u0016\u0003\u000fJ1!!\u0013\u0017\u0005\u0011auN\\4\t\u0015\u0005u\u0012QFA\u0001\n\u0003\u000bi\u0005F\u0002)\u0003\u001fBaAHA&\u0001\u0004\u0001\u0003BCA*\u0003[\t\t\u0011\"!\u0002V\u00059QO\\1qa2LH\u0003BA,\u0003;\u0002B!FA-A%\u0019\u00111\f\f\u0003\r=\u0003H/[8o\u0011%\ty&!\u0015\u0002\u0002\u0003\u0007\u0001&A\u0002yIAB!\"a\u0019\u0002.\u0005\u0005I\u0011BA3\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0004cA/\u0002j%\u0019\u00111\u000e0\u0003\r=\u0013'.Z2u\u0001")
public class Rand
extends RDG
implements Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "(", "L + partitionIndex);"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rngTerm, className, BoxesRunTime.boxToLong((long)this.seed())})));
        return ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.javaType(this.dataType()), ev.value(), rngTerm})), "false", ev.copy$default$3());
    }

    public Rand copy(Expression child) {
        return new Rand(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child) {
        this.child = child;
    }

    public Rand() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$));
    }
}

