/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT _FUNC_(10.0, 0.5, 100);\n       10.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u0001\u0003\u0001F\u0011Q#\u00119qe>D\u0018.\\1uKB+'oY3oi&dWM\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M9\u0001AEAP\u0003K#\u0004cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005]\u0011eB\u0001\r*\u001d\tI\u0002F\u0004\u0002\u001bO9\u00111D\n\b\u00039\u0015r!!\b\u0013\u000f\u0005y\u0019cBA\u0010#\u001b\u0005\u0001#BA\u0011\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015Q#\u0001#\u0001,\u0003U\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016\u0004\"a\u0005\u0017\u0007\u000b\u0005\u0011\u0001\u0012A\u0017\u0014\u00071rC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003_UJ!A\u000e\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000babC\u0011A\u001d\u0002\rqJg.\u001b;?)\u0005Y\u0003bB\u001e-\u0005\u0004%\t\u0001P\u0001\u001c\t\u00163\u0015)\u0016'U?B+%kQ#O)&cUiX!D\u0007V\u0013\u0016iQ-\u0016\u0003u\u0002\"a\f \n\u0005}\u0002$aA%oi\"1\u0011\t\fQ\u0001\nu\nA\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eK\u0006E\u0002\u0003DY\u0001!%\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t\u0011e\u0006\u0003\u0005G\u0005\n\u0005\r\u0011\"\u0003H\u0003%\u0019X/\\7be&,7/F\u0001I!\tIE*D\u0001K\u0015\tYe!\u0001\u0003vi&d\u0017BA'K\u0005E\tV/\u00198uS2,7+^7nCJLWm\u001d\u0005\t\u001f\n\u0013\t\u0019!C\u0005!\u0006i1/^7nCJLWm]0%KF$\"!\u0015+\u0011\u0005=\u0012\u0016BA*1\u0005\u0011)f.\u001b;\t\u000fUs\u0015\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\t\u0011]\u0013%\u0011!Q!\n!\u000b!b];n[\u0006\u0014\u0018.Z:!\u0011!I&I!a\u0001\n\u0013Q\u0016\u0001D5t\u0007>l\u0007O]3tg\u0016$W#A.\u0011\u0005=b\u0016BA/1\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0018\"\u0003\u0002\u0004%I\u0001Y\u0001\u0011SN\u001cu.\u001c9sKN\u001cX\rZ0%KF$\"!U1\t\u000fUs\u0016\u0011!a\u00017\"A1M\u0011B\u0001B\u0003&1,A\u0007jg\u000e{W\u000e\u001d:fgN,G\r\t\u0005\u0006q\t#\t!\u001a\u000b\u0004M\"L\u0007CA4C\u001b\u0005a\u0003\"\u0002$e\u0001\u0004A\u0005\"B-e\u0001\u0004Y\u0006BB6CA\u00035Q(A\u000fd_6\u0004(/Z:t)\"\u0014Xm\u001d%pY\u0012\u0014UO\u001a4fe2+gn\u001a;i\u0011\u0015A$\t\"\u0001n)\t1g\u000eC\u0003pY\u0002\u0007\u0001/A\u0007sK2\fG/\u001b<f\u000bJ\u0014xN\u001d\t\u0003_EL!A\u001d\u0019\u0003\r\u0011{WO\u00197f\u0011\u0015!(\t\"\u0001H\u0003E\tX/\u00198uS2,7+^7nCJLWm\u001d\u0005\u0006m\n#\ta^\u0001\u0004C\u0012$GCA)y\u0011\u0015IX\u000f1\u0001q\u0003\u00151\u0018\r\\;f\u0011\u0015Y(\t\"\u0001}\u0003\u0015iWM]4f)\t\tV\u0010C\u0003\u007fu\u0002\u0007a-A\u0003pi\",'\u000fC\u0004\u0002\u0002\t#\t!a\u0001\u0002\u001d\u001d,G\u000fU3sG\u0016tG/\u001b7fgR!\u0011QAA\u0006!\u0011y\u0013q\u00019\n\u0007\u0005%\u0001GA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u000e}\u0004\r!!\u0002\u0002\u0017A,'oY3oi\u0006<Wm\u001d\u0005\b\u0003#\u0011EQBA\n\u0003!\u0019w.\u001c9sKN\u001cH#A)\u0007\r\u0005]A\u0006AA\r\u0005i\u0001VM]2f]RLG.\u001a#jO\u0016\u001cHoU3sS\u0006d\u0017N_3s'\r\t)B\f\u0005\bq\u0005UA\u0011AA\u000f)\t\ty\u0002E\u0002h\u0003+A\u0001\"a\t\u0002\u0016\u00115\u0011QE\u0001\u0007Y\u0016tw\r\u001e5\u0015\u0007u\n9\u0003\u0003\u0004G\u0003C\u0001\r\u0001\u0013\u0005\t\u0003W\t)\u0002\"\u0002\u0002.\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003_\t9\u0004E\u00030\u0003\u000f\t\t\u0004E\u00020\u0003gI1!!\u000e1\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005e\u0012\u0011\u0006a\u0001M\u0006\u0019qN\u00196\t\u0011\u0005u\u0012Q\u0003C\u0003\u0003\u007f\t1\u0002Z3tKJL\u0017\r\\5{KR\u0019a-!\u0011\t\u0011\u0005\r\u00131\ba\u0001\u0003_\tQAY=uKND\u0011\"a\u0012-\u0005\u0004%\t!!\u0013\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u0002 !A\u0011Q\n\u0017!\u0002\u0013\ty\"A\u0006tKJL\u0017\r\\5{KJ\u0004\u0003\"CA)Y\u0005\u0005I\u0011QA*\u0003\u0015\t\u0007\u000f\u001d7z)1\t)&a\u0016\u0002d\u0005\u001d\u00141NA8!\t\u0019\u0002\u0001\u0003\u0005\u0002Z\u0005=\u0003\u0019AA.\u0003\u0015\u0019\u0007.\u001b7e!\u0011\ti&a\u0018\u000e\u0003\u0011I1!!\u0019\u0005\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t\u0003K\ny\u00051\u0001\u0002\\\u0005!\u0002/\u001a:dK:$\u0018mZ3FqB\u0014Xm]:j_:D\u0001\"!\u001b\u0002P\u0001\u0007\u00111L\u0001\u0013C\u000e\u001cWO]1ds\u0016C\bO]3tg&|g\u000eC\u0004\u0002n\u0005=\u0003\u0019A\u001f\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDq!!\u001d\u0002P\u0001\u0007Q(\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\n\u0003kb\u0013\u0011!CA\u0003o\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002z\u0005\u0015\u0005#B\u0018\u0002|\u0005}\u0014bAA?a\t1q\n\u001d;j_:\u00042bLAA\u00037\nY&a\u0017>{%\u0019\u00111\u0011\u0019\u0003\rQ+\b\u000f\\36\u0011)\t9)a\u001d\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\u0002\u0004\"CAFY\u0005\u0005I\u0011BAG\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0005\u0003BAI\u00037k!!a%\u000b\t\u0005U\u0015qS\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001a\u0006!!.\u0019<b\u0013\u0011\ti*a%\u0003\r=\u0013'.Z2u!\u0011\ti&!)\n\u0007\u0005\rFA\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ry\u0013qU\u0005\u0004\u0003S\u0003$a\u0002)s_\u0012,8\r\u001e\u0005\u000b\u00033\u0002!Q3A\u0005\u0002\u00055VCAA.\u0011)\t\t\f\u0001B\tB\u0003%\u00111L\u0001\u0007G\"LG\u000e\u001a\u0011\t\u0015\u0005\u0015\u0004A!f\u0001\n\u0003\ti\u000b\u0003\u0006\u00028\u0002\u0011\t\u0012)A\u0005\u00037\nQ\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007\u0005\u0003\u0006\u0002j\u0001\u0011)\u001a!C\u0001\u0003[C!\"!0\u0001\u0005#\u0005\u000b\u0011BA.\u0003M\t7mY;sC\u000eLX\t\u001f9sKN\u001c\u0018n\u001c8!\u0011%\ti\u0007\u0001BK\u0002\u0013\u0005C\bC\u0005\u0002D\u0002\u0011\t\u0012)A\u0005{\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\n\u0003c\u0002!Q3A\u0005BqB\u0011\"!3\u0001\u0005#\u0005\u000b\u0011B\u001f\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA!1\u0001\b\u0001C\u0001\u0003\u001b$B\"!\u0016\u0002P\u0006E\u00171[Ak\u0003/D\u0001\"!\u0017\u0002L\u0002\u0007\u00111\f\u0005\t\u0003K\nY\r1\u0001\u0002\\!A\u0011\u0011NAf\u0001\u0004\tY\u0006C\u0004\u0002n\u0005-\u0007\u0019A\u001f\t\u000f\u0005E\u00141\u001aa\u0001{!1\u0001\b\u0001C\u0001\u00037$\u0002\"!\u0016\u0002^\u0006}\u0017\u0011\u001d\u0005\t\u00033\nI\u000e1\u0001\u0002\\!A\u0011QMAm\u0001\u0004\tY\u0006\u0003\u0005\u0002j\u0005e\u0007\u0019AA.\u0011\u0019A\u0004\u0001\"\u0001\u0002fR1\u0011QKAt\u0003SD\u0001\"!\u0017\u0002d\u0002\u0007\u00111\f\u0005\t\u0003K\n\u0019\u000f1\u0001\u0002\\!I\u0011Q\u001e\u0001\t\u0006\u0004%I\u0001P\u0001\tC\u000e\u001cWO]1ds\"I\u0011\u0011\u001f\u0001\t\u0002\u0003\u0006K!P\u0001\nC\u000e\u001cWO]1ds\u0002Bq!!>\u0001\t\u0003\n90\u0001\u0006j]B,H\u000fV=qKN,\"!!?\u0011\r\u0005m(Q\u0001B\u0006\u001d\u0011\tiP!\u0001\u000f\u0007}\ty0C\u00012\u0013\r\u0011\u0019\u0001M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119A!\u0003\u0003\u0007M+\u0017OC\u0002\u0003\u0004A\u0002BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#A\u0011!\u0002;za\u0016\u001c\u0018\u0002\u0002B\u000b\u0005\u001f\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u0017U\u0003\u0001\u0013!EDB\u0013%!\u0011D\u000b\u0003\u00057\u0001ba\fB\u000f7\u0006\u0015\u0011b\u0001B\u0010a\t1A+\u001e9mKJB!Ba\t\u0001\u0011\u0003\u0005\u000b\u0015\u0002B\u000e\u0003\u0011AH%\r\u0011\t\u0013\t\u001d\u0002\u0001#b\u0001\n\u0013Q\u0016!\u0006:fiV\u0014h\u000eU3sG\u0016tG/\u001b7f\u0003J\u0014\u0018-\u001f\u0005\n\u0005W\u0001\u0001\u0012!Q!\nm\u000baC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u0017\u0010\t\u0005\u000b\u0003\u001b\u0001\u0001R1A\u0005\n\t=RCAA\u0003\u0011)\u0011\u0019\u0004\u0001E\u0001B\u0003&\u0011QA\u0001\ra\u0016\u00148-\u001a8uC\u001e,7\u000f\t\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\u0011Y\u0004\u0005\u0003\u0003>\t\rSB\u0001B \u0015\r\u0011\tEB\u0001\tC:\fG._:jg&!!Q\tB \u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\bb\u0002B%\u0001\u0011\u0005#1J\u0001\u0018GJ,\u0017\r^3BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012A\u0006\u0005\b\u0005\u001f\u0002A\u0011\tB)\u0003\u0019)\b\u000fZ1uKR)aCa\u0015\u0003X!9!Q\u000bB'\u0001\u00041\u0012A\u00022vM\u001a,'\u000f\u0003\u0005\u0003Z\t5\u0003\u0019\u0001B.\u0003!Ig\u000e];u%><\b\u0003\u0002B/\u0005?j\u0011AB\u0005\u0004\u0005C2!aC%oi\u0016\u0014h.\u00197S_^Daa\u001f\u0001\u0005B\t\u0015D#\u0002\f\u0003h\t%\u0004b\u0002B+\u0005G\u0002\rA\u0006\u0005\u0007}\n\r\u0004\u0019\u0001\f\t\u000f\t5\u0004\u0001\"\u0011\u0003p\u0005!QM^1m)\u0011\u0011\tHa\u001e\u0011\u0007=\u0012\u0019(C\u0002\u0003vA\u00121!\u00118z\u0011\u001d\u0011)Fa\u001bA\u0002YAqAa\u001f\u0001\t\u0003\u0012i(A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t)Fa \t\u000f\t\u0005%\u0011\u0010a\u0001{\u0005Ia.Z<PM\u001a\u001cX\r\u001e\u0005\b\u0005\u000b\u0003A\u0011\tBD\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011Q\u000bBE\u0011\u001d\u0011\tIa!A\u0002uBqA!$\u0001\t\u0003\u0012y)\u0001\u0005dQ&dGM]3o+\t\u0011\t\n\u0005\u0004\u0002|\n\u0015\u00111\f\u0005\u0007\u0005+\u0003A\u0011\t.\u0002\u00119,H\u000e\\1cY\u0016DqA!'\u0001\t\u0003\u0012Y*\u0001\u0005eCR\fG+\u001f9f+\t\u0011i\n\u0005\u0003\u0003\u000e\t}\u0015\u0002\u0002BQ\u0005\u001f\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0005K\u0003A\u0011\tBT\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0005S\u0003BAa+\u00032:\u0019qF!,\n\u0007\t=\u0006'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005g\u0013)L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005_\u0003\u0004bBA\u0016\u0001\u0011\u0005#\u0011\u0018\u000b\u0005\u0003_\u0011Y\fC\u0004\u0002:\t]\u0006\u0019\u0001\f\t\u000f\u0005u\u0002\u0001\"\u0011\u0003@R\u0019aC!1\t\u0011\u0005\r#Q\u0018a\u0001\u0003_A\u0011B!2\u0001\u0003\u0003%\tAa2\u0002\t\r|\u0007/\u001f\u000b\r\u0003+\u0012IMa3\u0003N\n='\u0011\u001b\u0005\u000b\u00033\u0012\u0019\r%AA\u0002\u0005m\u0003BCA3\u0005\u0007\u0004\n\u00111\u0001\u0002\\!Q\u0011\u0011\u000eBb!\u0003\u0005\r!a\u0017\t\u0013\u00055$1\u0019I\u0001\u0002\u0004i\u0004\"CA9\u0005\u0007\u0004\n\u00111\u0001>\u0011%\u0011)\u000eAI\u0001\n\u0003\u00119.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te'\u0006BA.\u00057\\#A!8\u0011\t\t}'\u0011^\u0007\u0003\u0005CTAAa9\u0003f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005O\u0004\u0014AC1o]>$\u0018\r^5p]&!!1\u001eBq\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005_\u0004\u0011\u0013!C\u0001\u0005/\fabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0003t\u0002\t\n\u0011\"\u0001\u0003X\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B|\u0001E\u0005I\u0011\u0001B}\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa?+\u0007u\u0012Y\u000eC\u0005\u0003\u0000\u0002\t\n\u0011\"\u0001\u0003z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0004\"CB\u0002\u0001\u0005\u0005I\u0011IB\u0003\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111q\u0001\t\u0005\u0003#\u001bI!\u0003\u0003\u00034\u0006M\u0005\u0002CB\u0007\u0001\u0005\u0005I\u0011\u0001\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\rE\u0001!!A\u0005\u0002\rM\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005c\u001a)\u0002\u0003\u0005V\u0007\u001f\t\t\u00111\u0001>\u0011%\u0019I\u0002AA\u0001\n\u0003\u001aY\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019i\u0002\u0005\u0004\u0004 \r\u0015\"\u0011O\u0007\u0003\u0007CQ1aa\t1\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007O\u0019\tC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0019Y\u0003AA\u0001\n\u0003\u0019i#\u0001\u0005dC:,\u0015/^1m)\rY6q\u0006\u0005\n+\u000e%\u0012\u0011!a\u0001\u0005cB\u0011ba\r\u0001\u0003\u0003%\te!\u000e\u0002\r\u0015\fX/\u00197t)\rY6q\u0007\u0005\n+\u000eE\u0012\u0011!a\u0001\u0005cB3\u0002AB\u001e\u0007\u0003\u001a\u0019ea\u0012\u0004JA!\u0011QLB\u001f\u0013\r\u0019y\u0004\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0019)%AC \u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0003/\u001a:dK:$\u0018mZ3!72\u0002\u0013mY2ve\u0006\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA=4\u0007E\\;nKJL7M\u0003\u0011!A\u0001\u0002\u0003eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0018!)\",\u0007E^1mk\u0016\u0004sN\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004S.^:uA\t,\u0007EY3uo\u0016,g\u000e\t\u0019/a)\u0001\u0003\u0005\t\u0011!A\u0005tG\rI\u0019/a9\u0002C\u000b[3!A\u0006\u001c7-\u001e:bGf\u0004\u0007\u0005]1sC6,G/\u001a:!Q\u0011,g-Y;mij\u0002\u0013\u0007\r\u00191a%\u0002\u0013n\u001d\u0011bAA|7/\u001b;jm\u0016\u0004c.^7fe&\u001c\u0007\u0005\\5uKJ\fG\u000eI<iS\u000eD'\u0002\t\u0011!A\u0001\u00023m\u001c8ue>d7\u000fI1qaJ|\u00070[7bi&|g\u000eI1dGV\u0014\u0018mY=!CR\u0004C\u000f[3!G>\u001cH\u000fI8gA5,Wn\u001c:z]\u0001B\u0015n\u001a5fe\u00022\u0018\r\\;fA=4\u0007\u0005Y1dGV\u0014\u0018mY=aAeLW\r\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!E\u0016$H/\u001a:!C\u000e\u001cWO]1ds2\u0002\u0003-\r\u00181_\u0005\u001c7-\u001e:bGf\u0004\u0007%[:!i\",\u0007E]3mCRLg/\u001a\u0011feJ|'\u000fI8gAQDW\rI1qaJ|\u00070[7bi&|gN\f\u0006!A\u0001\u0002\u0003\u0005I,iK:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002J7\u000fI1oA\u0005\u0014(/Y=-A\u0015\f7\r\u001b\u0011wC2,X\rI8gAQDW\r\t9fe\u000e,g\u000e^1hK\u0002\n'O]1zA5,8\u000f\u001e\u0011cK\u0002\u0012W\r^<fK:\u0004\u0003G\f\u0019!C:$\u0007%\r\u00181])\u0001\u0003\u0005\t\u0011!A%s\u0007\u0005\u001e5jg\u0002\u001a\u0017m]3-AI,G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005]3sG\u0016tG/\u001b7fA\u0005\u0014(/Y=!_\u001a\u00043m\u001c7v[:\u0004\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3o\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0016\u00148-\u001a8uC\u001e,\u0007%\u0019:sCft#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#aa\u0013\u0002\u0003SQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0019/a1\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u0019/a1\n\u0004G\f\u0019-cAr\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cAr\u0003\u0007\f\u00111]Ub\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u00181\u0015\u0001\u0002\u0003")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.accuracy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else {
                    if (!(object instanceof ArrayData)) throw new MatchError(object);
                    ArrayData arrayData = (ArrayData)object;
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                boolean returnPercentileArray = tuple23._1$mcZ$sp();
                double[] percentages = (double[])tuple23._2();
                boolean bl = returnPercentileArray;
                if (percentages == null) throw new MatchError((Object)tuple23);
                double[] dArray = percentages;
                this.x$1 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.x$1;
        }
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.returnPercentileArray;
        }
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.percentages;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$.apply(DoubleType$.MODULE$)})), IntegerType$.MODULE$}));
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() && this.accuracyExpression().foldable() ? (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy provided must be a positive integer literal (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.accuracy())}))) : (Predef$.MODULE$.doubleArrayOps(this.percentages()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All percentage values must be between 0.0 and 1.0 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(current = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(this.percentages()).mkString(", ")}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy or percentage provided must be a constant literal"})).s((Seq)Nil$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        DataType dataType2;
        block8: {
            block4: {
                double d;
                block6: {
                    Object value2;
                    block7: {
                        block5: {
                            value2 = this.child().eval(inputRow);
                            if (value2 == null) break block4;
                            dataType2 = this.child().dataType();
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            d = BoxesRunTime.unboxToInt((Object)value2);
                            break block6;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block7;
                        d = BoxesRunTime.unboxToLong((Object)value2);
                        break block6;
                    }
                    if (!(dataType2 instanceof NumericType)) break block8;
                    NumericType numericType = (NumericType)dataType2;
                    d = numericType.numeric().toDouble(value2);
                }
                double doubleValue = d;
                buffer.add(doubleValue);
            }
            return buffer;
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType3.simpleString()})));
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        DataType dataType2;
        block13: {
            Object object;
            block5: {
                double[] doubleResult;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                doubleResult = buffer.getPercentiles(this.percentages());
                                                dataType2 = this.child().dataType();
                                                if (!DateType$.MODULE$.equals(dataType2)) break block4;
                                                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final int apply(double x$2) {
                                                        return this.apply$mcID$sp(x$2);
                                                    }

                                                    public int apply$mcID$sp(double x$2) {
                                                        return (int)x$2;
                                                    }
                                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                                                break block5;
                                            }
                                            if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                                            object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final long apply(double x$3) {
                                                    return this.apply$mcJD$sp(x$3);
                                                }

                                                public long apply$mcJD$sp(double x$3) {
                                                    return (long)x$3;
                                                }
                                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                                            break block5;
                                        }
                                        if (!ByteType$.MODULE$.equals(dataType2)) break block7;
                                        object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final byte apply(double x$4) {
                                                return (byte)x$4;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                                        break block5;
                                    }
                                    if (!ShortType$.MODULE$.equals(dataType2)) break block8;
                                    object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final short apply(double x$5) {
                                            return (short)x$5;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
                                    break block5;
                                }
                                if (!IntegerType$.MODULE$.equals(dataType2)) break block9;
                                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(double x$6) {
                                        return this.apply$mcID$sp(x$6);
                                    }

                                    public int apply$mcID$sp(double x$6) {
                                        return (int)x$6;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                                break block5;
                            }
                            if (!LongType$.MODULE$.equals(dataType2)) break block10;
                            object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$7) {
                                    return this.apply$mcJD$sp(x$7);
                                }

                                public long apply$mcJD$sp(double x$7) {
                                    return (long)x$7;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                            break block5;
                        }
                        if (!FloatType$.MODULE$.equals(dataType2)) break block11;
                        object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final float apply(double x$8) {
                                return this.apply$mcFD$sp(x$8);
                            }

                            public float apply$mcFD$sp(double x$8) {
                                return (float)x$8;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        break block5;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block12;
                    object = doubleResult;
                    break block5;
                }
                if (!(dataType2 instanceof DecimalType)) break block13;
                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply(double x$9) {
                        return Decimal$.MODULE$.apply(x$9);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
            }
            Object result = object;
            return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType3.simpleString()})));
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$10 = newOffset;
        Expression x$11 = this.copy$default$1();
        Expression x$12 = this.copy$default$2();
        Expression x$13 = this.copy$default$3();
        int x$14 = this.copy$default$5();
        return this.copy(x$11, x$12, x$13, x$10, x$14);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$15 = newOffset;
        Expression x$16 = this.copy$default$1();
        Expression x$17 = this.copy$default$2();
        Expression x$18 = this.copy$default$3();
        int x$19 = this.copy$default$4();
        return this.copy(x$16, x$17, x$18, x$19, x$15);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes$class.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;
        private boolean isCompressed;
        private final int compressThresHoldBufferLength;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        private boolean isCompressed() {
            return this.isCompressed;
        }

        private void isCompressed_$eq(boolean x$1) {
            this.isCompressed = x$1;
        }

        public QuantileSummaries quantileSummaries() {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value2) {
            this.summaries_$eq(this.summaries().insert(value2));
            this.isCompressed_$eq(false);
            if (this.summaries().sampled().length >= this.compressThresHoldBufferLength) {
                this.compress();
            }
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
            this.isCompressed_$eq(true);
        }

        public PercentileDigest(QuantileSummaries summaries, boolean isCompressed) {
            this.summaries = summaries;
            this.isCompressed = isCompressed;
            int maxBufferLengthAfterCompression = (int)(1.0 / this.summaries().relativeError()) * 2;
            this.compressThresHoldBufferLength = maxBufferLengthAfterCompression * 2;
        }

        public PercentileDigest(double relativeError) {
            this(new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), relativeError, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4()), true);
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value2 = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value2, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count);
            return new PercentileDigest(summary, true);
        }
    }
}

