/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SolrMatchers {
    public static <T> Matcher<List<? extends T>> subListMatches(int fromIndex, int toIndex, Matcher<? super List<? super T>> subListMatcher) {
        return new SubListMatcher(fromIndex, toIndex, subListMatcher);
    }

    public static class SubListMatcher<T>
    extends TypeSafeDiagnosingMatcher<List<? extends T>> {
        private final int fromIndex;
        private final int toIndex;
        private final Matcher<? super List<T>> matchOnSubList;

        public SubListMatcher(int fromIndex, int toIndex, Matcher<? super List<? super T>> matchOnSubList) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.matchOnSubList = matchOnSubList;
        }

        public void describeTo(Description description) {
            description.appendText("sub-list from ").appendValue((Object)this.fromIndex).appendText(" to ").appendValue((Object)this.toIndex).appendText(" matching ").appendDescriptionOf(this.matchOnSubList);
        }

        protected boolean matchesSafely(List<? extends T> item, Description mismatchDescription) {
            if (item.size() < this.toIndex) {
                mismatchDescription.appendText(": expected sub-list endIndex ").appendValue((Object)this.toIndex).appendText(" greater than list size ").appendValue((Object)item.size()).appendText("\n          full-list: ").appendValue(item);
                return false;
            }
            List<? extends T> subList = item.subList(this.fromIndex, this.toIndex);
            if (!this.matchOnSubList.matches(subList)) {
                this.matchOnSubList.describeMismatch(subList, mismatchDescription);
                mismatchDescription.appendText("\n          sub-list:  ").appendValue(subList).appendText("\n          full-list: ").appendValue(item);
                return false;
            }
            return true;
        }
    }
}

