/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneTestCase.Nightly
public abstract class AbstractChaosMonkeySafeLeaderTestBase
extends AbstractFullDistribZkTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Integer RUN_LENGTH = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.runlength", "-1"));
    protected static final String[] fieldNames = new String[]{"f_i", "f_f", "f_d", "f_l", "f_dt"};
    protected static final BaseDistributedSearchTestCase.RandVal[] randVals = new BaseDistributedSearchTestCase.RandVal[]{rint, rfloat, rdouble, rlong, rdate};

    @BeforeClass
    public static void beforeSuperClass() {
        schemaString = "schema15.xml";
        System.setProperty("solr.autoCommit.maxTime", "15000");
        System.clearProperty("solr.httpclient.retries");
        System.clearProperty("solr.retries.on.forward");
        System.clearProperty("solr.retries.to.followers");
        AbstractChaosMonkeySafeLeaderTestBase.setErrorHook();
    }

    @AfterClass
    public static void afterSuperClass() {
        System.clearProperty("solr.autoCommit.maxTime");
        AbstractChaosMonkeySafeLeaderTestBase.clearErrorHook();
    }

    @Override
    public String[] getFieldNames() {
        return fieldNames;
    }

    @Override
    public BaseDistributedSearchTestCase.RandVal[] getRandValues() {
        return randVals;
    }

    protected abstract String getDirectoryFactory();

    @Override
    public void distribSetUp() throws Exception {
        AbstractChaosMonkeySafeLeaderTestBase.useFactory(this.getDirectoryFactory());
        super.distribSetUp();
    }

    public AbstractChaosMonkeySafeLeaderTestBase() {
        int numShards;
        this.sliceCount = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.slicecount", "-1"));
        if (this.sliceCount == -1) {
            this.sliceCount = AbstractChaosMonkeySafeLeaderTestBase.random().nextInt(TEST_NIGHTLY ? 5 : 3) + 1;
        }
        if ((numShards = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.shardcount", "-1"))) == -1) {
            numShards = this.sliceCount + AbstractChaosMonkeySafeLeaderTestBase.random().nextInt(TEST_NIGHTLY ? 12 : 2) + 1;
        }
        this.fixShardCount(numShards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        this.handle.clear();
        this.handle.put("timestamp", 4);
        this.randomlyEnableAutoSoftCommit();
        this.tryDelete();
        ArrayList<StoppableIndexingThread> threads = new ArrayList<StoppableIndexingThread>();
        int threadCount = 2;
        int batchSize = 1;
        if (AbstractChaosMonkeySafeLeaderTestBase.random().nextBoolean()) {
            batchSize = AbstractChaosMonkeySafeLeaderTestBase.random().nextInt(98) + 2;
        }
        boolean pauseBetweenUpdates = TEST_NIGHTLY ? AbstractChaosMonkeySafeLeaderTestBase.random().nextBoolean() : true;
        int maxUpdates = -1;
        maxUpdates = !pauseBetweenUpdates ? 1000 + AbstractChaosMonkeySafeLeaderTestBase.random().nextInt(1000) : 15000;
        for (int i = 0; i < threadCount; ++i) {
            StoppableIndexingThread indexThread = new StoppableIndexingThread(this.controlClient, (SolrClient)this.cloudClient, Integer.toString(i), true, maxUpdates, batchSize, pauseBetweenUpdates);
            threads.add(indexThread);
            indexThread.start();
        }
        this.chaosMonkey.startTheMonkey(false, 500);
        try {
            long runLength;
            if (RUN_LENGTH != -1) {
                runLength = RUN_LENGTH.intValue();
            } else {
                int[] runTimes = TEST_NIGHTLY ? new int[]{5000, 6000, 10000, 15000, 25000, 30000, 30000, 45000, 90000, 120000} : new int[]{5000, 7000, 15000};
                runLength = runTimes[AbstractChaosMonkeySafeLeaderTestBase.random().nextInt(runTimes.length - 1)];
            }
            Thread.sleep(runLength);
        }
        finally {
            this.chaosMonkey.stopTheMonkey();
        }
        for (StoppableIndexingThread indexThread : threads) {
            indexThread.safeStop();
        }
        for (StoppableIndexingThread indexThread : threads) {
            indexThread.join();
        }
        for (StoppableIndexingThread indexThread : threads) {
            AbstractChaosMonkeySafeLeaderTestBase.assertEquals((long)0L, (long)indexThread.getFailCount());
        }
        Thread.sleep(2000L);
        this.waitForThingsToLevelOut(3, TimeUnit.MINUTES);
        Thread.sleep(3000L);
        this.waitForThingsToLevelOut(3, TimeUnit.MINUTES);
        this.checkShardConsistency(batchSize == 1, true);
        if (VERBOSE) {
            System.out.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        if (AbstractChaosMonkeySafeLeaderTestBase.random().nextBoolean()) {
            this.zkServer.shutdown();
            this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
            this.zkServer.run(false);
        }
        try (CloudSolrClient client = this.createCloudClient("collection1");){
            this.createCollection(null, "testcollection", 1, 1, (SolrClient)client, null, "conf1");
        }
        ArrayList<Integer> numShardsNumReplicas = new ArrayList<Integer>(2);
        numShardsNumReplicas.add(1);
        numShardsNumReplicas.add(1);
        this.checkForCollection("testcollection", numShardsNumReplicas);
    }

    private void tryDelete() throws Exception {
        long start = System.nanoTime();
        long timeout = start + TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        while (System.nanoTime() < timeout) {
            try {
                this.del("*:*");
                break;
            }
            catch (SolrServerException e) {
                log.error("cluster may not be up yet", (Throwable)e);
                Thread.sleep(100L);
            }
        }
    }

    @Override
    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        AbstractChaosMonkeySafeLeaderTestBase.addFields(doc, fields);
        AbstractChaosMonkeySafeLeaderTestBase.addFields(doc, "rnd_b", true);
        this.indexDoc(doc);
    }
}

