/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.embedded.JettySolrRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCloudAuthTestCase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> AUTH_METRICS_KEYS = Arrays.asList("errors", "requests", "authenticated", "passThrough", "failWrongCredentials", "failMissingCredentials", "requestTimes", "totalTime");
    private static final List<String> AUTH_METRICS_METER_KEYS = Arrays.asList("errors", "count");
    private static final List<String> AUTH_METRICS_TIMER_KEYS = Collections.singletonList("requestTimes");
    private static final String METRICS_PREFIX_PKI = "SECURITY./authentication/pki.";
    private static final String METRICS_PREFIX = "SECURITY./authentication.";
    public static final Predicate NOT_NULL_PREDICATE = o -> o != null;
    private static final List<String> AUDIT_METRICS_KEYS = Arrays.asList("count");
    private static final List<String> AUTH_METRICS_TO_COMPARE = Arrays.asList("requests", "authenticated", "passThrough", "failWrongCredentials", "failMissingCredentials", "errors");
    private static final List<String> AUDIT_METRICS_TO_COMPARE = Arrays.asList("count");

    @BeforeClass
    public static void enableMetrics() {
        System.setProperty("metricsEnabled", "true");
    }

    @AfterClass
    public static void disableMetrics() {
        System.clearProperty("metricsEnabled");
    }

    protected void assertPkiAuthMetricsMinimums(int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) throws InterruptedException {
        this.assertAuthMetricsMinimums(METRICS_PREFIX_PKI, requests, authenticated, passThrough, failWrongCredentials, failMissingCredentials, errors);
    }

    protected void assertAuthMetricsMinimums(int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) throws InterruptedException {
        this.assertAuthMetricsMinimums(METRICS_PREFIX, requests, authenticated, passThrough, failWrongCredentials, failMissingCredentials, errors);
    }

    Map<String, Long> countSecurityMetrics(MiniSolrCloudCluster cluster, String prefix, List<String> keys) {
        ArrayList metrics = new ArrayList();
        cluster.getJettySolrRunners().forEach(r -> {
            MetricRegistry registry = r.getCoreContainer().getMetricManager().registry("solr.node");
            SolrCloudAuthTestCase.assertNotNull((Object)registry);
            metrics.add(registry.getMetrics());
        });
        HashMap<String, Long> counts = new HashMap<String, Long>();
        keys.forEach(k -> counts.put((String)k, this.sumCount(prefix, (String)k, metrics)));
        return counts;
    }

    private void assertAuthMetricsMinimums(String prefix, int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) throws InterruptedException {
        HashMap<String, Long> expectedCounts = new HashMap<String, Long>();
        expectedCounts.put("requests", Long.valueOf(requests));
        expectedCounts.put("authenticated", Long.valueOf(authenticated));
        expectedCounts.put("passThrough", Long.valueOf(passThrough));
        expectedCounts.put("failWrongCredentials", Long.valueOf(failWrongCredentials));
        expectedCounts.put("failMissingCredentials", Long.valueOf(failMissingCredentials));
        expectedCounts.put("errors", Long.valueOf(errors));
        Map<String, Long> counts = this.countSecurityMetrics(cluster, prefix, AUTH_METRICS_KEYS);
        boolean success = this.isMetricsEqualOrLarger(AUTH_METRICS_TO_COMPARE, expectedCounts, counts);
        SolrCloudAuthTestCase.assertTrue((String)("Expected metric minimums for prefix " + prefix + ": " + expectedCounts + ", but got: " + counts + "(Possible cause is delay in loading modified security.json; see SOLR-13464 for test work around)"), (boolean)success);
        if (counts.get("requests") > 0L) {
            SolrCloudAuthTestCase.assertTrue((String)"requestTimes count not > 1", (counts.get("requestTimes") > 1L ? 1 : 0) != 0);
            SolrCloudAuthTestCase.assertTrue((String)"totalTime not > 0", (counts.get("totalTime") > 0L ? 1 : 0) != 0);
        }
    }

    protected void assertAuditMetricsMinimums(MiniSolrCloudCluster cluster, String className, int count, int errors) throws InterruptedException {
        String prefix = "SECURITY./auditlogging." + className + ".";
        HashMap<String, Long> expectedCounts = new HashMap<String, Long>();
        expectedCounts.put("count", Long.valueOf(count));
        Map<String, Long> counts = this.countSecurityMetrics(cluster, prefix, AUDIT_METRICS_KEYS);
        boolean success = this.isMetricsEqualOrLarger(AUDIT_METRICS_TO_COMPARE, expectedCounts, counts);
        if (!success) {
            log.info("First metrics count assert failed, pausing 2s before re-attempt");
            Thread.sleep(2000L);
            counts = this.countSecurityMetrics(cluster, prefix, AUDIT_METRICS_KEYS);
            success = this.isMetricsEqualOrLarger(AUDIT_METRICS_TO_COMPARE, expectedCounts, counts);
        }
        SolrCloudAuthTestCase.assertTrue((String)("Expected metric minimums for prefix " + prefix + ": " + expectedCounts + ", but got: " + counts), (boolean)success);
    }

    private boolean isMetricsEqualOrLarger(List<String> metricsToCompare, Map<String, Long> expectedCounts, Map<String, Long> actualCounts) {
        return metricsToCompare.stream().allMatch(k -> ((Long)actualCounts.get(k)).intValue() >= ((Long)expectedCounts.get(k)).intValue());
    }

    private long sumCount(String prefix, String key, List<Map<String, Metric>> metrics) {
        SolrCloudAuthTestCase.assertTrue((String)("Metric " + prefix + key + " does not exist"), (boolean)metrics.get(0).containsKey(prefix + key));
        if (AUTH_METRICS_METER_KEYS.contains(key)) {
            return metrics.stream().mapToLong(l -> ((Meter)l.get(prefix + key)).getCount()).sum();
        }
        if (AUTH_METRICS_TIMER_KEYS.contains(key)) {
            return (long)(1000.0 * metrics.stream().mapToDouble(l -> ((Timer)l.get(prefix + key)).getMeanRate()).average().orElse(0.0));
        }
        return metrics.stream().mapToLong(l -> ((Counter)l.get(prefix + key)).getCount()).sum();
    }

    public static void verifySecurityStatus(HttpClient cl, String url, String objPath, Object expected, int count) throws Exception {
        SolrCloudAuthTestCase.verifySecurityStatus(cl, url, objPath, expected, count, null);
    }

    public static void verifySecurityStatus(HttpClient cl, String url, String objPath, Object expected, int count, String user, String pwd) throws Exception {
        SolrCloudAuthTestCase.verifySecurityStatus(cl, url, objPath, expected, count, SolrCloudAuthTestCase.makeBasicAuthHeader(user, pwd));
    }

    protected static void verifySecurityStatus(HttpClient cl, String url, String objPath, Object expected, int count, String authHeader) throws IOException, InterruptedException {
        boolean success = false;
        String s = null;
        List hierarchy = StrUtils.splitSmart((String)objPath, (char)'/');
        for (int i = 0; i < count; ++i) {
            HttpGet get = new HttpGet(url);
            if (authHeader != null) {
                SolrCloudAuthTestCase.setAuthorizationHeader((AbstractHttpMessage)get, authHeader);
            }
            HttpResponse rsp = cl.execute((HttpUriRequest)get);
            s = EntityUtils.toString((HttpEntity)rsp.getEntity());
            Map m = null;
            try {
                m = (Map)Utils.fromJSONString((String)s);
            }
            catch (Exception e) {
                SolrCloudAuthTestCase.fail((String)("Invalid json " + s));
            }
            Utils.consumeFully((HttpEntity)rsp.getEntity());
            Object actual = Utils.getObjectByPath((Object)m, (boolean)true, (List)hierarchy);
            if (expected instanceof Predicate) {
                Predicate predicate = (Predicate)expected;
                if (predicate.test(actual)) {
                    success = true;
                    break;
                }
            } else if (Objects.equals(actual == null ? null : String.valueOf(actual), expected)) {
                success = true;
                break;
            }
            Thread.sleep(50L);
        }
        SolrCloudAuthTestCase.assertTrue((String)("No match for " + objPath + " = " + expected + ", full response = " + s), (boolean)success);
    }

    protected static String makeBasicAuthHeader(String user, String pwd) {
        String userPass = user + ":" + pwd;
        return "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
    }

    public static void setAuthorizationHeader(AbstractHttpMessage httpMsg, String headerString) {
        httpMsg.setHeader((Header)new BasicHeader("Authorization", headerString));
        log.info("Added Authorization Header {}", (Object)headerString);
    }

    public static Map<String, Object> getAuthPluginsInUseForCluster(String url) {
        HashMap<String, Object> plugins = new HashMap<String, Object>();
        if (url.endsWith("authentication")) {
            for (JettySolrRunner r : cluster.getJettySolrRunners()) {
                plugins.put(r.getNodeName(), r.getCoreContainer().getAuthenticationPlugin());
            }
        } else if (url.endsWith("authorization")) {
            for (JettySolrRunner r : cluster.getJettySolrRunners()) {
                plugins.put(r.getNodeName(), r.getCoreContainer().getAuthorizationPlugin());
            }
        } else {
            SolrCloudAuthTestCase.fail((String)("Test helper method assumptions broken: " + url));
        }
        return plugins;
    }
}

