/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.junit.Test;

public abstract class AbstractBackupRepositoryTest
extends SolrTestCaseJ4 {
    protected abstract BackupRepository getRepository();

    protected abstract URI getBaseUri() throws URISyntaxException;

    protected NamedList<Object> getBaseBackupRepositoryConfiguration() {
        return new NamedList();
    }

    @Test
    public void testCanReadProvidedConfigValues() throws Exception {
        NamedList<Object> config = this.getBaseBackupRepositoryConfiguration();
        config.add("configKey1", (Object)"configVal1");
        config.add("configKey2", (Object)"configVal2");
        config.add("location", (Object)"foo");
        try (BackupRepository repo = this.getRepository();){
            repo.init(config);
            AbstractBackupRepositoryTest.assertEquals((Object)"configVal1", (Object)repo.getConfigProperty("configKey1"));
            AbstractBackupRepositoryTest.assertEquals((Object)"configVal2", (Object)repo.getConfigProperty("configKey2"));
        }
    }

    @Test
    public void testCanChooseDefaultOrOverrideLocationValue() throws Exception {
        NamedList<Object> config = this.getBaseBackupRepositoryConfiguration();
        config.add("location", (Object)"someLocation");
        try (BackupRepository repo = this.getRepository();){
            repo.init(config);
            AbstractBackupRepositoryTest.assertEquals((Object)"someLocation", (Object)repo.getBackupLocation(null));
            AbstractBackupRepositoryTest.assertEquals((Object)"someOverridingLocation", (Object)repo.getBackupLocation("someOverridingLocation"));
        }
    }

    @Test
    public void testCanDetermineWhetherFilesAndDirectoriesExist() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI emptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"emptyDir/"});
            URI nonEmptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"nonEmptyDir/"});
            URI nestedFileUri = repo.resolve(nonEmptyDirUri, new String[]{"file.txt"});
            repo.createDirectory(emptyDirUri);
            repo.createDirectory(nonEmptyDirUri);
            this.addFile(repo, nestedFileUri);
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(emptyDirUri));
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(nonEmptyDirUri));
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(nestedFileUri));
            URI nonexistedDirUri = repo.resolve(this.getBaseUri(), new String[]{"nonexistentDir/"});
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(nonexistedDirUri));
        }
    }

    @Test
    public void testCanDistinguishBetweenFilesAndDirectories() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI emptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"emptyDir/"});
            URI nonEmptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"nonEmptyDir/"});
            URI nestedFileUri = repo.resolve(nonEmptyDirUri, new String[]{"file.txt"});
            repo.createDirectory(emptyDirUri);
            repo.createDirectory(nonEmptyDirUri);
            this.addFile(repo, nestedFileUri);
            AbstractBackupRepositoryTest.assertEquals((Object)BackupRepository.PathType.DIRECTORY, (Object)repo.getPathType(emptyDirUri));
            AbstractBackupRepositoryTest.assertEquals((Object)BackupRepository.PathType.DIRECTORY, (Object)repo.getPathType(nonEmptyDirUri));
            AbstractBackupRepositoryTest.assertEquals((Object)BackupRepository.PathType.FILE, (Object)repo.getPathType(nestedFileUri));
        }
    }

    @Test
    public void testArbitraryFileDataCanBeStoredAndRetrieved() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI fileUri = repo.resolve(this.getBaseUri(), new String[]{"file.txt"});
            byte[] storedBytes = new byte[]{104, 101, 108, 108, 111};
            try (OutputStream os = repo.createOutput(fileUri);){
                os.write(storedBytes);
            }
            int expectedNumBytes = storedBytes.length;
            byte[] retrievedBytes = new byte[expectedNumBytes];
            try (IndexInput is = repo.openInput(this.getBaseUri(), "file.txt", new IOContext(IOContext.Context.READ));){
                AbstractBackupRepositoryTest.assertEquals((long)expectedNumBytes, (long)is.length());
                is.readBytes(retrievedBytes, 0, expectedNumBytes);
            }
            AbstractBackupRepositoryTest.assertArrayEquals((byte[])storedBytes, (byte[])retrievedBytes);
        }
    }

    @Test
    public void testCanDeleteEmptyOrFullDirectories() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI emptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"emptyDir"});
            URI nonEmptyDirUri = repo.resolve(this.getBaseUri(), new String[]{"nonEmptyDir"});
            URI fileUri = repo.resolve(nonEmptyDirUri, new String[]{"file.txt"});
            repo.createDirectory(emptyDirUri);
            repo.createDirectory(nonEmptyDirUri);
            this.addFile(repo, fileUri);
            repo.deleteDirectory(emptyDirUri);
            repo.deleteDirectory(nonEmptyDirUri);
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(emptyDirUri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(nonEmptyDirUri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(fileUri));
            URI level1DeeplyNestedUri = repo.resolve(this.getBaseUri(), new String[]{"nest1/"});
            URI level2DeeplyNestedUri = repo.resolve(level1DeeplyNestedUri, new String[]{"nest2/"});
            URI level3DeeplyNestedUri = repo.resolve(level2DeeplyNestedUri, new String[]{"nest3/"});
            URI level4DeeplyNestedUri = repo.resolve(level3DeeplyNestedUri, new String[]{"nest4/"});
            repo.createDirectory(level1DeeplyNestedUri);
            repo.createDirectory(level2DeeplyNestedUri);
            repo.createDirectory(level3DeeplyNestedUri);
            repo.createDirectory(level4DeeplyNestedUri);
            repo.deleteDirectory(level3DeeplyNestedUri);
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(level1DeeplyNestedUri));
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(level2DeeplyNestedUri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(level3DeeplyNestedUri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(level4DeeplyNestedUri));
        }
    }

    @Test
    public void testDirectoryCreationFailsIfParentDoesntExist() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI nonExistentParentUri = repo.resolve(this.getBaseUri(), new String[]{"nonExistentParent"});
            URI nestedUri = repo.resolve(nonExistentParentUri, new String[]{"childDirectoryToCreate"});
            repo.createDirectory(nestedUri);
        }
    }

    @Test
    public void testCanDeleteIndividualFiles() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI file1Uri = repo.resolve(this.getBaseUri(), new String[]{"file1.txt"});
            URI file2Uri = repo.resolve(this.getBaseUri(), new String[]{"file2.txt"});
            URI file3Uri = repo.resolve(this.getBaseUri(), new String[]{"file3.txt"});
            this.addFile(repo, file1Uri);
            this.addFile(repo, file2Uri);
            this.addFile(repo, file3Uri);
            URI nonexistentFileUri = repo.resolve(this.getBaseUri(), new String[]{"file4.txt"});
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(nonexistentFileUri));
            repo.delete(this.getBaseUri(), List.of("file4.txt"));
            repo.delete(this.getBaseUri(), List.of("file1.txt"));
            repo.delete(this.getBaseUri(), List.of("file2.txt", "file3.txt"));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(file1Uri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(file2Uri));
            AbstractBackupRepositoryTest.assertFalse((boolean)repo.exists(file3Uri));
        }
    }

    @Test
    public void testCanListFullOrEmptyDirectories() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            URI rootUri = repo.resolve(this.getBaseUri(), new String[]{"containsOtherDirs"});
            URI otherDir1Uri = repo.resolve(rootUri, new String[]{"otherDir1"});
            URI otherDir2Uri = repo.resolve(rootUri, new String[]{"otherDir2"});
            URI otherDir3Uri = repo.resolve(rootUri, new String[]{"otherDir3"});
            URI file1Uri = repo.resolve(otherDir3Uri, new String[]{"file1.txt"});
            URI file2Uri = repo.resolve(otherDir3Uri, new String[]{"file2.txt"});
            repo.createDirectory(rootUri);
            repo.createDirectory(otherDir1Uri);
            repo.createDirectory(otherDir2Uri);
            repo.createDirectory(otherDir3Uri);
            this.addFile(repo, file1Uri);
            this.addFile(repo, file2Uri);
            List<String> rootChildren = List.of(repo.listAll(rootUri));
            AbstractBackupRepositoryTest.assertEquals((long)3L, (long)rootChildren.size());
            AbstractBackupRepositoryTest.assertTrue((boolean)rootChildren.contains("otherDir1"));
            AbstractBackupRepositoryTest.assertTrue((boolean)rootChildren.contains("otherDir2"));
            AbstractBackupRepositoryTest.assertTrue((boolean)rootChildren.contains("otherDir3"));
            String[] otherDir2Children = repo.listAll(otherDir2Uri);
            AbstractBackupRepositoryTest.assertEquals((long)0L, (long)otherDir2Children.length);
            List<String> otherDir3Children = List.of(repo.listAll(otherDir3Uri));
            AbstractBackupRepositoryTest.assertEquals((long)2L, (long)otherDir3Children.size());
            AbstractBackupRepositoryTest.assertTrue((boolean)otherDir3Children.contains("file1.txt"));
            AbstractBackupRepositoryTest.assertTrue((boolean)otherDir3Children.contains("file2.txt"));
        }
    }

    @Test
    public void testDirectoryExistsWithDirectoryUri() throws Exception {
        try (BackupRepository repo = this.getRepository();){
            repo.createDirectory(this.getBaseUri());
            AbstractBackupRepositoryTest.assertTrue((boolean)repo.exists(repo.createDirectoryURI(this.getBaseUri().toString())));
        }
    }

    private void addFile(BackupRepository repo, URI file) throws IOException {
        try (OutputStream os = repo.createOutput(file);){
            os.write(100);
            os.write(101);
            os.write(102);
        }
    }
}

