/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.io.file.PathUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.SolrJettyTestRule;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.ClassRule;

@Deprecated
public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    @ClassRule
    public static SolrJettyTestRule solrClientTestRule = new SolrJettyTestRule();

    protected static JettySolrRunner createAndStartJetty(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        context = context == null ? "/solr" : context;
        JettyConfig jettyConfig = JettyConfig.builder().setContext(context).stopAtShutdown(stopAtShutdown).withServlets(extraServlets).withSSLConfig(sslConfig.buildServerSSLConfig()).build();
        Properties nodeProps = new Properties();
        if (configFile != null) {
            nodeProps.setProperty("solrconfig", configFile);
        }
        if (schemaFile != null) {
            nodeProps.setProperty("schema", schemaFile);
        }
        if (System.getProperty("solr.data.dir") == null && System.getProperty("solr.hdfs.home") == null) {
            nodeProps.setProperty("solr.data.dir", SolrJettyTestBase.createTempDir().toFile().getCanonicalPath());
        }
        return SolrJettyTestBase.createAndStartJetty(solrHome, nodeProps, jettyConfig);
    }

    protected static JettySolrRunner createAndStartJetty(String solrHome, String configFile, String context) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, configFile, null, context, true, null);
    }

    protected static JettySolrRunner createAndStartJetty(String solrHome, JettyConfig jettyConfig) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, new Properties(), jettyConfig);
    }

    protected static JettySolrRunner createAndStartJetty(String solrHome) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, new Properties(), JettyConfig.builder().withSSLConfig(sslConfig.buildServerSSLConfig()).build());
    }

    protected static JettySolrRunner createAndStartJetty(String solrHome, Properties nodeProperties, JettyConfig jettyConfig) throws Exception {
        Path coresDir = SolrJettyTestBase.createTempDir().resolve("cores");
        Properties props = new Properties();
        props.setProperty("name", "collection1");
        props.setProperty("configSet", "collection1");
        props.setProperty("config", "${solrconfig:solrconfig.xml}");
        props.setProperty("schema", "${schema:schema.xml}");
        SolrJettyTestBase.writeCoreProperties(coresDir.resolve("core"), props, "RestTestBase");
        Properties nodeProps = new Properties(nodeProperties);
        nodeProps.setProperty("coreRootDirectory", coresDir.toString());
        nodeProps.setProperty("configSetBaseDir", solrHome);
        solrClientTestRule.startSolr(Path.of(solrHome, new String[0]), nodeProps, jettyConfig);
        return SolrJettyTestBase.getJetty();
    }

    protected static JettySolrRunner getJetty() {
        return solrClientTestRule.getJetty();
    }

    protected static String getBaseUrl() {
        return solrClientTestRule.getBaseUrl();
    }

    protected static String getCoreUrl() {
        return SolrJettyTestBase.getBaseUrl() + "/collection1";
    }

    protected SolrClient getSolrClient() {
        return solrClientTestRule.getSolrClient();
    }

    public SolrClient createNewSolrClient() {
        return new HttpSolrClient.Builder(SolrJettyTestBase.getCoreUrl()).build();
    }

    protected HttpClient getHttpClient() {
        HttpSolrClient client = (HttpSolrClient)this.getSolrClient();
        return client.getHttpClient();
    }

    @Deprecated
    protected static void setupJettyTestHome(File solrHome, String collection) throws Exception {
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        SolrJettyTestBase.copySolrHomeToTemp(solrHome, collection);
    }

    protected static void cleanUpJettyHome(File solrHome) throws Exception {
        if (solrHome.exists()) {
            PathUtils.deleteDirectory((Path)solrHome.toPath());
        }
    }
}

