/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.solr.common.util.SuppressForbidden;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden(reason="We need to use log4J2 classes directly")
public final class LogListener
implements Closeable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final LoggerContext CTX = LoggerContext.getContext((boolean)false);
    private static final AtomicInteger ID_GEN = new AtomicInteger(0);
    private final String name;
    private final String loggerName;
    private final boolean removeLoggerConfigWhenDone;
    private final Level resetLevelWhenDone;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MutablePredicateFilter filter;
    private final QueueAppender loggerAppender;

    private static String createName(Level level) {
        return MethodHandles.lookup().lookupClass().getSimpleName() + "-" + String.valueOf(level) + "-" + ID_GEN.incrementAndGet();
    }

    public static LogListener error() {
        return LogListener.error("");
    }

    public static LogListener error(Class<?> logger) {
        return LogListener.error(logger.getName());
    }

    public static LogListener error(String logger) {
        return LogListener.create(Level.ERROR, logger);
    }

    public static LogListener warn() {
        return LogListener.warn("");
    }

    public static LogListener warn(Class<?> logger) {
        return LogListener.warn(logger.getName());
    }

    public static LogListener warn(String logger) {
        return LogListener.create(Level.WARN, logger);
    }

    public static LogListener info() {
        return LogListener.info("");
    }

    public static LogListener info(Class<?> logger) {
        return LogListener.info(logger.getName());
    }

    public static LogListener info(String logger) {
        return LogListener.create(Level.INFO, logger);
    }

    public static LogListener debug() {
        return LogListener.debug("");
    }

    public static LogListener debug(Class<?> logger) {
        return LogListener.debug(logger.getName());
    }

    public static LogListener debug(String logger) {
        return LogListener.create(Level.DEBUG, logger);
    }

    private static LogListener create(Level level, String logger) {
        String name = LogListener.createName(level);
        log.info("Creating {} for log messages from: {}", (Object)name, (Object)logger);
        return new LogListener(name, logger, level);
    }

    private LogListener(String name, String loggerName, Level level) {
        assert (null != name);
        assert (null != loggerName);
        assert (null != level);
        this.name = name;
        this.loggerName = loggerName;
        Configuration config = CTX.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        boolean bl = this.removeLoggerConfigWhenDone = !loggerName.equals(loggerConfig.getName());
        if (this.removeLoggerConfigWhenDone) {
            loggerConfig = new LoggerConfig(loggerName, null, true);
            config.addLogger(loggerName, loggerConfig);
        }
        Level level2 = this.resetLevelWhenDone = loggerConfig.getLevel().intLevel() < level.intLevel() ? loggerConfig.getLevel() : null;
        if (null != this.resetLevelWhenDone) {
            log.info("{} (temporarily) increasing level of {} to {} in order to record matching logs", new Object[]{this.name, this.loggerName, level});
            loggerConfig.setLevel(level);
        }
        this.filter = new MutablePredicateFilter(level);
        this.loggerAppender = new QueueAppender(name);
        loggerConfig.addAppender((Appender)this.loggerAppender, level, (Filter)this.filter);
        CTX.updateLoggers();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            LoggerConfig loggerConfig = CTX.getConfiguration().getLoggerConfig(this.loggerName);
            loggerConfig.removeAppender(this.loggerAppender.getName());
            if (null != this.resetLevelWhenDone) {
                loggerConfig.setLevel(this.resetLevelWhenDone);
            }
            if (this.removeLoggerConfigWhenDone) {
                CTX.getConfiguration().removeLogger(this.loggerName);
            }
            if (log.isInfoEnabled()) {
                log.info("Closing {} after recording {} log messages", (Object)this.name, (Object)this.getCount());
            }
            Assert.assertEquals((String)(this.name + " processed log events that it could not record beause queue capacity was exceeded"), (long)0L, (long)this.loggerAppender.getNumCapacityExceeded());
            Assert.assertEquals((String)(this.name + " recorded log events which were not expected & removed from the queue by the test code"), (long)0L, (long)this.loggerAppender.getQueue().size());
        }
    }

    public LogListener setQueue(BlockingQueue<LogEvent> queue) {
        this.loggerAppender.setQueue(queue);
        return this;
    }

    public void clearQueue() {
        this.loggerAppender.getQueue().clear();
    }

    public LogListener substring(String substr) {
        this.setPredicate(str -> str.contains(substr));
        return this;
    }

    public LogListener regex(Pattern pat) {
        this.setPredicate(str -> pat.matcher((CharSequence)str).find());
        return this;
    }

    public LogListener regex(String regex) {
        return this.regex(Pattern.compile(regex));
    }

    private void setPredicate(Predicate<String> predicate) {
        if (!this.filter.predicate.compareAndSet(null, predicate)) {
            throw new IllegalStateException("At most one method to set a message predicate can be called on a LogListener");
        }
    }

    public BlockingQueue<LogEvent> getQueue() {
        return this.loggerAppender.getQueue();
    }

    public String pollMessage() {
        LogEvent event = (LogEvent)this.getQueue().poll();
        return null == event ? null : event.getMessage().getFormattedMessage();
    }

    public String pollMessage(long timeout, TimeUnit unit) {
        LogEvent event = null;
        try {
            event = this.getQueue().poll(timeout, unit);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Assert.fail((String)"Our thread was interrupted while polling the queue.");
        }
        return null == event ? null : event.getMessage().getFormattedMessage();
    }

    public int getCount() {
        return this.loggerAppender.getCount();
    }

    @SuppressForbidden(reason="We need to use log4J2 classes directly")
    private static final class QueueAppender
    extends AbstractAppender {
        private final AtomicReference<BlockingQueue<LogEvent>> queue = new AtomicReference(new ArrayBlockingQueue(100));
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger capacityExceeded = new AtomicInteger(0);

        public QueueAppender(String name) {
            super(name, null, null, true, Property.EMPTY_ARRAY);
            assert (null != name);
            this.start();
        }

        public void append(LogEvent event) {
            BlockingQueue<LogEvent> q = this.queue.get();
            LogEvent memento = event instanceof MutableLogEvent ? ((MutableLogEvent)event).createMemento() : event;
            int currentCount = this.count.incrementAndGet();
            if (q.offer(memento)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} recorded a log event (#{}; currentSize={})", new Object[]{this.getName(), currentCount, q.size()});
                }
            } else {
                int currentCapacityExceeded = this.capacityExceeded.incrementAndGet();
                if (log.isErrorEnabled()) {
                    log.error("{} processed a log event which exceeded capacity and could not be recorded (#{}; currentSize={}; numTimesCapacityExceeded={})", new Object[]{this.getName(), currentCount, q.size(), currentCapacityExceeded});
                }
            }
        }

        public int getCount() {
            return this.count.get();
        }

        public int getNumCapacityExceeded() {
            return this.capacityExceeded.get();
        }

        public void setQueue(BlockingQueue<LogEvent> q) {
            assert (null != q);
            this.queue.set(q);
        }

        public BlockingQueue<LogEvent> getQueue() {
            return this.queue.get();
        }
    }

    @SuppressForbidden(reason="We need to use log4J2 classes directly")
    private static final class MutablePredicateFilter
    extends AbstractFilter {
        public final AtomicReference<Predicate<String>> predicate = new AtomicReference<Object>(null);
        final Level level;

        public MutablePredicateFilter(Level level) {
            super(Filter.Result.ACCEPT, Filter.Result.DENY);
            assert (null != level);
            this.level = level;
        }

        private Filter.Result doFilter(Level level, String msg, Throwable throwable) {
            if (level.equals((Object)this.level)) {
                Predicate<String> pred = this.predicate.get();
                if (null == pred) {
                    return this.getOnMatch();
                }
                if (null != msg && pred.test(msg)) {
                    return this.getOnMatch();
                }
                for (Throwable t = throwable; null != t; t = t.getCause()) {
                    if (!pred.test(t.toString())) continue;
                    return this.getOnMatch();
                }
            }
            return this.getOnMismatch();
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.doFilter(level, null == msg ? null : msg.toString(), t);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.doFilter(level, msg.getFormattedMessage(), t);
        }

        public Filter.Result filter(LogEvent event) {
            return this.doFilter(event.getLevel(), event.getMessage().getFormattedMessage(), event.getThrown());
        }
    }
}

