/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.embedded;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.index.DirectoryReader;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.cloud.SocketProxy;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.servlet.CoreContainerProvider;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.util.TimeOut;
import org.apache.solr.util.configuration.SSLConfigurationsFactory;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewritePatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.noggit.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JettySolrRunner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int THREAD_POOL_MAX_THREADS = 10000;
    private static final int THREAD_POOL_MAX_IDLE_TIME_MS = 260000;
    private Server server;
    volatile FilterHolder dispatchFilter;
    volatile FilterHolder debugFilter;
    private boolean waitOnSolr = false;
    private int jettyPort = -1;
    private final JettyConfig config;
    private final String solrHome;
    private final Properties nodeProperties;
    private volatile boolean startedBefore = false;
    private List<FilterHolder> extraFilters;
    private static final String excludePatterns = "/partials/.+,/libs/.+,/css/.+,/js/.+,/img/.+,/templates/.+";
    private int proxyPort = -1;
    private final boolean enableProxy;
    private SocketProxy proxy;
    private String protocol;
    private String host;
    private volatile boolean started = false;

    public JettySolrRunner(String solrHome, String context, int port) {
        this(solrHome, JettyConfig.builder().setContext(context).setPort(port).build());
    }

    public JettySolrRunner(String solrHome, JettyConfig config) {
        this(solrHome, new Properties(), config);
    }

    public JettySolrRunner(String solrHome, Properties nodeProperties, JettyConfig config) {
        this(solrHome, nodeProperties, config, false);
    }

    public JettySolrRunner(String solrHome, Properties nodeProperties, JettyConfig config, boolean enableProxy) {
        this.enableProxy = enableProxy;
        this.solrHome = solrHome;
        this.config = config;
        this.nodeProperties = nodeProperties;
        if (enableProxy) {
            try {
                this.proxy = new SocketProxy(0, config.sslConfig != null && config.sslConfig.isSSLMode());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setProxyPort(this.proxy.getListenPort());
        }
        this.init(this.config.port);
    }

    private void init(int port) {
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMaxThreads(10000);
        qtp.setIdleTimeout(260000);
        qtp.setReservedThreads(0);
        this.server = new Server((ThreadPool)qtp);
        this.server.manage((Object)qtp);
        this.server.setStopAtShutdown(this.config.stopAtShutdown);
        if (System.getProperty("jetty.testMode") != null) {
            Object connector;
            SslContextFactory.Server sslcontext = SSLConfig.createContextFactory((SSLConfig)this.config.sslConfig);
            HttpConfiguration configuration = new HttpConfiguration();
            if (sslcontext != null) {
                configuration.setSecureScheme("https");
                SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer(false);
                sslcontext.setSniRequired(false);
                secureRequestCustomizer.setSniHostCheck(false);
                configuration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
                HttpConnectionFactory http1ConnectionFactory = new HttpConnectionFactory(configuration);
                if (this.config.onlyHttp1) {
                    connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslcontext, http1ConnectionFactory.getProtocol()), http1ConnectionFactory});
                } else {
                    sslcontext.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    connector = new ServerConnector(this.server);
                    SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslcontext, "alpn");
                    connector.addConnectionFactory((ConnectionFactory)sslConnectionFactory);
                    connector.setDefaultProtocol(sslConnectionFactory.getProtocol());
                    HTTP2ServerConnectionFactory http2ConnectionFactory = new HTTP2ServerConnectionFactory(configuration);
                    ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[]{http2ConnectionFactory.getProtocol(), http1ConnectionFactory.getProtocol()});
                    alpn.setDefaultProtocol(http1ConnectionFactory.getProtocol());
                    connector.addConnectionFactory((ConnectionFactory)alpn);
                    connector.addConnectionFactory((ConnectionFactory)http1ConnectionFactory);
                    connector.addConnectionFactory((ConnectionFactory)http2ConnectionFactory);
                }
            } else {
                connector = this.config.onlyHttp1 ? new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration)}) : new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration), new HTTP2CServerConnectionFactory(configuration)});
            }
            connector.setReuseAddress(true);
            connector.setPort(port);
            connector.setHost("127.0.0.1");
            connector.setIdleTimeout(260000L);
            this.server.setConnectors(new Connector[]{connector});
            this.server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this.server, new Random()));
        } else {
            HttpConfiguration configuration = new HttpConfiguration();
            ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration), new HTTP2CServerConnectionFactory(configuration)});
            connector.setReuseAddress(true);
            connector.setPort(port);
            connector.setHost("127.0.0.1");
            connector.setIdleTimeout(260000L);
            this.server.setConnectors(new Connector[]{connector});
        }
        final ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, this.config.context, 1);
        root.setResourceBase(".");
        root.addEventListener((EventListener)new CoreContainerProvider(){

            public void contextInitialized(ServletContextEvent event) {
                int port = JettySolrRunner.this.jettyPort = JettySolrRunner.this.getFirstConnectorPort();
                if (JettySolrRunner.this.proxyPort != -1) {
                    port = JettySolrRunner.this.proxyPort;
                }
                JettySolrRunner.this.nodeProperties.setProperty("hostPort", Integer.toString(port));
                JettySolrRunner.this.nodeProperties.setProperty("hostContext", JettySolrRunner.this.config.context);
                root.getServletContext().setAttribute("solr.properties", (Object)JettySolrRunner.this.nodeProperties);
                root.getServletContext().setAttribute("solr.solr.home", (Object)JettySolrRunner.this.solrHome);
                SSLConfigurationsFactory.current().init();
                log.info("Jetty properties: {}", (Object)JettySolrRunner.this.nodeProperties);
                super.contextInitialized(event);
            }
        });
        this.debugFilter = root.addFilter(DebugFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.extraFilters = new ArrayList<FilterHolder>();
        for (Map.Entry entry : this.config.extraFilters.entrySet()) {
            this.extraFilters.add(root.addFilter((Class)entry.getKey(), (String)entry.getValue(), EnumSet.of(DispatcherType.REQUEST)));
        }
        for (Map.Entry entry : this.config.extraServlets.entrySet()) {
            root.addServlet((ServletHolder)entry.getKey(), (String)entry.getValue());
        }
        this.dispatchFilter = root.getServletHandler().newFilterHolder(Source.EMBEDDED);
        this.dispatchFilter.setHeldClass(SolrDispatchFilter.class);
        this.dispatchFilter.setInitParameter("excludePatterns", excludePatterns);
        root.addFilter(this.dispatchFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        root.addServlet(Servlet404.class, "/");
        ServletContextHandler chain = root;
        chain = this.injectJettyHandlers((HandlerWrapper)chain);
        if (this.config.enableV2) {
            RewriteHandler rwh = new RewriteHandler();
            rwh.setHandler((Handler)chain);
            rwh.setRewriteRequestURI(true);
            rwh.setRewritePathInfo(false);
            rwh.setOriginalPathAttribute("requestedPath");
            rwh.addRule((Rule)new RewritePatternRule("/api/*", "/solr/____v2"));
            chain = rwh;
        }
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setHandler((Handler)chain);
        gzipHandler.setMinGzipSize(23);
        gzipHandler.setIncludedMethods(new String[]{"GET"});
        this.server.setHandler((Handler)gzipHandler);
        StatisticsHandler graceful = new StatisticsHandler();
        graceful.setGracefulShutdownWaitsForRequests(true);
        this.server.insertHandler((HandlerWrapper)graceful);
        this.server.setStopTimeout(15000L);
    }

    protected HandlerWrapper injectJettyHandlers(HandlerWrapper chain) {
        return chain;
    }

    public SolrDispatchFilter getSolrDispatchFilter() {
        return (SolrDispatchFilter)this.dispatchFilter.getFilter();
    }

    public CoreContainer getCoreContainer() {
        SolrDispatchFilter solrDispatchFilter = this.getSolrDispatchFilter();
        if (solrDispatchFilter == null) {
            return null;
        }
        try {
            return solrDispatchFilter.getCores();
        }
        catch (UnavailableException e) {
            return null;
        }
    }

    public String getNodeName() {
        if (this.getCoreContainer() == null) {
            return null;
        }
        return this.getCoreContainer().getZkController().getNodeName();
    }

    public boolean isRunning() {
        return this.server.isRunning() && this.dispatchFilter != null && this.dispatchFilter.isRunning();
    }

    public boolean isStopped() {
        return this.server.isStopped() && this.dispatchFilter == null || this.server.isStopped() && this.dispatchFilter.isStopped() && ((QueuedThreadPool)this.server.getThreadPool()).isStopped();
    }

    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(boolean reusePort) throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            int port = reusePort && this.jettyPort != -1 ? this.jettyPort : this.config.port;
            log.info("Start Jetty (configured port={}, binding port={})", (Object)this.config.port, (Object)port);
            if (this.startedBefore) {
                this.waitOnSolr = false;
                this.init(port);
            } else {
                this.startedBefore = true;
            }
            if (!this.server.isRunning()) {
                if (this.config.portRetryTime > 0) {
                    this.retryOnPortBindFailure(this.config.portRetryTime, port);
                } else {
                    this.server.start();
                }
            }
            assert (this.dispatchFilter.isRunning());
            if (this.config.waitForLoadingCoresToFinishMs != null && this.config.waitForLoadingCoresToFinishMs > 0L) {
                this.waitForLoadingCoresToFinish(this.config.waitForLoadingCoresToFinishMs);
            }
            this.setProtocolAndHost();
            if (this.enableProxy) {
                if (this.started) {
                    this.proxy.reopen();
                } else {
                    this.proxy.open(this.getBaseUrl().toURI());
                }
            }
        }
        finally {
            this.started = true;
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    private void setProtocolAndHost() {
        String protocol;
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new IllegalStateException("Jetty Server has no Connectors");
        }
        ServerConnector c = (ServerConnector)conns[0];
        this.protocol = protocol = c.getDefaultProtocol().toLowerCase(Locale.ROOT).startsWith("ssl") ? "https" : "http";
        this.host = c.getHost();
    }

    private void retryOnPortBindFailure(int portRetryTime, int port) throws Exception {
        TimeOut timeout = new TimeOut((long)portRetryTime, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        int tryCnt = 1;
        while (true) {
            try {
                log.info("Trying to start Jetty on port {} try number {} ...", (Object)port, (Object)(++tryCnt));
                this.server.start();
            }
            catch (IOException ioe) {
                Exception e = this.lookForBindException(ioe);
                if (e instanceof BindException) {
                    log.info("Port is in use, will try again until timeout of {}", (Object)timeout);
                    this.server.stop();
                    Thread.sleep(3000L);
                    if (!timeout.hasTimedOut()) continue;
                }
                throw e;
            }
            break;
        }
    }

    Exception lookForBindException(IOException ioe) {
        Exception e = ioe;
        while (e.getCause() != null && e != e.getCause() && !(e instanceof BindException)) {
            if (!(e.getCause() instanceof Exception) || !((e = (Exception)e.getCause()) instanceof BindException)) continue;
            return e;
        }
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            QueuedThreadPool qtp = (QueuedThreadPool)this.server.getThreadPool();
            ReservedThreadExecutor rte = (ReservedThreadExecutor)qtp.getBean(ReservedThreadExecutor.class);
            this.server.stop();
            while (!qtp.isStopped()) {
                qtp.stop();
                if (!qtp.isStopped()) continue;
                Thread.sleep(50L);
            }
            qtp.setStopTimeout(Integer.MAX_VALUE);
            qtp.stop();
            qtp.join();
            if (rte != null) {
                rte.stop();
                TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
                timeout.waitFor("Timeout waiting for reserved executor to stop.", () -> ((ReservedThreadExecutor)rte).isStopped());
            }
            do {
                try {
                    this.server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.server.isStopped());
        }
        finally {
            if (this.enableProxy) {
                this.proxy.close();
            }
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    public void outputMetrics(File outputDirectory, String fileName) throws IOException {
        if (this.getCoreContainer() != null) {
            if (outputDirectory != null) {
                Path outDir = outputDirectory.toPath();
                Files.createDirectories(outDir, new FileAttribute[0]);
            }
            SolrMetricManager metricsManager = this.getCoreContainer().getMetricManager();
            Set registryNames = metricsManager.registryNames();
            for (String registryName : registryNames) {
                MetricRegistry metricsRegisty = metricsManager.registry(registryName);
                PrintStream ps = outputDirectory == null ? new PrintStream(OutputStream.nullOutputStream(), false, StandardCharsets.UTF_8) : new PrintStream(new File(outputDirectory, registryName + "_" + fileName), StandardCharsets.UTF_8);
                try {
                    ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)metricsRegisty).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).outputTo(ps).build();
                    reporter.report();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        } else {
            throw new IllegalStateException("No CoreContainer found");
        }
    }

    public void dumpCoresInfo(PrintStream pw) throws IOException {
        if (this.getCoreContainer() != null) {
            List cores = this.getCoreContainer().getCores();
            for (SolrCore core : cores) {
                NamedList coreStatus = CoreAdminOperation.getCoreStatus((CoreContainer)this.getCoreContainer(), (String)core.getName(), (boolean)false);
                core.withSearcher(solrIndexSearcher -> {
                    SimpleOrderedMap lukeIndexInfo = LukeRequestHandler.getIndexInfo((DirectoryReader)solrIndexSearcher.getIndexReader());
                    Map indexInfoMap = coreStatus.toMap(new LinkedHashMap());
                    indexInfoMap.putAll(lukeIndexInfo.toMap(new LinkedHashMap()));
                    pw.println(JSONUtil.toJSON((Object)indexInfoMap, (int)2));
                    pw.println();
                    return null;
                });
            }
        }
    }

    private int getFirstConnectorPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return ((ServerConnector)conns[0]).getLocalPort();
    }

    public int getLocalPort() {
        return this.getLocalPort(false);
    }

    public int getLocalPort(boolean internalPort) {
        if (this.jettyPort == -1) {
            throw new IllegalStateException("You cannot get the port until this instance has started");
        }
        if (internalPort) {
            return this.jettyPort;
        }
        return this.proxyPort != -1 ? this.proxyPort : this.jettyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public URL getBaseUrl() {
        try {
            return new URI(this.protocol, null, this.host, this.jettyPort, this.config.context, null, null).toURL();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getBaseURLV2() {
        try {
            return new URI(this.protocol, null, this.host, this.jettyPort, "/api", null, null).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getProxyBaseUrl() {
        try {
            return new URI(this.protocol, null, this.host, this.getLocalPort(), this.config.context, null, null).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SolrClient newClient() {
        return new HttpSolrClient.Builder(this.getBaseUrl().toString()).build();
    }

    public SolrClient newClient(int connectionTimeoutMillis, int socketTimeoutMillis) {
        return ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.getBaseUrl().toString()).withConnectionTimeout(connectionTimeoutMillis, TimeUnit.MILLISECONDS)).withSocketTimeout(socketTimeoutMillis, TimeUnit.MILLISECONDS)).build();
    }

    public DebugFilter getDebugFilter() {
        return (DebugFilter)this.debugFilter.getFilter();
    }

    public static void main(String[] args) throws Exception {
        JettySolrRunner jetty = new JettySolrRunner(".", "/solr", 8983);
        jetty.start();
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public Properties getNodeProperties() {
        return this.nodeProperties;
    }

    private void waitForLoadingCoresToFinish(long timeoutMs) {
        CoreContainer cores;
        if (this.dispatchFilter != null) {
            SolrDispatchFilter solrFilter = (SolrDispatchFilter)this.dispatchFilter.getFilter();
            try {
                cores = solrFilter.getCores();
            }
            catch (UnavailableException e) {
                throw new IllegalStateException("The CoreContainer is unavailable!");
            }
        } else {
            throw new IllegalStateException("The dispatchFilter is not set!");
        }
        cores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public SocketProxy getProxy() {
        return this.proxy;
    }

    static class Delay {
        final AtomicInteger counter;
        final int delayValue;
        final String reason;

        public Delay(String reason, int counter, int delay) {
            this.reason = reason;
            this.counter = new AtomicInteger(counter);
            this.delayValue = delay;
        }
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }

    public static class DebugFilter
    implements Filter {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private AtomicLong nRequests = new AtomicLong();
        List<Delay> delays = new ArrayList<Delay>();

        public long getTotalRequests() {
            return this.nRequests.get();
        }

        public void addDelay(String reason, int count, int delay) {
            this.delays.add(new Delay(reason, count, delay));
        }

        public void unsetDelay() {
            this.delays.clear();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.nRequests.incrementAndGet();
            this.executeDelay();
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }

        private void executeDelay() {
            int delayMs = 0;
            for (Delay delay : this.delays) {
                log.info("Delaying {}, for reason: {}", (Object)delay.delayValue, (Object)delay.reason);
                if (delay.counter.decrementAndGet() != 0) continue;
                delayMs += delay.delayValue;
            }
            if (delayMs > 0) {
                log.info("Pausing this socket connection for {}ms...", (Object)delayMs);
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                log.info("Waking up after the delay of {}ms...", (Object)delayMs);
            }
        }
    }
}

