/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.command.FourLetterCommands;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTestServer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static Path SOLRHOME;
    public static final int TIMEOUT = 45000;
    public static final int TICK_TIME = 1000;
    protected final ZKServerMain zkServer = new ZKServerMain();
    private volatile Path zkDir;
    private volatile int clientPort;
    private volatile Thread zooThread;
    private volatile int theTickTime = 1000;
    private volatile int maxSessionTimeout = 90000;
    private volatile int minSessionTimeout = 3000;
    protected volatile SolrZkClient rootClient;
    protected volatile SolrZkClient chRootClient;
    private volatile ZKDatabase zkDb;

    public ZkTestServer(Path zkDir) throws Exception {
        this(zkDir, 0);
    }

    public ZkTestServer(Path zkDir, int port) throws KeeperException, InterruptedException {
        String limiterAction;
        this.zkDir = zkDir;
        this.clientPort = port;
        String reportAction = System.getProperty("tests.zk.violationReportAction");
        if (reportAction != null) {
            log.info("Overriding violation report action to: {}", (Object)reportAction);
            this.setViolationReportAction(LimitViolationAction.valueOf(reportAction));
        }
        if ((limiterAction = System.getProperty("tests.zk.limiterAction")) != null) {
            log.info("Overriding limiter action to: {}", (Object)limiterAction);
            this.getLimiter().setAction(LimitViolationAction.valueOf(limiterAction));
        }
        ObjectReleaseTracker.track((Object)this);
    }

    private void init(boolean solrFormat) throws Exception {
        try {
            this.rootClient = new SolrZkClient.Builder().withUrl(this.getZkHost()).withTimeout(45000, TimeUnit.MILLISECONDS).withConnTimeOut(30000, TimeUnit.MILLISECONDS).build();
        }
        catch (Exception e) {
            log.error("error making rootClient, trying one more time", (Throwable)e);
            this.rootClient = new SolrZkClient.Builder().withUrl(this.getZkHost()).withTimeout(45000, TimeUnit.MILLISECONDS).withConnTimeOut(30000, TimeUnit.MILLISECONDS).build();
        }
        if (solrFormat) {
            this.tryCleanSolrZkNode();
            this.makeSolrZkNode();
        }
        this.chRootClient = new SolrZkClient.Builder().withUrl(this.getZkAddress()).withTimeout(45000, TimeUnit.MILLISECONDS).withConnTimeOut(30000, TimeUnit.MILLISECONDS).build();
    }

    public String getZkHost() {
        String hostName = System.getProperty("hostName", "127.0.0.1");
        return hostName + ":" + this.zkServer.getLocalPort();
    }

    public String getZkAddress() {
        return this.getZkAddress("/solr");
    }

    public String getZkAddress(String chroot) {
        if (!((String)chroot).startsWith("/")) {
            chroot = "/" + (String)chroot;
        }
        return this.getZkHost() + (String)chroot;
    }

    public void ensurePathExists(String path) throws IOException {
        try (SolrZkClient client = new SolrZkClient.Builder().withUrl(this.getZkHost()).withTimeout(10000, TimeUnit.MILLISECONDS).build();){
            client.makePath(path, null, CreateMode.PERSISTENT, null, false, true, 0);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Error checking path {}", (Object)path, (Object)e);
            throw new IOException("Error checking path " + path, SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    public int getPort() {
        return this.zkServer.getLocalPort();
    }

    public void expire(long sessionId) {
        log.debug("Closing zookeeper connection for session {}", (Object)sessionId);
        Request si = new Request(null, sessionId, 0, -11, null, null);
        this.zkServer.zooKeeperServer.submitRequest(si);
    }

    public ZKDatabase getZKDatabase() {
        return this.zkServer.zooKeeperServer.getZKDatabase();
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkDb = zkDb;
        this.zkServer.zooKeeperServer.setZKDatabase(zkDb);
    }

    public void run() throws InterruptedException, IOException {
        this.run(true);
    }

    public void run(boolean solrFormat) throws InterruptedException, IOException {
        log.info("STARTING ZK TEST SERVER");
        ZkTestServer.ensureStatCommandWhitelisted();
        final AtomicReference zooError = new AtomicReference();
        try {
            if (this.zooThread != null) {
                throw new IllegalStateException("ZK TEST SERVER IS ALREADY RUNNING");
            }
            final Thread parentThread = Thread.currentThread();
            this.zooThread = new Thread("ZkTestServer Run Thread"){

                @Override
                public void run() {
                    ServerConfig config = new ServerConfig(){
                        {
                            this.setClientPort(ZkTestServer.this.clientPort);
                            this.dataDir = ZkTestServer.this.zkDir.toFile();
                            this.dataLogDir = ZkTestServer.this.zkDir.toFile();
                            this.tickTime = ZkTestServer.this.theTickTime;
                            this.maxSessionTimeout = ZkTestServer.this.maxSessionTimeout;
                            this.minSessionTimeout = ZkTestServer.this.minSessionTimeout;
                        }

                        public void setClientPort(int clientPort) {
                            this.clientPortAddress = new InetSocketAddress("127.0.0.1", clientPort);
                            log.info("client port: {}", (Object)this.clientPortAddress);
                        }
                    };
                    try {
                        ZkTestServer.this.zkServer.runFromConfig(config);
                    }
                    catch (Throwable t) {
                        zooError.set(t);
                        parentThread.interrupt();
                    }
                }
            };
            ObjectReleaseTracker.track((Object)this.zooThread);
            this.zooThread.start();
            int cnt = 0;
            int port = -1;
            try {
                port = this.getPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            while (port < 1) {
                Thread.sleep(100L);
                try {
                    port = this.getPort();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (cnt == 500) {
                    throw new RuntimeException("Could not get the port for ZooKeeper server");
                }
                ++cnt;
            }
            log.info("start zk server on port: {}", (Object)port);
            Assert.assertTrue((String)"ZK Server did not go up when expected", (boolean)ClientBase.waitForServerUp((String)this.getZkHost(), (long)30000L));
            this.init(solrFormat);
        }
        catch (Exception e) {
            RuntimeException toThrow = new RuntimeException("Could not get ZK port");
            Throwable t = (Throwable)zooError.get();
            if (t != null) {
                toThrow.initCause(t);
                toThrow.addSuppressed(e);
            } else {
                toThrow.initCause(e);
            }
            throw toThrow;
        }
    }

    /*
     * Loose catch block
     */
    public void shutdown() throws IOException, InterruptedException {
        log.info("Shutting down ZkTestServer.");
        try {
            IOUtils.closeQuietly((Closeable)this.rootClient);
            IOUtils.closeQuietly((Closeable)this.chRootClient);
        }
        finally {
            block17: {
                try {
                    this.zkServer.shutdown();
                }
                catch (Exception e) {
                    log.error("Exception shutting down ZooKeeper Test Server", (Throwable)e);
                }
                if (this.zkDb != null) {
                    this.zkDb.close();
                }
                while (true) {
                    try {
                        if (this.zooThread != null) {
                            this.zooThread.join();
                            ObjectReleaseTracker.release((Object)this.zooThread);
                        }
                        this.zooThread = null;
                        break block17;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
                catch (NullPointerException e) {}
            }
        }
        ObjectReleaseTracker.release((Object)this);
    }

    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        log.info("connecting to {} {}", (Object)host, (Object)port);
        try (BufferedReader reader = null;){
            String string;
            try (Socket sock = new Socket(host, port);){
                String line;
                OutputStream outstream = sock.getOutputStream();
                outstream.write(cmd.getBytes(StandardCharsets.US_ASCII));
                outstream.flush();
                sock.shutdownOutput();
                reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), StandardCharsets.US_ASCII));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        log.info("parse host and port list: {}", (Object)hplist);
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    public int getTheTickTime() {
        return this.theTickTime;
    }

    public void setTheTickTime(int theTickTime) {
        this.theTickTime = theTickTime;
    }

    public Path getZkDir() {
        return this.zkDir;
    }

    public void setViolationReportAction(LimitViolationAction violationReportAction) {
        this.zkServer.setViolationReportAction(violationReportAction);
    }

    public ZKServerMain.WatchLimiter getLimiter() {
        return this.zkServer.getLimiter();
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMaxSessionTimeout(int maxSessionTimeout) {
        this.maxSessionTimeout = maxSessionTimeout;
    }

    public void setMinSessionTimeout(int minSessionTimeout) {
        this.minSessionTimeout = minSessionTimeout;
    }

    void buildZooKeeper(String config, String schema) throws Exception {
        this.buildZooKeeper(SOLRHOME, config, schema);
    }

    public static void putConfig(String confName, SolrZkClient zkClient, Path solrhome, String name) throws Exception {
        ZkTestServer.putConfig(confName, zkClient, null, solrhome, name, name);
    }

    public static void putConfig(String confName, SolrZkClient zkClient, Path solrhome, String srcName, String destName) throws Exception {
        ZkTestServer.putConfig(confName, zkClient, null, solrhome, srcName, destName);
    }

    public static void putConfig(String confName, SolrZkClient zkClient, String zkChroot, Path solrhome, String srcName, String destName) throws Exception {
        Path file = solrhome.resolve("collection1").resolve("conf").resolve(srcName);
        if (!Files.exists(file, new LinkOption[0])) {
            if (log.isInfoEnabled()) {
                log.info("skipping {} because it doesn't exist", (Object)file.toAbsolutePath());
            }
            return;
        }
        String destPath = "/configs/" + confName + "/" + destName;
        if (zkChroot != null) {
            destPath = zkChroot + destPath;
        }
        if (log.isInfoEnabled()) {
            log.info("put {} to {}", (Object)file.toAbsolutePath(), (Object)destPath);
        }
        zkClient.makePath(destPath, Files.readAllBytes(file), false, true);
    }

    public void buildZooKeeper(Path solrhome, String config, String schema) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("configName", "conf1");
        ZkNodeProps zkProps = new ZkNodeProps(props);
        ArrayList<Op> ops = new ArrayList<Op>(2);
        String path = "/collections";
        ops.add(Op.create((String)path, null, (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/collections/collection1";
        ops.add(Op.create((String)path, (byte[])Utils.toJSON((Object)zkProps), (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/collections/collection1/shards";
        ops.add(Op.create((String)path, null, (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/collections/control_collection";
        ops.add(Op.create((String)path, (byte[])Utils.toJSON((Object)zkProps), (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/collections/control_collection/shards";
        ops.add(Op.create((String)path, null, (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/configs";
        ops.add(Op.create((String)path, null, (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        path = "/configs/conf1";
        ops.add(Op.create((String)path, null, (List)this.chRootClient.getZkACLProvider().getACLsToAdd(path), (CreateMode)CreateMode.PERSISTENT));
        this.chRootClient.multi(ops, true);
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, config, "solrconfig.xml");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, schema, "schema.xml");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "solrconfig.snippet.randomindexconfig.xml");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "stopwords.txt");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "protwords.txt");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "currency.xml");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "enumsConfig.xml");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "open-exchange-rates.json");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "mapping-ISOLatin1Accent.txt");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "old_synonyms.txt");
        ZkTestServer.putConfig("conf1", this.chRootClient, solrhome, "synonyms.txt");
    }

    public void makeSolrZkNode() throws Exception {
        this.rootClient.makePath("/solr", false, true);
    }

    public void tryCleanSolrZkNode() throws Exception {
        this.tryCleanPath("/solr");
    }

    void tryCleanPath(String path) throws Exception {
        if (this.rootClient.exists(path, true).booleanValue()) {
            this.rootClient.clean(path);
        }
    }

    protected void printLayout() throws Exception {
        this.rootClient.printLayoutToStream(System.out);
    }

    public SolrZkClient getZkClient() {
        return this.chRootClient;
    }

    private static void ensureStatCommandWhitelisted() {
        String stat = FourLetterCommands.getCommandString((int)FourLetterCommands.statCmd);
        if (!FourLetterCommands.isEnabled((String)stat)) {
            String original = System.getProperty("zookeeper.4lw.commands.whitelist");
            try {
                log.error("ZkTestServer requires the 'stat' command, temporarily manipulating your whitelist");
                System.setProperty("zookeeper.4lw.commands.whitelist", "*");
                FourLetterCommands.resetWhiteList();
                Assert.assertTrue((String)"Temporary manipulation of ZK Whitelist didn't work?", (boolean)FourLetterCommands.isEnabled((String)stat));
            }
            finally {
                if (null == original) {
                    System.clearProperty("zookeeper.4lw.commands.whitelist");
                } else {
                    System.setProperty("zookeeper.4lw.commands.whitelist", original);
                }
            }
            Assert.assertTrue((String)"Temporary manipulation of ZK Whitelist didn't survive re-setting original value, ZK 4LW init logic has broken this class", (boolean)FourLetterCommands.isEnabled((String)stat));
        }
    }

    static {
        try {
            SOLRHOME = SolrTestCaseJ4.TEST_PATH();
        }
        catch (RuntimeException e) {
            log.warn("TEST_PATH() does not exist - solrj test?");
        }
    }

    public static class HostPort {
        String host;
        int port;

        HostPort(String host, int port) {
            assert (!host.contains(":")) : host;
            this.host = host;
            this.port = port;
        }
    }

    class ZKServerMain {
        private volatile ServerCnxnFactory cnxnFactory;
        private volatile ZooKeeperServer zooKeeperServer;
        private volatile LimitViolationAction violationReportAction = LimitViolationAction.REPORT;
        private volatile WatchLimiter limiter = new WatchLimiter(1L, LimitViolationAction.IGNORE);

        ZKServerMain() {
        }

        protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
            try {
                ManagedUtil.registerLog4jMBeans();
            }
            catch (JMException e) {
                log.warn("Unable to register log4j JMX control", (Throwable)e);
            }
            ServerConfig config = new ServerConfig();
            if (args.length == 1) {
                config.parse(args[0]);
            } else {
                config.parse(args);
            }
            this.runFromConfig(config);
        }

        public void runFromConfig(ServerConfig config) throws IOException {
            ObjectReleaseTracker.track((Object)this);
            log.info("Starting server");
            try {
                String limitViolations;
                System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
                FileTxnSnapLog ftxn = new FileTxnSnapLog(config.getDataLogDir(), config.getDataDir());
                this.zooKeeperServer = new ZooKeeperServer(ftxn, config.getTickTime(), config.getMinSessionTimeout(), config.getMaxSessionTimeout(), config.getClientPortListenBacklog(), (ZKDatabase)new TestZKDatabase(ftxn, this.limiter), "");
                this.cnxnFactory = new NIOServerCnxnFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
                this.cnxnFactory.startup(this.zooKeeperServer);
                this.cnxnFactory.join();
                if (this.violationReportAction != LimitViolationAction.IGNORE && !(limitViolations = this.limiter.reportLimitViolations()).isEmpty()) {
                    log.warn("Watch limit violations: {}", (Object)limitViolations);
                    if (this.violationReportAction == LimitViolationAction.FAIL) {
                        throw new AssertionError((Object)"Parallel watch limits violated");
                    }
                }
            }
            catch (InterruptedException e) {
                log.warn("Server interrupted", (Throwable)e);
            }
        }

        protected void shutdown() throws IOException {
            block11: {
                ZKDatabase zkDb = this.zooKeeperServer.getZKDatabase();
                try {
                    if (this.cnxnFactory != null) {
                        while (true) {
                            this.cnxnFactory.shutdown();
                            try {
                                this.cnxnFactory.join();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (zkDb != null) {
                        zkDb.close();
                    }
                    if (this.cnxnFactory == null) break block11;
                    try {
                        int port = this.cnxnFactory.getLocalPort();
                        if (port > 0) {
                            Assert.assertTrue((String)"ZK Server did not go down when expected", (boolean)ClientBase.waitForServerDown((String)ZkTestServer.this.getZkHost(), (long)30000L));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                finally {
                    ObjectReleaseTracker.release((Object)this);
                }
            }
        }

        public int getLocalPort() {
            int port;
            if (this.cnxnFactory == null) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            try {
                port = this.cnxnFactory.getLocalPort();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            if (port == 0) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            return port;
        }

        public void setViolationReportAction(LimitViolationAction violationReportAction) {
            this.violationReportAction = violationReportAction;
        }

        public WatchLimiter getLimiter() {
            return this.limiter;
        }

        private class TestZKDatabase
        extends ZKDatabase {
            private final WatchLimiter limiter;

            public TestZKDatabase(FileTxnSnapLog snapLog, WatchLimiter limiter) {
                super(snapLog);
                this.limiter = limiter;
            }

            public Stat statNode(String path, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
                this.limiter.statLimit.updateForWatch(path, (Watcher)serverCnxn);
                return super.statNode(path, serverCnxn);
            }

            public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
                this.limiter.dataLimit.updateForWatch(path, watcher);
                return super.getData(path, stat, watcher);
            }

            public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
                this.limiter.childrenLimit.updateForWatch(path, watcher);
                return super.getChildren(path, stat, watcher);
            }
        }

        public class WatchLimiter {
            WatchLimit statLimit;
            WatchLimit dataLimit;
            WatchLimit childrenLimit;

            private WatchLimiter(long limit, LimitViolationAction action) {
                this.statLimit = new WatchLimit(limit, "create/delete", action);
                this.dataLimit = new WatchLimit(limit, "data", action);
                this.childrenLimit = new WatchLimit(limit, "children", action);
            }

            public void setAction(LimitViolationAction action) {
                this.statLimit.setAction(action);
                this.dataLimit.setAction(action);
                this.childrenLimit.setAction(action);
            }

            public void setLimit(long limit) {
                this.statLimit.setLimit(limit);
                this.dataLimit.setLimit(limit);
                this.childrenLimit.setLimit(limit);
            }

            public String reportLimitViolations() {
                return this.statLimit.reportLimitViolations() + this.dataLimit.reportLimitViolations() + this.childrenLimit.reportLimitViolations();
            }

            private void updateForFire(WatchedEvent event) {
                switch (event.getType()) {
                    case None: {
                        break;
                    }
                    case NodeCreated: 
                    case NodeDeleted: {
                        this.statLimit.updateForFire(event);
                        break;
                    }
                    case NodeDataChanged: {
                        this.dataLimit.updateForFire(event);
                        break;
                    }
                    case NodeChildrenChanged: {
                        this.childrenLimit.updateForFire(event);
                        break;
                    }
                    case ChildWatchRemoved: {
                        break;
                    }
                    case DataWatchRemoved: {
                        break;
                    }
                }
            }
        }

        private class WatchLimit {
            private long limit;
            private final String desc;
            private volatile LimitViolationAction action;
            private final Map<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
            private final ConcurrentHashMap<String, Long> maxCounters = new ConcurrentHashMap();

            WatchLimit(long limit, String desc, LimitViolationAction action) {
                this.limit = limit;
                this.desc = desc;
                this.action = action;
            }

            public void setAction(LimitViolationAction action) {
                this.action = action;
            }

            public void setLimit(long limit) {
                this.limit = limit;
            }

            public void updateForWatch(String key, Watcher watcher) {
                if (watcher != null) {
                    log.debug("Watch added: {}: {}", (Object)this.desc, (Object)key);
                    long count = this.counters.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                    Long lastCount = this.maxCounters.get(key);
                    if (lastCount == null || count > lastCount) {
                        this.maxCounters.put(key, count);
                    }
                    if (count > this.limit && this.action != LimitViolationAction.IGNORE) {
                        String msg = "Number of watches created in parallel for data: " + key + ", type: " + this.desc + " exceeds limit (" + count + " > " + this.limit + ")";
                        log.warn("{}", (Object)msg);
                        if (this.action == LimitViolationAction.FAIL) {
                            throw new AssertionError((Object)msg);
                        }
                    }
                }
            }

            public void updateForFire(WatchedEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug("Watch fired: {}: {}", (Object)this.desc, (Object)event.getPath());
                }
                this.counters.get(event.getPath()).decrementAndGet();
            }

            private String reportLimitViolations() {
                String[] maxKeys = ((ConcurrentHashMap.CollectionView)((Object)this.maxCounters.keySet())).toArray(new String[0]);
                Arrays.sort(maxKeys, new Comparator<String>(){
                    private final Comparator<Long> valComp = Comparator.naturalOrder().reversed();

                    @Override
                    public int compare(String o1, String o2) {
                        return this.valComp.compare(WatchLimit.this.maxCounters.get(o1), WatchLimit.this.maxCounters.get(o2));
                    }
                });
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String key : maxKeys) {
                    long value = this.maxCounters.get(key);
                    if (value <= this.limit) continue;
                    if (first) {
                        sb.append("\nMaximum concurrent ").append(this.desc).append(" watches above limit:\n\n");
                        first = false;
                    }
                    sb.append("\t").append(this.maxCounters.get(key)).append('\t').append(key).append('\n');
                }
                return sb.toString();
            }
        }
    }

    public static enum LimitViolationAction {
        IGNORE,
        REPORT,
        FAIL;

    }
}

