/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.lucene.util.Constants;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLTestConfig {
    private static final String TEST_KEYSTORE_BOGUSHOST_RESOURCE = "SSLTestConfig.hostname-and-ip-missmatch.keystore";
    private static final String TEST_KEYSTORE_LOCALHOST_RESOURCE = "SSLTestConfig.testing.keystore";
    private static final String TEST_PASSWORD = "secret";
    private final boolean checkPeerName;
    private final Resource keyStore;
    private final Resource trustStore;
    private final boolean useSsl;
    private final boolean clientAuth;
    private static final HttpClientUtil.SocketFactoryRegistryProvider HTTP_ONLY_SCHEMA_PROVIDER = new HttpClientUtil.SocketFactoryRegistryProvider(){

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
    };
    private static final Pattern KNOWN_BAD_OPENJDK_JVMS = Pattern.compile("(^11(\\.0(\\.0|\\.1|\\.2)?)?($|(\\_|\\+|\\-).*$))|(^(11|12|13).*-testing.*$)|(^13-ea.*$)");

    public SSLTestConfig() {
        this(false, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth) {
        this(useSSL, clientAuth, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth, boolean checkPeerName) {
        this.useSsl = useSSL;
        this.clientAuth = clientAuth;
        this.checkPeerName = checkPeerName;
        if (this.useSsl) {
            SSLTestConfig.assumeSslIsSafeToTest();
        }
        String resourceName = checkPeerName ? TEST_KEYSTORE_LOCALHOST_RESOURCE : TEST_KEYSTORE_BOGUSHOST_RESOURCE;
        this.trustStore = this.keyStore = Resource.newClassPathResource((String)resourceName);
        if (null == this.keyStore || !this.keyStore.exists()) {
            throw new IllegalStateException("Unable to locate keystore resource file in classpath: " + resourceName);
        }
    }

    public boolean getCheckPeerName() {
        return this.checkPeerName;
    }

    public boolean isSSLMode() {
        return this.useSsl;
    }

    public boolean isClientAuthMode() {
        return this.clientAuth;
    }

    public HttpClientUtil.SocketFactoryRegistryProvider buildClientSocketFactoryRegistryProvider() {
        if (this.isSSLMode()) {
            SSLConnectionSocketFactory sslConnectionFactory = this.buildClientSSLConnectionSocketFactory();
            assert (null != sslConnectionFactory);
            return new SSLSocketFactoryRegistryProvider(sslConnectionFactory);
        }
        return HTTP_ONLY_SCHEMA_PROVIDER;
    }

    public SSLContext buildClientSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        assert (this.isSSLMode());
        SSLContextBuilder builder = SSLContexts.custom();
        builder.setSecureRandom(NotSecurePseudoRandom.INSTANCE);
        builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(this.keyStore, TEST_PASSWORD), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        if (this.isClientAuthMode()) {
            builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(this.trustStore, TEST_PASSWORD), TEST_PASSWORD.toCharArray());
        }
        return builder.build();
    }

    public SSLConfig buildClientSSLConfig() {
        if (!this.isSSLMode()) {
            return null;
        }
        return new SSLConfig(this.isSSLMode(), this.isClientAuthMode(), null, null, null, null){

            public SslContextFactory.Client createClientContextFactory() {
                SslContextFactory.Client factory = new SslContextFactory.Client(!SSLTestConfig.this.checkPeerName);
                try {
                    factory.setSslContext(SSLTestConfig.this.buildClientSSLContext());
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", e);
                }
                return factory;
            }
        };
    }

    public SSLConfig buildServerSSLConfig() {
        if (!this.isSSLMode()) {
            return null;
        }
        return new SSLConfig(this.isSSLMode(), this.isClientAuthMode(), null, null, null, null){

            public SslContextFactory.Server createContextFactory() {
                SslContextFactory.Server factory = new SslContextFactory.Server();
                try {
                    SSLContextBuilder builder = SSLContexts.custom();
                    builder.setSecureRandom(NotSecurePseudoRandom.INSTANCE);
                    builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(SSLTestConfig.this.keyStore, SSLTestConfig.TEST_PASSWORD), SSLTestConfig.TEST_PASSWORD.toCharArray());
                    if (this.isClientAuthMode()) {
                        builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(SSLTestConfig.this.trustStore, SSLTestConfig.TEST_PASSWORD), (TrustStrategy)new TrustSelfSignedStrategy()).build();
                    }
                    factory.setSslContext(builder.build());
                }
                catch (Exception e) {
                    throw new RuntimeException("ssl context init failure: " + e.getMessage(), e);
                }
                factory.setNeedClientAuth(this.isClientAuthMode());
                return factory;
            }
        };
    }

    private static KeyStore buildKeyStore(Resource resource, String password) {
        try {
            return CertificateUtils.getKeyStore((Resource)resource, (String)"JKS", null, (String)password);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to build KeyStore from resource: " + resource.getName(), ex);
        }
    }

    public SSLConnectionSocketFactory buildClientSSLConnectionSocketFactory() {
        SSLConnectionSocketFactory sslConnectionFactory;
        if (!this.isSSLMode()) {
            return null;
        }
        try {
            SSLContext sslContext = this.buildClientSSLContext();
            sslConnectionFactory = !this.checkPeerName ? new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : new SSLConnectionSocketFactory(sslContext);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", e);
        }
        return sslConnectionFactory;
    }

    public static void assumeSslIsSafeToTest() {
        if (Constants.JVM_NAME.startsWith("OpenJDK") || Constants.JVM_NAME.startsWith("Java HotSpot(TM)")) {
            RandomizedTest.assumeFalse((String)("Test (or randomization for this seed) wants to use SSL, but SSL is known to fail on your JVM: " + Constants.JVM_NAME + " / " + Constants.JVM_VERSION), (boolean)SSLTestConfig.isOpenJdkJvmVersionKnownToHaveProblems(Constants.JVM_VERSION));
        }
    }

    static boolean isOpenJdkJvmVersionKnownToHaveProblems(String jvmVersion) {
        return KNOWN_BAD_OPENJDK_JVMS.matcher(jvmVersion).matches();
    }

    private static class NotSecurePseudoRandom
    extends SecureRandom {
        public static final SecureRandom INSTANCE = new NotSecurePseudoRandom();
        private static final SecureRandomSpi NOT_SECURE_SPI = new SecureRandomSpi(){

            @Override
            public byte[] engineGenerateSeed(int numBytes) {
                return NotSecurePseudoRandom.fillData(new byte[numBytes]);
            }

            @Override
            public void engineNextBytes(byte[] bytes) {
                NotSecurePseudoRandom.fillData(bytes);
            }

            @Override
            public void engineSetSeed(byte[] seed) {
            }
        };

        private static final byte[] fillData(byte[] data) {
            ThreadLocalRandom.current().nextBytes(data);
            return data;
        }

        private NotSecurePseudoRandom() {
            super(NOT_SECURE_SPI, null);
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            return NotSecurePseudoRandom.fillData(new byte[numBytes]);
        }

        @Override
        public void nextBytes(byte[] bytes) {
            NotSecurePseudoRandom.fillData(bytes);
        }

        @Override
        public void nextBytes(byte[] bytes, SecureRandomParameters params) {
            NotSecurePseudoRandom.fillData(bytes);
        }

        @Override
        public void setSeed(byte[] seed) {
        }

        @Override
        public void setSeed(long seed) {
        }

        @Override
        public void reseed() {
        }

        @Override
        public void reseed(SecureRandomParameters params) {
        }
    }

    private static class SSLSocketFactoryRegistryProvider
    extends HttpClientUtil.SocketFactoryRegistryProvider {
        private final SSLConnectionSocketFactory sslConnectionFactory;

        public SSLSocketFactoryRegistryProvider(SSLConnectionSocketFactory sslConnectionFactory) {
            this.sslConnectionFactory = sslConnectionFactory;
        }

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return RegistryBuilder.create().register("https", (Object)this.sslConnectionFactory).build();
        }
    }
}

