/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.IpTables;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosMonkey {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NO_STOP_WARN_TIME = 60;
    private static final int CONLOSS_PERCENT = 10;
    private static final int EXPIRE_PERCENT = 10;
    private Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty;
    private static final Boolean MONKEY_ENABLED = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.enabled", "true"));
    private static final String CONN_LOSS = System.getProperty("solr.tests.cloud.cm.connloss", "false");
    private static final String EXP = System.getProperty("solr.tests.cloud.cm.exp", "false");
    private ZkTestServer zkServer;
    private ZkStateReader zkStateReader;
    private String collection;
    private volatile boolean stop = false;
    private AtomicInteger stops = new AtomicInteger();
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger expires = new AtomicInteger();
    private AtomicInteger connloss = new AtomicInteger();
    private boolean expireSessions;
    private boolean causeConnectionLoss;
    private boolean aggressivelyKillLeaders;
    private Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty;
    private volatile RTimer runTimer;
    private List<AbstractFullDistribZkTestBase.CloudJettyRunner> deadPool = new ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner>();
    private Thread monkeyThread;
    private final Random chaosRandom;

    public ChaosMonkey(ZkTestServer zkServer, ZkStateReader zkStateReader, String collection, Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty, Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty) {
        this.shardToJetty = shardToJetty;
        this.shardToLeaderJetty = shardToLeaderJetty;
        this.zkServer = zkServer;
        this.zkStateReader = zkStateReader;
        this.collection = collection;
        this.chaosRandom = new Random(LuceneTestCase.random().nextLong());
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is Disabled and will not run");
            return;
        }
        this.expireSessions = EXP != null ? Boolean.parseBoolean(EXP) : this.chaosRandom.nextBoolean();
        this.causeConnectionLoss = CONN_LOSS != null ? Boolean.parseBoolean(CONN_LOSS) : this.chaosRandom.nextBoolean();
        ChaosMonkey.monkeyLog("init - expire sessions:" + this.expireSessions + " cause connection loss:" + this.causeConnectionLoss);
    }

    public void expireSession(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            ChaosMonkey.monkeyLog("expire session for " + jetty.getLocalPort() + " !");
            ChaosMonkey.causeConnectionLoss(jetty);
            long sessionId = cores.getZkController().getZkClient().getSolrZooKeeper().getSessionId();
            this.zkServer.expire(sessionId);
        }
    }

    public void expireRandomSession() throws KeeperException, InterruptedException {
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            this.expireSession(jetty.jetty);
            this.expires.incrementAndGet();
        }
    }

    public void randomConnectionLoss() throws KeeperException, InterruptedException {
        ChaosMonkey.monkeyLog("Will cause connection loss!");
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            ChaosMonkey.causeConnectionLoss(jetty.jetty);
            this.connloss.incrementAndGet();
        }
    }

    public static void causeConnectionLoss(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            ChaosMonkey.monkeyLog("Will cause connection loss on " + jetty.getLocalPort());
            SolrZkClient zkClient = cores.getZkController().getZkClient();
            zkClient.getSolrZooKeeper().closeCnxn();
        }
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopShard(String slice, int index) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.shardToJetty.get(slice).get(index);
        this.stopJetty(cjetty);
        return cjetty;
    }

    public void stopJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.stop(cjetty.jetty);
        this.stops.incrementAndGet();
    }

    public void killJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.kill(cjetty);
        this.stops.incrementAndGet();
    }

    public void stopJetty(JettySolrRunner jetty) throws Exception {
        this.stops.incrementAndGet();
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    private static void stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        assert (jetty != null);
        ChaosMonkey.monkeyLog("stop jetty! " + jetty.getLocalPort());
        SolrDispatchFilter sdf = jetty.getSolrDispatchFilter();
        if (sdf != null) {
            try {
                sdf.destroy();
            }
            catch (Throwable t) {
                log.error("", t);
            }
        }
        try {
            jetty.stop();
        }
        catch (InterruptedException e) {
            log.info("Jetty stop interrupted - should be a test caused interruption, we will try again to be sure we shutdown");
        }
        if (!jetty.isStopped()) {
            jetty.stop();
        }
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not stop jetty");
        }
    }

    public static void kill(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.kill(jetty);
        }
    }

    public static void kill(JettySolrRunner jetty) throws Exception {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null && cores.isZooKeeperAware()) {
            int zklocalport = ((InetSocketAddress)cores.getZkController().getZkClient().getSolrZooKeeper().getSocketAddress()).getPort();
            IpTables.blockPort(zklocalport);
        }
        IpTables.blockPort(jetty.getLocalPort());
        ChaosMonkey.monkeyLog("kill jetty! " + jetty.getLocalPort());
        jetty.stop();
        ChaosMonkey.stop(jetty);
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not kill jetty");
        }
    }

    public static void kill(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.kill(cjetty.jetty);
    }

    public void stopAll(int pauseBetweenMs) throws Exception {
        Set<String> keys = this.shardToJetty.keySet();
        ArrayList<1> jettyThreads = new ArrayList<1>(keys.size());
        for (String string : keys) {
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(string);
            for (final AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
                Thread.sleep(pauseBetweenMs);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ChaosMonkey.this.stopJetty(jetty);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                jettyThreads.add(thread);
                thread.start();
            }
        }
        for (Thread thread : jettyThreads) {
            thread.join();
        }
    }

    public void startAll() throws Exception {
        Set<String> keys = this.shardToJetty.keySet();
        for (String key : keys) {
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(key);
            for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
                ChaosMonkey.start(jetty.jetty);
            }
        }
    }

    public void stopShard(String slice) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            this.stopJetty(jetty);
        }
    }

    public void stopShardExcept(String slice, String shardName) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            if (jetty.nodeName.equals(shardName)) continue;
            this.stopJetty(jetty);
        }
    }

    public JettySolrRunner getShard(String slice, int index) throws Exception {
        JettySolrRunner jetty = this.shardToJetty.get((Object)slice).get((int)index).jetty;
        return jetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.stopRandomShard(sliceName);
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.stopJetty(cjetty);
        }
        return cjetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.killRandomShard(sliceName);
    }

    private String getRandomSlice() {
        Map slices = this.zkStateReader.getClusterState().getCollection(this.collection).getSlicesMap();
        ArrayList sliceKeyList = new ArrayList(slices.size());
        sliceKeyList.addAll(slices.keySet());
        String sliceName = (String)sliceKeyList.get(this.chaosRandom.nextInt(sliceKeyList.size()));
        return sliceName;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.killJetty(cjetty);
        }
        return cjetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner getRandomJetty(String slice, boolean aggressivelyKillLeaders) throws KeeperException, InterruptedException {
        int numActive = 0;
        if ((numActive = this.checkIfKillIsLegal(slice, numActive)) < 2) {
            ChaosMonkey.monkeyLog("only one active node in shard - monkey cannot kill :(");
            return null;
        }
        int numRunning = 0;
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cjetty : this.shardToJetty.get(slice)) {
            if (this.deadPool.contains(cjetty)) continue;
            ++numRunning;
        }
        if (numRunning < 2) {
            ChaosMonkey.monkeyLog("only one active node in shard - monkey cannot kill :(");
            return null;
        }
        boolean canKillIndexer = this.canKillIndexer(slice);
        if (!canKillIndexer) {
            ChaosMonkey.monkeyLog("Number of indexer nodes (nrt or tlog replicas) is not enough to kill one of them, Will only choose a pull replica to kill");
        }
        int chance = this.chaosRandom.nextInt(10);
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = null;
        if (chance <= 5 && aggressivelyKillLeaders && canKillIndexer) {
            cjetty = this.shardToLeaderJetty.get(slice);
        } else {
            boolean isLeader;
            boolean rtIsLeader;
            block25: {
                List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
                int attempt = 0;
                do {
                    ++attempt;
                    int index = this.chaosRandom.nextInt(jetties.size());
                    cjetty = jetties.get(index);
                    if (canKillIndexer || this.getTypeForJetty(slice, cjetty) == Replica.Type.PULL) break block25;
                } while (attempt <= 20);
                ChaosMonkey.monkeyLog("Can't kill indexer nodes (nrt or tlog replicas) and couldn't find a random pull node after 20 attempts - monkey cannot kill :(");
                return null;
            }
            Replica leader = null;
            try {
                leader = this.zkStateReader.getLeaderRetry(this.collection, slice);
            }
            catch (Throwable t) {
                log.error("Could not get leader", t);
                return null;
            }
            CoreContainer cc = cjetty.jetty.getCoreContainer();
            if (cc != null) {
                try (SolrCore core = cc.getCore(leader.getStr("core"));){
                    rtIsLeader = core != null && core.getCoreDescriptor().getCloudDescriptor().isLeader();
                }
            } else {
                return null;
            }
            boolean bl = isLeader = leader.getStr("node_name").equals(cjetty.nodeName) || rtIsLeader;
            if (!aggressivelyKillLeaders && isLeader) {
                ChaosMonkey.monkeyLog("abort! I don't kill leaders");
                return null;
            }
        }
        if (cjetty.jetty.getLocalPort() == -1) {
            ChaosMonkey.monkeyLog("abort! This guy is already dead");
            return null;
        }
        ChaosMonkey.monkeyLog("chose a victim! " + cjetty.jetty.getLocalPort());
        return cjetty;
    }

    private Replica.Type getTypeForJetty(String sliceName, AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) {
        DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(this.collection);
        Slice slice = docCollection.getSlice(sliceName);
        ZkNodeProps props = (ZkNodeProps)slice.getReplicasMap().get(cjetty.coreNodeName);
        if (props == null) {
            throw new RuntimeException("shard name " + cjetty.coreNodeName + " not found in " + slice.getReplicasMap().keySet());
        }
        return Replica.Type.valueOf((String)props.getStr("type"));
    }

    private boolean canKillIndexer(String sliceName) throws KeeperException, InterruptedException {
        int numIndexersFoundInShard = 0;
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cloudJetty : this.shardToJetty.get(sliceName)) {
            this.zkStateReader.forceUpdateCollection(this.collection);
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(this.collection);
            Slice slice = docCollection.getSlice(sliceName);
            ZkNodeProps props = (ZkNodeProps)slice.getReplicasMap().get(cloudJetty.coreNodeName);
            if (props == null) {
                throw new RuntimeException("shard name " + cloudJetty.coreNodeName + " not found in " + slice.getReplicasMap().keySet());
            }
            Replica.State state = Replica.State.getState((String)props.getStr("state"));
            Replica.Type replicaType = Replica.Type.valueOf((String)props.getStr("type"));
            String nodeName = props.getStr("node_name");
            if (!cloudJetty.jetty.isRunning() || state != Replica.State.ACTIVE || replicaType != Replica.Type.TLOG && replicaType != Replica.Type.NRT || !this.zkStateReader.getClusterState().liveNodesContain(nodeName)) continue;
            ++numIndexersFoundInShard;
        }
        return numIndexersFoundInShard > 1;
    }

    private int checkIfKillIsLegal(String sliceName, int numActive) throws KeeperException, InterruptedException {
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cloudJetty : this.shardToJetty.get(sliceName)) {
            this.zkStateReader.forceUpdateCollection(this.collection);
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(this.collection);
            Slice slice = docCollection.getSlice(sliceName);
            ZkNodeProps props = (ZkNodeProps)slice.getReplicasMap().get(cloudJetty.coreNodeName);
            if (props == null) {
                throw new RuntimeException("shard name " + cloudJetty.coreNodeName + " not found in " + slice.getReplicasMap().keySet());
            }
            Replica.State state = Replica.State.getState((String)props.getStr("state"));
            String nodeName = props.getStr("node_name");
            if (!cloudJetty.jetty.isRunning() || state != Replica.State.ACTIVE || !this.zkStateReader.getClusterState().liveNodesContain(nodeName)) continue;
            ++numActive;
        }
        return numActive;
    }

    public void startTheMonkey(boolean killLeaders, final int roundPauseUpperLimit) {
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is disabled and will not start");
            return;
        }
        ChaosMonkey.monkeyLog("starting");
        if (this.chaosRandom.nextBoolean()) {
            ChaosMonkey.monkeyLog("Jetty will not commit on close");
            DirectUpdateHandler2.commitOnClose = false;
        }
        this.aggressivelyKillLeaders = killLeaders;
        this.runTimer = new RTimer();
        this.stop = false;
        this.monkeyThread = new Thread(){

            @Override
            public void run() {
                while (!ChaosMonkey.this.stop) {
                    try {
                        Thread.sleep(ChaosMonkey.this.chaosRandom.nextInt(roundPauseUpperLimit));
                        ChaosMonkey.this.causeSomeChaos();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ChaosMonkey.monkeyLog("finished");
                ChaosMonkey.monkeyLog("I ran for " + ChaosMonkey.this.runTimer.getTime() / 1000.0 + "s. I stopped " + ChaosMonkey.this.stops + " and I started " + ChaosMonkey.this.starts + ". I also expired " + ChaosMonkey.this.expires.get() + " and caused " + ChaosMonkey.this.connloss + " connection losses");
            }
        };
        this.monkeyThread.start();
    }

    public static void monkeyLog(String msg) {
        log.info("monkey: " + msg);
    }

    public static void monkeyLog(String msg, Object ... logParams) {
        log.info("monkey: " + msg, logParams);
    }

    public void stopTheMonkey() {
        this.stop = true;
        try {
            this.monkeyThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.runTimer.stop();
        DirectUpdateHandler2.commitOnClose = true;
        double runtime = this.runTimer.getTime() / 1000.0;
        if (runtime > 60.0 && this.stops.get() == 0) {
            LuceneTestCase.fail((String)"The Monkey ran for over 60 seconds and no jetties were stopped - this is worth investigating!");
        }
    }

    public void causeSomeChaos() throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty;
        if (this.chaosRandom.nextBoolean() && !this.deadPool.isEmpty()) {
            int index = this.chaosRandom.nextInt(this.deadPool.size());
            JettySolrRunner jetty = this.deadPool.get((int)index).jetty;
            if (jetty.isStopped() && !ChaosMonkey.start(jetty)) {
                return;
            }
            this.deadPool.remove(index);
            this.starts.incrementAndGet();
            return;
        }
        int rnd = this.chaosRandom.nextInt(10);
        if (this.expireSessions && rnd < 10) {
            this.expireRandomSession();
        }
        if (this.causeConnectionLoss && rnd < 10) {
            this.randomConnectionLoss();
        }
        if ((cjetty = this.chaosRandom.nextBoolean() ? this.stopRandomShard() : this.killRandomShard()) != null) {
            this.deadPool.add(cjetty);
        }
    }

    public int getStarts() {
        return this.starts.get();
    }

    public static void stop(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.stop(jetty);
        }
    }

    public static void stop(JettySolrRunner jetty) throws Exception {
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    public static void start(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.start(jetty);
        }
    }

    public static boolean start(JettySolrRunner jetty) throws Exception {
        ChaosMonkey.monkeyLog("starting jetty! " + jetty.getLocalPort());
        IpTables.unblockPort(jetty.getLocalPort());
        try {
            jetty.start();
        }
        catch (Exception e) {
            jetty.stop();
            Thread.sleep(3000L);
            try {
                jetty.start();
            }
            catch (Exception e2) {
                jetty.stop();
                Thread.sleep(10000L);
                try {
                    jetty.start();
                }
                catch (Exception e3) {
                    jetty.stop();
                    Thread.sleep(30000L);
                    try {
                        jetty.start();
                    }
                    catch (Exception e4) {
                        log.error("Could not get the port to start jetty again", (Throwable)e4);
                        jetty.stop();
                        return false;
                    }
                }
            }
        }
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null && cores.isZooKeeperAware()) {
            int zklocalport = ((InetSocketAddress)cores.getZkController().getZkClient().getSolrZooKeeper().getSocketAddress()).getPort();
            IpTables.unblockPort(zklocalport);
        }
        return true;
    }

    public static void wait(long runLength, String collectionName, ZkStateReader zkStateReader) throws InterruptedException {
        TimeOut t = new TimeOut(runLength, TimeUnit.MILLISECONDS, TimeSource.NANO_TIME);
        while (!t.hasTimedOut()) {
            Thread.sleep(Math.min(1000L, t.timeLeft(TimeUnit.MILLISECONDS)));
            ChaosMonkey.logCollectionStateSummary(collectionName, zkStateReader);
        }
    }

    private static void logCollectionStateSummary(String collectionName, ZkStateReader zkStateReader) {
        Pattern portPattern = Pattern.compile(".*:([0-9]*).*");
        DocCollection docCollection = zkStateReader.getClusterState().getCollection(collectionName);
        if (docCollection == null) {
            ChaosMonkey.monkeyLog("Could not find collection {}", collectionName);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Collection status: {");
        for (Slice slice : docCollection.getSlices()) {
            builder.append(slice.getName() + ": {");
            for (Replica replica : slice.getReplicas()) {
                log.info(replica.toString());
                Matcher m = portPattern.matcher(replica.getBaseUrl());
                m.find();
                String jettyPort = m.group(1);
                builder.append(String.format(Locale.ROOT, "%s(%s): {state: %s, type: %s, leader: %s, Live: %s}, ", replica.getName(), jettyPort, replica.getState(), replica.getType(), replica.get("leader") != null, zkStateReader.getClusterState().liveNodesContain(replica.getNodeName())));
            }
            if (slice.getReplicas().size() > 0) {
                builder.setLength(builder.length() - 2);
            }
            builder.append("}, ");
        }
        if (docCollection.getSlices().size() > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("}");
        ChaosMonkey.monkeyLog(builder.toString());
    }
}

