/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TikaLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(SolrInputDocument doc) {
        ArrayList<DetectedLanguage> languages = new ArrayList<DetectedLanguage>();
        String content = this.concatFields(doc);
        if (content.length() != 0) {
            LanguageIdentifier identifier = new LanguageIdentifier(content);
            Double distance = Double.parseDouble(this.tikaSimilarityPattern.matcher(identifier.toString()).replaceFirst("$1"));
            Double certainty = 1.0 - 5.0 * distance;
            certainty = certainty < 0.0 ? 0.0 : certainty;
            DetectedLanguage language = new DetectedLanguage(identifier.getLanguage(), certainty);
            languages.add(language);
            log.debug("Language detected as " + language + " with a certainty of " + language.getCertainty() + " (Tika distance=" + identifier.toString() + ")");
        } else {
            log.debug("No input text to detect language from, returning empty list");
        }
        return languages;
    }

    protected String concatFields(SolrInputDocument doc) {
        StringBuilder sb = new StringBuilder(this.getExpectedSize(doc, this.inputFields));
        block0: for (String fieldName : this.inputFields) {
            Collection fieldValues;
            log.debug("Appending field " + fieldName);
            if (!doc.containsKey((Object)fieldName) || (fieldValues = doc.getFieldValues(fieldName)) == null) continue;
            for (Object content : fieldValues) {
                if (content instanceof String) {
                    String stringContent = (String)content;
                    if (stringContent.length() > this.maxFieldValueChars) {
                        sb.append(stringContent.substring(0, this.maxFieldValueChars));
                    } else {
                        sb.append(stringContent);
                    }
                    sb.append(" ");
                    if (sb.length() <= this.maxTotalChars) continue;
                    sb.setLength(this.maxTotalChars);
                    continue block0;
                }
                log.warn("Field " + fieldName + " not a String value, not including in detection");
            }
        }
        return sb.toString();
    }

    private int getExpectedSize(SolrInputDocument doc, String[] fields) {
        int docSize = 0;
        for (String field : fields) {
            Collection contents = doc.getFieldValues(field);
            for (Object content : contents) {
                if (!(content instanceof String)) continue;
                docSize += Math.min(((String)content).length(), this.maxFieldValueChars);
            }
            docSize = Math.min(docSize, this.maxTotalChars);
        }
        return docSize;
    }
}

