/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Map;
import org.apache.solr.client.api.model.ListClusterPropertiesResponse;
import org.apache.solr.client.api.model.SetClusterPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;

@Path(value="/cluster/properties")
public interface ClusterPropertyApis {
    @GET
    @Operation(summary="List all cluster properties in this Solr cluster.", tags={"cluster-properties"})
    public ListClusterPropertiesResponse listClusterProperties();

    @GET
    @Path(value="/{propertyName}")
    @Operation(summary="Get a cluster property in this Solr cluster.", tags={"cluster-properties"})
    public SolrJerseyResponse getClusterProperty(@Parameter(description="The name of the property being retrieved.", required=true) @PathParam(value="propertyName") String var1);

    @PUT
    @Path(value="/{propertyName}")
    @Operation(summary="Set a single new or existing cluster property in this Solr cluster.", tags={"cluster-properties"})
    public SolrJerseyResponse createOrUpdateClusterProperty(@Parameter(description="The name of the property being set.", required=true) @PathParam(value="propertyName") String var1, @RequestBody(description="Value to set for the property", required=true) SetClusterPropertyRequestBody var2) throws Exception;

    @PUT
    @Operation(summary="Set nested cluster properties in this Solr cluster.", tags={"cluster-properties"})
    public SolrJerseyResponse createOrUpdateNestedClusterProperty(@RequestBody(description="Property/ies to be set", required=true) Map<String, Object> var1) throws Exception;

    @DELETE
    @Path(value="/{propertyName}")
    @Operation(summary="Delete a cluster property in this Solr cluster.", tags={"cluster-properties"})
    public SolrJerseyResponse deleteClusterProperty(@Parameter(description="The name of the property being deleted.", required=true) @PathParam(value="propertyName") String var1);
}

