/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import slingxss.com.google.common.base.Optional;
import slingxss.com.google.common.base.Preconditions;
import slingxss.com.google.common.collect.Maps;
import slingxss.com.google.common.collect.Sets;

interface Joinable<T> {
    public JoinStrategy<T> getJoinStrategy();

    public static abstract class JoinHelper<T, SJ extends Joinable<SJ>> {
        final Class<T> baseType;
        final Class<SJ> specialJoinableType;
        final T zeroValue;
        final T identityValue;
        private Map<JoinStrategy<SJ>, Set<SJ>> requireSpecialJoining;
        private Set<T> uniq = new LinkedHashSet<T>();

        JoinHelper(Class<T> baseType, Class<SJ> specialJoinableType, T zeroValue, T identityValue) {
            this.baseType = baseType;
            this.specialJoinableType = specialJoinableType;
            this.zeroValue = Preconditions.checkNotNull(zeroValue);
            this.identityValue = Preconditions.checkNotNull(identityValue);
        }

        abstract Optional<? extends Iterable<? extends T>> split(T var1);

        abstract T rejoin(Set<? extends T> var1);

        void unroll(T x) {
            Optional<Iterable<T>> splitX = this.split(x);
            if (splitX.isPresent()) {
                for (T part : splitX.get()) {
                    this.unroll(part);
                }
            } else if (this.specialJoinableType.isInstance(x)) {
                Set<SJ> toJoinTogether;
                Joinable sj = (Joinable)this.specialJoinableType.cast(x);
                JoinStrategy strategy = sj.getJoinStrategy();
                if (this.requireSpecialJoining == null) {
                    this.requireSpecialJoining = Maps.newLinkedHashMap();
                }
                if ((toJoinTogether = this.requireSpecialJoining.get(strategy)) == null) {
                    toJoinTogether = Sets.newLinkedHashSet();
                    this.requireSpecialJoining.put(strategy, toJoinTogether);
                }
                toJoinTogether.add(sj);
            } else {
                this.uniq.add(Preconditions.checkNotNull(x));
            }
        }

        T join() {
            if (this.uniq.contains(this.zeroValue)) {
                return this.zeroValue;
            }
            if (this.requireSpecialJoining != null) {
                Iterator<Map.Entry<JoinStrategy<SJ>, Set<SJ>>> entryIterator = this.requireSpecialJoining.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<JoinStrategy<SJ>, Set<SJ>> e = entryIterator.next();
                    JoinStrategy<SJ> strategy = e.getKey();
                    Set<SJ> toJoin = e.getValue();
                    entryIterator.remove();
                    Joinable joined = toJoin.size() == 1 ? (Joinable)toJoin.iterator().next() : (Joinable)strategy.join(toJoin);
                    this.uniq.add(Preconditions.checkNotNull(this.baseType.cast(joined)));
                }
            }
            this.uniq.remove(this.identityValue);
            switch (this.uniq.size()) {
                case 0: {
                    return this.identityValue;
                }
                case 1: {
                    return this.uniq.iterator().next();
                }
            }
            return this.rejoin(this.uniq);
        }
    }

    public static interface JoinStrategy<T> {
        public T join(Iterable<? extends T> var1);

        public boolean equals(Object var1);

        public int hashCode();
    }
}

