/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import slingxss.com.google.common.collect.ImmutableMap;
import slingxss.com.google.common.collect.ImmutableSet;

public class DynamicAttributesSanitizerPolicy
extends ElementAndAttributePolicyBasedSanitizerPolicy {
    private Map<String, ElementAndAttributePolicies> elementAndAttrPolicies;
    private Map<String, AttributePolicy> dynamicAttributesPolicyMap;
    private List<String> onInvalidRemoveTagList;
    private int numberOfErrors;

    public DynamicAttributesSanitizerPolicy(HtmlStreamEventReceiver out, ImmutableMap<String, ElementAndAttributePolicies> elAndAttrPolicies, ImmutableSet<String> allowedTextContainers, Map<String, AttributePolicy> dynamicAttributesPolicyMap, List<String> onInvalidRemoveTagList) {
        super(out, elAndAttrPolicies, allowedTextContainers);
        this.elementAndAttrPolicies = elAndAttrPolicies;
        this.dynamicAttributesPolicyMap = dynamicAttributesPolicyMap;
        this.onInvalidRemoveTagList = onInvalidRemoveTagList;
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        if (elementName != null && attrs != null && this.elementAndAttrPolicies != null) {
            ElementAndAttributePolicies policies = this.elementAndAttrPolicies.get(elementName);
            String adjustedElementName = this.applyPolicies2(elementName, attrs, policies);
            if (!(adjustedElementName == null || attrs.isEmpty() && policies.htmlTagSkipType.skipAvailability())) {
                this.writeOpenTag(policies, adjustedElementName, attrs);
                return;
            }
            this.deferOpenTag(elementName);
        }
    }

    @Nullable
    final String applyPolicies2(String elementName, List<String> attrs, ElementAndAttributePolicies policies) {
        String adjustedElementName;
        Boolean removeTag = false;
        if (policies != null) {
            ListIterator<String> attrsIt = attrs.listIterator();
            while (attrsIt.hasNext()) {
                String name = attrsIt.next();
                AttributePolicy attrPolicy = null;
                for (Map.Entry<String, AttributePolicy> dynamicAttributeEntry : this.dynamicAttributesPolicyMap.entrySet()) {
                    if (!name.startsWith(dynamicAttributeEntry.getKey())) continue;
                    attrPolicy = dynamicAttributeEntry.getValue();
                    break;
                }
                if (attrPolicy == null) {
                    attrPolicy = policies.attrPolicies.get(name);
                }
                if (attrPolicy == null) {
                    ++this.numberOfErrors;
                    attrsIt.remove();
                    attrsIt.next();
                    attrsIt.remove();
                    continue;
                }
                String value = attrsIt.next();
                String adjustedValue = attrPolicy.apply(elementName, name, value);
                if (adjustedValue == null) {
                    ++this.numberOfErrors;
                    if (this.onInvalidRemoveTagList.contains(name)) {
                        removeTag = true;
                    }
                    attrsIt.remove();
                    attrsIt.previous();
                    attrsIt.remove();
                    continue;
                }
                attrsIt.set(adjustedValue);
            }
            try {
                Method removeDuplicateAttributesMethod = ElementAndAttributePolicyBasedSanitizerPolicy.class.getDeclaredMethod("removeDuplicateAttributes", List.class);
                removeDuplicateAttributesMethod.setAccessible(true);
                try {
                    removeDuplicateAttributesMethod.invoke(null, attrs);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            String string = adjustedElementName = Boolean.TRUE.equals(removeTag) ? null : policies.elPolicy.apply(elementName, attrs);
            if (adjustedElementName != null) {
                adjustedElementName = HtmlLexer.canonicalElementName(adjustedElementName);
            }
        } else {
            ++this.numberOfErrors;
            adjustedElementName = null;
        }
        return adjustedElementName;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }
}

