/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContentContext
implements XSSFilterRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(PolicyHandler policyHandler, String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                boolean bl = policyHandler.getAntiSamy().scan(str).getNumberOfErrors() == 0;
                return bl;
            }
            catch (Exception se) {
                this.logError(se, str);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return false;
    }

    @Override
    public String filter(PolicyHandler policyHandler, String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            try {
                CleanResults results = this.getCleanResults(policyHandler, str);
                if (results != null) {
                    String cleaned = results.getCleanHTML();
                    List<String> errors = results.getErrorMessages();
                    for (String error : errors) {
                        this.log.info("AntiSamy warning: {}", (Object)error);
                    }
                    this.log.debug("Protected (HTML -> HTML):\n{}", (Object)cleaned);
                    return cleaned;
                }
            }
            catch (Exception e) {
                this.logError(e, str);
            }
        }
        return "";
    }

    @Override
    public boolean supportsPolicy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CleanResults getCleanResults(PolicyHandler handler, String input) throws ScanException, PolicyException {
        CleanResults results;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            results = handler.getAntiSamy().scan(input);
        }
        catch (StackOverflowError e) {
            this.log.debug("Will perform a second attempt at filtering the following input due to a StackOverflowError:\n{}", (Object)input);
            results = handler.getFallbackAntiSamy().scan(input);
            this.log.debug("Second attempt was successful.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return results;
    }

    private void logError(Exception e, String input) {
        this.log.warn("Unable to check input.", (Throwable)e);
        this.log.debug("Provided input: {}", (Object)input);
    }
}

