/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.owasp.validator.html.InternalPolicy;

public class ASHTMLSerializer
extends HTMLSerializer {
    private boolean encodeAllPossibleEntities;

    public ASHTMLSerializer(Writer w, OutputFormat format, InternalPolicy policy) {
        super(w, format);
        this.encodeAllPossibleEntities = policy.isEntityEncodeIntlCharacters();
    }

    @Override
    protected String getEntityRef(int charToPrint) {
        if (this.encodeAllPossibleEntities || "<>\"'&".indexOf(charToPrint) != -1) {
            return super.getEntityRef(charToPrint);
        }
        return null;
    }

    @Override
    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText('>');
        }
        if (rawName == null || !HTMLdtd.isOnlyOpening(rawName)) {
            if (this._indenting && !state.preserveSpace && state.afterElement) {
                this._printer.breakLine();
            }
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        if (rawName == null || !rawName.equalsIgnoreCase("A") && !rawName.equalsIgnoreCase("TD")) {
            state.afterElement = true;
        }
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }
}

