/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.sling.testing.tools.osgi.WebconsoleClient;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlesInstaller {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebconsoleClient webconsoleClient;
    public static final String ACTIVE_STATE = "active";

    public BundlesInstaller(WebconsoleClient wcc) {
        this.webconsoleClient = wcc;
    }

    public boolean isInstalled(File bundleFile) throws Exception {
        String bundleSymbolicName = this.getBundleSymbolicName(bundleFile);
        try {
            this.log.debug("Checking if installed: " + bundleSymbolicName);
            this.webconsoleClient.checkBundleInstalled(bundleSymbolicName, 1);
            this.log.debug("Already installed: " + bundleSymbolicName);
            return true;
        }
        catch (AssertionError e) {
            this.log.debug("Not yet installed: " + bundleSymbolicName);
            return false;
        }
    }

    public boolean isInstalledWithSameVersion(File bundleFile) throws Exception {
        String versionInBundle;
        String bundleSymbolicName = this.getBundleSymbolicName(bundleFile);
        String versionOnServer = this.webconsoleClient.getBundleVersion(bundleSymbolicName);
        if (versionOnServer.equals(versionInBundle = this.getBundleVersion(bundleFile))) {
            return true;
        }
        this.log.info("Bundle installed doesn't match: " + bundleSymbolicName + ", versionOnServer=" + versionOnServer + ", versionInBundle=" + versionInBundle);
        return false;
    }

    public void installBundles(List<File> toInstall, boolean startBundles) throws Exception {
        for (File f : toInstall) {
            String bundleSymbolicName = this.getBundleSymbolicName(f);
            if (this.isInstalled(f)) {
                if (f.getName().contains("SNAPSHOT")) {
                    this.log.info("Reinstalling (due to SNAPSHOT version): " + bundleSymbolicName);
                    this.webconsoleClient.uninstallBundle(bundleSymbolicName, f);
                } else if (!this.isInstalledWithSameVersion(f)) {
                    this.log.info("Reinstalling (due to version mismatch): " + bundleSymbolicName);
                    this.webconsoleClient.uninstallBundle(bundleSymbolicName, f);
                } else {
                    this.log.info("Not reinstalling: " + bundleSymbolicName);
                    continue;
                }
            }
            this.webconsoleClient.installBundle(f, startBundles);
        }
        this.log.info("{} additional bundles installed from {}", (Object)toInstall.size(), (Object)toInstall.get(0).getAbsolutePath());
    }

    public void waitForBundlesInstalled(List<String> symbolicNames, int timeoutSeconds) throws Exception {
        this.log.info("Checking that bundles are installed (timeout {} seconds): {}", (Object)timeoutSeconds, symbolicNames);
        for (String symbolicName : symbolicNames) {
            this.webconsoleClient.checkBundleInstalled(symbolicName, timeoutSeconds);
        }
    }

    public void startAllBundles(List<String> symbolicNames, int timeoutSeconds) throws Exception {
        this.log.info("Starting bundles (timeout {} seconds): {}", (Object)timeoutSeconds, symbolicNames);
        long timeout = System.currentTimeMillis() + (long)timeoutSeconds * 1000L;
        LinkedList<String> toStart = new LinkedList<String>();
        while (System.currentTimeMillis() < timeout) {
            toStart.clear();
            for (String name : symbolicNames) {
                String state = this.webconsoleClient.getBundleState(name);
                if (state.equalsIgnoreCase(ACTIVE_STATE)) continue;
                toStart.add(name);
                break;
            }
            if (toStart.isEmpty()) {
                this.log.info("Ok - all bundles are in the {} state", (Object)ACTIVE_STATE);
                break;
            }
            for (String name : toStart) {
                this.webconsoleClient.startBundle(name);
            }
            Thread.sleep(500L);
        }
        if (!toStart.isEmpty()) {
            Assert.fail((String)("Some bundles did not start: " + toStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBundleSymbolicName(File bundleFile) throws IOException {
        String name = null;
        JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));
        try {
            Manifest m = jis.getManifest();
            if (m == null) {
                Assert.fail((String)("Manifest is null in " + bundleFile.getAbsolutePath()));
            }
            name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        finally {
            jis.close();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBundleVersion(File bundleFile) throws IOException {
        String version = null;
        JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));
        try {
            Manifest m = jis.getManifest();
            if (m == null) {
                Assert.fail((String)("Manifest is null in " + bundleFile.getAbsolutePath()));
            }
            version = m.getMainAttributes().getValue("Bundle-Version");
        }
        finally {
            jis.close();
        }
        return version;
    }
}

