/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.junit;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Component
@Service
@Property(name="pattern", value={"/.*"})
public class TestNameLoggingFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String className = httpRequest.getHeader("sling.test.class");
        if (className == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String testName = httpRequest.getHeader("sling.test.name");
        try {
            MDC.put((String)"sling.test.name", (String)testName);
            MDC.put((String)"sling.test.class", (String)className);
            this.log.info("Starting request as part of test ==== {}.{} ====", (Object)className, (Object)testName);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.log.info("Finishing request as part of test ==== {}.{} ====", (Object)className, (Object)testName);
            MDC.remove((String)"sling.test.name");
            MDC.remove((String)"sling.test.class");
        }
    }

    public void destroy() {
    }
}

