/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.mime.internal.MimeTypeServiceImpl;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@Component(service={MimeTypeService.class})
public final class MockMimeTypeService
extends MimeTypeServiceImpl {
    private boolean initialized;

    private void lazyInitialization() {
        if (!this.initialized) {
            this.initialized = true;
            ComponentContext componentContext = MockOsgi.newComponentContext();
            this.bindLogService(MockOsgi.newLogService(((Object)((Object)this)).getClass()));
            this.activate(componentContext);
        }
    }

    public String getMimeType(String name) {
        this.lazyInitialization();
        return super.getMimeType(name);
    }

    public String getExtension(String mimeType) {
        this.lazyInitialization();
        return super.getExtension(mimeType);
    }

    public void registerMimeType(String mimeType, String ... extensions) {
        this.lazyInitialization();
        super.registerMimeType(mimeType, extensions);
    }

    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        this.lazyInitialization();
        super.registerMimeType(mimeTabStream);
    }
}

