/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.lang.reflect.Array;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.InvalidServiceFilterSyntaxException;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class MockSlingScriptHelper
implements SlingScriptHelper {
    private final SlingHttpServletRequest request;
    private final SlingHttpServletResponse response;
    private final BundleContext bundleContext;

    public MockSlingScriptHelper(SlingHttpServletRequest request, SlingHttpServletResponse response, BundleContext bundleContext) {
        this.request = request;
        this.response = response;
        this.bundleContext = bundleContext;
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public SlingHttpServletResponse getResponse() {
        return this.response;
    }

    public <ServiceType> ServiceType getService(Class<ServiceType> serviceType) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceType.getName());
        if (serviceReference != null) {
            return (ServiceType)this.bundleContext.getService(serviceReference);
        }
        return null;
    }

    public <ServiceType> ServiceType[] getServices(Class<ServiceType> serviceType, String filter) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(serviceType.getName(), filter);
            if (serviceReferences != null) {
                Object[] services = (Object[])Array.newInstance(serviceType, serviceReferences.length);
                for (int i = 0; i < serviceReferences.length; ++i) {
                    services[i] = this.bundleContext.getService(serviceReferences[i]);
                }
                return services;
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        catch (InvalidSyntaxException ex) {
            throw new InvalidServiceFilterSyntaxException(filter, ex.getMessage(), (Throwable)ex);
        }
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void forward(String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(String path) {
        throw new UnsupportedOperationException();
    }

    public void forward(Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void forward(Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public SlingScript getScript() {
        throw new UnsupportedOperationException();
    }

    public void include(String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(String path) {
        throw new UnsupportedOperationException();
    }

    public void include(Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void include(Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }
}

