/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.CacheValidatorProvider;
import org.apache.jackrabbit.oak.security.user.RepMembersConflictHandler;
import org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl;
import org.apache.jackrabbit.oak.security.user.UserContext;
import org.apache.jackrabbit.oak.security.user.UserImporter;
import org.apache.jackrabbit.oak.security.user.UserInitializer;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.UserPrincipalProvider;
import org.apache.jackrabbit.oak.security.user.UserValidatorProvider;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(service={UserConfiguration.class, SecurityConfiguration.class})
@Designate(ocd=Configuration.class)
public class UserConfigurationImpl
extends ConfigurationBase
implements UserConfiguration,
SecurityConfiguration {
    private static final UserAuthenticationFactory DEFAULT_AUTH_FACTORY = new UserAuthenticationFactoryImpl();

    public UserConfigurationImpl() {
    }

    public UserConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.user"));
    }

    public static UserAuthenticationFactory getDefaultAuthenticationFactory() {
        return DEFAULT_AUTH_FACTORY;
    }

    @Activate
    private void activate(Configuration configuration, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.user";
    }

    @Override
    @Nonnull
    public ConfigurationParameters getParameters() {
        ConfigurationParameters params = super.getParameters();
        if (!params.containsKey("userAuthenticationFactory")) {
            return ConfigurationParameters.of(params, ConfigurationParameters.of("userAuthenticationFactory", DEFAULT_AUTH_FACTORY));
        }
        return params;
    }

    @Override
    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new UserInitializer(this.getSecurityProvider());
    }

    @Override
    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new UserValidatorProvider(this.getParameters(), this.getRootProvider(), this.getTreeProvider()), (Object)new CacheValidatorProvider(principals, this.getTreeProvider()));
    }

    @Override
    @Nonnull
    public List<ThreeWayConflictHandler> getConflictHandlers() {
        return ImmutableList.of((Object)new RepMembersConflictHandler());
    }

    @Override
    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new UserImporter(this.getParameters()));
    }

    @Override
    @Nonnull
    public Context getContext() {
        return UserContext.getInstance();
    }

    @Override
    @Nonnull
    public UserManager getUserManager(Root root, NamePathMapper namePathMapper) {
        UserManagerImpl umgr = new UserManagerImpl(root, namePathMapper, this.getSecurityProvider());
        if (this.getParameters().getConfigValue("supportAutoSave", false).booleanValue()) {
            return new AutoSaveEnabledManager(umgr, root);
        }
        return umgr;
    }

    @Override
    @Nullable
    public PrincipalProvider getUserPrincipalProvider(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
        return new UserPrincipalProvider(root, this, namePathMapper);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak UserConfiguration")
    static @interface Configuration {
        @AttributeDefinition(name="User Path", description="Path underneath which user nodes are being created.")
        public String usersPath() default "/rep:security/rep:authorizables/rep:users";

        @AttributeDefinition(name="Group Path", description="Path underneath which group nodes are being created.")
        public String groupsPath() default "/rep:security/rep:authorizables/rep:groups";

        @AttributeDefinition(name="System User Relative Path", description="Path relative to the user root path underneath which system user nodes are being created. The default value is 'system'.")
        public String systemRelativePath() default "system";

        @AttributeDefinition(name="Default Depth", description="Number of levels that are used by default to store authorizable nodes")
        public int defaultDepth() default 2;

        @AttributeDefinition(name="Import Behavior", description="Behavior for user/group related items upon XML import.", options={@Option(label="abort", value="abort"), @Option(label="besteffort", value="besteffort"), @Option(label="ignore", value="ignore")})
        public String importBehavior() default "ignore";

        @AttributeDefinition(name="Hash Algorithm", description="Name of the algorithm used to generate the password hash.")
        public String passwordHashAlgorithm() default "SHA-256";

        @AttributeDefinition(name="Hash Iterations", description="Number of iterations to generate the password hash.")
        public int passwordHashIterations() default 1000;

        @AttributeDefinition(name="Hash Salt Size", description="Salt size to generate the password hash.")
        public int passwordSaltSize() default 8;

        @AttributeDefinition(name="Omit Admin Password", description="Boolean flag to prevent the administrator account to be created with a password upon repository initialization. Please note that changing this option after the initial repository setup will have no effect.")
        public boolean omitAdminPw() default false;

        @AttributeDefinition(name="Autosave Support", description="Configuration option to enable autosave behavior. Note: this config option is present for backwards compatibility with Jackrabbit 2.x and should only be used for broken code that doesn't properly verify the autosave behavior (see Jackrabbit API). If this option is turned on autosave will be enabled by default; otherwise autosave is not supported.")
        public boolean supportAutoSave() default false;

        @AttributeDefinition(name="Maximum Password Age", description="Maximum age in days a password may have. Values greater 0 will implicitly enable password expiry. A value of 0 indicates unlimited password age.")
        public int passwordMaxAge() default 0;

        @AttributeDefinition(name="Change Password On First Login", description="When enabled, forces users to change their password upon first login.")
        public boolean initialPasswordChange() default false;

        @AttributeDefinition(name="Maximum Password History Size", description="Maximum number of passwords recorded for a user after changing her password (NOTE: upper limit is 1000). When changing the password the new password must not be present in the password history. A value of 0 indicates no password history is recorded.")
        public int passwordHistorySize() default 0;

        @AttributeDefinition(name="Principal Cache Expiration", description="Optional configuration defining the number of milliseconds until the principal cache expires (NOTE: currently only respected for principal resolution with the internal system session such as used for login). If not set or equal/lower than zero no caches are created/evaluated.")
        public long cacheExpiration() default 0L;

        @AttributeDefinition(name="RFC7613 Username Comparison Profile", description="Enable the UsercaseMappedProfile defined in RFC7613 for username comparison.")
        public boolean enableRFC7613UsercaseMappedProfile() default false;
    }
}

